package org.fmph.project;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

import org.fmph.knet.infection.simple.SimpleEnvironment;
import org.fmph.knet.infection.simple.SimpleSimulator;
import org.fmph.knet.infection.simple.SimpleVaccinationProvider;
import org.fmph.knet.infection.Person;

/**
 * Hlavna trieda, spustajuca celu simulaciu.
 * Je nutne naimplementovat vlastnu instanciu interface-u {@link SimpleVaccinationProvider}
 */
public class Project {
  
  public static void main(String[] args) throws FileNotFoundException, IOException {
    SimpleEnvironment environment = SimpleEnvironment.load("simple.properties", "simple.edges");  //nahradit za vlastny vstup
    SimpleSimulator simulator = new SimpleSimulator(environment, new MyProvider());
    //simulator.initalVaccination(...) - umozni ockovanie pred zaciatkom simulacie. Ako argument vyzaduje zoznam osob na ockovanie
    simulator.simulate();
  }
 
  //Demo - tento provider nesprostredkuje ziadnu vakcinaciu
  private static class MyProvider implements SimpleVaccinationProvider{

    @Override
    public Collection<Person> getVaccination(SimpleSimulator arg0, SimpleEnvironment arg1, int arg2) {
      return Collections.emptyList();
    }
    
  }

}
