/*
 * Decompiled with CFR 0.152.
 */
package org.fmph.knet.jung.io;

import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.fmph.knet.jung.io.EdgeFactory;
import org.fmph.knet.jung.io.VertexFactory;

public class EdgeFormatReader<V, E> {
    final EdgeFactory<E> eFactory;
    final VertexFactory<V> vFactory;

    public EdgeFormatReader(VertexFactory<V> vFactory, EdgeFactory<E> eFactory) {
        this.vFactory = vFactory;
        this.eFactory = eFactory;
    }

    public UndirectedGraph<V, E> readGraph(String fileName) throws NumberFormatException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        UndirectedSparseGraph graph = new UndirectedSparseGraph();
        HashMap vertexes = new HashMap();
        while ((line = reader.readLine()) != null) {
            String[] edge = line.trim().split("\\s+");
            Object va = vertexes.get(edge[0]);
            va = va == null ? this.vFactory.createVertex(edge[0]) : va;
            vertexes.put(edge[0], va);
            Object vb = vertexes.get(edge[1]);
            vb = vb == null ? this.vFactory.createVertex(edge[1]) : vb;
            vertexes.put(edge[1], vb);
            graph.addEdge(this.eFactory.createEdge(new Pair(va, vb)), va, vb);
        }
        return graph;
    }
}

