/*
 * Decompiled with CFR 0.152.
 */
package org.fmph.knet.infection.simulator;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import org.fmph.knet.infection.Environment;
import org.fmph.knet.infection.HealthModifier;
import org.fmph.knet.infection.HealthStatus;
import org.fmph.knet.infection.Pair;
import org.fmph.knet.infection.Person;
import org.fmph.knet.infection.VaccinationProvider;
import org.fmph.knet.infection.simulator.PersonImpl;

public abstract class Simulator {
    private final VaccinationProvider provider;
    private final Environment environment;
    private int time = 0;
    private boolean beforeSimulation = true;

    public Simulator(Environment environment, VaccinationProvider vaccinationProvider) {
        this.environment = environment;
        this.provider = vaccinationProvider;
        if (environment.getGraph().getVertexCount() > 0 && !(environment.getGraph().getVertices().iterator().next() instanceof PersonImpl)) {
            throw new RuntimeException("Podporovane su iba instancie triedy org.fpmh.knet.infection.simulator.PersonImpl!!!");
        }
        this.init();
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected abstract Collection<HealthModifier> produceVaccines();

    public abstract HealthStatus resolveStatus(PersonImpl var1);

    protected abstract void init();

    public final void simulate() {
        this.beforeSimulation = false;
        while (this.getTime() < this.environment.getFinalTime()) {
            this.step();
            this.logState(Level.FINE);
            ++this.time;
        }
        this.logState(Level.INFO);
    }

    public void initialModifiersApplication(Collection<Pair<PersonImpl, HealthModifier>> toApply) {
        if (!this.beforeSimulation) {
            return;
        }
        for (Pair<PersonImpl, HealthModifier> pair : toApply) {
            pair.getFirst().recieveHealthModifier(pair.getSecond());
            pair.getFirst().processModifiers(this);
        }
    }

    protected void step() {
        for (Person p : this.environment.getGraph().getVertices()) {
            ((PersonImpl)p).nextDay(this);
        }
        this.logState(Level.FINEST);
        Collection<HealthModifier> produceVaccines = this.produceVaccines();
        int max = this.produceVaccines().size();
        Collection<Pair<Person, HealthModifier>> vaccination = this.provider.getVaccination(this, this.environment, produceVaccines);
        int i = 0;
        for (Pair<Person, HealthModifier> pair : vaccination) {
            if (i >= max) break;
            ((PersonImpl)pair.getFirst()).recieveHealthModifier(pair.getSecond());
            ++i;
        }
        this.logState(Level.FINEST);
        for (Person person : this.environment.getGraph().getVertices()) {
            PersonImpl pi = (PersonImpl)person;
            pi.spreadModifiers(this.spreadingStrategy(pi));
        }
        this.logState(Level.FINEST);
        for (Person person : this.environment.getGraph().getVertices()) {
            ((PersonImpl)person).processModifiers(this);
        }
        this.logState(Level.FINEST);
    }

    protected Collection<PersonImpl> spreadingStrategy(PersonImpl p) {
        LinkedList<PersonImpl> result = new LinkedList<PersonImpl>();
        for (Person pe : this.environment.getGraph().getNeighbors((Object)p)) {
            result.add((PersonImpl)pe);
        }
        return result;
    }

    public final int getTime() {
        return this.time;
    }

    public abstract void logState(Level var1);
}

