/*
 * Decompiled with CFR 0.152.
 */
package org.fmph.knet.infection.simulator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fmph.knet.infection.HealthModifier;
import org.fmph.knet.infection.HealthStatus;
import org.fmph.knet.infection.Person;
import org.fmph.knet.infection.simulator.Simulator;

public class PersonImpl
implements Person {
    private Object id;
    private List<HealthModifier> receivedModifiers = new ArrayList<HealthModifier>();
    private Map<Object, HealthModifier> myModifiers = new HashMap<Object, HealthModifier>();

    public PersonImpl(Object id) {
        this.id = id;
    }

    @Override
    public HealthStatus getHealthStatus(Simulator simulator) {
        return simulator.resolveStatus(this);
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public Collection<HealthModifier> getModifiers() {
        return this.myModifiers.values();
    }

    public void spreadModifiers(Collection<PersonImpl> toSpread) {
        for (HealthModifier modifier : this.sortedModifiers(this.myModifiers.values())) {
            for (PersonImpl p : toSpread) {
                if (!modifier.isSpreading()) continue;
                p.recieveHealthModifier(modifier.duplicate());
            }
        }
    }

    private List<HealthModifier> sortedModifiers(Collection<HealthModifier> modifiers) {
        HealthModifier[] sorted = modifiers.toArray(new HealthModifier[0]);
        Arrays.sort(sorted, new Comparator<HealthModifier>(){

            @Override
            public int compare(HealthModifier o1, HealthModifier o2) {
                return o2.priority() - o1.priority();
            }
        });
        return Arrays.asList(sorted);
    }

    public void recieveHealthModifier(HealthModifier modifier) {
        this.receivedModifiers.add(modifier);
    }

    void processModifiers(Simulator simulator) {
        for (HealthModifier modifier : this.sortedModifiers(this.receivedModifiers)) {
            modifier.apply(this, simulator);
        }
        this.receivedModifiers = new ArrayList<HealthModifier>();
    }

    public void nextDay(Simulator simulator) {
        for (HealthModifier modifier : this.sortedModifiers(this.myModifiers.values())) {
            modifier.nextDay(this, simulator);
        }
    }

    public void addModifier(HealthModifier hm) {
        this.myModifiers.put(hm.getType(), hm);
    }

    public void removeModifier(HealthModifier modifier) {
        this.myModifiers.remove(modifier);
        this.myModifiers.remove(modifier.getType());
    }

    public String toString() {
        return "Person(" + this.id + " " + this.myModifiers.values().toString() + ", " + this.receivedModifiers.toString() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersonImpl other = (PersonImpl)obj;
        return this.id.equals(other.id);
    }
}

