/*
 * Decompiled with CFR 0.152.
 */
package org.fmph.knet.infection.simple;

import edu.uci.ics.jung.graph.Hypergraph;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fmph.knet.infection.Environment;
import org.fmph.knet.infection.HealthModifier;
import org.fmph.knet.infection.HealthStatus;
import org.fmph.knet.infection.Pair;
import org.fmph.knet.infection.Person;
import org.fmph.knet.infection.VaccinationProvider;
import org.fmph.knet.infection.simple.FixedVaccinator;
import org.fmph.knet.infection.simple.GraphWriter;
import org.fmph.knet.infection.simple.RandomRangeInfector;
import org.fmph.knet.infection.simple.SimpleEnvironment;
import org.fmph.knet.infection.simple.SimpleVaccinationProvider;
import org.fmph.knet.infection.simulator.PersonImpl;
import org.fmph.knet.infection.simulator.Simulator;

public class SimpleSimulator
extends Simulator {
    private static Random r = new Random(System.currentTimeMillis());
    private static final Logger LOGGER = Logger.getLogger("One");
    private int mandays = 0;

    public SimpleSimulator(SimpleEnvironment environment, SimpleVaccinationProvider provider) {
        super(environment, new FixedVaccinationProvider(provider));
        environment.setSimulator(this);
    }

    @Override
    protected SimpleEnvironment getEnvironment() {
        return (SimpleEnvironment)super.getEnvironment();
    }

    private int getAvailableVaccines() {
        double rate = this.getEnvironment().getMaxVaccinationRate() / (double)(this.getEnvironment().getVaccineInfo().time() + 1);
        return (int)((double)this.getEnvironment().getGraph().getVertexCount() * rate);
    }

    @Override
    protected Collection<HealthModifier> produceVaccines() {
        LinkedList<HealthModifier> vaccines = new LinkedList<HealthModifier>();
        int i = 0;
        while (i < this.getAvailableVaccines()) {
            vaccines.add(new FixedVaccinator(this.getEnvironment().getVaccineInfo()));
            ++i;
        }
        return vaccines;
    }

    @Override
    protected void step() {
        super.step();
        for (Person p : this.getEnvironment().getGraph().getVertices()) {
            if (p.getHealthStatus(this) != HealthStatus.INFECTED) continue;
            ++this.mandays;
        }
    }

    @Override
    public HealthStatus resolveStatus(PersonImpl person) {
        if (person.getModifiers().isEmpty()) {
            return HealthStatus.NORMAL;
        }
        if (person.getModifiers().iterator().next() instanceof RandomRangeInfector) {
            return HealthStatus.INFECTED;
        }
        if (person.getModifiers().iterator().next() instanceof FixedVaccinator) {
            return HealthStatus.IMMUNE;
        }
        return HealthStatus.UNDEFINED;
    }

    @Override
    protected void init() {
        SimpleEnvironment env = this.getEnvironment();
        for (Person p : env.getGraph().getVertices()) {
            if (!(r.nextDouble() < env.getInitialInfectionRate())) continue;
            ((PersonImpl)p).addModifier(new RandomRangeInfector(env.getInfection()));
        }
    }

    public void initalVaccination(Collection<PersonImpl> toVaccinate) {
        LinkedList<Pair<PersonImpl, HealthModifier>> toApply = new LinkedList<Pair<PersonImpl, HealthModifier>>();
        for (PersonImpl p : toVaccinate) {
            toApply.add(new Pair<PersonImpl, FixedVaccinator>(p, new FixedVaccinator(this.getEnvironment().getVaccineInfo())));
        }
        this.initialModifiersApplication(toApply);
    }

    @Override
    public void logState(Level level) {
        int vertices = this.getEnvironment().getGraph().getVertexCount();
        int immune = 0;
        int normal = 0;
        int infected = 0;
        int undefined = 0;
        for (Person p : this.getEnvironment().getGraph().getVertices()) {
            switch (p.getHealthStatus(this)) {
                case NORMAL: {
                    ++normal;
                    break;
                }
                case IMMUNE: {
                    ++immune;
                    break;
                }
                case INFECTED: {
                    ++infected;
                    break;
                }
                default: {
                    ++undefined;
                }
            }
        }
        double pIm = (double)immune / (double)vertices;
        double pN = (double)normal / (double)vertices;
        double pInf = (double)infected / (double)vertices;
        double pUn = (double)undefined / (double)vertices;
        NumberFormat format = NumberFormat.getPercentInstance();
        LOGGER.log(level, "STEP: " + this.getEnvironment().getTime() + " / " + this.getEnvironment().getFinalTime());
        LOGGER.log(level, "Vertices:  " + vertices);
        LOGGER.log(level, "Normal:  " + normal + "    " + format.format(pN));
        LOGGER.log(level, "Infected:  " + infected + "    " + format.format(pInf));
        LOGGER.log(level, "Immune:  " + immune + "    " + format.format(pIm));
        LOGGER.log(level, "Undefined:  " + undefined + "    " + format.format(pUn));
        LOGGER.log(level, "Osobodn\u00ed nakazen\u00fdch:  " + this.mandays);
        if (LOGGER.getParent().getLevel() == level) {
            this.saveGraph("simple" + this.getTime() + ".graphml");
        }
    }

    public void saveGraph(String fileName) {
        GraphWriter writer = new GraphWriter(this);
        try {
            FileWriter w = new FileWriter(fileName);
            writer.save((Hypergraph)this.getEnvironment().getGraph(), w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class FixedVaccinationProvider
    implements VaccinationProvider {
        SimpleVaccinationProvider provider;

        FixedVaccinationProvider(SimpleVaccinationProvider provider) {
            this.provider = provider;
        }

        @Override
        public Collection<Pair<Person, HealthModifier>> getVaccination(Simulator simulator, Environment environment, Collection<HealthModifier> availableVaccines) {
            LinkedList<Pair<Person, HealthModifier>> result = new LinkedList<Pair<Person, HealthModifier>>();
            LinkedList<HealthModifier> available = new LinkedList<HealthModifier>(availableVaccines);
            for (Person p : this.provider.getVaccination((SimpleSimulator)simulator, (SimpleEnvironment)environment, availableVaccines.size())) {
                if (available.isEmpty()) continue;
                HealthModifier modifier = (HealthModifier)available.iterator().next();
                result.add(new Pair<Person, HealthModifier>(p, modifier));
                available.remove(modifier);
            }
            return result;
        }
    }
}

