/*
 * Decompiled with CFR 0.152.
 */
package org.fmph.knet.infection.simple;

import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.fmph.knet.infection.Environment;
import org.fmph.knet.infection.Person;
import org.fmph.knet.infection.simple.Infection;
import org.fmph.knet.infection.simple.Vaccine;
import org.fmph.knet.infection.simulator.Edge;
import org.fmph.knet.infection.simulator.PersonImpl;
import org.fmph.knet.infection.simulator.Simulator;
import org.fmph.knet.jung.io.EdgeFactory;
import org.fmph.knet.jung.io.EdgeFormatReader;
import org.fmph.knet.jung.io.VertexFactory;

public class SimpleEnvironment
implements Environment {
    private int finalTime;
    private double initialInfectionRate;
    private Vaccine vaccine;
    private Infection infection;
    private UndirectedGraph<Person, Edge> graph;
    private Simulator simulator;
    private double maxVaccinationRate;

    public SimpleEnvironment(Properties p, UndirectedGraph<Person, Edge> graph) {
        this.graph = graph;
        this.finalTime = Integer.parseInt(p.getProperty("FinalTime", "100"));
        this.initialInfectionRate = Double.parseDouble(p.getProperty("InitialInfectionRate", "5")) / 100.0;
        this.maxVaccinationRate = Double.parseDouble(p.getProperty("MaximalVaccinationRate", "20")) / 100.0;
        int min = Integer.parseInt(p.getProperty("MinimalInfectionTime", "5"));
        int max = Integer.parseInt(p.getProperty("MaximalInfectionTime", "8"));
        double prob = Double.parseDouble(p.getProperty("InfectionProbability", "20")) / 100.0;
        this.infection = new Infection(min, max, prob);
        int time = Integer.parseInt(p.getProperty("VaccinationDuration", "12"));
        this.vaccine = new Vaccine(time);
    }

    public void setSimulator(Simulator simulator) {
        this.simulator = simulator;
    }

    @Override
    public int getFinalTime() {
        return this.finalTime;
    }

    @Override
    public UndirectedGraph<Person, Edge> getGraph() {
        return this.graph;
    }

    public static SimpleEnvironment load(String properties, String edgeFile) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        p.load(new FileReader(properties));
        UndirectedGraph<Person, Edge> graph = SimpleEnvironment.loadGraph(edgeFile);
        return new SimpleEnvironment(p, graph);
    }

    private static UndirectedGraph<Person, Edge> loadGraph(String edgeFile) throws NumberFormatException, IOException {
        EdgeFormatReader<Person, Edge> reader = new EdgeFormatReader<Person, Edge>(new VertexFactory<Person>(){

            @Override
            public Person createVertex(Object param) {
                return new PersonImpl(param);
            }
        }, new EdgeFactory<Edge>(){

            @Override
            public Edge createEdge(Object param) {
                Pair ids = (Pair)param;
                return new Edge((PersonImpl)ids.getFirst(), (PersonImpl)ids.getSecond());
            }
        });
        return reader.readGraph(edgeFile);
    }

    public double getInitialInfectionRate() {
        return this.initialInfectionRate;
    }

    public Vaccine getVaccineInfo() {
        return this.vaccine;
    }

    public Infection getInfection() {
        return this.infection;
    }

    @Override
    public int getTime() {
        return this.simulator.getTime();
    }

    public double getMaxVaccinationRate() {
        return this.maxVaccinationRate;
    }
}

