/*
 * Decompiled with CFR 0.152.
 */
package org.fmph.knet.infection.simple;

import java.util.Random;
import org.fmph.knet.infection.HealthModifier;
import org.fmph.knet.infection.HealthStatus;
import org.fmph.knet.infection.Person;
import org.fmph.knet.infection.simple.Infection;
import org.fmph.knet.infection.simulator.PersonImpl;
import org.fmph.knet.infection.simulator.Simulator;

public class RandomRangeInfector
implements HealthModifier {
    private static Random r = new Random(System.currentTimeMillis());
    private Infection infection;
    private int timeToDie;
    private int duration;

    public RandomRangeInfector(Infection infection) {
        this.infection = infection;
        this.duration = this.timeToDie = RandomRangeInfector.getInfectionTime(infection);
    }

    @Override
    public Object getType() {
        return this.infection;
    }

    static int getInfectionTime(Infection infection) {
        return infection.getMinimalInfectionTime() + r.nextInt(infection.getMaximalInfectionTime() - infection.getMinimalInfectionTime() + 1);
    }

    @Override
    public void apply(Person p, Simulator simulator) {
        double pr;
        if (p.getHealthStatus(simulator) == HealthStatus.NORMAL && (pr = r.nextDouble()) < this.infection.probability()) {
            ((PersonImpl)p).addModifier(this);
        }
    }

    @Override
    public boolean isSpreading() {
        return true;
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public void nextDay(Person person, Simulator simulator) {
        if (this.timeToDie == 0) {
            ((PersonImpl)person).removeModifier(this);
        }
        --this.timeToDie;
    }

    @Override
    public HealthModifier duplicate() {
        return new RandomRangeInfector(this.infection);
    }

    public String toString() {
        return "INF(" + this.timeToDie + "/" + this.duration + ")";
    }
}

