/*
 * Decompiled with CFR 0.152.
 */
package org.fmph.knet.infection.simple;

import edu.uci.ics.jung.io.GraphMLMetadata;
import edu.uci.ics.jung.io.GraphMLWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.fmph.knet.infection.HealthStatus;
import org.fmph.knet.infection.Person;
import org.fmph.knet.infection.simulator.Edge;
import org.fmph.knet.infection.simulator.Simulator;

public class GraphWriter
extends GraphMLWriter<Person, Edge> {
    private final Simulator simulator;
    private final Map<String, String> types = new HashMap<String, String>();

    public GraphWriter(Simulator simulatorx) {
        this.simulator = simulatorx;
        this.setVertexIDs((Transformer)new Transformer<Person, String>(){

            public String transform(Person arg0) {
                return (String)arg0.getId();
            }
        });
        this.types.put("HealthStatus", "String");
        this.addVertexData("HealthStatus", "HealthStatus", "NORMAL", (Transformer)new Transformer<Person, String>(){

            public String transform(Person arg0) {
                return arg0.getHealthStatus(GraphWriter.this.simulator).name();
            }
        });
        this.types.put("HS", "Integer");
        this.addVertexData("HS", "HS", "1", (Transformer)new Transformer<Person, String>(){

            public String transform(Person arg0) {
                return String.valueOf(arg0.getHealthStatus(GraphWriter.this.simulator).getKey());
            }
        });
        this.types.put("Weight", "Integer");
        this.addEdgeData("Weight", "Weight", "1", (Transformer)new Transformer<Edge, String>(){

            public String transform(Edge arg0) {
                HealthStatus hsb;
                HealthStatus hsa = arg0.getNodeA().getHealthStatus(GraphWriter.this.simulator);
                if (hsa == (hsb = arg0.getNodeB().getHealthStatus(GraphWriter.this.simulator))) {
                    return "1";
                }
                if (!(hsa != HealthStatus.IMMUNE && hsb != HealthStatus.IMMUNE || hsa != HealthStatus.NORMAL && hsb != HealthStatus.NORMAL)) {
                    return "1";
                }
                if (hsa == HealthStatus.INFECTED || hsb == HealthStatus.INFECTED) {
                    if (hsa == HealthStatus.NORMAL || hsb == HealthStatus.NORMAL) {
                        return "3";
                    }
                    if (hsa == HealthStatus.IMMUNE || hsb == HealthStatus.IMMUNE) {
                        return "1";
                    }
                }
                return "-1";
            }
        });
    }

    protected void writeKeySpecification(String key, String type, GraphMLMetadata<?> ds, BufferedWriter bw) throws IOException {
        String def;
        bw.write("<key id=\"" + key + "\" for=\"" + type + "\" attr.type=\"" + this.types.get(key) + "\"");
        boolean closed = false;
        String desc = ds.description;
        if (desc != null) {
            if (!closed) {
                bw.write(">\n");
                closed = true;
            }
            bw.write("<desc>" + desc + "</desc>\n");
        }
        if ((def = ds.default_value) != null) {
            if (!closed) {
                bw.write(">\n");
                closed = true;
            }
            bw.write("<default>" + def.toString() + "</default>\n");
        }
        if (!closed) {
            bw.write("/>\n");
        } else {
            bw.write("</key>\n");
        }
    }
}

