/*
 * Decompiled with CFR 0.152.
 */
package org.fmph.knet.infection.simple;

import org.fmph.knet.infection.HealthModifier;
import org.fmph.knet.infection.HealthStatus;
import org.fmph.knet.infection.Person;
import org.fmph.knet.infection.simple.Vaccine;
import org.fmph.knet.infection.simulator.PersonImpl;
import org.fmph.knet.infection.simulator.Simulator;

public class FixedVaccinator
implements HealthModifier {
    private Vaccine vaccine;
    private int timeToDie;

    public FixedVaccinator(Vaccine vaccine) {
        this.vaccine = vaccine;
        this.timeToDie = vaccine.time();
    }

    @Override
    public void apply(Person p, Simulator simulator) {
        if (p.getHealthStatus(simulator) == HealthStatus.NORMAL) {
            ((PersonImpl)p).addModifier(this);
        }
    }

    @Override
    public Object getType() {
        return this.vaccine;
    }

    @Override
    public boolean isSpreading() {
        return false;
    }

    @Override
    public int priority() {
        return 2;
    }

    @Override
    public void nextDay(Person person, Simulator simulator) {
        if (this.timeToDie == 0) {
            ((PersonImpl)person).removeModifier(this);
        }
        --this.timeToDie;
    }

    @Override
    public HealthModifier duplicate() {
        return new FixedVaccinator(this.vaccine);
    }

    public String toString() {
        return "VAC(" + this.timeToDie + "/" + this.vaccine.time + ")";
    }
}

