#lang racket

;;;; 1. cvičenie z predmetu 2-AIN-285 Symbolické programovanie a LISP
;;;;
;;;; Meno a priezvisko:
;;;; Verzia DrRacket: 7.5
;;;; Dátum: 17.2.2020
;;;; WWW: http://www.ii.fmph.uniba.sk/cl/view.php/courses/2-AIN-285-lisp/1920ls/?lang=sk 
;;;; Kontakt: Jan.Komara(at)fmph.uniba.sk 
;;;;
;;;; Úvodná poznámka. Toto cvičenie je venované týmto témam:
;;;; - vyhodnocovanie výrazov,
;;;; - explicitné definície,
;;;; - rekurzívne definície.
;;;; Zadanie sa skladá z týchto súborov: 
;;;; - Súbory ex*.rkt obsahujú úlohy, ktoré máte riešiť na tomto cvičení.
;;;;
;;;; Hodnotenie. vyhodnocovaniu
;;;; - Počet bodov za úlohy v tomto súbore: 3 
;;;; - Počet bodov za prémiove úlohy v tomto súbore: 1 
;;;; - Počet bodov za projektové úlohy v tomto súbore: 0 
;;;; Odovzdať do 23.2.2020 (nedeľa) do 18:00.

;; [Lisp]

(require racket/undefined)
(define ... undefined)
(define (query f m n) (for/list ([i (in-range m (+ n 1))]) (list i (f i))))

;; Literatúra.
;; [1] Hal Abelson and Jerry Sussman and Julie Sussman.
;;     Structure and Interpretation of Computer Programs.
;;     MIT Press, second edition, 1996. 

;;; Kapitola. Rekurzívne definície.

;;; Sekcia. Primitívna rekurzia.

;; Príklad. Nasledujúci komponent obsahuje definíciu sumačnej funkcie pomocou
;; primitívnej rekurzie:
;;   sum(0) = 0
;;   sum(n+1) = sum(n)+n+1

(define (sum n)
  (if (= n 0)
      0
      (+ (sum (- n 1)) n)))

;; (query sum 0 10)

;; (1 bod)
;; Úloha. Definujte primitívnou rekurziou funkciu faktoriál fact(n) ≡ n!:
;;   0! = 1
;;   (n+1)! = (n+1)×n!

(define (fact n) ...)

;; (query fact 0 10)

;; Úloha. Definujte primitívnou rekurziou operáciu umocnenia exp(a,n) ≡ a^n:
;;   a^0 = 1
;;   a^(n+1) = a×a^n

(define (exp a n) ...)

;; (query (λ (n) (exp 2 n)) 0 10)

;; (prémia 1 bod)
;; Úloha. Definujte primitívnou rekurziou funkciu integer-sqrt, ktorej výsledkom
;; pre dané prirodzené číslo je jeho celočíselná druhá odmocnina:
;;   integer-sqrt(x) = y ↔ y^2 ≤ x < (y+1)^2
;; Kvôli efektivite doporučujeme využiť špeciálnu formu let resp. let*.

(define (integer-sqrt x) ...)

;; (query integer-sqrt 0 10)

;;; Sekcia. Obyčajná rekurzia.

;; Úloha. Nájdite rekurzívnu definíciu funkcie, ktorá enumeruje Fibonacciho
;; postupnosť:
;;   fib(0) = 0
;;   fib(1) = 1
;;   fib(n+2) = fib(n+1)+fib(n)

(define (fib n) ...)

;; (query fib 0 10)

;; (1 bod)
;; Úloha. Implementujte Euklidov algoritmus pre výpočet najväčšieho spoločného
;; deliteľa dvoch prirodzených čísel. Idea algoritmu je vyjadrená touto
;; vlastnosťou
;;   x ≠ 0 ∧ d | x → d | y ↔ d | y mod x

(define (gcd x y) ...)

;; (query (λ (y) (gcd 6 y)) 1 20)

;;; Sekcia. Rekurzia s mierou.

;; Úloha. Implementujte Euklidov algoritmus pre výpočet najväčšieho spoločného
;; deliteľa dvoch nenulových prirodzených čísel. Idea algoritmu je vyjadrená
;; touto vlastnosťou
;;   x < y ∧ d | x → d | y ↔ d | y-x

(define (gcd2 x y) ...)

;; query (λ (y) (gcd2 6 y)) 1 20)

;;; Sekcia. Transfinitná rekurzia.

;; (1 bod)
;; Úloha. Definujte Ackermann-Péterovej funkciu:
;;   A(0,y) = y+1
;;   A(x+1,0) = A(x,1)
;;   A(x+1,y+1) = A(x,A(x+1,y))
;; Platí:
;;   A(1,y) = y+2
;;   A(2,y) = 2y+3 = 2(y+3)-3
;;   A(3,y) = 8×2^y-3 = 2^(y+3)-3
;;   A(4,y) = 2^2^...^2-3

(define (A x y) ...)

;; (query (λ (y) (A 0 y)) 0 10)
;; (query (λ (y) (A 1 y)) 0 10)
;; (query (λ (y) (A 2 y)) 0 10)
;; (query (λ (y) (A 3 y)) 0 10)
;; (query (λ (y) (A 4 y)) 0 1)
