#lang racket

;;;; 1. cvičenie z predmetu 2-AIN-285 Symbolické programovanie a LISP
;;;;
;;;; Meno a priezvisko:
;;;; Verzia DrRacket: 7.5
;;;; Dátum: 17.2.2020
;;;; WWW: http://www.ii.fmph.uniba.sk/cl/view.php/courses/2-AIN-285-lisp/1920ls/?lang=sk 
;;;; Kontakt: Jan.Komara(at)fmph.uniba.sk 
;;;;
;;;; Úvodná poznámka. Toto cvičenie je venované týmto témam:
;;;; - vyhodnocovanie výrazov,
;;;; - explicitné definície,
;;;; - rekurzívne definície.
;;;; Zadanie sa skladá z týchto súborov: 
;;;; - Súbory ex*.rkt obsahujú úlohy, ktoré máte riešiť na tomto cvičení.
;;;;
;;;; Hodnotenie. vyhodnocovaniu
;;;; - Počet bodov za úlohy v tomto súbore: 1 
;;;; - Počet bodov za prémiove úlohy v tomto súbore: 0 
;;;; - Počet bodov za projektové úlohy v tomto súbore: 0 
;;;; Odovzdať do 23.2.2020 (nedeľa) do 18:00.

;; [Lisp]

(require racket/undefined)
(define ... undefined)
(define (query f m n) (for/list ([i (in-range m (+ n 1))]) (list i (f i))))

;; Literatúra.
;; [1] Hal Abelson and Jerry Sussman and Julie Sussman.
;;     Structure and Interpretation of Computer Programs.
;;     MIT Press, second edition, 1996. 

;;; Kapitola. Explicitné definície.

;;; Sekcia. Jednoduché explicitné definície.

;; Príklad. Nasledujúci komponent obsahuje definíciu funkcie, ktorá vráti
;; štvorec (druhú mocninu) daného čísla.

(define (square x) (* x x))

;; (square 5)
;; (query square 0 10)

;; Úloha. Definujte funkciu, ktorá pre dané číslo vráti jeho tretiu mocninu.

(define (cube x) ...)

;; (cube 5)
;; (query cube 0 10)

;; Úloha. Zostrojte program, ktorý pre dané dve čísla vypočíta súčet ich
;; štvorcov. 

(define (sum-of-squares x y) ...)

;; (sum-of-squares 3 4)
;; (query (λ (y) (sum-of-squares 1 y)) 0 10)

;;; Sekcia. Priradenia.

;; Príklad. Nasledujúci komponent obsahuje program pre funkciu, ktorá pre dané
;; číslo vráti jeho štvrtú mocninu. Všimnite si použitie špeciálnej formy let.
;; Tá zaručí, že sú potrebné len 2 násobenia.

(define (fourth-power x) (let ([y (* x x)]) (* y y)))

;; (fourth-power 5)
;; (query fourth-power 0 10)

;; Úloha. Zostrojte program, ktorý vypočíta piatu mocninu vstupného čísla.
;; Nájdite implementáciu, v ktorej sú potrebné len 3 násobenia.

(define (fifth-power x) ...)

;; (fifth-power 5)
;; (query fifth-power 0 10)

;;; Sekcia. Podmienkové výrazy.

;; Príklad. Nasledujúci komponent obsahuje definíciu signum funkcie, ktorá
;; vráti znamienko daného reálneho čísla:
;;   (x > 0 → sgn(x) = 1) ∧ sgn(0) = 0 ∧ (x < 0 → sgn(x) = -1)
;; Všimnite si použitie špeciálnej formy cond.

(define (sgn x)
  (cond [(> x 0) 1]
        [(= x 0) 0]
        [(< x 0) -1]))

;; (query sgn -5 5)

;; Alternatívna definícia pomocou špeciálnej formy else.

(define (sgn2 x)
  (cond [(> x 0) 1]
        [(= x 0) 0]
        [else -1]))

;; (query sgn2 -5 5)

;; Alternatívna definícia pomocou špeciálnej formy if.

(define (sgn3 x)
  (if (> x 0)
      1
      (if (= x 0)
          0
          -1)))

;; (query sgn3 -5 5)

;; Úloha. Definujte funkciu abs, ktorej výsledkom pre dané reálne číslo je jeho
;; absolútna hodnota:
;;   (x > 0 → abs(x) = x) ∧ abs(0) = 0 ∧ (x < 0 → abs(x) = -x)

(define (abs x) ...)

;; (query abs -5 5)

;; Úloha. Definujte binárnu funkciu min, ktorá pre dané dve čísla vráti ich
;; minimum:
;;   min(x,y) ≤ x ∧ min(x,y) ≤ y ∧ (min(x,y) = x ∨ min(x,y) = y)

(define (min x y) ...)

;; (query (λ (y) (min 5 y)) 0 10)

;; Úloha. Definujte binárnu funkciu max, ktorej výsledkom pre dané dve čísla je
;; ich maximum:
;;   max(x,y) ≥ x ∧ max(x,y) ≥ y ∧ (max(x,y) = x ∨ max(x,y) = y)

(define (max x y) ...)

;; (query (λ (y) (max 5 y)) 0 10)

;; (1 bod)
;; Úloha. Definujte ternárnu funkciu median, ktorá pre dané tri čísla vráti ich
;; medián:
;;   x ≤ y ∧ y ≤ z → median(x,y,z) = y
;;   median(x,y,z) = median(y,x,z) ∧ median(x,y,z) = median(x,z,y)

(define (median x y z) ...)

;; (query (λ (y) (median 2 y 8)) 0 10)
