#lang racket

;;;; 1. cvičenie z predmetu 2-AIN-285 Symbolické programovanie a LISP
;;;;
;;;; Meno a priezvisko:
;;;; Verzia DrRacket: 7.5
;;;; Dátum: 17.2.2020
;;;; WWW: http://www.ii.fmph.uniba.sk/cl/view.php/courses/2-AIN-285-lisp/1920ls/?lang=sk 
;;;; Kontakt: Jan.Komara(at)fmph.uniba.sk 
;;;;
;;;; Úvodná poznámka. Toto cvičenie je venované týmto témam:
;;;; - vyhodnocovanie výrazov,
;;;; - explicitné definície,
;;;; - rekurzívne definície.
;;;; Zadanie sa skladá z týchto súborov: 
;;;; - Súbory ex*.rkt obsahujú úlohy, ktoré máte riešiť na tomto cvičení.
;;;;
;;;; Hodnotenie. vyhodnocovaniu
;;;; - Počet bodov za úlohy v tomto súbore: 0 
;;;; - Počet bodov za prémiove úlohy v tomto súbore: 0 
;;;; - Počet bodov za projektové úlohy v tomto súbore: 0 
;;;; Odovzdať do 23.2.2020 (nedeľa) do 18:00.

;; Literatúra.
;; [1] Hal Abelson and Jerry Sussman and Julie Sussman.
;;     Structure and Interpretation of Computer Programs.
;;     MIT Press, second edition, 1996. 

;;; Kapitola. Vyhodnocovanie výrazov.

;; V tejto časti použijeme Lisp ako kalkulačku na vyhodnocovanie výrazov formou dopytov.
;; Na zadávanie dopytov slúži interaktívne okno Run.

;; Základné aritmetické operácie.
;; - Sčítanie.
;;   - M-syntax: 2+3.      Lisp syntax: (+ 2 3).
;;   - M-syntax: 2+3+4.    Lisp syntax: (+ 2 3 4). 
;; - Odčítanie. 
;;   - M-syntax: 2-3.      Lisp syntax: (- 2 3).
;;   - M-syntax: 2-3-4.    Lisp syntax: (- 2 3 4). 
;; - Násobenie. 
;;   - M-syntax: 2×3.      Lisp syntax: (* 2 3).
;;   - M-syntax: 2×3×4.    Lisp syntax: (* 2 3 4). 
;; - Racionálne delenie.
;;   - M-syntax: 17/5.     Lisp syntax: (/ 17 5).
;;   - M-syntax: 17/5/3.   Lisp syntax: (/ 17 5 3).
;; - Celočíselné (euklidovské, neúplné) delenie.
;;   - M-syntax: 17÷5.     Lisp syntax: (quotient 17 5).
;; - Zvyšok po celočíselnom delení.
;;   - M-syntax: 17 mod 5. Lisp syntax: (remainder 17 5) resp. (modulo 17 5).

;; Základné aritmetické predikáty.
;; - Rovnosť.
;;   - M-syntax: 1 = 2. Lisp syntax: (= 1 2).
;; - Nerovnosť.
;;   - M-syntax: 1 ≠ 2. Lisp syntax: (not (= 1 2)).
;; - Vzťah menší.
;;   - M-syntax: 1 < 2. Lisp syntax: (< 1 2).
;; - Vzťah menší alebo rovný.
;;   - M-syntax: 1 ≤ 2. Lisp syntax: (<= 1 2).
;; - Vzťah väčší.
;;   - M-syntax: 1 > 2. Lisp syntax: (> 1 2).
;; - Vzťah väčší alebo rovný.
;;   - M-syntax: 1 ≥ 2. Lisp syntax: (>= 1 2).

;; Základné výrokovo-logické spojky a im odpovedajúce boolovské operácie.
;; - Negácia.
;;   - M-syntax: ¬1 = 2.                Lisp syntax: (not (= 1 2)).
;; - Konjukcia.
;;   - M-syntax: 1 = 1 ∧ 2 = 2.         Lisp syntax: (and (= 1 1) (= 2 2)).
;;   - M-syntax: 1 = 1 ∧ 2 = 2 ∧ 3 = 3. Lisp syntax: (and (= 1 1) (= 2 2) (= 3 3)).
;; - Disjunkcia.
;;   - M-syntax: 1 ≤ 2 ∨ 1 ≥ 2.         Lisp syntax: (or (<= 1 2) (>= 1 2)).
;;   - M-syntax: 1 < 2 ∨ 1 = 2 ∨ 1 > 2. Lisp syntax: (or (< 1 2) (= 1 2) (> 1 2)).
;; - Implikácia.
;;   - M-syntax: 1 < 2 → 1 ≥ 2.         Lisp syntax: (implies (< 1 2) (<= 1 2)).
;; - Ekvivalencia.
;;   - M-syntax: 1 < 2 ↔ 2 > 1.
;; Viacargumentové boolovské operácie sa vyhodnocujú nestriktne.
;; Najprv sa vyhodnotí prvý argument a až potom podľa potreby ďalší.

;; Úloha. Vyhodnoťte nasledujúce výrazy:
;:   M-syntax: 3×5+(10-6)             Lisp syntax: ...
;;   M-syntax: 3×(2×4+(3+5))+(10-7+6) Lisp syntax: ...
