mod Ex10b


loc rem 
  \para \bf  10. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2013/2014  \end 
  \para* \bf  ČASŤ B  \end
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex10.zip 

loc rem 
  \para* \it  Dátum:  \end 6. a 7. 5. 2014 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované postfixovému
  stroju a numerickým výrazom.

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2013/2014. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2014.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Maux10

incl Mtesting10

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  17. ARITMETICKÉ VÝRAZY A VÝROKOVÉ FORMULY  \end 

rem 
  \para \bf  17.3. Výrokové formuly  \end 

rem 
  \para \bf  \it  Definícia.  \end  \end \it  Výrokovou formulou  \end 
  (skrátene \it  formulou  \end) je: 
  \items 
   \item \para výroková premenná \ft Tex2_varidx(X,i) \end, 
   \item \para konštanta nepravda \ft \f \end, konštanta pravda \ft \t \end, 
   \item \para negácia \ft ~f \end, ak \ft f \end je výrokovou formulou, 
   \item \para disjunkcia \ft f1 \/ f2 \end, konjunkcia \ft f1 & f2 \end 
         a implikácia \ft f1 -> f2 \end, ak \ft f1 \end a \ft f2 \end sú 
         výrokovými formulami. 
  \end
  \para Nič iné nie je výrokovou formulou. 

rem 
  \para \bf  \it  Kódovanie výrokových formúl.  \end  \end Výrokové 
  formuly zakódujeme podobne ako binárne stromy či aritmetické výrazy 
  nasledujúcimi párovacími konštruktormi. Konštruktory jednotlivých typov 
  výrokových formúl sú uvedené v rovnakom poradí ako v predchádzajúcej 
  definícii. 
  \para Predikát \ft Form(f) \end platí, ak \ft f \end je kódom výrokovej 
  formuly. 

fun Vf 'Vf_d'
  Vf(i) = 0,i

fun/0 Ff 'Ff_d'
  Ff = 1,0

fun/0 Tf 'Tf_d'
  Tf = 2,0

fun Nf 'Nf_d'
  Nf(f1) = 3,f1

fun/2 Of 'Of_d'
  Of(f1,f2) = 4,f1,f2

fun/2 Af 'Af_d'
  Af(f1,f2) = 5,f1,f2

fun/2 If 'If_d'
  If(f1,f2) = 6,f1,f2

pred Form 
  Form Vf(i) <- N(i)
  Form(Ff)
  Form(Tf)
  Form Nf(f1) <- Form(f1)
  Form Of(f1,f2) <- Form(f1) & Form(f2)
  Form Af(f1,f2) <- Form(f1) & Form(f2)
  Form If(f1,f2) <- Form(f1) & Form(f2)

rem 
  \para \bf  \it  Príklad.  \end  \end Nasledujúca konštanta kóduje formulu 
  \ft Paren((X0 & X1)) -> Paren((X0 \/ X1)) \end. Pozrite si zdrojový kód jej 
  definície. 

fun/0 And_impl_or 
  And_impl_or = If(Af(Vf(0),Vf(1)),Of(Vf(0),Vf(1)))

rem 
  \para \bf  \it  Príklad.  \end  \end Nasledujúca konštanta kóduje formulu, 
  ktorá vyjadruje de Morganov zákon pre konjunkciu 
  \eq* 
    ~(X0 & X1) <-> Paren((~X0 \/ ~X1))
  \end
  \para pričom ekvivalencia je nahradená konjunkciou implikácií v jednom 
  a druhom smere. Aby bol kód formuly prehľadnejší, zadefinovali sme 
  konštantu klauzulou, v tele ktorej sme ľavú a pravú stranu ekvivalencie 
  priradili do pomocných premenných. 

fun/0 De_morgan_conj 
  De_morgan_conj = Af(If(notand,ornotnot),If(ornotnot,notand)) <- 
    Nf Af(Vf(0),Vf(1)) = notand & Of(Nf Vf(0),Nf Vf(1)) = ornotnot

rem 
  \para \bf  Úloha.  \end Zakódujte formulu, ktorá vyjadruje 
  distributívnosť disjunkcie cez konjunkciu 
  \eq* 
    Paren((X0 \/ Paren((X1 & X2)))) <-> 
    Paren((Paren((X0 \/ X1)) & Paren((X0 \/ X2))))
  \end
  \para Ekvivalenciu vyjadrite konjunkciou implikácií. 

fun/0 Distrib_disj_conj 
  Distrib_disj_conj = Af(Foo,Foo)

rem 
  \para \bf  Úloha.  \end \header* pred/2 True  \end Zadefinujte predikát 
  \ft Tex2_equiv(True(vs,f),Tex2_true(vs,f)) \end, ktorý platí práve vtedy, 
  keď je výroková formula s kódom \ft f \end pravdivá pri ohodnotení 
  premenných \ft vs \end. 
  \para \it  Ohodnotenie výrokových premenných  \end \ft vs \end je zoznam 
  čísel \ft 0 \end a \ft 1 \end. Výroková premenná \ft Vf(i) \end je \it  
  pravdivá pri ohodnotení \ft vs \end  \end, ak je prvok \ft Sub(vs,i) \end 
  rovný \ft 1 \end. 
  \para Testovanie: 
  \verbatim 
      True_test = rs:Results
  \end

pred/2 True 'Tex2_true'
  True(vs,Vf(i)) <- Quux
  True(vs,Ff) <- Quux
  True(vs,Tf) <- Quux
  True(vs,Nf(f1)) <- Quux
  True(vs,Af(f1,f2)) <- Quux
  True(vs,Of(f1,f2)) <- Quux
  True(vs,If(f1,f2)) <- Quux

fun/2 True_ 'Tex2_true_'
  True_(vs,f) = 0 <- ~True(vs,f)
  True_(vs,f) = 1 <- True(vs,f)

fun/0 True_test 
  True_test = 
  Check(True_((0,1,0),Vf(0)),0),Check(True_((0,1,0),Vf(1)),1),
  Check(True_((0,1,0),Vf(5)),0),Check(True_((0,1,0),Ff),0),
  Check(True_((1,1,0),Ff),0),Check(True_((0,1,0),Tf),1),
  Check(True_((1,1,0),Tf),1),Check(True_((0,1,0),Nf Vf(0)),1),
  Check(True_((1,1,0),Nf Vf(0)),0),Check(True_((0,1,0),Nf Vf(1)),0),
  Check(True_((0,0,0),Nf Vf(1)),1),Check(True_((0,0,0),Af(Vf(0),Vf(1))),0),
  Check(True_((0,1,0),Af(Vf(0),Vf(1))),0),
  Check(True_((1,0,0),Af(Vf(0),Vf(1))),0),
  Check(True_((1,1,0),Af(Vf(0),Vf(1))),1),
  Check(True_((0,0,0),Of(Vf(0),Vf(1))),0),
  Check(True_((0,1,0),Of(Vf(0),Vf(1))),1),
  Check(True_((1,0,0),Of(Vf(0),Vf(1))),1),
  Check(True_((1,1,0),Of(Vf(0),Vf(1))),1),
  Check(True_((0,0,0),If(Vf(0),Vf(1))),1),
  Check(True_((0,1,0),If(Vf(0),Vf(1))),1),
  Check(True_((1,0,0),If(Vf(0),Vf(1))),0),
  Check(True_((1,1,0),If(Vf(0),Vf(1))),1),Check(True_((0,0,0),xor),0),
  Check(True_((0,1,0),xor),1),Check(True_((1,0,0),xor),1),
  Check(True_((1,1,0),xor),0),Check(True_((1,0,0,0),ifthenelse),0),
  Check(True_((0,0,0,0),ifthenelse),0),Check(True_((1,0,1,0),ifthenelse),0),
  Check(True_((0,0,1,0),ifthenelse),1),Check(True_((1,1,0,0),ifthenelse),1),
  Check(True_((0,1,0,0),ifthenelse),0),Check(True_((1,1,1,0),ifthenelse),1),
  Check(True_((0,1,1,0),ifthenelse),1),0 <- 
    Of(Nf If(Vf(0),Vf(1)),Nf If(Vf(1),Vf(0))) = xor & 
    Af(If(Vf(0),Vf(1)),If(Nf Vf(0),Vf(2))) = ifthenelse

rem 
  \para \it  Pomocná definícia pre testovanie nasledujúcich funkcií.  \end 

fun/2 True_vals 
  True_vals(0,t) = 0
  True_vals((vs,vss),t) = True_(vs,t),True_vals(vss,t)

rem 
  \para \bf  17.4. Transformácia výrokových formúl  \end 

rem 
  \para \bf  Konjunktívne formuly  \end 

rem 
  \para \bf  \it  Definícia.  \end  \end \it  Konjunktívna formula  \end je 
  taká výroková formula, ktorá obsahuje iba výrokové premenné, negáciu 
  a konjunkciu. 
  \para Predikát \ft Cform \end platí pre kódy konjunktívnych formúl. 

pred Cform 
  Cform Vf(i) <- N(i)
  Cform Nf(f1) <- Cform(f1)
  Cform Af(f1,f2) <- Cform(f1) & Cform(f2)

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Cform_from(f) \end, ktorá 
  pre ľubovoľnú výrokovú formulu \ft f \end zostrojí ekvivalentnú 
  konjunktívnu formulu. 
  \para* \it  Špecifikácia.  \end 
  \eq* 
    Form(f) -> Cform Cform_from(f)
  \end
  \eq* 
    Form(f) -> \a vs(True(vs,f) <-> True(vs,Cform_from(f)))
  \end
  \para \it  Návod.  \end Využite nasledujúce ekvivalencie: 
  \eq* 
    \f <-> Paren((Tex2_varidx(X,Tex0_z) & ~Tex2_varidx(X,Tex0_z)))
  \end
  \eq* 
    Paren((A \/ B)) <-> ~(~A & ~B)
  \end
  \eq* 
    Paren((A -> B)) <-> ~(A & ~B)
  \end
  \para \it  Testovanie.  \end 
  \verbatim 
      Cform_from_test0 = rs:Results_form
      Cform_from_test = rs:Results_form_transf
  \end
  \para Prvý test je konkrétnejší, ale zbytočne prísny – za nesprávne 
  transformované môže prehlásiť aj formuly, ktoré vyhovujú 
  špecifikácii. Druhý test je abstraktnejší, testuje splnenie jednotlivých 
  podmienok špecifikácie. 

fun Cform_from 
  Cform_from Vf(i) = Foo
  Cform_from(Ff) = Foo
  Cform_from(Tf) = Foo
  Cform_from Nf(f1) = Foo
  Cform_from Af(f1,f2) = Foo
  Cform_from Of(f1,f2) = Foo
  Cform_from If(f1,f2) = Foo

fun/0 Cform_from_test0 
  Cform_from_test0 = 
  Check(Cform_from Af(Vf(0),Nf Af(Vf(2),Nf Vf(1))),
        Af(Vf(0),Nf Af(Vf(2),Nf Vf(1)))),Check(Cform_from(f2),cf2),
  Check(Cform_from(f3),cf3),Check(Cform_from(f4),cf4),Check(Cform_from(f5),cf5),
  0 <- 
    Nf Of(Vf(0),Nf Vf(1)) = f2 & Nf Nf Af(Nf Vf(0),Nf Nf Vf(1)) = cf2 & 
    Af(If(Vf(1),Vf(2)),Nf Of(Vf(0),Vf(1))) = f3 & 
    Af(Nf Af(Vf(1),Nf Vf(2)),Nf Nf Af(Nf Vf(0),Nf Vf(1))) = cf3 & 
    Of(If(Vf(0),Nf Vf(1)),If(Nf Vf(2),Vf(1))) = f4 & 
    Nf Af(Nf Nf Af(Vf(0),Nf Nf Vf(1)),Nf Nf Af(Nf Vf(2),Nf Vf(1))) = cf4 & 
    If(Nf Of(Vf(2),Nf Vf(1)),Of(Nf Vf(1),Vf(0))) = f5 & 
    Nf Af(Nf Nf Af(Nf Vf(2),Nf Nf Vf(1)),Nf Nf Af(Nf Nf Vf(1),Nf Vf(0))) = cf5

fun Check_cform_from 
  Check_cform_from(0) = 0
  Check_cform_from(f,fs) = 
  Test_case3(f,Check_cform(cf),Check(True_vals(Fvss3,f),True_vals(Fvss3,cf))),
  Check_cform_from(fs) <- 
    Cform_from(f) = cf

fun/0 Cform_from_test 
  Cform_from_test = Check_cform_from(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,0) <- 
    Vf(2) = f1 & Tf = f2 & Ff = f3 & Nf Vf(1) = f4 & Af(Vf(1),Vf(2)) = f5 & 
    Of(Vf(0),Vf(1)) = f6 & If(Vf(0),Vf(2)) = f7 & 
    Of(Nf If(Vf(0),Vf(1)),Nf If(Vf(1),Vf(0))) = f8 & 
    Af(If(Vf(0),Vf(1)),If(Nf Vf(0),Vf(2))) = f9 & 
    If(Nf Af(Vf(0),Af(Tf,Vf(1))),Of(Ff,Of(Nf Vf(0),Nf Vf(1)))) = f10 & 
    If(Of(If(Vf(0),Ff),Nf Vf(1)),Nf Af(Vf(0),Vf(1))) = f11

rem 
  \para \bf  Negačný normálny tvar  \end 

rem 
  \para \bf  \it  Definícia.  \end  \end Výroková formula je v \it  negačnom 
  normálnom tvare  \end práve vtedy, keď sa skladá iba z výrokových 
  premenných, negácií výrokových premenných, disjunkcií a konjunkcií. 
  \para Predikát \ft Nnf \end platí pre kódy formúl v negačnom normálnom 
  tvare. 

pred Nnf 
  Nnf Vf(i)
  Nnf Nf Vf(i)
  Nnf Af(f1,f2) <- Nnf(f1) & Nnf(f2)
  Nnf Of(f1,f2) <- Nnf(f1) & Nnf(f2)

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Nnf_from(f) \end, ktorá pre 
  ľubovoľnú výrokovú formulu \ft f \end zostrojí ekvivalentnú formulu 
  v negačnom normálnom tvare. 
  \para* \it  Špecifikácia.  \end 
  \eq* 
    Form(f) -> Nnf Nnf_from(f)
  \end
  \eq* 
    Form(f) -> \a vs(True(vs,f) <-> True(vs,Nnf_from(f)))
  \end
  \para \it  Návod.  \end Využite ekvivalencie spomínané pri funkcii 
  \ft Cform_from \end a de Morganove zákony: 
  \eq* 
    ~Paren((A \/ B)) <-> Paren((~A & ~B))
  \end
  \eq* 
    ~Paren((A & B)) <-> Paren((~A \/ ~B))
  \end
  \para \it  Testovanie.  \end 
  \verbatim 
      Nnf_from_test = rs:Results_form_transf
  \end

fun Nnf_from 
  Nnf_from Vf(i) = Foo
  Nnf_from(Ff) = Foo
  Nnf_from(Tf) = Foo
  Nnf_from Af(f1,f2) = Foo
  Nnf_from Of(f1,f2) = Foo
  Nnf_from If(f1,f2) = Foo
  Nnf_from Nf Vf(i) = Foo
  Nnf_from Nf Nf(f1) = Foo
  Nnf_from Nf(Ff) = Foo
  Nnf_from Nf(Tf) = Foo
  Nnf_from Nf Af(f1,f2) = Foo
  Nnf_from Nf Of(f1,f2) = Foo
  Nnf_from Nf If(f1,f2) = Foo

fun Check_nnf_from 
  Check_nnf_from(0) = 0
  Check_nnf_from(f,fs) = 
  Test_case3(f,Check_nnf(cf),Check(True_vals(Fvss3,f),True_vals(Fvss3,cf))),
  Check_nnf_from(fs) <- 
    Nnf_from(f) = cf

fun/0 Nnf_from_test 
  Nnf_from_test = Check_nnf_from(f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,0) <- 
    Vf(2) = f1 & Tf = f2 & Ff = f3 & Nf Vf(1) = f4 & Af(Vf(1),Vf(2)) = f5 & 
    Of(Vf(0),Vf(1)) = f6 & If(Vf(0),Vf(2)) = f7 & 
    Of(Nf If(Vf(0),Vf(1)),Nf If(Vf(1),Vf(0))) = f8 & 
    Af(If(Vf(0),Vf(1)),If(Nf Vf(0),Vf(2))) = f9 & 
    If(Nf Nf Nf Af(Vf(0),Vf(1)),Of(Nf Vf(0),Nf Vf(1))) = f10 & 
    If(Of(If(Vf(0),Ff),Nf Vf(1)),Nf Af(Vf(0),Vf(1))) = f11 & 
    If(Nf Of(Vf(0),Af(Nf(Ff),Vf(1))),Af(Nf Vf(0),Nf Vf(1))) = f12 & 
    If(Af(Nf If(Tf,Vf(0)),If(Vf(1),Nf(Tf))),Nf Of(Vf(0),Vf(1))) = f13

