mod Ex04a

loc rem 
  \para \bf  4. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2012/2013  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex04.zip 

loc rem 
  \para* \it  Dátum:  \end 5. 3. 2013 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované dyadickej 
  číselnej sústave a operáciám na dyadickom zápise čísel – 
  aritmetickým ( \it  ex04a  \end) a symbolickým ( \it  ex04b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2012/2013. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2013.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting04

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/0 Tex0_tau
  Id(0,Ent('tau'),0)

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots_around
  Fenced(Op(Ent('ctdot'),0),Arg(0),Op(Ent('ctdot'),0))

appldisp/1 Tex1_paren_cdots_paren_around
  Fenced(Op('(',Ent('ctdot'),'(',0),Arg(0),Op(')',Ent('ctdot'),')',0))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

appldisp/2 Tex2_idx
  Subsup(Arg(0),75,Arg(1),None)

appldisp/1 Tex1_set
  Fenced(Op('{',0),Arg(0),Op('}',0))

appldisp/2 Tex2_in
  Infix(Arg(0),25,0,Op(Ent('isin'),0),Arg(1))

appldisp/1 Tex1_f
  Prefix(90,2,Id(1,'F',0),Arg(0))

appldisp/1 Tex1_s1
  Std('S1',0)

appldisp/1 Tex1_s2
  Std('S2',0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),26,3,Op(Ent('equiv'),0),Arg(1))

appldisp/2 Tex2_exp
  Subsup(Arg(0),75,None,Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  8. DYADICKÁ ČÍSELNÁ SÚSTAVA  \end 

rem 
  \para \it  Dyadický zápis čísla.  \end Každé prirodzené číslo 
  \ft n \end možno jednoznačne zapísať v tvare 
  \eq* 
    n = 
    (Tex1_paren_cdots_paren_around((0*2+Tex2_idx(d,k))*2+Tex2_idx(d,k-1))*2+d2)*
    2+d1
  \end
  \para kde \ft Tex2_in(Tex2_idx(d,i),Tex1_set(1,2)) \end pre všetky 
  \ft i <= k \end, \ft 1 <= i \end. 
  \para Postupnosť \ft 0 \end \ft Tex2_idx(d,k) \end \ft Tex2_idx(d,k-1) \end 
  … \ft d2 \end \ft d1 \end nazývame \it  dyadickým zápisom  \end 
  (dyadickou reprezentáciou) čísla \ft n \end. 
  \para Napríklad 
  \eq* 
    17 = (((0*2+1)*2+1)*2+2)*2+1
  \end
  \para Dyadický zápis čísla \ft 17 \end je teda 
  \eq* 
    S1 S2 S1 S1(0)
  \end

rem 
  \para \bf  8.1. Dyadické konštruktory  \end 

rem 
  \para \it  [CL] Dyadické konštruktory.  \end V CL sú preddefinované 
  funkcie 
  \eq* 
    Tex2_equiv(Tex1_s1(x),S1(x)) = 2*x+1
  \end
  \eq* 
    Tex2_equiv(Tex1_s2(x),S2(x)) = 2*x+2
  \end
  \para nazývané \it  dyadické konštruktory  \end. Pomocou nich môžeme 
  konštruovať dyadický zápis čísel. Funkciu \ft Tex1_s1(n) \end môžeme 
  chápať ako „pridaj číslicu 1 na koniec dyadického zápisu čísla 
  \ft n \end “. Tomu zodpovedá aj spôsob jej zobrazenia: \ft S1(n) \end. 
  Význam \ft S2 \end sa dá chápať analogicky. 

rem 
  \para \bf  [CL] Úloha  \end. Vyhodnoťte nasledujúce dopyty (queries): 
  \verbatim 
  S1 S2 S1 S1(0) = n
  \end
  \verbatim 
  50 = n & S1(n) = p & S2(n) = q
  \end

rem 
  \para \bf  8.2. Dyadická diskriminácia  \end 

rem 
  \para \it  [CL] Dyadický formát.  \end CL dokáže zobraziť hodnotu 
  premennej v Query v dyadickom zápise pomocou \it  dyadického formátu 
   \end \ft N2 \end. 
  \para Syntax: 
  \verbatim 
      hodnota = premenna:N2
  \end
  \para Hodnota sa zobrazí akoby bola skonštruovaná z 0 pomocou 
  konštruktorov \ft S1 \end a \ft S2 \end. 

rem 
  \para \bf  [CL] Úloha  \end. Vyhodnoťte nasledujúce dopyty (queries): 
  \verbatim 
  17 = n:N2
  \end
  \verbatim 
  17+12 = n & n = m:N2
  \end
  \verbatim 
  S1 S2 S1 S2 S1(0) = n & n = m:N2
  \end

rem 
  \para \it  [CL] Dyadická diskriminácia.  \end Každé prirodzené číslo je 
  buď \ft 0 \end alebo dyadický zápis \ft n \end končí číslicou 1 alebo 
  dyadický zápis \ft n \end končí číslicou 2. Tieto možnosti sú 
  vzájomne výlučné. 
  \eq (N2_cover)
    n = 0 \/ \e m n = S1(m) \/ \e m n = S2(m)
  \end
  \eq (N2_excl)
    ~(n = 0 & \e m n = S1(m)) & ~(n = 0 & \e m n = S2(m)) & 
    ~(\e m n = S1(m) & \e m n = S2(m))
  \end
  \para Tieto 3 možnosti tvoria \it  dyadickú diskrimináciu  \end. CL pozná 
  túto diskrimináciu. Používame ju v tvare 
  \def* 
    Tex1_cdots(Tex0_tau) <- Tex0_tau = 0
    Tex1_cdots(Tex0_tau) <- Tex0_tau = S1(m)
    Tex1_cdots(Tex0_tau) <- Tex0_tau = S2(m)
  \end
  \para kde \ft t \end je ľubovoľný výraz (obyčajne argument funkcie) a 
  \ft m \end je \it  nová  \end premenná (podobne ako pri monadickej 
  diskriminácii). 
  \para Dyadickú diskrimináciu možno dosadiť do argumentov definovanej 
  funkcie: 
  \def* 
    Tex1_f(0) = Tex0_cdots
    Tex1_f S1(m) = Tex1_cdots_around(m)
    Tex1_f S2(m) = Tex1_cdots_around(m)
  \end
  \para V tomto cvičení používajte \bf  iba dyadickú diskrimináciu  \end! 

rem 
  \para \bf  [CL] Úloha  \end. Zadajte nasledujúce dopyty (queries) pre 
  viacero rôznych hodnôt \ft n \end: 
  \verbatim 
  17 = n:N2 & n = 0
  \end
  \verbatim 
  17 = n:N2 & n = S1(m)
  \end
  \verbatim 
  17 = n:N2 & n = S1(m:N2)
  \end
  \verbatim 
  17 = n:N2 & n = S2(m)
  \end
  \verbatim 
  17 = n:N2 & n = S2(m:N2)
  \end

rem 
  \para \bf  8.3. Dyadická rekurzia  \end 

rem 
  \para \it  Dyadická rekurzia.  \end Ak funkciu zadefinujeme tak, že všetky 
  \it  rekurzívne volania majú menší počet dyadických číslic  \end ako 
  pôvodný argument, teda 
  \def* 
    Tex1_f(0) = Tex0_cdots
    Tex1_f S1(m) = Tex1_cdots_around Tex1_f(m)
    Tex1_f S2(m) = Tex1_cdots_around Tex1_f(m)
  \end
  \para hovoríme o \it  dyadickej rekurzii  \end. Dyadická rekurzia je 
  špeciálnym prípadom všeobecnej (course-of-values) rekurzie, pretože 
  \eq* 
    m < S1(m) & m < S2(m)
  \end
  \para Všetky funkcie v tomto cvičení definujte \bf  iba dyadickou 
  rekurziou  \end! 

rem 
  \para \bf  8.3. Aritmetické operácie na dyadickom zápise čísel  \end 

rem 
  \para \it  Poznámka.  \end Dyadickou rekurziou môžeme zadefinovať \it  
  efektívne  \end aritmetické operácie na prirodzených číslach 
  s neobmedzenou presnosťou. Počet krokov potrebných na takto zadefinované 
  operácie lineárne závisí od počtu číslic v dyadickom zápise 
  argumentov operácie, nie od hodnoty argumentov. 

rem 
  \para \bf  Úloha. Nasledovník.  \end Dyadickou rekurziou zadefinujte funkciu 
  nasledovník \ft Succ(x) = x+1 \end. 
  \para* \it  Návod.  \end Predstavte si dyadickú verziu sčítania, ako ste 
  sa ho učili na základnej škole. Uvedomte si, kedy nastáva prenos do 
  vyššieho rádu. 
  \verbatim 
    0211 (11)     0212 (12)      0222 (14)
    +  1          +  1          +   1     
    ----          ----          -----     
    0212 (12)     0221 (13)     01111 (15)
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Succ_test = r:Results_n
  \end

fun Succ 
  Succ(0) = Foo
  Succ S1(x) = Foo
  Succ S2(x) = Foo

fun/0 Succ_test 
  Succ_test = 
  Check(Succ(0),1),Check(Succ(1),2),Check(Succ(2),3),Check(Succ(3),4),
  Check(Succ(4),5),Check(Succ(5),6),Check(Succ(6),7),Check(Succ(7),8),
  Check(Succ(8),9),Check(Succ(32768*32367-2),32768*32367-1),
  Check(Succ(Sq(32768)-2),Sq(32768)-1),0

rem 
  \para \bf  Úloha. Sčítanie.  \end \header* fun/2 Add  \end Dyadickou 
  rekurziou zadefinujte funkciu sčítanie \ft Add(x,y) = x+y \end. 
  \para* \it  Návod 1 (názorný).  \end Predstavte si dyadickú verziu 
  sčítania, ako ste sa ho učili na základnej škole. Rozoberte jednotlivé 
  prípady: 
  \verbatim 
      0    x1    x1    x1    x2    x2    x2
    + y   + 0   +y1   +y2   + 0   +y1   +y2
    ---   ---   ---   ---   ---   ---   ---
     ??    ??    ??    ??    ??    ??    ??
  \end
  \para Na prenos do vyššieho rádu použite funkciu nasledovník ( 
  \ft Succ \end) z predchádzajúcej úlohy. 
  \para* \it  Návod 2 (algebraický).  \end Uvedomte si, že 
  \ft S1(x) = 2*x+1 \end a že \ft S2(x) = 2*x+2 \end. Preto napríklad 
  \ft Add(S1(x),S2(y)) = Tex1_paren(2*x+1)+(2*y+2) \end. Upravte tento výraz 
  tak, aby sa dal zapísať \it  iba  \end pomocou \ft S1 \end, \ft S2 \end, 
  funkcie \ft Succ(x) \end a rekurzívneho volania \ft Add(x,y) \end, ktoré 
  má hodnotu \ft x+y \end. Podobne postupujte aj v ostatných prípadoch. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Add_test = r:Results_n
  \end

fun/2 Add 
  Add(0,y) = Foo
  Add(S1(x),0) = Foo
  Add(S1(x),S1(y)) = Foo
  Add(S1(x),S2(y)) = Foo
  Add(S2(x),0) = Foo
  Add(S2(x),S1(y)) = Foo
  Add(S2(x),S2(y)) = Foo

fun/0 Add_test 
  Add_test = 
  Check(Add(0,0),0+0),Check(Add(0,43210),0+43210),Check(Add(3,0),3+0),
  Check(Add(3,3),3+3),Check(Add(3,12),3+12),Check(Add(12,0),12+0),
  Check(Add(12,3),12+3),Check(Add(12,12),12+12),
  Check(Add(12345*67890,98765*43210),12345*67890+98765*43210),0

rem 
  \para \bf  Úloha. Dvojnásobok.  \end Dyadickou rekurziou zadefinujte funkciu 
  dvojnásobok \ft Twice(x) = 2*x \end. Nepoužite žiadne pomocné funkcie, ani 
  tie, ktoré ste doteraz naprogramovali. 
  \para* \it  Návod.  \end Uvedomte si, že \ft S1(x) = 2*x+1 \end a teda 
  \ft Twice S1(x) = 2*(2*x+1) \end. Upravte tento výraz tak, aby sa dal 
  zapísať iba pomocou \ft S1 \end, \ft S2 \end a rekurzívneho volania 
  \ft Twice(x) \end, ktoré má hodnotu \ft 2*x \end. Podobne postupujte pri 
  \ft Twice S2(x) = 2*(2*x+2) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Twice_test = r:Results_n
  \end

fun Twice 
  Twice(x) = Foo

fun/0 Twice_test 
  Twice_test = 
  Check(Twice(0),0),Check(Twice(1),2*1),Check(Twice(2),2*2),Check(Twice(3),2*3),
  Check(Twice(4),2*4),Check(Twice(5),2*5),Check(Twice(6),2*6),
  Check(Twice(7),2*7),
  Check(Twice(Sq Sq Sq Sq(65536)-1),2*(Sq Sq Sq Sq(65536)-1)),0

rem 
  \para \bf  Úloha. Násobenie.  \end \header* fun/2 Mul  \end Dyadickou 
  rekurziou zadefinujte funkciu násobenie \ft Mul(x,y) = x*y \end. 
  \para* \it  Návod.  \end Postupujte podobne ako pri funkcii \ft Twice \end. 
  Použite funkcie \ft Twice \end a \ft Add \end. Dyadickú diskrimináciu 
  použite iba na jeden argument. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Mul_test = r:Results_n
  \end

fun/2 Mul 
  Mul(x,y) = Foo

fun/0 Mul_test 
  Mul_test = 
  Check(Mul(0,0),0*0),Check(Mul(0,20304),0*20304),Check(Mul(20304,0),20304*0),
  Check(Mul(1,20304),1*20304),Check(Mul(20304,1),20304*1),
  Check(Mul(2,20304),2*20304),Check(Mul(20304,2),20304*2),
  Check(Mul(3,20304),3*20304),Check(Mul(20304,3),20304*3),
  Check(Mul(4,20304),4*20304),Check(Mul(20304,4),20304*4),
  Check(Mul(5,20304),5*20304),Check(Mul(20304,5),20304*5),
  Check(Mul(6,20304),6*20304),Check(Mul(20304,6),20304*6),
  Check(Mul(20304,5000),20304*5000),Check(Mul(5000,20304),5000*20304),
  Check(Mul(Sq(20304),Sq(50000)),Sq(20304)*Sq(50000)),
  Check(Mul(Sq(50000),Sq(20304)),Sq(50000)*Sq(20304)),0

rem 
  \para \bf  Úloha. Umocnenie.  \end \header* fun/2 Exp  \end Dyadickou 
  rekurziou zadefinujte funkciu umocnenie \ft Exp(x,y) = Tex2_exp(x,y) \end. 
  \para* \it  Návod.  \end Postupujte podobne ako pri funkcii \ft Twice \end, 
  teda vyjadrite pomocou už zadefinovaných operácií a rekurzie 
  \ft Exp(x,y) \end hodnoty \ft Exp(x,S1(y)) = Tex2_exp(x,2*y+1) \end a 
  \ft Exp(x,S2(y)) = Tex2_exp(x,2*y+2) \end. Namiesto dvoch rovnakých 
  rekurzívnych volaní použite priradenie do novej premennej (viď úvod 
  ex03a). 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Exp_test = r:Results_n
  \end

fun/2 Exp 
  Exp(x,y) = Foo

fun/0 Exp_test 
  Exp_test = 
  Check(Exp(0,0),1),Check(Exp(0,20304),0),Check(Exp(1,20304),1),
  Check(Exp(10,0),1),Check(Exp(10,1),10),Check(Exp(10,2),100),
  Check(Exp(10,3),1000),Check(Exp(10,4),10000),Check(Exp(10,5),100000),
  Check(Exp(10,6),1000000),Check(Exp(2,256),Sq Sq Sq Sq(65536)),0

rem 
  \para \bf  Prémiová domáca úloha \it  du04a  \end.  \end (2+2 body) 
  Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp#pdu  \end 
  \para Časti a) a b) môžete odovzdať nezávisle od seba. 
  \para* \bf  a)  \end (2 body) Dokážte, že pre vašu definíciu funkcie 
  \ft Exp \end platí: 
  \eq (Exp_succ)
    Exp(x,y+1) = x*Exp(x,y)
  \end
  \para Použite svoju definíciu funkcie \ft Exp \end, úplnú indukciu, 
  analýzu prípadov 
  \eq (N2_cover)
    n = 0 \/ \e m n = S1(m) \/ \e m n = S2(m)
  \end
  \para a fakt, že platí 
  \eq* 
    m < S1(m) & m < S2(m)
  \end
  \para definície konštruktorov \ft S1 \end a \ft S2 \end a vlastnosti 
  sčítania a násobenia. \bf  Nepredpokladajte  \end, že \ft Exp \end 
  skutočne počíta umocnenie! 
  \para* \bf  b)  \end (2 body) Naprogramujte dyadickou rekurziou funkciu 
  \ft Pred(x) \end, ktorá počíta predchodcu čísla \ft x \end, teda 
  \ft Pred(x) = x-1 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Pred_test = r:Results_n
  \end

fun Pred 
  Pred(x) = Foo

fun/0 Pred_test 
  Pred_test = 
  Check(Pred(0),0-1),Check(Pred(1),1-1),Check(Pred(2),2-1),Check(Pred(3),3-1),
  Check(Pred(4),4-1),Check(Pred(5),5-1),Check(Pred(6),6-1),Check(Pred(7),7-1),
  Check(Pred(8),8-1),Check(Pred(9),9-1),
  Check(Pred(32768*32367-1),32768*32367-2),Check(Pred(Sq(32768)-1),Sq(32768)-2),
  0

