mod Ex03b

loc rem 
  \para \bf  3. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  2012/2013  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex03.zip 

loc rem 
  \para* \it  Dátum:  \end 25. 2. 2013 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované 
  priraďujúcim diskrimináciám ( \it  ex03a  \end) a chvostovej rekurzii
  ( \it  ex03b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2012/2013. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2013.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting03

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/0 Tex0_ast
  Op(Ent('ast'),0)

appldisp/1 Tex1_cdots_around
  Fenced(Op(Ent('ctdot'),0),Arg(0),Op(Ent('ctdot'),0))

appldisp/1 Tex1_f
  Std('f',0)

appldisp/2 Tex2_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/1 Tex1_fact
  Postfix(Arg(0),60,1,Op('!',0))

appldisp/2 Tex2_exp
  Subsup(Arg(0),75,None,Arg(1))

appldisp/1 Tex1_fib
  Subsup(Id(0,'fib',0),75,Arg(0),None)

appldisp/1 Tex1_fib_efficient
  Subsup(Id(0,'fib',0),75,Arg(0),Id(0,'efficient',0))

appldisp/1 Tex1_f1_efficient
  Prefix(90,2,Subsup(Id(0,'F',0),75,Id(0,'1',0),Id(0,'efficient',0)),Arg(0))

appldisp/1 Tex1_f2_efficient
  Prefix(90,2,Subsup(Id(0,'F',0),75,Id(0,'2',0),Id(0,'efficient',0)),Arg(0))

appldisp/1 Tex1_f3_efficient
  Prefix(90,2,Subsup(Id(0,'F',0),75,Id(0,'3',0),Id(0,'efficient',0)),Arg(0))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  7. CHVOSTOVÁ REKURZIA  \end 

rem 
  \para \it  Poznámka.  \end Podrobnejší návod na riešenie nasledujúcich 
  úloh nájdete napríklad v prednáškach [1]. 
  \para* Úlohy označené hviezdičkou \bf  \ft Tex0_ast \end  \end riešte 
  \bf  po  \end vyriešení všetkých neoznačených úloh. 

rem 
  \para \bf  7.1 Rekurzia pre cyklus while  \end 

rem 
  \para \it  Výpočet faktoriálu while cyklom.  \end Funkciu 
  \ft Tex2_equiv(Fact(n),Tex1_fact(n)) \end 
  \def* 
    Tex1_fact(0) = 1
    Tex1_fact(n+1) = (n+1)*Tex1_fact(n)
  \end
  \para vypočítame pomocou pascalovského while cyklu nasledovne: 
  \verbatim 
      f := 1;                  }  Fact
      while n <> 0 do begin   -
          f := f*n;            |
          n := n-1             |- While_fact
      end;                     |
      Result := f             -
  \end

rem 
  \para* \bf  Úloha. Faktoriál chvostovou rekurziou.  \end 
  \header* fun/2 While_fact  \end Simulujte uvedený while cyklus 
  chvostovorekurzívnou funkciou \ft While_fact(n,f) \end a použite ju na 
  zadefinovanie funkcie \ft Tex2_equiv(Fact(n),Tex1_fact(n)) \end. Pomocný 
  argument \ft f \end nazývame \it  akumulátor  \end. 
  \para Ako je naznačené vyššie, funkcia \ft While_fact \end počíta iba 
  cyklus a vrátenie výsledku. 
  \para Hlavná funkcia \ft Fact \end inicializuje akumulátor \ft f \end 
  vhodným volaním funkcie \ft While_fact \end. 
  \para Invariant: 
  \eq* 
    While_fact(n,f) = f*Tex1_fact(n)
  \end

fun/2 While_fact 
  While_fact(n,f) = Foo

fun Fact 'Tex1_fact'
  Fact(n) = Foo

rem 
  \para Testujte dopytmi: 
  \verbatim 
      While_fact_test = r:Results
      Fact_test = r:Results
  \end

fun/0 While_fact_test 
  While_fact_test = 
  Check(While_fact(0,10),1*10),Check(While_fact(1,10),1*10),
  Check(While_fact(2,10),2*10),Check(While_fact(3,10),6*10),
  Check(While_fact(4,10),24*10),Check(While_fact(5,10),120*10),
  Check(While_fact(6,10),720*10),Check(While_fact(7,10),5040*10),0

fun/0 Fact_test 
  Fact_test = 
  Check(Fact(0),1),Check(Fact(1),1),Check(Fact(2),2),Check(Fact(3),6),
  Check(Fact(4),24),Check(Fact(5),120),Check(Fact(6),720),Check(Fact(7),5040),0

rem 
  \para* \bf  Úloha. Umocnenie chvostovou rekurziou.  \end 
  \header* fun/2 Exp  \end \header* fun/3 While_exp  \end Naprogramujte 
  umocnenie pomocou simulácie while cyklu. 
  \para* \bf  a)  \end Do nasledujúcej poznámky vpíšte fragment 
  pascalovského programu, ktorý vypočíta umocnenie do akumulátora 
  \ft e \end, podobne ako pri faktoriáli. 

rem 
  e := ...;
  while ... do begin
      ...
  end;
  Result := e

rem 
  \para \bf  b)  \end \header* fun/3 While_exp  \end Zadefinujte 
  chvostovorekurzívnu funkciu \ft While_exp(x,y,e) \end, ktorá simuluje váš 
  while cyklus, ale nie inicializáciu akumulátora. 
  \para Invariant: 
  \eq (While_exp_inv)
    While_exp(x,y,Tex2_exp(x,z)) = Tex2_exp(x,y+z)
  \end

fun/3 While_exp 
  While_exp(x,y,e) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      While_exp_test = r:Results
  \end

fun/0 While_exp_test 
  While_exp_test = 
  Check(While_exp(0,0,10),1*10),Check(While_exp(1,0,10),1*10),
  Check(While_exp(2,0,10),1*10),Check(While_exp(5,0,10),1*10),
  Check(While_exp(0,1,10),0*10),Check(While_exp(1,1,10),1*10),
  Check(While_exp(2,1,10),2*10),Check(While_exp(5,1,10),5*10),
  Check(While_exp(0,10,10),0*10),Check(While_exp(1,10,10),1*10),
  Check(While_exp(2,10,10),1024*10),Check(While_exp(5,10,10),9765625*10),0

rem 
  \para \bf  c)  \end \header* fun/2 Exp  \end Funkcia 
  \ft Tex2_equiv(Exp(x,y),Tex2_exp(x,y)) \end odštartuje simuláciu while cyklu 
  s vhodnou začiatočnou hodnotou akumulátora \ft e \end. 

fun/2 Exp 'Tex2_exp'
  Exp(x,y) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      Exp_test = r:Results
  \end

fun/0 Exp_test 
  Exp_test = 
  Check(Exp(0,0),1),Check(Exp(1,0),1),Check(Exp(2,0),1),Check(Exp(5,0),1),
  Check(Exp(0,1),0),Check(Exp(1,1),1),Check(Exp(2,1),2),Check(Exp(5,1),5),
  Check(Exp(0,10),0),Check(Exp(1,10),1),Check(Exp(2,10),1024),
  Check(Exp(5,10),9765625),0

rem 
  \para \bf  7.2 Efektívny výpočet Fibonacciho postupnosti  \end 

rem 
  \para \it  Efektívny výpočet členov Fibonacciho postupnosti while cyklom. 
   \end Funkciu \ft Tex2_equiv(Fib(n),Tex1_fib(n)) \end pre \ft n \end-tý člen 
  Fibonacciho postupnosti 

fun Fib 'Tex1_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n)+Fib(n+1)

rem 
  \para môžeme efektívne vypočítať pomocou \it  while  \end cyklu s dvoma 
  akumulátormi \ft m \end, \ft d \end, v ktorých si pamätáme dva po sebe 
  nasledujúce členy postupnosti: 
  \verbatim 
      if n = 0 then                            -
          Result := 0                           |
      else begin                                |_ Fib_efficient
          n := n - 1; { !! }                    |
          m := 0; { fib(0) }                    |
          d := 1; { fib(1) }                   -
          while n <> 0 do begin                -
              { m = fib(i) & d = fib(i+1) }     |
              m1 := d;                          |
              d1 := m+d;                        |
              m := m1; d := d1;                 |- While_fib
              { m = fib(i+1) & d = fib(i+2) }   |
              n := n-1                          |
          end;                                  |
          Result := d                          -
      end
  \end

rem 
  \para* \bf  Úloha. Efektívny výpočet členov Fibonacciho postupnosti 
  chvostovou rekurziou.  \end 
  \para* \bf  a)  \end \header* fun/3 While_fib  \end Simulujte while cyklus z 
  predchádzajúcej poznámky chvostovorekurzívnu funkciou 
  \ft While_fib(n,m,d) \end. Úvodný test a inicializáciu premenných zatiaľ 
  neberte do úvahy. 
  \para Invariant: 
  \eq* 
    While_fib(n,Fib(i),Fib(i+1)) = Fib(n+i+1)
  \end

fun/3 While_fib 
  While_fib(n,m,d) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      While_fib_test = r:Results
  \end

fun/0 While_fib_test 
  While_fib_test = 
  Check(While_fib(0,Fib(0),Fib(1)),Fib(1)),
  Check(While_fib(1,Fib(0),Fib(1)),Fib(2)),
  Check(While_fib(2,Fib(0),Fib(1)),Fib(3)),
  Check(While_fib(3,Fib(0),Fib(1)),Fib(4)),
  Check(While_fib(4,Fib(0),Fib(1)),Fib(5)),
  Check(While_fib(5,Fib(0),Fib(1)),Fib(6)),
  Check(While_fib(6,Fib(0),Fib(1)),Fib(7)),
  Check(While_fib(7,Fib(0),Fib(1)),Fib(8)),
  Check(While_fib(8,Fib(0),Fib(1)),Fib(9)),
  Check(While_fib(0,Fib(3),Fib(4)),Fib(4)),
  Check(While_fib(1,Fib(3),Fib(4)),Fib(5)),
  Check(While_fib(5,Fib(3),Fib(4)),Fib(9)),0

rem 
  \para \bf  b)  \end Naprogramujte funkciu 
  \ft Tex2_equiv(Fib_efficient(n),Tex1_fib_efficient(n)) \end, ktorá vykoná 
  úvodný test pascalovského programu a spustí simuláciu while cyklu so 
  správne inicializovanými hodnotami premenných \ft n \end, \ft a \end, 
  \ft b \end. 

fun Fib_efficient 'Tex1_fib_efficient'
  Fib_efficient(n) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      Fib_efficient_test = r:Results
  \end

fun/0 Fib_efficient_test 
  Fib_efficient_test = 
  Check(Fib_efficient(0),Fib(0)),Check(Fib_efficient(1),Fib(1)),
  Check(Fib_efficient(2),Fib(2)),Check(Fib_efficient(3),Fib(3)),
  Check(Fib_efficient(4),Fib(4)),Check(Fib_efficient(5),Fib(5)),
  Check(Fib_efficient(6),Fib(6)),Check(Fib_efficient(7),Fib(7)),
  Check(Fib_efficient(8),Fib(8)),0

rem 
  \para \bf  \ft Tex0_ast \end Úloha.  \end Podobne ako v predchádzajúcej 
  úlohe zadefinujte efektívnu verziu 
  \ft Tex2_equiv(F1_efficient(n),Tex1_f1_efficient(n)) \end nasledujúcej 
  funkcie \ft F1(n) \end chvostovou rekurziou. 

fun F1 
  F1(0) = 0
  F1(1) = 1
  F1(2) = 2
  F1(n+3) = F1(n)+F1(n+1)+F1(n+2)

rem 
  \para \bf  a)  \end Do nasledujúcej poznámky vpíšte pascalovský program, 
  ktorý počíta funkciu \ft F1 \end while cyklom. Výpočet je podobný 
  výpočtu Fibonacciho postupnosti. Program si pamätá 3 po sebe nasledujúce 
  členy postupnosti v akumulátoroch \ft a \end, \ft b \end, \ft c \end. 

rem 
  if n = 0 then
      ...
  else if n = 1 then
      ...
  else begin
      n := ...;
      a := ...; { F1(0) }
      b := ...; { F1(1) }
      c := ...; { F1(2) }
      while ... do begin
          { a = F1(i) & b = F1(i+1) & c = F1(i+2) }
          ...
          { a = F1(i+1) & b = F1(i+2) & c = F1(i+3) }
      end;
      Result := c
  end

rem 
  \para \bf  b)  \end \header* fun/4 While_f1  \end Simulujte while cyklus 
  funkciou \ft While_f1(n,a,b,c) \end. 
  \para* Invariant: 
  \eq* 
    While_f1(n,F1(i),F1(i+1),F1(i+2)) = F1(n+i+2)
  \end

fun/4 While_f1 
  While_f1(n,a,b,c) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      While_f1_test = r:Results
  \end

fun/0 While_f1_test 
  While_f1_test = 
  Check(While_f1(0,F1(0),F1(1),F1(2)),F1(2)),
  Check(While_f1(1,F1(0),F1(1),F1(2)),F1(3)),
  Check(While_f1(2,F1(0),F1(1),F1(2)),F1(4)),
  Check(While_f1(3,F1(0),F1(1),F1(2)),F1(5)),
  Check(While_f1(4,F1(0),F1(1),F1(2)),F1(6)),
  Check(While_f1(5,F1(0),F1(1),F1(2)),F1(7)),
  Check(While_f1(6,F1(0),F1(1),F1(2)),F1(8)),
  Check(While_f1(7,F1(0),F1(1),F1(2)),F1(9)),
  Check(While_f1(8,F1(0),F1(1),F1(2)),F1(10)),
  Check(While_f1(0,F1(3),F1(4),F1(5)),F1(5)),
  Check(While_f1(1,F1(3),F1(4),F1(5)),F1(6)),
  Check(While_f1(5,F1(3),F1(4),F1(5)),F1(10)),0

rem 
  \para \bf  c)  \end Vo funkcii 
  \ft Tex2_equiv(F1_efficient(n),Tex1_f1_efficient(n)) \end ošetrite okrajové 
  prípady a odštartujte cyklus so správne inicializovanými premennými. 

fun F1_efficient 'Tex1_f1_efficient'
  F1_efficient(n) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      F1_efficient_test = r:Results
  \end

fun/0 F1_efficient_test 
  F1_efficient_test = 
  Check(F1_efficient(0),F1(0)),Check(F1_efficient(1),F1(1)),
  Check(F1_efficient(2),F1(2)),Check(F1_efficient(3),F1(3)),
  Check(F1_efficient(4),F1(4)),Check(F1_efficient(5),F1(5)),
  Check(F1_efficient(6),F1(6)),Check(F1_efficient(7),F1(7)),
  Check(F1_efficient(8),F1(8)),Check(F1_efficient(9),F1(9)),0

rem 
  \para \bf  7.3 Rekurzia pre cyklus for  \end 

rem 
  \para \it  Faktoriál cyklom for.  \end Faktoriál môžeme počítať aj 
  pomocou pascalovského for cyklu: 
  \verbatim 
      f := 1;                       } Fact1
      for i := 1 to n do begin     -
          f := f*i                  |_ For_fact
      end;                          |
      Result := f                  -
  \end

rem 
  \para \bf  Úloha. Faktoriál spätnou chvostovou rekurziou.  \end 
  Naprogramujte funkciu \ft Fact1 \end využitím pomocnej funkcie 
  \ft For_fact \end. 
  \para* \bf  a)  \end Funkcia \ft For_fact \end simuluje for cyklus 
  z predchádzajúcej poznámky. Zadefinujte ju chvostovou \it  spätnou 
  rekuziou  \end, pri ktorej rekurzívny argument \ft i \end rastie, kým 
  neprekročí hranicu \ft n \end. Uvedomte si, že cyklus 
  \verbatim 
      for i := 1 to n do begin TELO end
  \end
  \para je ekvivalentný 
  \verbatim 
      i := 1; while i <= n do begin TELO; i := i+1 end
  \end

fun/3 For_fact 
  For_fact(i,n,f) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      For_fact_test = r:Results
  \end

fun/0 For_fact_test 
  For_fact_test = 
  Check(For_fact(0,1,10),0),Check(For_fact(0,2,10),0),
  Check(For_fact(1,0,10),1*10),Check(For_fact(1,1,10),1*10),
  Check(For_fact(1,2,10),2*10),Check(For_fact(1,3,10),6*10),
  Check(For_fact(1,4,10),24*10),Check(For_fact(1,5,10),120*10),
  Check(For_fact(1,6,10),720*10),Check(For_fact(1,7,10),5040*10),
  Check(For_fact(3,6,10),3*4*5*6*10),0

rem 
  \para \bf  b)  \end Funkcia \ft Fact1 \end spustí cyklus so správne 
  inicializovanými premennými \ft i \end, \ft f \end a \ft n \end. 

fun Fact1 
  Fact1(n) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      Fact1_test = r:Results
  \end

fun/0 Fact1_test 
  Fact1_test = 
  Check(Fact1(0),1),Check(Fact1(1),1),Check(Fact1(2),2),Check(Fact1(3),6),
  Check(Fact1(4),24),Check(Fact1(5),120),Check(Fact1(6),720),
  Check(Fact1(7),5040),0

rem 
  \para \bf  \ft Tex0_ast \end Úloha.  \end Zadefinujte efektívnu verziu 
  \ft Tex2_equiv(F2_efficient(n),Tex1_f2_efficient(n)) \end nasledujúcej 
  funkcie \ft F2(n) \end využitím spätnej chvostovej rekurzie. 

fun F2 
  F2(0) = 0
  F2(1) = 1
  F2(n+2) = F2(n)+F2(n+1)+n

rem 
  \para Funkciu \ft F2 \end môžeme efektívne vypočítať nasledujúcim for 
  cyklom. 
  \verbatim 
      if n = 0 then                          -
          Result := 0                         |
      else if n = 1 then                      |
          Result := 1                         |_ F2_efficient
      else begin                              |
          n := n - 2; { ! }                   |
          a := 0; { F2(0) }                   |
          b := 1; { F2(1) }                  -
          for i := 0 to n do begin           -
              { a = F2(i) & b = F2(i+1) }     |
              a1 := b;                        |
              b1 := a+b+i;                    |_ For_f2
              a := a1; b := b1;               |
              { a = F2(i+1) & c = F2(i+2) }   |
          end;                                |
          Result := b                        -
      end
  \end
  \para \header* fun/4 For_f2  \end Simulujte for cyklus pomocnou funkciou 
  \ft For_f2(i,n,a,b) \end zadefinovanou spätnou chvostovou rekurziou. 
  \para* Invariant: 
  \eq* 
    i <= n+1 -> For_f2(i,n,F2(i),F2(i+1)) = F2(n+2)
  \end
  \para Úvodné testy, inicializáciu premenných a štart cyklu implementujte 
  v hlavnej funkcii \ft Tex2_equiv(F2_efficient(n),Tex1_f2_efficient(n)) \end 

fun/4 For_f2 
  For_f2(i,n,a,b) = Foo

fun F2_efficient 'Tex1_f2_efficient'
  F2_efficient(n) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      For_f2_test = r:Results
      F2_efficient_test = r:Results
  \end

fun/0 For_f2_test 
  For_f2_test = 
  Check(For_f2(0,0,F2(0),F2(1)),F2(2)),Check(For_f2(0,1,F2(0),F2(1)),F2(3)),
  Check(For_f2(0,2,F2(0),F2(1)),F2(4)),Check(For_f2(0,3,F2(0),F2(1)),F2(5)),
  Check(For_f2(0,7,F2(0),F2(1)),F2(9)),Check(For_f2(1,0,F2(1),F2(2)),F2(2)),
  Check(For_f2(1,1,F2(1),F2(2)),F2(3)),Check(For_f2(1,2,F2(1),F2(2)),F2(4)),
  Check(For_f2(1,3,F2(1),F2(2)),F2(5)),Check(For_f2(1,7,F2(1),F2(2)),F2(9)),
  Check(For_f2(4,8,F2(4),F2(5)),F2(10)),0

fun/0 F2_efficient_test 
  F2_efficient_test = 
  Check(F2_efficient(0),F2(0)),Check(F2_efficient(1),F2(1)),
  Check(F2_efficient(2),F2(2)),Check(F2_efficient(3),F2(3)),
  Check(F2_efficient(4),F2(4)),Check(F2_efficient(5),F2(5)),
  Check(F2_efficient(6),F2(6)),Check(F2_efficient(7),F2(7)),
  Check(F2_efficient(8),F2(8)),Check(F2_efficient(9),F2(9)),0

rem 
  \para \bf  \ft Tex0_ast \end Úloha.  \end Zadefinujte efektívnu verziu 
  \ft Tex2_equiv(F3_efficient(n),Tex1_f3_efficient(n)) \end funkcie 
  \ft F3(n) \end spätnou chvostovou rekurziou podobne ako v predchádzajúcej 
  úlohe. 

fun F3 
  F3(0) = 0
  F3(1) = 1
  F3(2) = 2
  F3(n+3) = F3(n)+F3(n+1)+F3(n+2)+n

rem 
  \para \header* fun/5 For_f3  \end Invariant: 
  \eq* 
    i <= n+1 -> For_f3(i,n,F3(i),F3(i+1),F3(i+2)) = F3(n+3)
  \end

fun/5 For_f3 
  For_f3(i,n,a,b,c) = Foo

fun F3_efficient 'Tex1_f3_efficient'
  F3_efficient(n) = Foo

rem 
  \para Testujte dopytom: 
  \verbatim 
      For_f3_test = r:Results
      F3_efficient_test = r:Results
  \end

fun/0 For_f3_test 
  For_f3_test = 
  Check(For_f3(0,0,F3(0),F3(1),F3(2)),F3(3)),
  Check(For_f3(0,1,F3(0),F3(1),F3(2)),F3(4)),
  Check(For_f3(0,2,F3(0),F3(1),F3(2)),F3(5)),
  Check(For_f3(0,3,F3(0),F3(1),F3(2)),F3(6)),
  Check(For_f3(0,7,F3(0),F3(1),F3(2)),F3(10)),
  Check(For_f3(1,0,F3(1),F3(2),F3(3)),F3(3)),
  Check(For_f3(1,1,F3(1),F3(2),F3(3)),F3(4)),
  Check(For_f3(1,2,F3(1),F3(2),F3(3)),F3(5)),
  Check(For_f3(1,3,F3(1),F3(2),F3(3)),F3(6)),
  Check(For_f3(1,7,F3(1),F3(2),F3(3)),F3(10)),
  Check(For_f3(4,8,F3(4),F3(5),F3(6)),F3(11)),0

fun/0 F3_efficient_test 
  F3_efficient_test = 
  Check(F3_efficient(0),F3(0)),Check(F3_efficient(1),F3(1)),
  Check(F3_efficient(2),F3(2)),Check(F3_efficient(3),F3(3)),
  Check(F3_efficient(4),F3(4)),Check(F3_efficient(5),F3(5)),
  Check(F3_efficient(6),F3(6)),Check(F3_efficient(7),F3(7)),
  Check(F3_efficient(8),F3(8)),Check(F3_efficient(9),F3(9)),0

rem 
  \para \bf  Prémiová domáca úloha \it  du03b  \end.  \end (2+2 body) 
  Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp#pdu  \end 
  \para* \bf  a)  \end (2 body) 
  \para Dokážte, že vaša definícia funkcie \ft While_exp \end má 
  vlastnosť 
  \eq (While_exp_inv)
    \a z While_exp(x,y,Tex2_exp(x,z)) = Tex2_exp(x,y+z)
  \end
  \para Zápis \ft Tex2_exp(x,y) \end predstavuje \it  skutočné umocnenie 
   \end, a teda môžete použiť všetky jeho vlastnosti. Využite 
  matematickú indukciu, vlastnosť dokazujte pre všetky \ft z \end. 
  \para Následne dokážte, že vaša definícia funkcie \ft Exp \end pomocou 
  \ft While_exp \end má vlastnosť: \header* fun/2 Exp  \end 
  \eq (Exp_spec)
    Exp(x,y) = Tex2_exp(x,y)
  \end
  \para Využite (While_exp_inv) a potrebné vlastnosti umocňovania. 
  Nezamieňajte si však funkciu \ft Exp \end a umocňovanie. 
  \para* \bf  b)  \end (2 body) 
  \para Zistite presný počet rekurzívnych volaní potrebných na výpočet 
  \ft Fib(200) \end podľa klasickej \it  neefektívnej  \end definície (viď 
  vyššie úvod k časti 7.2). Vysvetlite, ako ste k tomuto počtu dospeli. 
  \para \it  [CL] Poznámka.  \end Pri výpočte odpovede pomocou CL narazíte 
  na nasledovný problém: Hľadaný počet rekurzívnych volaní je viac ako 
  30-bitové číslo. Takéto čísla CL normálne zobrazuje v zmiešanom 
  desiatkovo-dyadickom zápise (vysvetlíme neskôr). V iba desiatkovej 
  sústave číslo zobrazíte použitím formátu \ft N \end podľa 
  nasledujúceho príkladu: 
  \verbatim 
      123456789*1000000001 = x:N
  \end

