mod Ex08b

loc rem 
  \para \bf  8. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/ex/ex08.zip 

loc rem 
  \para* \it  Dátum:  \end streda 6. 4. 2011 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované triedeniu
  zoznamov (ex08a) a reprezentácii konečných množín usporiadanými zoznamami
  bez opakovania (ex08b).

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania LS 2010/2011. 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,0,Op(Ent('equiv'),0),Arg(1))

appldisp/2 Tex2_member
  Infix(Arg(0),15,0,Op(Ent('isin'),0),Arg(1))

appldisp/2 Tex2_insert
  Infix(Arg(0),35,1,Op(Ent('cup'),0),Fenced(Op('{',0),Arg(1),Op('}',0)))

appldisp/2 Tex2_delete
  Infix(Arg(0),35,1,Op(Ent('setmn'),0),Fenced(Op('{',0),Arg(1),Op('}',0)))

appldisp/2 Tex2_union
  Infix(Arg(0),35,1,Op(Ent('cup'),0),Arg(1))

appldisp/2 Tex2_inter
  Infix(Arg(0),35,1,Op(Ent('cap'),0),Arg(1))

appldisp/2 Tex2_diff
  Infix(Arg(0),35,1,Op(Ent('setmn'),0),Arg(1))

appldisp/2 Tex2_sdiff
  Infix(Arg(0),35,1,Op(Ent('triangle'),0),Arg(1))

appldisp/2 Tex2_subset
  Infix(Arg(0),15,0,Op(Ent('sube'),0),Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  14. ZOZNAMOVÁ REPREZENTÁCIA KONEČNÝCH MNOŽÍN  \end 

rem 
  \para \bf  \it  Reprezentácia množín usporiadanými zoznamami bez 
  opakovania.  \end  \end Konečné množiny môžeme jednoducho reprezentovať 
  zoznamami. Pri množinách je dôležitá iba príslušnosť prvku do 
  množiny. Počet výskytov prvku ani poradie prvkov nie sú podstatné. 
  Množiny môžeme preto reprezentovať usporiadanými zoznamami bez opakovania 
  prvkov. Operácie na dvoch množinách potom dokážeme naprogramovať tak, 
  aby počet krokov potrebných na ich vykonanie lineárne závisel od súčtu 
  počtu prvkov v množinách. 

rem 
  \para \bf  \it  [CL] Trichotomická diskriminácia.  \end  \end 
  V nasledujúcich úohách využijeme \it  trichotomickú  \end 
  diskrimináciu: 
  \def* 
    Tex2_cdots(s,t) <- s < t
    Tex2_cdots(s,t) <- s = t
    Tex2_cdots(s,t) <- s > t
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Set(xs) \end, ktorý 
  platí, ak \ft xs \end je zoznam, ktorý reprezentuje množinu, teda 
  usporiadaný a bez opakovania. 
  \para Definícia je podobná predikátu \ft Ord \end z ex08a. 
  \para Špecifikácia: 
  \eq* 
    Set(xs) <-> \a ys\a a\a b\a zs(xs = ys++(a,b,zs) -> a < b)
  \end

pred Set 
  Set(xs) <- Quux

rem 
  \para \bf  Úloha.  \end \header* pred/2 Member  \end Zadefinujte predikát 
  \ft Tex2_equiv(Member(a,xs),Tex2_member(a,xs)) \end, ktorý platí, ak je 
  \ft a \end prvkom množiny \ft xs \end. 
  \para \header* pred/2 Member 'Tex2_member' \end Napríklad 
  \ft Member(4,2,4,6,8,0) \end a \ft ~Member(5,2,4,6,8,0) \end. 
  \para Využite (ale netestujte!), že \ft xs \end je množina. Ani v jednom 
  z uvedených príkladov výpočet nesmie prejsť celý zoznam 
  \ft 2,4,6,8,0 \end. 
  \para Špecifikácia: 
  \eq* 
    Set(xs) -> Member(a,xs) <-> a in xs
  \end

pred/2 Member 'Tex2_member'
  Member(a,xs) <- Quux

rem 
  \para \bf  \it  Extenzionalita.  \end  \end Všimnite si, že reprezentácia 
  množín usporiadanými zoznamami bez opakovania je jednoznačná a teda má 
  vlastnosť extenzionality: Množiny sú si rovné práve vtedy, keď majú tie 
  isté prvky. 
  \eq* 
    Set(xs) & Set(ys) -> xs = ys <-> \a a(Member(a,xs) <-> Member(a,ys))
  \end

rem 
  \para \bf  Úloha.  \end \header* fun/2 Insert  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Insert(xs,a),Tex2_insert(xs,a)) \end, ktorá vloží prvok 
  \ft a \end do množiny \ft xs \end, teda vráti množinu, ktorá obsahuje 
  všetky prvky \ft xs \end a prvok \ft a \end. 
  \para \header* fun/2 Insert 'Tex2_insert' \end Napríklad 
  \ft Insert((2,4,6,8,0),5) = 2,4,5,6,8,0 \end a 
  \ft Insert((2,4,6,8,0),4) = 2,4,6,8,0 \end. 
  \para Pozor na poradie argumentov a na fakt, že v množinách sa prvky 
  neopakujú a sú usporiadané. Nepoužite žiadne pomocné funkcie ani 
  predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para Špecifikácia: 
  \eq* 
    Set(xs) -> Set Insert(xs,a)
  \end
  \eq* 
    Set(xs) -> \a b(Member(b,Insert(xs,a)) <-> b = a \/ Member(b,xs))
  \end

fun/2 Insert 'Tex2_insert'
  Insert(xs,a) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Delete  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Delete(xs,a),Tex2_delete(xs,a)) \end, ktorá odstráni prvok 
  \ft a \end z množiny \ft xs \end, teda vráti množinu obsahujúcu všetky 
  prvky \ft xs \end okrem \ft a \end. 
  \para \header* fun/2 Delete 'Tex2_delete' \end Napríklad 
  \ft Delete((2,4,6,8,0),4) = 2,6,8,0 \end a 
  \ft Delete((2,4,6,8,0),5) = 2,4,6,8,0 \end. 
  \para Pozor na poradie argumentov a na fakt, že v množinách sa prvky 
  neopakujú a sú usporiadané. Nepoužite žiadne pomocné funkcie ani 
  predikáty (vrátane \ft Set \end a \ft Member \end). Ani v jednom 
  z uvedených príkladov výpočet nesmie prejsť celý zoznam 
  \ft 2,4,6,8,0 \end. 
  \para Špecifikácia: 
  \eq* 
    Set(x) -> Set Delete(x,a)
  \end
  \eq* 
    Set(x) -> \a b(Member(b,Delete(x,a)) <-> b != a & Member(b,x))
  \end

fun/2 Delete 'Tex2_delete'
  Delete(xs,a) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Union  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Union(xs,ys),Tex2_union(xs,ys)) \end, ktorá zjednotí množiny 
  \ft xs \end a \ft ys \end. 
  \para \header* fun/2 Union 'Tex2_union' \end Napríklad 
  \ft Union((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 1,2,3,4,5,6,7,8,9,10,0 \end. 
  \para Využite (ale netestujte!), že \ft xs \end a \ft ys \end sú množiny. 
  Algoritmus pre zjednotenie je podobný zlúčeniu utriedených zoznamov, vo 
  výsledku sa však žiadny prvok nesmie opakovať. Nepoužite žiadne pomocné 
  funkcie ani predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Union(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(Member(a,Union(xs,ys)) <-> Member(a,xs) \/ Member(a,ys))
  \end

fun/2 Union 'Tex2_union'
  Union(xs,ys) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Inter  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Inter(xs,ys),Tex2_inter(xs,ys)) \end, ktorá vypočíta prienik 
  množín \ft xs \end a \ft ys \end. 
  \para \header* fun/2 Inter 'Tex2_inter' \end Napríklad 
  \ft Inter((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 2,9,0 \end. 
  \para Využite (ale netestujte!), že \ft xs \end a \ft ys \end sú množiny. 
  Použite podobný algoritmus ako pre zjednotenie. Nepoužite žiadne pomocné 
  funkcie ani predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Inter(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(Member(a,Inter(xs,ys)) <-> Member(a,xs) & Member(a,ys))
  \end

fun/2 Inter 'Tex2_inter'
  Inter(xs,ys) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Diff  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Diff(xs,ys),Tex2_diff(xs,ys)) \end, ktorá vypočíta rozdiel 
  množín \ft xs \end a \ft ys \end. 
  \para \header* fun/2 Diff 'Tex2_diff' \end Napríklad 
  \ft Diff((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 4,8,10,0 \end. 
  \para Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Diff(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(Member(a,Diff(xs,ys)) <-> Member(a,xs) & ~Member(a,ys))
  \end

fun/2 Diff 'Tex2_diff'
  Diff(xs,ys) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Sdiff  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Sdiff(xs,ys),Tex2_sdiff(xs,ys)) \end, ktorá vypočíta 
  symetrický rozdiel množín \ft xs \end a \ft ys \end. 
  \para \header* fun/2 Sdiff 'Tex2_sdiff' \end Napríklad 
  \ft Sdiff((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 1,3,4,5,6,7,8,10,0 \end. 
  \para Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Sdiff(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(Member(a,Sdiff(xs,ys)) <-> 
         Member(a,xs) & ~Member(a,ys) \/ ~Member(a,xs) & Member(a,ys))
  \end

fun/2 Sdiff 'Tex2_sdiff'
  Sdiff(xs,ys) = Foo

rem 
  \para \bf  Úloha.  \end \header* pred/2 Subset  \end Zadefinujte predikát 
  \ft Tex2_equiv(Subset(xs,ys),Tex2_subset(xs,ys)) \end, ktorý platí, ak 
  \ft xs \end je podmnožinou \ft ys \end. 
  \para \header* pred/2 Subset 'Tex2_subset' \end Napríklad 
  \ft Subset((2,4,8,9,10,0),1,2,3,4,5,6,7,8,9,10,0) \end a 
  \ft ~Subset((2,4,8,9,10,0),2,4,6,8,10,0) \end. 
  \para Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Subset(xs,ys) <-> \a a(Member(a,xs) -> Member(a,ys))
  \end

pred/2 Subset 'Tex2_subset'
  Subset(xs,ys) <- Quux

