mod Ex06

loc rem 
  \para \bf  6. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/ex/ex06.zip 

loc rem 
  \para* \it  Dátum:  \end streda 23. 3. 2011 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované párovaniu
  a zoznamom. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbor \it  ex06.cl  \end obsahuje úlohy týkajúce sa operácií na
   zoznamoch. 
  \end

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania LS 2010/2011. 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/0 Tex0_ldots
  Op(Ent('hellip'),0)

appldisp/2 Tex2_varidx
  Subsup(Arg(0),75,Arg(1),None)

appldisp/2 Tex2_sub
  Prefix(70,2,Arg(0),Fenced(Op('[',0),Arg(1),Op(']',0)))

appldisp/3 Tex3_msub
  Prefix(70,2,Arg(0),
         Fenced(Op('[',0),Infix(Arg(1),25,3,Op(Ent('colone'),0),Arg(2)),Op(']',0)))

appldisp/1 Tex1_fib
  Subsup(Id(0,'fib',0),75,Arg(0),None)

fun Fib 'Tex1_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n+1)+Fib(n)

appldisp/1 Tex1_f
  Std('f',0)

appldisp/2 Tex2_interval_co
  Fenced(Op('[',0),Infix(Arg(0),25,3,Id(0,'  .. ',0),Arg(1)),Op(')',0))

appldisp/2 Tex2_realinterval_co
  Fenced(Op(Ent('lang'),0),Infix(Arg(0),30,0,Op(',',0),Arg(1)),Op(')',0))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  8. PÁROVACIA FUNKCIA CL  \end 

rem 
  \para \it  [CL] Zabudovaná párovacia funkcia.  \end Párovacia funkcia 
  zabudovaná do CL je založená na enumerácii (očíslovaní) binárnych 
  stromov. Zapisuje sa binárnym infixovým operátorom " \it  ,  \end " 
  (čiarka), napríklad 
  \eq* 
    1,3
  \end
  \para Operátor "," má veľmi nízku prioritu a implicitne sa zátvorkuje 
  doprava: 
  \eq* 
    Tex2_equiv((1+2,3+4),Tex1_paren(Tex1_paren(1+2),Tex1_paren(3+4)))
  \end
  \eq* 
    Tex2_equiv((1,2,3,4),Tex1_paren(1,Tex1_paren(2,Tex1_paren(3,4))))
  \end

rem 
  \para \it  Vlastnosti párovacej funkcie CL.  \end Podobne ako pre iné 
  párovacie funkcie, pre funkciu "," platí: 
  \items 
   \item \para ak sa dva páry rovnajú, rovnajú sa po zložkách: 
         \eq (1)
           x,y = u,v -> x = u & y = v
         \end
   \item \para zložky páru sú menšie ako pár: 
         \eq (2)
           x < x,y & y < x,y
         \end
   \item \para každé nenulové číslo je pár: 
         \eq (3)
           x = 0 \/ \e y\e z x = y,z
         \end
  \end
  \para Z vlastnosti (2) vyplýva: 
  \eq (4)
    0 != x,y
  \end

rem 
  \para \it  [CL] Párová diskriminácia.  \end Na definovanie funkcií, ktoré 
  spracúvajú vstup vytvorený párovaním budeme používať párovú 
  diskrimináciu: 
  \def* 
    Tex1_cdots(t) <- t = 0
    Tex1_cdots(t) <- t = x,y
  \end
  \para kde \ft x \end a \ft y \end sú nové premenné. 
  \para Párovú diskrimináciu umožňujú vlastnosti (3) a (4)
  z predchádzajúceho odseku. 

rem 
  \para \bf  9. ZOZNAMY  \end 

rem 
  \para \it  Kódovanie konečných postupností párovaním.  \end Pomocou 
  párovacej funkcie môžeme zakódovať konečné postupnosti čísel 
  ľubovoľnej dĺžky nasledovne: 
  \items 
   \item \para \ft 0 \end kóduje prázdnu postupnosť, 
   \item \para \ft x,xs \end kóduje postupnosť, ktorej prvým prvkom je 
         číslo \ft x \end a zvyšok postupnosti je zakódovaný číslom 
         \ft xs \end. 
  \end
  \para Inak povedané, postupnosť čísel \ft x1 \end, \ft x2 \end, …, 
  \ft Tex2_varidx(x,n) \end zakódujeme ako 
  \eq* 
    x1,x2,Tex0_ldots,Tex2_varidx(x,n),0
  \end
  \para Koncová \ft 0 \end nie je prvkom postupnosti. Jej význam je podobný 
  smerníku \it  nil  \end v pascale. 
  \para Kód konečnej postupnosti nazývame \it  zoznam  \end. 
  \para Napríklad šesťprvkovú postupnosť 2, 3, 5, 7, 11, 13 zakódujeme 
  zoznamom 
  \eq* 
    2,3,5,7,11,13,0
  \end

rem 
  \para \it  Konvencia.  \end Na označenie zoznamov budeme používať 
  premenné s príponou \it  -s  \end (množné číslo v angličtine), 
  napríklad \ft xs \end, \ft ys \end, \ft zs \end. 

rem 
  \para \bf  9.1 Programovanie so zoznamami  \end 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft L(xs) \end počítajúcu 
  dĺžku zoznamu \ft xs \end: 
  \eq* 
    L(x1,x2,Tex0_ldots,Tex2_varidx(x,n),0) = n
  \end
  \para Napr. \ft L(2,3,5,7,11,13,0) = 6 \end. 

fun L 
  L(xs) = Foo

rem 
  \para \bf  Úloha.  \end Zistite, koľko prvkov má zoznam 
  \eq* 
    1,(2,3),0,4,(5,6,0),((7,8),9),0
  \end
  \para Čo je piatym prvkom tohto zoznamu (ak poradie počítame od 1)? 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Conc  \end Zadefinujte funkciu 
  \ft Conc(xs,ys) \end, ktorá zreťazí zoznamy \ft xs \end a \ft ys \end, teda 
  \eq* 
    Conc((x1,x2,Tex0_ldots,Tex2_varidx(x,n),0),
         Tex1_paren(y1,y2,Tex0_ldots,Tex2_varidx(y,m),0)) = 
    x1,x2,Tex0_ldots,Tex2_varidx(x,n),y1,y2,Tex0_ldots,Tex2_varidx(y,m),0
  \end
  \para Napr. \ft Conc((1,2,3,0),Tex1_paren(4,5,6,0)) = 1,2,3,4,5,6,0 \end. 

fun/2 Conc 
  Conc(xs,ys) = Foo

rem 
  \para \it  [CL] Zabudované zreťazenie.  \end Zreťazenie je zabudované ako 
  binárny infixový operátor. Zapisuje sa \ft xs \end ++ \ft ys \end 
  a zobrazuje sa \ft xs++ys \end. 
  \para* Zreťazenie je \it  asociatívne  \end, teda 
  \eq* 
    Tex1_paren(xs++ys)++zs = xs++Tex1_paren(ys++zs)
  \end
  \para Automaticky sa \it  zátvorkuje vľavo  \end, teda 
  \eq* 
    Tex2_equiv(xs++ys++zs,Tex1_paren(xs++ys)++zs)
  \end
  \para Zreťazenie má \it  vyššiu prioritu ako párovanie  \end, preto 
  \eq* 
    Tex2_equiv((a,xs++ys),a,Tex1_paren(xs++ys))
  \end
  \para \it  Upozornenie.  \end Aby ste spojili zoznam \ft xs \end, prvok 
  \ft a \end a zoznam \ft ys \end v tomto poradí, musíte napísať 
  \eq* 
    xs++(a,ys)
  \end
  \para Ak napíšete \ft xs++a,ys \end bez zátvoriek, znamená to 
  \ft Tex1_paren(xs++a),ys \end! 

rem 
  \para \bf  Úloha.  \end Aj keď sú hodnoty výrazov 
  \ft Tex1_paren(xs++ys)++zs \end a \ft xs++Tex1_paren(ys++zs) \end rovnaké, 
  výpočty prebiehajú rôzne. 
  \para Na ktorý z týchto výpočtov je potrebný menší počet krokov? 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rev(xs) \end, ktorá obráti 
  zoznam \ft xs \end: 
  \eq* 
    Rev(x1,x2,Tex0_ldots,Tex2_varidx(x,n),0) = 
    Tex2_varidx(x,n),Tex0_ldots,x2,x1,0
  \end
  \para Napr. \ft Rev(2,3,5,7,11,0) = 11,7,5,3,2,0 \end. 

fun Rev 
  Rev(xs) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Delall  \end Zadefinujte funkciu 
  \ft Delall(a,xs) \end, ktorá odstráni všetky výskyty prvku \ft a \end zo 
  zoznamu \ft xs \end. 
  \para* Napr. \ft Delall(3,1,3,2,3,3,3,4,3,0) = 1,2,4,0 \end. 
  \para* Uvedomte si, že musíte vytvoriť celý výstupný zoznam. Funkcia 
  nemôže meniť vstupný zoznam. 

fun/2 Delall 
  Delall(a,xs) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Last(xs) \end, ktorá vráti 
  posledný prvok zoznamu \ft xs \end, ak existuje, alebo \ft 0 \end, ak je 
  \ft xs \end prázdny. 
  \para* Napr. \ft Last(9,1,7,3,5,0) = 5 \end. 
  \para* Pokúste sa nájsť verziu bez pomocných funkcií. Ak má zoznam \it  
  aspoň  \end jeden prvok, ako zistíte, či má \it  práve  \end jeden prvok? 

fun Last 
  Last(xs) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Sub  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Sub(xs,i),Tex2_sub(xs,i)) \end, ktorá vráti \ft i \end-ty 
  prvok zoznamu \ft xs \end (počítajúc od 0): 
  \header* fun/2 Sub 'Tex2_sub' \end 
  \eq* 
    Sub((Tex2_varidx(x,0),x1,Tex0_ldots,Tex2_varidx(x,i),Tex0_ldots,
         Tex2_varidx(x,n),0),i) = Tex2_varidx(x,i)
  \end
  \para Napr. \ft Sub((2,3,5,7,11,0),2) = 5 \end. 
  \para* Špecifikácia 
  \eq* 
    i < L(xs) -> Sub(xs,i) = a <-> \e ys\e zs(xs = ys++(a,zs) & L(ys) = i)
  \end
  \para* Nepoužite žiadne pomocné funkcie. 

fun/2 Sub 'Tex2_sub'
  Sub(xs,i) = Foo

rem 
  \para \it  Poznámka.  \end Všimnite si, že (na rozdiel od polí) na 
  zoznamoch je indexovanie pomerne výpočtovo náročné: Na prístup k prvku na
  \ft i \end-tom mieste zoznamu potrebujeme \ft i \end krokov.
  \para* Indexovaniu sa preto budeme pri programovaní vyhýbať. Budeme ho však
  používať na špecifikáciu.

rem 
  \para \bf  Úloha.  \end \header* fun/2 Take  \end Zadefinujte funkciu 
  \ft Take(i,xs) \end, ktorá vráti zoznam pozostávajúci z prvých 
  \ft i \end prvkov zoznamu \ft xs \end, teda 
  \eq* 
    Take(i,a1,a2,Tex0_ldots,Tex2_varidx(a,i),Tex0_ldots,Tex2_varidx(a,n),0) = 
    a1,a2,Tex0_ldots,Tex2_varidx(a,i),0
  \end
  \para Napr. \ft Take(2,9,8,7,6,5,0) = 9,8,0 \end. 
  \para* Špecifikácia 
  \eq* 
    i <= L(xs) -> Take(i,xs) = ys <-> L(ys) = i & \e zs xs = ys++zs
  \end
  \eq* 
    i > L(xs) -> Take(i,xs) = xs
  \end
  \para* Nepoužite žiadne pomocné funkcie. 

fun/2 Take 
  Take(i,xs) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Drop  \end \header* fun/2 Take  \end 
  Zadefinujte funkciu \ft Drop(i,xs) \end, ktorá odstráni prvých \ft i \end 
  prvkov zo zoznamu \ft xs \end, teda 
  \eq* 
    Drop(i,a1,a2,Tex0_ldots,Tex2_varidx(a,i),Tex2_varidx(a,i+1),Tex0_ldots,
         Tex2_varidx(a,n),0) = Tex2_varidx(a,i+1),Tex0_ldots,Tex2_varidx(a,n),0
  \end
  \para Napr. \ft Drop(2,9,8,7,6,5,0) = 7,6,5,0 \end. 
  \para* Špecifikácia 
  \eq* 
    i <= L(xs) -> Drop(i,xs) = ys <-> L(xs) = i+L(ys) & \e zs xs = zs++ys
  \end
  \eq* 
    i > L(xs) -> Drop(i,xs) = 0
  \end
  \para* Nepoužite žiadne pomocné funkcie. 

fun/2 Drop 
  Drop(i,xs) = Foo

rem 
  \para \it  Poznámka.  \end Všimnite si, že platí 
  \eq* 
    xs = Take(i,xs)++Drop(i,xs)
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Minl(xs) \end, ktorá vráti 
  najmenší prvok zoznamu \ft xs \end. Napr. \ft Minl(3,2,1,5,4,0) = 1 \end. 
  \para* Pre prázdny zoznam funkcia vráti 0. 
  \para* \it  Nepoužite  \end žiadne „bulharské“ konštanty (99999 a 
  podobne). Počas výpočtu nevytvárajte nové zoznamy. 
  \para* \it  Návod.  \end Zistite, či má neprázdny zoznam práve jeden 
  prvok (podobne ako pri \ft Last \end). Ak nie, priraďte výsledok 
  rekurzívneho volania do pomocnej premennej a potom ho porovnajte s prvým 
  prvkom. 
  \para* Iná možnosť: Použite pomocnú funkciu, ktorá si pamätá 
  priebežné minimum v ďalšom argumente. Argument pri spustení 
  správne inicializujte (nie bulharskou konštantou!). 

fun Minl 
  Minl(xs) = Foo

rem 
  \para \bf  DOMÁCA ÚLOHA  \end 
  \para* Nasledujúce úlohy odporúčame riešiť ako súčasť prípravy na test.

rem 
  \para \bf  Úloha.  \end \header* fun/3 Msub  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Msub(xs,i,a),Tex3_msub(xs,i,a)) \end, ktorá zmení hodnotu 
  \ft i \end-teho prvku zoznamu \ft xs \end na \ft a \end, ak 
  \ft i < L(xs) \end: \header* fun/3 Msub 'Tex3_msub' \end 
  \eq* 
    Msub((Tex2_varidx(x,0),x1,Tex0_ldots,Tex2_varidx(x,i-1),Tex2_varidx(x,i),
          Tex2_varidx(x,i+1),Tex0_ldots,Tex2_varidx(x,n),0),i,a) = 
    Tex2_varidx(x,0),x1,Tex0_ldots,Tex2_varidx(x,i-1),a,Tex2_varidx(x,i+1),
    Tex0_ldots,Tex2_varidx(x,n),0
  \end
  \para Ak \ft i >= L(xs) \end, funkcia vráti nezmenený zoznam. 
  \para* Napr. \ft Msub((2,3,5,7,11,0),2,999) = 2,3,999,7,11,0 \end. 
  \para* Špecifikácia 
  \eq* 
    i < L(xs) -> Sub(Msub(xs,i,a),i) = a
  \end
  \eq* 
    i < L(xs) -> \a j(i != j -> Sub(Msub(xs,i,a),j) = Sub(xs,j))
  \end
  \eq* 
    i >= L(xs) -> Msub(xs,i,a) = xs
  \end
  \para* Nepoužite žiadne pomocné funkcie. 

fun/3 Msub 'Tex3_msub'
  Msub(xs,i,a) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Filter_even(xs) \end, ktorá 
  v zozname \ft xs \end ponechá iba párne čísla. Napr. 
  \ft Filter_even(1,2,6,5,4,0) = 2,6,4,0 \end. 

fun Filter_even 
  Filter_even(xs) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Zip  \end Zadefinujte funkciu 
  \ft Zip(xs,ys) \end, ktorá pre zoznamy \ft xs \end a \ft ys \end rovnakej 
  dĺžky vráti zoznam \it  dvojíc  \end prvkov zoznamov \ft xs \end a 
  \ft ys \end: 
  \eq* 
    Zip((x1,x2,Tex0_ldots,Tex2_varidx(x,n),0),Tex1_paren(y1,y2,Tex0_ldots,
        Tex2_varidx(y,n),0)) = 
    (x1,y1),(x2,y2),Tex0_ldots,(Tex2_varidx(x,n),Tex2_varidx(y,n)),0
  \end
  \para Napr. \ft Zip((9,8,7,6,5,0),1,2,3,4,5,0) = (9,1),(8,2),(7,3),(6,4),(5,5),0 \end. 

fun/2 Zip 
  Zip(xs,ys) = Foo

rem 
  \para \bf  Úloha.  \end \header* fun/2 Interval  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Interval(m,n),Tex2_interval_co(m,n)) \end, ktorá vráti zoznam 
  prirodzených v polouzavretom intervale \ft Tex2_realinterval_co(m,n) \end. 
  \header* fun/2 Interval 'Tex2_interval_co' \end 
  \para* Napr. \ft Interval(4,8) = 4,5,6,7,0 \end. 
  \para* Špecifikácia 
  \eq* 
    m <= n -> L Interval(m,n) = n-m
  \end
  \eq* 
    m+i < n -> Sub(Interval(m,n),i) = m+i
  \end

fun/2 Interval 'Tex2_interval_co'
  Interval(m,n) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Map_fib(xs) \end, ktorá 
  aplikuje Fibonacciho funkciu na všetky prvky zoznamu \ft xs \end a vráti 
  zoznam výsledkov: 
  \eq* 
    Map_fib(a1,a2,Tex0_ldots,Tex2_varidx(a,n),0) = 
    Fib(a1),Fib(a2),Tex0_ldots,Fib Tex2_varidx(a,n),0
  \end
  \para* Špecifikácia
  \eq* 
    L Map(x) = L(x)
  \end
  \eq* 
    i < L(x) -> Sub(Map(x),i) = Fib Sub(x,i)
  \end
  \para Použite funkciu \ft Fib(n) \end je zadefinovanú na začiatku tohto 
  súboru. 
  \para* Funkciu \ft Map_fib \end naprogramujte tak, aby sa dala použiť 
  s akoukoľvek funkciou \ft Tex1_f(n) \end namiesto \ft Fib(n) \end. 

fun Map_fib 
  Map_fib(xs) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Table_fib(n) \end, ktorá 
  vypočíta zoznam prvých \ft n \end prvkov Fibonacciho postupnosti, teda 
  \eq* 
    Table_fib(0) = 0
  \end
  \eq* 
    Table_fib(n+1) = Fib(0),Fib(1),Tex0_ldots,Fib(n),0
  \end

fun Table_fib 
  Table_fib(n) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Maxl(xs) \end, ktorá vráti 
  najväčší prvok zoznamu \ft xs \end. Pre prázdny zoznam funkcia vráti 0. 
  \para* Napr. \ft Maxl(3,2,1,5,4,0) = 5 \end. 

fun Maxl 
  Maxl(xs) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Suml(xs) \end, ktorá sčíta 
  všetky prvky zoznamu \ft xs \end: 
  \eq* 
    Suml(0) = 0
  \end
  \eq* 
    Suml(a1,a2,Tex0_ldots,Tex2_varidx(a,n),0) = 
    a1+a2+Tex0_ldots+Tex2_varidx(a,n)
  \end
  \para Napr. \ft Suml(2,3,5,7,11,0) = 28 \end. 

fun Suml 
  Suml(xs) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rotl(xs) \end, ktorá zrotuje 
  zoznam \ft xs \end doľava: 
  \eq* 
    Rotl(a1,a2,Tex0_ldots,Tex2_varidx(a,n),0) = 
    a2,Tex0_ldots,Tex2_varidx(a,n),a1,0
  \end
  \para Napr. \ft Rotl(2,4,6,8,0) = 4,6,8,2,0 \end. Pokúste sa o definíciu bez 
  pomocných funkcií a bez zreťazenia. 

fun Rotl 
  Rotl(xs) = Foo

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Rotr(xs) \end, ktorá zrotuje 
  zoznam \ft xs \end doprava: 
  \eq* 
    Rotr(a1,a2,Tex0_ldots,Tex2_varidx(a,n-1),Tex2_varidx(a,n),0) = 
    Tex2_varidx(a,n),a1,a2,Tex0_ldots,Tex2_varidx(a,n-1),0
  \end
  \para Napr. \ft Rotr(2,4,6,8,0) = 8,2,4,6,0 \end. Pokúste sa o definíciu bez 
  pomocných funkcií a bez zreťazenia. 

fun Rotr 
  Rotr(xs) = Foo

