mod Ex03b

loc rem 
  \para \bf  3. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/ex/ex03.zip 

loc rem 
  \para* \it  Dátum:  \end streda 2. 3. 2011 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované priraďujúcim
  diskrimináciám a simulácii cyklov chvostovou rekurziou. Zadanie sa skladá
  z týchto súborov: 
  \items 
   \item \para Súbory \it  ex03*.cl  \end obsahujú úlohy, ktoré máte 
         riešiť na tomto cvičení. 
  \end

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania. 
  2011. 
  \para http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/udp-screen.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

rem 
  \para \it  [CL] CL-TeX.  \end 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots_around
  Fenced(Op(Ent('ctdot'),0),Arg(0),Op(Ent('ctdot'),0))

appldisp/1 Tex1_f
  Std('f',0)

appldisp/2 Tex2_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/1 Tex1_fact
  Postfix(Arg(0),60,1,Op('!',0))

appldisp/2 Tex2_exp
  Subsup(Arg(0),75,None,Arg(1))

appldisp/1 Tex1_fib
  Subsup(Id(0,'fib',0),75,Arg(0),None)

appldisp/1 Tex1_fib_efficient
  Subsup(Id(0,'fib',0),75,Arg(0),Id(0,'efficient',0))

appldisp/1 Tex1_f1_efficient
  Prefix(90,2,Subsup(Id(0,'F',0),75,Id(0,'1',0),Id(0,'efficient',0)),Arg(0))

appldisp/1 Tex1_f2_efficient
  Prefix(90,2,Subsup(Id(0,'F',0),75,Id(0,'2',0),Id(0,'efficient',0)),Arg(0))

appldisp/1 Tex1_f3_efficient
  Prefix(90,2,Subsup(Id(0,'F',0),75,Id(0,'3',0),Id(0,'efficient',0)),Arg(0))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  7. SIMULÁCIA CYKLOV CHVOSTOVOU REKURZIOU  \end 

rem 
  \para \it  Poznámka.  \end Podrobnejší návod na riešenie nasledujúcich 
  úloh nájdete napríklad v prednáškach [1]. 
  \para* Úlohy označené hviezdičkou \bf  *  \end riešte \bf  po  \end 
  vyriešení všetkých neoznačených úloh. 

rem 
  \para \bf  7.1 Simulácia while cyklu  \end 

rem 
  \para \it  Výpočet faktoriálu while cyklom.  \end Funkciu 
  \ft Tex2_equiv(Fact(n),Tex1_fact(n)) \end 
  \def* 
    Tex1_fact(0) = 0
    Tex1_fact(n+1) = (n+1)*Tex1_fact(n)
  \end
  \para vypočítame pomocou pascalovského while cyklu nasledovne: 
  \verbatim 
      f := 1;                  }  Fact
      while n <> 0 do begin   -
          f := f*n;            |
          n := n-1             |- While_fact
      end;                     |
      Result := f             -
  \end

rem 
  \para* \bf  Úloha. Faktoriál simuláciou while cyklu.  \end 
  \header* fun/2 While_fact  \end Simulujte uvedený while cyklus 
  chvostovorekurzívnou funkciou \ft While_fact(n,f) \end a použite ju na 
  zadefinovanie funkcie \ft Tex2_equiv(Fact(n),Tex1_fact(n)) \end. Pomocný 
  argument \ft f \end nazývame \it  akumulátor  \end. 
  \para Ako je naznačené vyššie, funkcia \ft While_fact \end počíta iba 
  cyklus a vrátenie výsledku. 
  \para Hlavná funkcia \ft Fact \end inicializuje akumulátor \ft f \end 
  vhodným volaním funkcie \ft While_fact \end. 
  \para Invariant: 
  \eq* 
    While_fact(n,f) = f*Tex1_fact(n)
  \end

fun/2 While_fact 
  While_fact(n,f) = Foo

fun Fact 'Tex1_fact'
  Fact(n) = Foo

rem 
  \para* \bf  Úloha. Umocnenie simuláciou while cyklu.  \end 
  \header* fun/2 Exp  \end \header* fun/3 While_exp  \end Naprogramujte 
  umocnenie pomocou simulácie while cyklu. 
  \para* \bf  a)  \end Do nasledujúcej poznámky vpíšte fragment 
  pascalovského programu, ktorý vypočíta umocnenie do akumulátora 
  \ft e \end, podobne ako pri faktoriáli. 

rem 
  e := ...;
  while ... do begin
      ...
  end;
  Result := e

rem 
  \para \bf  b)  \end Zadefinujte chvostovorekurzívnu funkciu 
  \ft While_exp(x,y,e) \end, ktorá simuluje váš while cyklus, ale nie 
  inicializáciu akumulátora. 
  \para Invariant: 
  \eq* 
    While_exp(x,y,Tex2_exp(x,z)) = Tex2_exp(x,y+z)
  \end

fun/3 While_exp 
  While_exp(x,y,e) = Foo

rem 
  \para \bf  c)  \end Funkcia \ft Tex2_equiv(Exp(x,y),Tex2_exp(x,y)) \end 
  odštartuje simuláciu while cyklu s vhodnou začiatočnou hodnotou 
  akumulátora \ft e \end. 

fun/2 Exp 'Tex2_exp'
  Exp(x,y) = Foo

rem 
  \para \bf  7.2 Efektívny výpočet Fibonacciho postupnosti  \end 

rem 
  \para \it  Efektívny výpočet členov Fibonacciho postupnosti while cyklom. 
   \end Funkciu \ft Tex2_equiv(Fib(n),Tex1_fib(n)) \end pre \ft n \end-tý člen 
  Fibonacciho postupnosti 

fun Fib 'Tex1_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n)+Fib(n+1)

rem 
  \para môžeme efektívne vypočítať pomocou \it  while  \end cyklu s dvoma 
  akumulátormi \ft m \end, \ft d \end, v ktorých si pamätáme dva po sebe 
  nasledujúce členy postupnosti: 
  \verbatim 
      if n = 0 then                            -
          Result := 0                           |
      else begin                                |_ Fib_efficient
          n := n - 1; { !! }                    |
          m := 0; { fib(0) }                    |
          d := 1; { fib(1) }                   -
          while n <> 0 do begin                -
              { m = fib(i) & d = fib(i+1) }     |
              m1 := d;                          |
              d1 := m+d;                        |
              m := m1; d := d1;                 |- While_fib
              { m = fib(i+1) & d = fib(i+2) }   |
              n := n-1                          |
          end;                                  |
          Result := d                          -
      end
  \end

rem 
  \para* \bf  Úloha. Efektívny výpočet členov Fibonacciho postupnosti 
  simuláciou while cyklu.  \end 
  \para* \bf  a)  \end \header* fun/3 While_fib  \end Simulujte while cyklus z 
  predchádzajúcej poznámky chvostovorekurzívnu funkciou 
  \ft While_fib(n,m,d) \end. Úvodný test a inicializáciu premenných zatiaľ 
  neberte do úvahy. 
  \para Invariant: 
  \eq* 
    While_fib(n,Fib(i),Fib(i+1)) = Fib(n+i+1)
  \end

fun/3 While_fib 
  While_fib(n,m,d) = Foo

rem 
  \para \bf  b)  \end Naprogramujte funkciu 
  \ft Tex2_equiv(Fib_efficient(n),Tex1_fib_efficient(n)) \end, ktorá vykoná 
  úvodný test pascalovského programu a spustí simuláciu while cyklu so 
  správne inicializovanými hodnotami premenných \ft n \end, \ft a \end, 
  \ft b \end. 

fun Fib_efficient 'Tex1_fib_efficient'
  Fib_efficient(n) = Foo

rem 
  \para \bf  * Úloha.  \end Podobne ako v predchádzajúcej úlohe zadefinujte 
  efektívnu verziu \ft Tex2_equiv(F1_efficient(n),Tex1_f1_efficient(n)) \end 
  nasledujúcej funkcie \ft F1(n) \end simuláciou while cyklu. 

fun F1 
  F1(0) = 0
  F1(1) = 1
  F1(2) = 2
  F1(n+3) = F1(n)+F1(n+1)+F1(n+2)

rem 
  \para \bf  a)  \end Do nasledujúcej poznámky vpíšte pascalovský program, 
  ktorý počíta funkciu \ft F1 \end while cyklom. Výpočet je podobný 
  výpočtu Fibonacciho postupnosti. Program si pamätá 3 po sebe nasledujúce 
  členy postupnosti v akumulátoroch \ft a \end, \ft b \end, \ft c \end. 

rem 
  if n = 0 then
      ...
  else if n = 1 then
      ...
  else begin
      n := ...;
      a := ...; { F1(0) }
      b := ...; { F1(1) }
      c := ...; { F1(2) }
      while ... do begin
          { a = F1(i) & b = F1(i+1) & c = F1(i+2) }
          ...
          { a = F1(i+1) & b = F1(i+2) & c = F1(i+3) }
      end;
      Result := c
  end

rem 
  \para \bf  b)  \end \header* fun/4 While_f1  \end Simulujte while cyklus 
  funkciou \ft While_f1(n,a,b,c) \end. 
  \para* Invariant: 
  \eq* 
    While_f1(n,F1(i),F1(i+1),F1(i+2)) = F1(n+i+2)
  \end

fun/4 While_f1 
  While_f1(n,a,b,c) = Foo

rem 
  \para \bf  c)  \end Vo funkcii 
  \ft Tex2_equiv(F1_efficient(n),Tex1_f1_efficient(n)) \end ošetrite okrajové 
  prípady a odštartujte cyklus so správne inicializovanými premennými. 

fun F1_efficient 'Tex1_f1_efficient'
  F1_efficient(n) = Foo

rem 
  \para \bf  7.3 Simulácia for cyklu  \end 

rem 
  \para \it  Faktoriál simuláciou for cyklu.  \end Faktoriál môžeme 
  počítať aj pomocou pascalovského for cyklu: 
  \verbatim 
      f := 1;                       } Fact1
      for i := 1 to n do begin     -
          f := f*i                  |_ For_fact
      end;                          |
      Result := f                  -
  \end

rem 
  \para \bf  Úloha. Faktoriál simuláciou for cyklu.  \end Naprogramujte 
  funkciu \ft Fact1 \end využitím pomocnej funkcie \ft For_fact \end. 
  \para* \bf  a)  \end Funkcia \ft For_fact \end simuluje for cyklus z 
  predchádzjúcej poznámky. Zadefinujte ju \it  spätnou rekuziou  \end, pri 
  ktorej rekurzívny argument \ft i \end rastie, kým neprekročí hranicu 
  \ft n \end. Uvedomte si, že cyklus 
  \verbatim 
      for i := 1 to n do begin TELO end
  \end
  \para je ekvivalentný 
  \verbatim 
      i := 1; while i <= n do begin TELO; i := i+1 end
  \end

fun/3 For_fact 
  For_fact(i,n,f) = Foo

rem 
  \para \bf  b)  \end Funkcia \ft Fact1 \end spustí cyklus so správne 
  inicializovanými premennými \ft i \end, \ft f \end a \ft n \end. 

fun Fact1 
  Fact1(n) = Foo

rem 
  \para \bf  * Úloha.  \end Zadefinujte efektívnu verziu 
  \ft Tex2_equiv(F2_efficient(n),Tex1_f2_efficient(n)) \end nasledujúcej 
  funkcie \ft F2(n) \end simuláciou for cyklu. 

fun F2 
  F2(0) = 0
  F2(1) = 1
  F2(n+2) = F2(n)+F2(n+1)+n

rem 
  \para Funkciu \ft F2 \end môžeme efektívne vypočítať nasledujúcim for 
  cyklom. 
  \verbatim 
      if n = 0 then                          -
          Result := 0                         |
      else if n = 1 then                      |
          Result := 1                         |_ F2_efficient
      else begin                              |
          n := n - 2; { ! }                   |
          a := 0; { F2(0) }                   |
          b := 1; { F2(1) }                  -
          for i := 0 to n do begin           -
              { a = F2(i) & b = F2(i+1) }     |
              a1 := b;                        |
              b1 := a+b+i;                    |_ For_f2
              a := a1; b := b1;               |
              { a = F2(i+1) & c = F2(i+2) }   |
          end;                                |
          Result := b                        -
      end
  \end
  \para \header* fun/4 For_f2  \end Simulujte for cyklus pomocnou 
  chvostovorekurzívnou funkciou \ft For_f2(i,n,a,b) \end. 
  \para* Invariant: 
  \eq* 
    i <= n+1 -> For_f2(i,n,F2(i),F2(i+1)) = F2(n+2)
  \end
  \para Úvodné testy, inicializáciu premenných a štart cyklu implementujte 
  v hlavnej funkcii \ft Tex2_equiv(F2_efficient(n),Tex1_f2_efficient(n)) \end 

fun/4 For_f2 
  For_f2(i,n,a,b) = Foo

fun F2_efficient 'Tex1_f2_efficient'
  F2_efficient(n) = Foo

rem 
  \para \bf  * Úloha.  \end Zadefinujte efektívnu verziu 
  \ft Tex2_equiv(F3_efficient(n),Tex1_f3_efficient(n)) \end funkcie 
  \ft F3(n) \end simuláciou for cyklu podobne ako v predchádzajúcej úlohe. 

fun F3 
  F3(0) = 0
  F3(1) = 1
  F3(2) = 2
  F3(n+3) = F3(n)+F3(n+1)+F3(n+2)+n

rem 
  \para \header* fun/5 For_f3  \end Invariant: 
  \eq* 
    i <= n+1 -> For_f3(i,n,F3(i),F3(i+1),F3(i+2)) = F3(n+3)
  \end

fun/5 For_f3 
  For_f3(i,n,a,b,c) = Foo

fun F3_efficient 'Tex1_f3_efficient'
  F3_efficient(n) = Foo

