mod Test02_0810

incl Strings

incl Xml_mod

incl Blog

rem 
  \para \bf  2. TEST Z ÚVODU DO DEKLARATÍVNEHO PROGRAMOVANIA  \end 
  \para* Streda 25. 4. 2007 o 8:10 

rem 
  \para \bf  Vaše meno:  \end [doplňte!] 

rem 
  \para Test pozostáva z jednej úlohy rozdelenej na päť častí. Zadanie je 
  uvedené nižšie. 
  \para* \bf  POKYNY  \end 
  \items 
   \item \para Na vyriešenie úlohy máte 90 minút. 
   \item \para Meno súboru obsahujúceho vaše riešenie: \it  test02_0810.cl 
          \end. 
   \item \para Na priebežné ukladanie vášho riešenia používajte tlačidlo 
         \it  Save  \end ( \it  Alt+S  \end). 
   \item \para Vaše riešenie odovzdajte podľa pokynov cvičiaceho. 
  \end
  \para* \bf  POČET BODOV:  \end 20 (5+4+1+8+2) 

rem 
  \para \bf  \it  Preskočte nasledujúce komponenty až po nadpis \bf  ZADANIE 
   \end.  \end  \end 

appldisp/0 Cdots
  Op(Ent('ctdot'),0)

appldisp/0 Ldots
  Op(Ent('hellip'),0)

fun/0 Fill_in 'Cdots'
  Fill_in = 20070425

fun/0 Fill_arg 'Ldots'
  Fill_arg = 20070425

pred/0 Fill__in 'Cdots'
  Fill__in

fun/0 Fill_x 'Cdots'
  Fill_x = Xs('TODO')

fun/0 Fill_lx 'Cdots'
  Fill_lx = Fill_x,0

rem 
  \para \it  \bf  Z A D A N I E  \end  \end 

rem 
  \para \bf  XML formát pre blog  \end, ktorý sme používali na predmete 
  Moderný prístup k webdesignu, majú nasledujúcu štruktúru: 
  \para Koreňový element \it  blog  \end obsahuje ľubovoľný počet 
  elementov \it  post  \end (príspevok). Každý element \it  post  \end 
  obsahuje v tomto poradí: 
  \points 
   \item \para práve jeden element \it  headline  \end: nadpis príspevku 
         (reťazec); 
   \item \para práve jeden element \it  date  \end: dátum zverejnenia 
         príspevku (reťazec); 
   \item \para práve jeden element \it  content  \end: text príspevku 
         (fragment XHTML); 
  \end
  \para Element \it  post  \end má niekoľko atribútov, z ktorých nás budú 
  zaujímať 
  \items 
   \item \para atribút \it  id  \end: jednoznačný identifikátor príspevku; 
   \item \para atribút \it  ref  \end: ak existuje, tento príspevok je 
         reakciou (odpoveďou) na príspevok, ktorého ID je hodnotou atribútu 
         \it  ref  \end; 
   \item \para atribút \it  category  \end: kategória, do ktorej autor tento 
         príspevok zaradil. 
  \end
  \para Ostatné elementy nemajú atribúty. 

rem 
  \para Príkladom blogu v opísanom formáte je konštanta \ft X_blog \end z 
  modulu \ft Blog \end. Jej skrátená (testovacia) verzia \ft X_blog_mini \end 
  obsahuje iba štyri príspevky (3 obyčajné a jednu odpoveď). 

rem 
  \para \bf  ÚLOHA.  \end \header* fun/3 Main  \end 
  \para* Naprogramujte funkciu \ft Main(qd,qc,blog) \end, ktorá zobrazí 
  \ft blog \end do vhodne sformátovaného XHTML. Zobrazí iba obyčajné 
  príspevky (nie odpovede) zverejnené po zadanom dátume \ft qd \end, ktoré 
  sú zaradené do kategórie \ft qc \end. 
  \para Odporúčaný postup riešenia je nasledovný: 
  \points 
   \item \para Prekódujte blog do zjednodušenej CL-štruktúry. ( \bf  \it  5 
         bodov  \end  \end) 
   \item \para Vyfiltrujte príspevky z tejto štruktúry podľa daných 
         kritérií. ( \bf  \it  4 body  \end  \end) 
   \item \para Utrieďte príspevky podľa dátumu od najnovšieho po 
         najstarší. ( \bf  \it  1 bod  \end  \end) 
   \item \para Zobrazte príspevky do XHTML. ( \bf  \it  8 bodov  \end  \end) 
   \item \para Spojte uvedené tri časti do funkcie \ft Main \end. ( \bf  \it  
         2 body  \end  \end) 
  \end
  \para Jednotlivé časti budú bodované nezávisle. Môžete riešiť 
  ktorúkoľvek z nich bez ohľadu na to, či ste vyriešili predchádzujúce. 
  Ak sa rozhodnete pre iný ako odporúčaný postup, body za riešenie Vám 
  pridelíme podľa uváženia. Bez ohľadu na zvolený postup bude plne 
  funkčné riešenie hodnotené 20-timi bodmi. 
  \para Detaily prekódovania, filtrovania a zobrazenia sú opísané nižšie. 

rem 
  \para \bf  1. Prekódovanie blogu do \ft Lst(Post) \end  \end (5 bodov) 

rem 
  \para Pre zjednodušenie ďalšej manipulácie s blogmi ich prekódujeme do 
  dátovej štruktúry typu \ft Lst(Post) \end (predikát \ft Posts \end), teda 
  do zoznamu príspevkov, z ktorých každý vznikne prekódovaním elementu 
  \it  post  \end. 
  \para Každý príspevok je šestica vytvorená konštruktorom \ft Post \end s 
  argumentami: identifikátor príspevku (hodnota atribútu \it  id  \end); 
  názov príspevku (reťazcový obsah podelementu \it  headline  \end); dátum 
  zverejnenia (reťazcový obsah podelementu \it  date  \end); odkaz na 
  pôvodný príspevok, na ktorý je tento odpoveďou (hodnota atribútu \it  
  ref  \end alebo prázdny reťazec, ak tento atribút neexistuje); kategória 
  príspevku (hodnota atribútu \it  category  \end); text článku (obsah 
  podelementu \it  content  \end). Argumenty \ft Post \end sú reťazce ( 
  \ft Str \end), okrem posledného, ktorý je XML ( \ft Lst(X) \end). 

fun/6 Post 
  Post(id,headline,date,ref,cat,content) = 6,id,headline,date,ref,cat,content

pred Posts 
  Posts(0)
  Posts(Post(id,headline,date,ref,cat,content),ps) <- 
    Str(id) & Str(headline) & Str(date) & Str(ref) & Str(cat) & Xml(content) & 
    Posts(ps)

rem 
  \para Prekódovanie blogu z XML do opísanej štruktúry by ste mali 
  realizovať nasledujúcimi funkciami. \it  Odporúčame  \end začať 
  naprogramovaním hlavnej funkcie \ft In_blog \end a postupne dopĺňať 
  pomocné funkcie. 

rem 
  \para \ft Is(In_post,(X -> Post)) \end 
  \para Funkcia \ft In_post \end prekóduje \it  jeden  \end element \it  post 
   \end do štruktúry vytvorenej konštruktorom \ft Post \end. 
  \para Na získanie reťazcového obsahu detí použite funkciu 
  \ft Value_of \end definovanú v module \ft Xml_mod \end. Hodnotu atribútov 
  získate funkciou \ft Fva \end z toho istého modulu. Uvedomte si, že ak 
  atribút neexistuje, \ft Fva \end vráti prázdny reťazec. 

fun In_post 
  In_post(x) = Fill_in

rem 
  \para \ft Is(In_posts,(Lst(X) -> Lst(Post))) \end 
  \para Funkcia \ft In_posts \end prekóduje zoznam elementov \it  post  \end do 
  zoznamu, ktorého prvkami sú štruktúry vytvorené konštruktorom 
  \ft Post \end. Každý element \it  post  \end pošle na prekódovanie funkcii 
  \ft In_post \end. 

fun In_posts 
  In_posts(lx) = Fill_in

rem 
  \para \ft Is(In_blog,(Lst(X) -> Lst(Post))) \end 
  \para Funkcia \ft In_blog \end dostane XML dokument tvorený koreňovým 
  elementom \it  blog  \end. Jeho deti pošle na spracovanie funkcii 
  \ft In_posts \end, ktorej výsledok bezo zmeny vráti. 

fun In_blog 
  In_blog(lx) = Fill_in

rem 
  \para \bf  2. Filtrovanie \ft Lst(Post) \end  \end (4 body) 

rem 
  \para \ft Is(Filter,(Str,Str,Lst(Post) -> Lst(Post))) \end 
  \header* fun/3 Filter  \end \header* pred/3 Q  \end 
  \para Funkcia \ft Filter(qd,qc,ps) \end vyberie zo zoznamu príspevkov \it  ps 
   \end tie, ktoré boli zverejnené \it  po dátume  \end \ft qd \end a sú 
  zaradené \it  v kategórii  \end \ft qc \end a \it  nie sú odpoveďami 
   \end, teda nemajú atribút \it  ref  \end. Ak je ale \ft qd = '*' \end, 
  nefiltruje sa podľa dátumu. Podobne ak \ft qc = '*' \end, nefiltruje sa 
  podľa kategórie. 
  \para Na rozhodnutie o tom, či jeden príspevok patrí do výsledku, 
  odporúčame naprogramovať pomocný predikát \ft Q(qd,qc,p) \end. 
  Predpokladáme, že všetky dátumy sú vo formáte \it  YYYY  \end- \it  MM 
   \end- \it  DD  \end T \it  hh  \end: \it  mm  \end: \it  ss  \end Z 
  (ISO-8601, RFC-3339), takže ich môžeme porovnávať ako reťazce 
  predikátom \ft Lt_s \end z modulu \ft Strings \end. 

pred/3 Q 
  Q(qd,qc,post) <- Fill__in

fun/3 Filter 
  Filter(qd,qc,ps) = Fill_in

rem 
  \para \bf  3. Utriedenie \ft Lst(Post) \end podľa dátumu  \end (1 bod) 

rem 
  \para \ft Is(Sort,(Lst(Post) -> Lst(Post))) \end \header* fun Sort  \end 
  \header* pred/2 Newer  \end 
  \para Funkcia \ft Sort(ps) \end utriedi zoznam príspevkov \it  ps  \end 
  podľa dátumu \it  od najnovšieho po najstarší  \end algoritmom insert 
  sort. 
  \para Vašou úlohou je naprogramovať pomocný predikát 
  \ft Newer(p1,p2) \end na porovnanie dvoch príspevkov, aby sme dosiahli 
  požadované usporiadanie. Predpokladáme, že všetky dátumy sú vo formáte 
  \it  YYYY  \end- \it  MM  \end- \it  DD  \end T \it  hh  \end: \it  mm  \end: 
  \it  ss  \end Z (ISO-8601, RFC-3339), takže ich môžeme porovnávať ako 
  reťazce predikátom \ft Lt_s \end z modulu \ft Strings \end. 

pred/2 Newer 
  Newer(p1,p2) <- Fill__in

fun Insert 
  Insert(p,0) = p,0
  Insert(p,q,ps) = p,q,ps <- Newer(p,q)
  Insert(p,q,ps) = q,Insert(p,ps) <- ~Newer(p,q)

fun Sort 
  Sort(0) = 0
  Sort(p,ps) = Insert(p,Sort(ps))

rem 
  \para \bf  4. Zobrazenie \ft Lst(Post) \end do XHTML  \end (8 bodov) 

rem 
  \para Podobne ako pri prekódovaní blogu z XML do \ft Lst(Post) \end 
  odporúčame \it  začať hlavnou zobrazovacou funkciou  \end \ft Ht_blog \end 
  a postupne pridávať pomocné funkcie. 

rem 
  \para \ft Is(Ht_post,(Post -> X)) \end 
  \para Funkcia \ft Ht_post \end zoberie štruktúru vytvorenú konštruktorom 
  \ft Post \end a vytvorí \it  jeden element  \end typu \it  div  \end, ktorý 
  obsahuje 
  \items 
   \item \para názov príspevku ako nadpis druhej úrovne; 
   \item \para nadpis má atribút id, ktorého hodnotou je jednoznačný 
         identifikátor príspevku; 
   \item \para za nadpisom nasleduje odsek obsahujúci dátum zverejnenia a 
         kategóriu s vhodným pomocným textom (napr. Published: ... | 
         Category: ...); 
   \item \para za týmito údajmi nasleduje text príspevku uzavretý do 
         elementu \it  div  \end; pozor, text je fragment XHTML, nie reťazec; 
   \item \para na konci príspevku je vnútorný odkaz (<a href="#...">...</a>) 
         na začiatok dokumentu s vhodným textom. 
  \end

fun Ht_post 
  Ht_post(post) = Fill_x

rem 
  \para \ft Is(Ht_posts,(Lst(Post) -> Lst(X))) \end 
  \para Funkcia \ft Ht_posts \end zoberie zoznam príspevkov a vráti zoznam 
  XHTML elementov, z ktorých každý je zobrazením jedného príspevku. 

fun Ht_posts 
  Ht_posts(ps) = Fill_lx

rem 
  \para \ft Is(Ht_toc,(Lst(Post) -> Lst(X))) \end 
  \para Funkcia \ft Ht_posts \end zoberie zoznam príspevkov a vráti zoznam 
  XHTML elementov, z ktorých každý je vnútorným odkazom (<a 
  href="#...">...</a>) na príslušný príspevok pomocou jeho id. Textom odkazu 
  je názov príspevku. 

fun Ht_toc 
  Ht_toc(ps) = Fill_lx

rem 
  \para \ft Is(Ht_blog,(Lst(Post) -> Lst(X))) \end 
  \para Funkcia \ft Ht_blog \end zoberie zoznam príspevkov \ft Lst(Post) \end a 
  vytvorí XHTML dokument. Pritom: 
  \items 
   \item \para dokument začína nadpisom prvej úrovne s vhodným textom (napr. 
         tbc's blog); 
   \item \para nadpis má atribút \it  id  \end s hodnotou \it  top  \end; 
   \item \para za nadpisom nasleduje element \it  div  \end obsahujúci zoznam 
         odkazov na príspevky vytvorený funkciou \ft Ht_toc \end; tento 
         \ft div \end odporúčame vhodne naštýlovať (napr. float: left); 
   \item \para nasledujú samotné príspevky sformátované funkciou 
         \ft Ht_posts \end. 
  \end
  \para Odporúčame použiť pomocnú funkciu \ft Html \end známu z cvičení 
  a definovanú v module \ft Xml_mod \end. 

fun Ht_blog 
  Ht_blog(ps) = Fill_lx

rem 
  \para \bf  5. Hlavná funkcia  \end (2 body) 

rem 
  \para \ft Is(Main,(Str,Str,Lst(X) -> Lst(X))) \end 
  \para Funkcia \ft Main \end zoberie blog zakódovaný ako XML, prekóduje ho 
  do zoznamu príspevkov \ft Lst(Post) \end. Ďalej prefiltruje príspevky 
  podľa kritérií \ft qd \end a \ft qc \end, zotriedi ich a výsledný zoznam 
  zobrazí do XHTML. 

fun/3 Main 
  Main(qd,qa,blog) = Fill_in

