mod Mtesting09

incl Maux09

rem 
  \para \bf  Pomocné definície pre testovanie  \end 

appldisp/0 Tex0_type_m
  Op('',0)

appldisp/3 Tex3_ok
  Prefix(70,0,Id(4,'OK',0),
         Fenced(Op('[',0),
                Infix(Arg(0),30,0,Subsup(Op('=',0),75,Arg(2),None),Arg(1)),Op(']',0)))

appldisp/3 Tex3_failed
  Prefix(70,0,Id(6,'FAILED',0),
         Fenced(Op('[',0),
                Infix(Arg(0),30,0,Subsup(Op(Ent('ne'),0),75,Arg(2),None),Arg(1)),
                Op(']',0)))

appldisp/2 Tex2_error_
  Prefix(70,0,Prefix(20,0,Id(6,'FAILED',0),Arg(0)),Fenced(Op('[',0),Arg(1),Op(']',0)))

appldisp/2 Tex2_test_case
  Fenced(Op('{',0),
         Infix(Prefix(70,2,Id(0,'Testing on  ',0),Arg(0)),20,0,Op(': ',0),Arg(1)),
         Op('}',0))

appldisp/3 Tex3_test_case
  Fenced(Op('{',0),
         Infix(Prefix(70,2,Id(0,'Testing on  ',0),Arg(0)),20,0,Op(': ',0),
               Infix(Arg(1),30,0,Op('; ',0),Arg(2))),Op('}',0))

appldisp/4 Tex4_test_case
  Fenced(Op('{',0),
         Infix(Prefix(70,2,Id(0,'Testing on  ',0),Arg(0)),20,0,Op(': ',0),
               Infix(Arg(1),30,0,Op('; ',0),Infix(Arg(2),30,0,Op('; ',0),Arg(3)))),
         Op('}',0))

appldisp/2 Tex2_check
  Infix(Arg(0),30,0,Subsup(Op('=',0),75,None,Id(6,'?',0)),Arg(1))

fun/0 Type_m 'Tex0_type_m'
  Type_m = 0,0

pred Type 
  Type(Type_m)

fun/3 Result_ok 'Tex3_ok'
  Result_ok(x,y,t) = 77,x,y,t

fun/3 Result_failed 'Tex3_failed'
  Result_failed(x,y,t) = 66,x,y,t

fun/2 Error_ 'Tex2_error_'
  Error_(msg,x) = 55,msg,x

pred Is_error_ 
  Is_error_ Error_(msg,x)

fun/2 Test_case2 'Tex2_test_case'
  Test_case2(t,rs) = 82,t,rs

fun/3 Test_case3 'Tex3_test_case'
  Test_case3(t,a,b) = 83,t,a,b

fun/4 Test_case4 'Tex4_test_case'
  Test_case4(t,a,b,c) = 84,t,a,b,c

fun/2 Check 'Tex2_check'
  Check(x,y) = Result_ok(x,y,Type_m) <- x = y
  Check(x,y) = Result_failed(x,y,Type_m) <- x != y

rem 
  \para \bf  Formáty výsledkov testov  \end 

pred Result 
  Result Result_ok(x,y,t) <- M(x) & M(y) & Type(t)
  Result Result_failed(x,y,t) <- M(x) & M(y) & Type(t)

pred Results 
  Results(0)
  Results(r,rs) <- Result(r) & Results(rs)

rem 
  \para \bf  Testovanie funkcií na výrazoch  \end 

fun/0 Vs_primes 
  Vs_primes = 
  101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,
  197,199,0

fun Ct_ 'Tex1_ct'
  Ct_(n) = 0,n

fun Vt_ 'Tex1_vt'
  Vt_(i) = 1,i

fun/2 At_ 'Tex2_at'
  At_(t1,t2) = 2,t1,t2

fun/2 Mt_ 'Tex2_mt'
  Mt_(t1,t2) = 3,t1,t2

pred Term_ 
  Term_ Ct_(n) <- N(n)
  Term_ Vt_(i) <- N(i)
  Term_ At_(t1,t2) <- Term_(t1) & Term_(t2)
  Term_ Mt_(t1,t2) <- Term_(t1) & Term_(t2)
  Term_ Error_(msg,t) <- Str(msg) & Term_(t)

pred Results_term 
  Results_term(0)
  Results_term(Result_ok(x,y,t),rs) <- 
    Term_(x) & Term_(y) & Type(t) & Results_term(rs)
  Results_term(Result_failed(x,y,t),rs) <- 
    Term_(x) & Term_(y) & Type(t) & Results_term(rs)

pred Results_den 
  Results_den(0)
  Results_den(Test_case2(t,rs),rss) <- Term_(t) & Results(rs) & Results_den(rss)

fun Check_lassoc_ 
  Check_lassoc_ Ct_(n) = Ct_(n)
  Check_lassoc_ Vt_(i) = Vt_(i)
  Check_lassoc_ At_(t,Ct_(n)) = At_(Check_lassoc_(t),Ct_(n))
  Check_lassoc_ At_(t,Vt_(i)) = At_(Check_lassoc_(t),Vt_(i))
  Check_lassoc_ At_(t,Mt_(t1,t2)) = At_(Check_lassoc_(t),Mt_(t1,t2))
  Check_lassoc_ At_(t,At_(t1,t2)) = Error_('not Lassoc',At_(t,At_(t1,t2)))
  Check_lassoc_ Mt_(t1,t2) = Mt_(t1,t2)

fun Check_lassoc 
  Check_lassoc(t) = t <- ~Term_(t)
  Check_lassoc(t) = Check_lassoc_(t) <- Term_(t)

pred Results_lassoc 
  Results_lassoc(0)
  Results_lassoc(Test_case4(t,lat,denr,szr),rss) <- 
    Term_(t) & Term_(lat) & Result(denr) & Result(szr) & Results_lassoc(rss)

pred Mterm_ 
  Mterm_ Ct_(n)
  Mterm_ Vt_(i)
  Mterm_ Mt_(t1,t2) <- Mterm_(t1) & Mterm_(t2)

pred Is_at 
  Is_at At_(t1,t2)

fun Check_anf_ 
  Check_anf_(t) = t <- Mterm_(t)
  Check_anf_(t) = At_(Check_anf_(t1),Check_anf_(t2)) <- 
    ~Mterm_(t) & Is_at(t) & t = At_(t1,t2)
  Check_anf_(t) = t <- ~Mterm_(t) & ~Is_at(t) & Is_error_(t)
  Check_anf_(t) = Error_('not Anf',t) <- ~Mterm_(t) & ~Is_at(t) & ~Is_error_(t)

fun Check_anf 
  Check_anf(t) = t <- ~Term_(t)
  Check_anf(t) = Check_anf_(t) <- Term_(t)

pred Results_mul 
  Results_mul(0)
  Results_mul(Test_case3((t1,t2),at,denr),rss) <- 
    Term_(t1) & Term_(t2) & Term_(at) & Result(denr) & Results_mul(rss)

pred Results_anf 
  Results_anf(0)
  Results_anf(Test_case3(t,at,denr),rss) <- 
    Term_(t) & Term_(at) & Result(denr) & Results_anf(rss)

rem 
  \para \bf  Testovanie funkcií na formulách  \end 

fun Vf_ 'Vf_d'
  Vf_(i) = 0,i

fun/0 Ff_ 'Ff_d'
  Ff_ = 1,0

fun/0 Tf_ 'Tf_d'
  Tf_ = 2,0

fun Nf_ 'Nf_d'
  Nf_(f1) = 3,f1

fun/2 Of_ 'Of_d'
  Of_(f1,f2) = 4,f1,f2

fun/2 Af_ 'Af_d'
  Af_(f1,f2) = 5,f1,f2

fun/2 If_ 'If_d'
  If_(f1,f2) = 6,f1,f2

pred Form_ 
  Form_ Vf_(i) <- N(i)
  Form_(Ff_)
  Form_(Tf_)
  Form_ Nf_(f1) <- Form_(f1)
  Form_ Of_(f1,f2) <- Form_(f1) & Form_(f2)
  Form_ Af_(f1,f2) <- Form_(f1) & Form_(f2)
  Form_ If_(f1,f2) <- Form_(f1) & Form_(f2)
  Form_ Error_(msg,f) <- Str(msg) & Form_(f)

fun/0 Fvss3 
  Fvss3 = 
  (0,0,0,0),(1,0,0,0),(0,1,0,0),(1,1,0,0),(0,0,1,0),(1,0,1,0),(0,1,1,0),
  (1,1,1,0),0

pred Results_true 
  Results_true(0)
  Results_true(Test_case2(f,truer),rs) <- 
    Form_(f) & Result(truer) & Results_true(rs)

pred Results_form 
  Results_form(0)
  Results_form(Result_ok(x,y,t),rs) <- 
    Form_(x) & Form_(y) & Type(t) & Results_form(rs)
  Results_form(Result_failed(x,y,t),rs) <- 
    Form_(x) & Form_(y) & Type(t) & Results_form(rs)

pred Cform_shallow 
  Cform_shallow Vf_(i)
  Cform_shallow Nf_(f1)
  Cform_shallow Af_(f1,f2)

fun Check_cform_ 
  Check_cform_(f) = f <- Cform_shallow(f) & f = Vf_(i)
  Check_cform_(f) = Nf_ Check_cform_(f1) <- Cform_shallow(f) & f = Nf_(f1)
  Check_cform_(f) = Af_(Check_cform_(f1),Check_cform_(f2)) <- 
    Cform_shallow(f) & f = Af_(f1,f2)
  Check_cform_(f) = Error_('not Cform',f) <- ~Cform_shallow(f)

fun Check_cform 
  Check_cform(f) = f <- ~Form_(f)
  Check_cform(f) = Check_cform_(f) <- Form_(f)

pred Results_form_transf 
  Results_form_transf(0)
  Results_form_transf(Test_case3(f,cf,truer),rs) <- 
    Form_(f) & Form_(cf) & Result(truer) & Results_form_transf(rs)

pred Nnf_shallow 
  Nnf_shallow Vf_(i)
  Nnf_shallow Nf_ Vf_(i)
  Nnf_shallow Af_(f1,f2)
  Nnf_shallow Of_(f1,f2)

fun Check_nnf_ 
  Check_nnf_(f) = f <- Nnf_shallow(f) & f = Vf_(i)
  Check_nnf_(f) = f <- Nnf_shallow(f) & f = Nf_ Vf_(i)
  Check_nnf_(f) = Af_(Check_nnf_(f1),Check_nnf_(f2)) <- 
    Nnf_shallow(f) & f = Af_(f1,f2)
  Check_nnf_(f) = Of_(Check_nnf_(f1),Check_nnf_(f2)) <- 
    Nnf_shallow(f) & f = Of_(f1,f2)
  Check_nnf_(f) = Error_('not Nnf',f) <- ~Nnf_shallow(f)

fun Check_nnf 
  Check_nnf(f) = f <- ~Form_(f)
  Check_nnf(f) = Check_nnf_(f) <- Form_(f)

pred Results_subst 
  Results_subst(0)
  Results_subst(Test_case4((s,k,t),s1,denr,szr),rss) <- 
    Term_(s) & N(k) & Term_(t) & Term_(s1) & Result(denr) & Result(szr) & 
    Results_subst(rss)

