mod Ex07a


loc rem 
  \para \bf  7. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2013/2014  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex07.zip 

loc rem 
  \para* \it  Dátum:  \end 1. a 2. 4. 2014 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované kombinatorickým
  úlohám na zoznamoch – rozpoznávaniu rôznych druhov podzoznamov
  a generovaniu zoznamov všetkých týchto podzoznamov. Budeme študovať súvislé
  úseky ( \it  ex07a  \end) a podpostupnosti a permutácie ( \it  ex07b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2013/2014. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2014.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 


incl Maux07

incl Mtesting07

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  14. KOMBINATORICKÉ FUNKCIE NA ZOZNAMOCH  \end 

rem 
  \para \bf  [CL] Reťazce  \end 

rem 
  \para \bf  \it  Znaky a reťazce.  \end  \end \it  Reťazec  \end je v CL 
  zoznamom \it  znakov  \end (viď definície predikátov – formátov 
  \ft Ch \end a \ft Str \end v module \ft Standard \end). Znaky sú uzavreté 
  v úvodzovkách (napr. "a"), reťazce v apostrofoch (napr. 'abc efg 123'). 
  Čísla zobrazíme ako znaky pomocou formátu \ft Ch \end. Zoznamy zobrazíme 
  ako reťazce pomocou formátu \ft Str \end. 

rem 
  \para \bf  Úloha.  \end Vyhodnoťte query: 
  \verbatim 
      90 = c:Ch & 72,101,108,108,111,33,0 = xs:Str &
      ("l","a",0) = ys:Str & 'tra'++ys++ys = zs:Str
  \end

rem 
  \para \bf  \it  Zoznamy reťazcov.  \end  \end Doteraz sme väčšinou 
  pracovali s jednoduchými zoznamami čísel, občas s dvojicami zoznamov 
  alebo zoznamami dvojíc. Hodnotami väčšiny funkcií v tomto cvičení 
  budú \it  zoznamy zoznamov  \end. Prehľadnejšie je pozerať sa na ne ako na 
  \it  zoznamy reťazcov  \end. 
  \para Predikát – formát \ft Lstr \end (z modulu \ft Maux07 \end) platí 
  pre zoznamy reťazcov a umožňuje takto zobrazovať hodnoty premenných 
  v query: 
  \def 
    pred Lstr 
    Lstr(0)
    Lstr(xs,xss) <- Str(xs) & Lstr(xss)
  \end

rem 
  \para \bf  Úloha.  \end Vyhodnoťte dopyt: 
  \verbatim 
      (97,98,99,0),0,(100,101,0),0 = xss:Lstr
  \end

rem 
  \para \bf  14.1. Súvislé úseky  \end 

rem 
  \para \bf  14.1.1. Sufixy  \end 

rem 
  \para \bf  \it  Sufix.  \end  \end \header* pred/2 Suffix  \end Predikát 
  \ft Tex2_equiv(Suffix(xs,zs),Tex2_suffix(xs,zs)) \end platí práve vtedy, 
  keď zoznam \ft zs \end je \it  sufixom  \end (súvislým koncovým úsekom) 
  zoznamu \ft xs \end: 

pred/2 Suffix 'Tex2_suffix'
  Suffix(xs,zs) <-> \e ys xs = ys++zs

rem 
  \para Napríklad: 
  \eq* 
    Suffix((5,7,11,0),5,7,11,0)
  \end
  \eq* 
    Suffix((2,3,5,7,11,0),5,7,11,0)
  \end
  \eq* 
    ~Suffix(0,5,7,11,0)
  \end
  \eq* 
    ~Suffix((2,3,5,7,11,13,0),5,7,11,0)
  \end
  \para V nasledujúcej úlohe využijeme, že 
  \items 
   \item \para jediným sufixom prázdneho zoznamu je iba prázdny zoznam: 
         \eq (Suffix_zero)
           Suffix(0,zs) <-> zs = 0
         \end
   \item \para sufixami neprázdneho zoznamu \ft Paren(x,xs) \end sú 
         \para a) zoznam \ft Paren(x,xs) \end sám, 
         \para b) všetky sufixy zoznamu \ft xs \end, 
         \para* teda: 
         \eq (Suffix_pair)
           Suffix(Paren(x,xs),zs) <-> zs = Paren(x,xs) \/ Suffix(xs,zs)
         \end
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Suffixes(xs) \end, ktorej 
  hodnotou je \it  zoznam všetkých sufixov  \end zoznamu (reťazca) 
  \ft xs \end. Funkciu zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  (Suffix_zero) a (Suffix_pair). 
  \para* Špecifikácia: 
  \eq* 
    zs in Suffixes(xs) <-> Suffix(xs,zs)
  \end
  \eq* 
    Str(xs) -> Lstr Suffixes(xs)
  \end
  \para* Napríklad: 
  \def* 
    Suffixes(1,2,3,0) = (1,2,3,0),(2,3,0),(3,0),0,0
    Suffixes('aky') = 'aky','ky','y','',0
    Suffixes('taky') = 'taky','aky','ky','y','',0
  \end
  \para* \it  Testovanie.  \end Výsledok v druhom a treťom príklade 
  zobrazujte formátom \ft Lstr \end (viď vyššie). 
  \para* Môžete tiež použiť predpripravený test: 
  \verbatim 
      Suffixes_test = r:Results_lstr
  \end
  \para Na poradí reťazcov vo výslednom zozname nezáleží a test je 
  naprogramovaný tak, aby ho nebral do úvahy. 

fun Suffixes 
  Suffixes(xs) = Foo

fun/0 Suffixes_test 
  Suffixes_test = 
  Check_lext(Suffixes(''),'',0),Check_lext(Suffixes('y'),'y','',0),
  Check_lext(Suffixes('aky'),'aky','ky','y','',0),
  Check_lext(Suffixes('taky'),'taky','aky','ky','y','',0),0

rem 
  \para \bf  14.1.2. Prefixy  \end 

rem 
  \para \bf  \it  Prefix.  \end  \end \header* pred/2 Prefix  \end Predikát 
  \ft Tex2_equiv(Prefix(ys,xs),Tex2_prefix(ys,xs)) \end platí práve vtedy, 
  keď \ft ys \end je \it  prefixom  \end (súvislým začiatočným úsekom) 
  zoznamu \ft xs \end: 

pred/2 Prefix 'Tex2_prefix'
  Prefix(ys,xs) <-> \e zs xs = ys++zs

rem 
  \para Napríklad: 
  \eq* 
    Prefix(0,2,3,5,7,11,0)
  \end
  \eq* 
    Prefix((2,3,5,0),2,3,5,7,11,0)
  \end
  \eq* 
    ~Prefix((2,3,5,0),0)
  \end
  \eq* 
    ~Prefix((1,2,3,0),2,3,5,7,11,0)
  \end
  \para V nasledujúcej úlohe využijeme, že 
  \items 
   \item \para jediným prefixom prázdneho zoznamu je prázdny zoznam: 
         \eq (Prefix_zero)
           Prefix(ys,0) <-> ys = 0
         \end
   \item \para prefixami neprázdneho zoznamu \ft x,xs \end sú 
         \para a) prázdny zoznam, 
         \para b) všetky zoznamy \ft x,vs \end, kde \ft vs \end je prefixom 
         zoznamu \ft xs \end, 
         \para* teda: 
         \eq (Prefix_pair)
           Prefix(ys,Paren(x,xs)) <-> 
           ys = 0 \/ \e vs(ys = Paren(x,vs) & Prefix(vs,xs))
         \end
  \end

rem 
  \para \bf  Úloha. Pridanie znaku na začiatok viacerých reťazcov.  \end 
  \header* fun/2 Map_pair  \end Zadefinujte funkciu \ft Map_pair(a,xss) \end, 
  ktorá pridá prvok \ft a \end na začiatok každého zoznamu v zozname 
  zoznamov \ft xss \end (znak \ft a \end na začiatok každého reťazca 
  v zozname reťazcov \ft xss \end). 
  \para* Špecifikácia: 
  \eq* 
    ys in Map_pair(a,xss) <-> \e xs(ys = Paren(a,xs) & xs in xss)
  \end
  \eq* 
    Ch(a) & Lstr(xss) -> Lstr Map_pair(a,xss)
  \end
  \para* Napríklad: 
  \def* 
    Map_pair(99,Paren((50,30,20,0),(1,2,0),0,(7,0),0)) = 
    (99,50,30,20,0),(99,1,2,0),(99,0),(99,7,0),0
    Map_pair("#",Paren('abcde','','123','@',0)) = '#abcde','#','#123','#@',0
  \end
  \para \it  Všimnite si.  \end Vstupný a výstupný zoznam zoznamov majú 
  rovnaký počet prvkov. Špeciálne: ak je vstupný zoznam zoznamov prázdny, 
  je prázdy aj výstupný zoznam. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Map_pair_test_str = r:Results_lstr
      Map_pair_test_n = r:Results
  \end

fun/2 Map_pair 
  Map_pair(a,xss) = Foo

fun/0 Map_pair_test_str 
  Map_pair_test_str = 
  Check_lext(Map_pair("#",0),0),Check_lext(Map_pair("#",'',0),'#',0),
  Check_lext(Map_pair("#",'abc',0),'#abc',0),
  Check_lext(Map_pair("#",Paren('abcde','','123','@',0)),'#abcde','#','#123','#@',0),0

fun/0 Map_pair_test_n 
  Map_pair_test_n = 
  Check_lext(Map_pair(88,0),0),Check_lext(Map_pair(88,0,0),(88,0),0),
  Check_lext(Map_pair(88,Paren((1,2,3,0),0)),(88,1,2,3,0),0),
  Check_lext(Map_pair(88,Paren((1,2,3,4,5,0),0,(22,0,33,0),(0,0),0)),
             (88,1,2,3,4,5,0),(88,0),(88,22,0,33,0),(88,0,0),0),
  Check_lext(Map_pair(0,Paren((1,2,3,4,5,0),0,(22,0,33,0),(0,0),0)),
             (0,1,2,3,4,5,0),(0,0),(0,22,0,33,0),(0,0,0),0),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Prefixes(xs) \end, ktorej 
  hodnotou je \it  zoznam všetkých prefixov  \end zoznamu (reťazca) 
  \ft xs \end. Funkciu zadefinujte zoznamovou rekurziou. Využite vlastnosti 
  prefixov (Prefix_zero) a (Prefix_pair) a funkciu \ft Map_pair \end. 
  \para* Špecifikácia: 
  \eq* 
    ys in Prefixes(xs) <-> Prefix(ys,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Prefixes(xs)
  \end
  \para* Napríklad: 
  \def* 
    Prefixes(2,3,5,0) = 0,(2,0),(2,3,0),(2,3,5,0),0
    Prefixes('aky') = '','a','ak','aky',0
    Prefixes('taky') = '','t','ta','tak','taky',0
  \end
  \para* \it  Testovanie.  \end 
  \verbatim 
      Prefixes_test = r:Results_lstr
  \end

fun Prefixes 
  Prefixes(xs) = Foo

fun/0 Prefixes_test 
  Prefixes_test = 
  Check_lext(Prefixes(''),'',0),Check_lext(Prefixes('ky'),'','k','ky',0),
  Check_lext(Prefixes('aky'),'','a','ak','aky',0),
  Check_lext(Prefixes('taky'),'','t','ta','tak','taky',0),0

rem 
  \para \bf  14.1.3. Segmenty  \end 

rem 
  \para \bf  \it  Segment.  \end  \end \header* pred/2 Segment  \end Predikát 
  \ft Tex2_equiv(Segment(us,xs),Tex2_segment(us,xs)) \end platí práve vtedy, 
  keď \ft us \end je \it  segmentom  \end (podreťazcom, všeobecným 
  súvislým úsekom) zoznamu \ft xs \end: 

pred/2 Segment 'Tex2_segment'
  Segment(us,xs) <-> \e ys\e zs xs = ys++us++zs

rem 
  \para* Napríklad 
  \eq* 
    Segment((5,7,0),5,7,11,13,0)
  \end
  \eq* 
    Segment((5,7,0),2,3,5,7,11,13,0)
  \end
  \eq* 
    ~Segment((5,7,0),0)
  \end
  \eq* 
    ~Segment((5,7,0),3,5,6,7,11,0)
  \end

rem 
  \para \bf  Úloha.  \end Sformulujte (na papier alebo do nasledujúcej 
  poznámky) vlastnosti predikátu \ft Tex2_segment(us,xs) \end pre prázdny 
  a neprázdny zoznam \ft xs \end podobne, ako sme to urobili pre predikáty 
  \ft Tex2_suffix(xs,zs) \end ( \ft Sufix \end) a \ft Tex2_prefix(ys,xs) \end ( 
  \ft Prefix \end). Využite pritom jeden z týchto predikátov. 
  \eq (Segment_zero)
    Segment(us,0) <-> Quux
  \end
  \eq (Segment_pair)
    Segment(us,Paren(x,xs)) <-> Quux
  \end

rem 
  (Segment_zero)
      Segment(us,0) <-> ?
  (Segment_pair)
      Segment(us,(x,xs)) <-> ?

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Segments(xs) \end, ktorej 
  hodnotou je \it  zoznam všetkých súvislých úsekov  \end zoznamu 
  (reťazca) \ft xs \end. Funkciu \ft Segments \end zadefinujte zoznamovou 
  rekurziou podľa vlastností predikátu \ft Segment \end, ktoré ste 
  sformulovali v predchádzajúcej úlohe. Využite niektorú z funkcií 
  \ft Suffixes \end, \ft Prefixes \end. 
  \para* Špecifikácia: 
  \eq* 
    us in Segments(xs) <-> Segment(us,xs)
  \end
  \eq* 
    Str(xs) -> Lstr Segments(xs)
  \end
  \para* Napríklad: 
  \def* 
    Segments('ky') = 'k','ky','y','',0
    Segments('aky') = 'a','ak','aky','k','ky','y','',0
    Segments('taky') = 't','ta','tak','taky','a','ak','aky','k','ky','y','',0
  \end
  \para Snažte sa zadefinovať funkciu \ft Segments \end tak, aby sa zoznamy 
  v jej výslednej hodnote neopakovali. Predpripravený test túto vlastnosť 
  nekontroluje. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Segments_test = r:Results_lstr
  \end

fun Segments 
  Segments(xs) = Foo

fun/0 Segments_test 
  Segments_test = 
  Check_lext(Segments(''),'',0),Check_lext(Segments('ky'),'k','ky','y','',0),
  Check_lext(Segments('aky'),'a','ak','aky','k','ky','y','',0),
  Check_lext(Segments('taky'),'t','ta','tak','taky','a','ak','aky','k','ky','y','',0),0

