mod Ex06b

rem 
  \para \bf  6. CVIČENIE (DOMÁCA ÚLOHA) Z PREDMETU ÚVOD DO DEKLARATÍVNEHO 
  PROGRAMOVANIA LS 2013/2014  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex06.zip 

loc rem 
  \para* \it  Dátum:  \end 27. 3. 2014 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované triedeniu 
  zoznamov ( \it  ex06a  \end) a reprezentácii konečných množín 
  usporiadanými zoznamami bez opakovania ( \it  ex06b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2013/2014. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2014.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting06

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,0,Op(Ent('equiv'),0),Arg(1))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/2 Tex2_member
  Infix(Arg(0),15,0,Op(Ent('isin'),0),Arg(1))

appldisp/2 Tex2_member_
  Infix(Arg(0),25,0,Subsup(Op(Ent('isin'),0),75,Op(Ent('ast'),0),None),Arg(1))

appldisp/2 Tex2_insert
  Infix(Arg(0),35,1,Op(Ent('cup'),0),Fenced(Op('{',0),Arg(1),Op('}',0)))

appldisp/2 Tex2_delete
  Infix(Arg(0),35,1,Op(Ent('setmn'),0),Fenced(Op('{',0),Arg(1),Op('}',0)))

appldisp/2 Tex2_union
  Infix(Arg(0),35,1,Op(Ent('cup'),0),Arg(1))

appldisp/2 Tex2_inter
  Infix(Arg(0),35,1,Op(Ent('cap'),0),Arg(1))

appldisp/2 Tex2_diff
  Infix(Arg(0),35,1,Op(Ent('setmn'),0),Arg(1))

appldisp/2 Tex2_sdiff
  Infix(Arg(0),35,1,Op(Ent('triangle'),0),Arg(1))

appldisp/2 Tex2_subset
  Infix(Arg(0),15,0,Op(Ent('sube'),0),Arg(1))

appldisp/2 Tex2_subset_
  Infix(Arg(0),25,0,Subsup(Op(Ent('sube'),0),75,Op(Ent('ast'),0),None),Arg(1))

appldisp/2 Tex2_ltlex
  Infix(Arg(0),30,0,Subsup(Op(Ent('lt'),0),75,Id(0,'lex',0),None),Arg(1))

appldisp/2 Tex2_cartesian
  Infix(Arg(0),50,0,Op(Ent('times'),0),Arg(1))

appldisp/2 Tex2_image
  Prefix(89,0,Arg(0),Fenced(Op('[',0),Arg(1),Op(']',0)))

appldisp/2 Tex2_composition
  Infix(Arg(0),45,0,Op(Ent('compfn'),0),Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  13. ZOZNAMOVÁ REPREZENTÁCIA KONEČNÝCH MNOŽÍN  \end 

rem 
  \para \bf  \it  Reprezentácia množín usporiadanými zoznamami bez 
  opakovania.  \end  \end Konečné množiny môžeme jednoducho reprezentovať 
  zoznamami. Pri množinách je dôležitá iba príslušnosť prvku do 
  množiny. Počet výskytov prvku ani poradie prvkov nie sú podstatné. 
  Množiny môžeme preto reprezentovať usporiadanými zoznamami bez opakovania 
  prvkov. Operácie na dvoch množinách potom dokážeme naprogramovať tak, 
  aby počet krokov potrebných na ich vykonanie lineárne závisel od súčtu 
  počtu prvkov v množinách. 

rem 
  \para \bf  \it  [CL] Trichotomická diskriminácia.  \end  \end 
  V nasledujúcich úlohách využijeme \it  trichotomickú  \end 
  diskrimináciu: 
  \def* 
    Tex2_cdots(s,t) <- s < t
    Tex2_cdots(s,t) <- s = t
    Tex2_cdots(s,t) <- s > t
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Set(xs) \end, ktorý 
  platí, ak \ft xs \end je zoznam, ktorý reprezentuje množinu, teda 
  usporiadaný a bez opakovania. 
  \para* Definícia je podobná predikátu \ft Ord \end z ex08a. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) <-> \a ys\a a\a b\a zs(xs = ys++(a,b,zs) -> a < b)
  \end
  \para* Testovanie: 
  \verbatim 
      Set_test = r:Results
  \end

pred Set 
  Set(xs) <- Quux

fun Set_ 
  Set_(xs) = 1 <- Set(xs)
  Set_(xs) = 0 <- ~Set(xs)

fun/0 Set_test 
  Set_test = 
  Check(Set_(0),1),Check(Set_(0,0),1),Check(Set_(0,1,0),1),Check(Set_(1,1,0),0),
  Check(Set_(0,0,1,0),0),Check(Set_(0,1,1,0),0),Check(Set_(0,1,2,0),1),
  Check(Set_(4,5,4,0),0),Check(Set_(0,2,3,4,0),1),Check(Set_(4,3,2,0,0),0),
  Check(Set_(0,2,1,3,0),0),0

rem 
  \para \bf  Úloha.  \end \header* pred/2 Member  \end Zadefinujte predikát 
  \ft Tex2_equiv(Member(a,xs),Tex2_member(a,xs)) \end, ktorý platí, ak je 
  \ft a \end prvkom množiny \ft xs \end. 
  \para* \header* pred/2 Member 'Tex2_member' \end Napríklad 
  \ft Member(4,2,4,6,8,0) \end a \ft ~Member(5,2,4,6,8,0) \end. 
  \para* Využite (ale netestujte!), že \ft xs \end je množina. Ani v jednom 
  z uvedených príkladov výpočet nesmie prejsť celý zoznam 
  \ft 2,4,6,8,0 \end. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) -> Member(a,xs) <-> a in xs
  \end
  \para* Testovanie: 
  \verbatim 
      Member_test = r:Results
  \end

pred/2 Member 'Tex2_member'
  Member(a,xs) <- Quux

fun/2 Member_ 'Tex2_member_'
  Member_(a,xs) = 1 <- Member(a,xs)
  Member_(a,xs) = 0 <- ~Member(a,xs)

fun/0 Member_test 
  Member_test = 
  Check(Member_(0,0),0),Check(Member_(1,0),0),Check(Member_(0,0,0),1),
  Check(Member_(1,0,0),0),Check(Member_(0,0,2,0),1),Check(Member_(1,0,2,0),0),
  Check(Member_(2,0,2,0),1),Check(Member_(3,0,2,0),0),
  Check(Member_(4,2,4,6,8,0),1),Check(Member_(5,2,4,6,8,0),0),0

rem 
  \para \bf  \it  Extenzionalita.  \end  \end Všimnite si, že reprezentácia 
  množín usporiadanými zoznamami bez opakovania je jednoznačná a teda má 
  vlastnosť extenzionality: Množiny sú si rovné práve vtedy, keď majú tie 
  isté prvky. 
  \eq* 
    Set(xs) & Set(ys) -> xs = ys <-> \a a(Member(a,xs) <-> Member(a,ys))
  \end

rem 
  \para \bf  Úloha.  \end \header* fun/2 Insert  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Insert(xs,a),Tex2_insert(xs,a)) \end, ktorá vloží prvok 
  \ft a \end do množiny \ft xs \end, teda vráti množinu, ktorá obsahuje 
  všetky prvky \ft xs \end a prvok \ft a \end. 
  \para* \header* fun/2 Insert 'Tex2_insert' \end Napríklad 
  \ft Insert((2,4,6,8,0),5) = 2,4,5,6,8,0 \end a 
  \ft Insert((2,4,6,8,0),6) = 2,4,6,8,0 \end. 
  \para* Pozor na poradie argumentov a na fakt, že v množinách sa prvky 
  neopakujú a sú usporiadané. Nepoužite žiadne pomocné funkcie ani 
  predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) -> Set Insert(xs,a)
  \end
  \eq* 
    Set(xs) -> \a b(Member(b,Insert(xs,a)) <-> b = a \/ Member(b,xs))
  \end
  \para* Testovanie: 
  \verbatim 
      Insert_test = r:Results
  \end

fun/2 Insert 'Tex2_insert'
  Insert(xs,a) = Foo

fun/0 Insert_test 
  Insert_test = 
  Check(Insert(0,0),0,0),Check(Insert((1,0),0),0,1,0),
  Check(Insert((1,0),2),1,2,0),Check(Insert((2,0),2),2,0),
  Check(Insert((2,4,6,8,0),5),2,4,5,6,8,0),
  Check(Insert((2,4,6,8,0),6),2,4,6,8,0),
  Check(Insert((2,4,6,8,0),10),2,4,6,8,10,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Delete  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Delete(xs,a),Tex2_delete(xs,a)) \end, ktorá odstráni prvok 
  \ft a \end z množiny \ft xs \end, teda vráti množinu obsahujúcu všetky 
  prvky \ft xs \end okrem \ft a \end. 
  \para* \header* fun/2 Delete 'Tex2_delete' \end Napríklad 
  \ft Delete((2,4,6,8,0),6) = 2,4,8,0 \end a 
  \ft Delete((2,4,6,8,0),5) = 2,4,6,8,0 \end. 
  \para* Pozor na poradie argumentov a na fakt, že v množinách sa prvky 
  neopakujú a sú usporiadané. Nepoužite žiadne pomocné funkcie ani 
  predikáty (vrátane \ft Set \end a \ft Member \end). Ani v jednom 
  z uvedených príkladov výpočet nesmie prejsť celý zoznam 
  \ft 2,4,6,8,0 \end. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) -> Set Delete(xs,a)
  \end
  \eq* 
    Set(xs) -> \a b(Member(b,Delete(xs,a)) <-> b != a & Member(b,xs))
  \end
  \para* Testovanie: 
  \verbatim 
      Delete_test = r:Results
  \end

fun/2 Delete 'Tex2_delete'
  Delete(xs,a) = Foo

fun/0 Delete_test 
  Delete_test = 
  Check(Delete(0,0),0),Check(Delete((1,0),0),1,0),Check(Delete((1,0),2),1,0),
  Check(Delete((2,4,6,8,0),2),4,6,8,0),Check(Delete((2,4,6,8,0),6),2,4,8,0),
  Check(Delete((2,4,6,8,0),5),2,4,6,8,0),
  Check(Delete((2,4,6,8,0),10),2,4,6,8,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Union  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Union(xs,ys),Tex2_union(xs,ys)) \end, ktorá zjednotí množiny 
  \ft xs \end a \ft ys \end. 
  \para* \header* fun/2 Union 'Tex2_union' \end Napríklad 
  \ft Union((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 1,2,3,4,5,6,7,8,9,10,0 \end. 
  \para* Využite (ale netestujte!), že \ft xs \end a \ft ys \end sú množiny. 
  Algoritmus pre zjednotenie je podobný zlúčeniu utriedených zoznamov, vo 
  výsledku sa však žiadny prvok nesmie opakovať. Nepoužite žiadne pomocné 
  funkcie ani predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Union(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(Member(a,Union(xs,ys)) <-> Member(a,xs) \/ Member(a,ys))
  \end
  \para* Testovanie: 
  \verbatim 
      Union_test = r:Results
  \end

fun/2 Union 'Tex2_union'
  Union(xs,ys) = Foo

fun/0 Union_test 
  Union_test = 
  Check(Union(0,3,6,0),3,6,0),Check(Union((0,9,0),0),0,9,0),
  Check(Union((4,6,0),4,5,0),4,5,6,0),Check(Union((4,5,0),4,6,0),4,5,6,0),
  Check(Union((0,9,0),3,6,0),0,3,6,9,0),Check(Union((3,6,0),0,9,0),0,3,6,9,0),
  Check(Union((2,4,8,9,10,0),1,2,3,5,6,7,9,0),1,2,3,4,5,6,7,8,9,10,0),
  Check(Union((1,2,3,5,6,7,9,0),2,4,8,9,10,0),1,2,3,4,5,6,7,8,9,10,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Inter  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Inter(xs,ys),Tex2_inter(xs,ys)) \end, ktorá vypočíta prienik 
  množín \ft xs \end a \ft ys \end. 
  \para* \header* fun/2 Inter 'Tex2_inter' \end Napríklad 
  \ft Inter((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 2,9,0 \end. 
  \para* Využite (ale netestujte!), že \ft xs \end a \ft ys \end sú množiny. 
  Použite podobný algoritmus ako pre zjednotenie. Nepoužite žiadne pomocné 
  funkcie ani predikáty (vrátane \ft Set \end a \ft Member \end). 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Inter(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(Member(a,Inter(xs,ys)) <-> Member(a,xs) & Member(a,ys))
  \end
  \para* Testovanie: 
  \verbatim 
      Inter_test = r:Results
  \end

fun/2 Inter 'Tex2_inter'
  Inter(xs,ys) = Foo

fun/0 Inter_test 
  Inter_test = 
  Check(Inter(0,3,6,0),0),Check(Inter((0,9,0),0),0),
  Check(Inter((4,6,0),4,5,0),4,0),Check(Inter((4,5,0),4,6,0),4,0),
  Check(Inter((0,1,9,0),0,3,6,9,0),0,9,0),
  Check(Inter((0,3,6,9,0),0,1,9,0),0,9,0),
  Check(Inter((2,4,8,9,10,0),1,2,3,5,6,7,9,0),2,9,0),
  Check(Inter((1,2,3,5,6,7,9,0),2,4,8,9,10,0),2,9,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Diff  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Diff(xs,ys),Tex2_diff(xs,ys)) \end, ktorá vypočíta rozdiel 
  množín \ft xs \end a \ft ys \end. 
  \para* \header* fun/2 Diff 'Tex2_diff' \end Napríklad 
  \ft Diff((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 4,8,10,0 \end. 
  \para* Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Diff(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(Member(a,Diff(xs,ys)) <-> Member(a,xs) & ~Member(a,ys))
  \end
  \para* Testovanie: 
  \verbatim 
      Diff_test = r:Results
  \end

fun/2 Diff 'Tex2_diff'
  Diff(xs,ys) = Foo

fun/0 Diff_test 
  Diff_test = 
  Check(Diff(0,3,6,0),0),Check(Diff((0,9,0),0),0,9,0),
  Check(Diff((4,6,0),4,5,0),6,0),Check(Diff((4,5,0),4,6,0),5,0),
  Check(Diff((0,1,9,0),0,3,6,9,0),1,0),Check(Diff((0,3,6,9,0),0,1,9,0),3,6,0),
  Check(Diff((2,4,8,9,10,0),1,2,3,5,6,7,9,0),4,8,10,0),
  Check(Diff((1,2,3,5,6,7,9,0),2,4,8,9,10,0),1,3,5,6,7,0),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Sdiff  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Sdiff(xs,ys),Tex2_sdiff(xs,ys)) \end, ktorá vypočíta 
  symetrický rozdiel množín \ft xs \end a \ft ys \end. 
  \para* \header* fun/2 Sdiff 'Tex2_sdiff' \end Napríklad 
  \ft Sdiff((2,4,8,9,10,0),1,2,3,5,6,7,9,0) = 1,3,4,5,6,7,8,10,0 \end. 
  \para* Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Set Sdiff(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> 
    \a a(Member(a,Sdiff(xs,ys)) <-> 
         Member(a,xs) & ~Member(a,ys) \/ ~Member(a,xs) & Member(a,ys))
  \end
  \para* Testovanie: 
  \verbatim 
      Sdiff_test = r:Results
  \end

fun/2 Sdiff 'Tex2_sdiff'
  Sdiff(xs,ys) = Foo

fun/0 Sdiff_test 
  Sdiff_test = 
  Check(Sdiff(0,3,6,0),3,6,0),Check(Sdiff((0,9,0),0),0,9,0),
  Check(Sdiff((4,6,0),4,5,0),5,6,0),Check(Sdiff((4,5,0),4,6,0),5,6,0),
  Check(Sdiff((0,1,9,0),0,3,6,9,0),1,3,6,0),
  Check(Sdiff((0,3,6,9,0),0,1,9,0),1,3,6,0),
  Check(Sdiff((2,4,8,9,10,0),1,2,3,5,6,7,9,0),1,3,4,5,6,7,8,10,0),
  Check(Sdiff((1,2,3,5,6,7,9,0),2,4,8,9,10,0),1,3,4,5,6,7,8,10,0),0

rem 
  \para \bf  Úloha.  \end \header* pred/2 Subset  \end Zadefinujte predikát 
  \ft Tex2_equiv(Subset(xs,ys),Tex2_subset(xs,ys)) \end, ktorý platí, ak 
  \ft xs \end je podmnožinou \ft ys \end. 
  \para* \header* pred/2 Subset 'Tex2_subset' \end Napríklad 
  \ft Subset((2,4,8,9,10,0),1,2,3,4,5,6,7,8,9,10,0) \end a 
  \ft ~Subset((2,4,8,9,10,0),2,4,6,8,10,0) \end. 
  \para* Platia rovnaké obmedzenia a odporúčania ako v predošlých 
  úlohách. 
  \para* Špecifikácia: 
  \eq* 
    Set(xs) & Set(ys) -> Subset(xs,ys) <-> \a a(Member(a,xs) -> Member(a,ys))
  \end
  \para* Testovanie: 
  \verbatim 
      Subset_test = r:Results
  \end

pred/2 Subset 'Tex2_subset'
  Subset(xs,ys) <- Quux

fun/2 Subset_ 'Tex2_subset_'
  Subset_(a,xs) = 1 <- Subset(a,xs)
  Subset_(a,xs) = 0 <- ~Subset(a,xs)

fun/0 Subset_test 
  Subset_test = 
  Check(Subset_(0,0),1),Check(Subset_(0,1,3,5,0),1),Check(Subset_((0,0),0),0),
  Check(Subset_((5,0),0),0),Check(Subset_((5,0),3,5,7,0),1),
  Check(Subset_((6,0),3,5,7,0),0),
  Check(Subset_((2,4,8,9,10,0),1,2,3,4,5,6,7,8,9,10,0),1),
  Check(Subset_((1,2,3,4,5,6,7,8,9,10,0),2,4,8,9,10,0),0),
  Check(Subset_((2,4,8,9,10,0),2,4,6,8,10,0),0),
  Check(Subset_((2,4,6,8,10,0),2,4,8,9,10,0),0),
  Check(Subset_((2,4,6,8,10,0),2,4,6,8,10,0),1),0

rem 
  \para \bf  Prémiová domáca úloha \it  du06  \end.  \end (1+1+1+(1+1)+1 = 
  6 bodov) 
  \para Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end 
  \para Jednotlivé časti úlohy budeme hodnotiť samostatne. 
  \para Časti a) a b) sa nachádzajú v súbore \it  ex06a  \end. 

rem 
  \para* \bf  \it  Definícia.  \end  \end Dvojica \ft Paren(x1,y1) \end je \it  
  lexikograficky menšia  \end ako dvojica \ft Paren(x2,y2) \end práve vtedy, 
  keď \ft x1 < x2 \end alebo \ft x1 = x2 \end a \ft y1 < y2 \end. 
  \para \header* pred/2 Ltlex  \end Formálne túto vlastnosť vyjadríme 
  predikátom \ft Tex2_equiv(Ltlex(p,q),Tex2_ltlex(p,q)) \end s nasledujúcou 
  klauzálnou definíciou. 

pred/2 Ltlex 'Tex2_ltlex'
  Ltlex((x1,y1),x2,y2) <- x1 < x2
  Ltlex((x1,y1),x2,y2) <- x1 = x2 & y1 < y2

rem 
  \para* \bf  \it  Definícia.  \end  \end \it  Konečná relácia  \end je 
  zoznam dvojíc, ktoré sú usporiadané lexikograficky. 
  \para Napríklad zoznam 
  \eq* 
    R1 = (0,3),(1,2),(2,5),(2,7),(2,12),(4,4),(4,13),(5,7),(5,11),0
  \end
  \para je konečnou reláciou, ale zoznamy 
  \eq* 
    xs = (0,3),(1,2),(2,7),0,(4,12),(5,11),0
  \end
  \eq* 
    ys = (0,3),(2,7),(1,2),(3,5),0
  \end
  \eq* 
    zs = (0,3),(1,9),(1,7),(2,13),0
  \end
  \para z rôznych dôvodov ( \it  akých?  \end) nie sú konečnými 
  reláciami. 
  \para Konečné relácie sú špeciálnym typom asociatívnych zoznamov 
  z prémiovej domácej úlohy du05 c). 
  \para Predikát \ft Rel(r) \end platí práve vtedy, keď \ft r \end je 
  konečná relácia. 

pred Rel 
  Rel(0)
  Rel((x1,y1),0)
  Rel((x1,y1),(x2,y2),r) <- Ltlex((x1,y1),x2,y2) & Rel((x2,y2),r)

fun/0 R1 
  R1 = (0,3),(1,2),(2,5),(2,7),(2,12),(4,4),(4,13),(5,7),(5,11),0

rem 
  \para \bf  \it  Definícia.  \end  \end \it  Karteziánskym súčinom  \end 
  konečných množín \ft xs \end a \ft ys \end nazveme konečnú reláciu 
  \ft Tex2_cartesian(xs,ys) \end, ktorá obsahuje dvojicu \ft Paren(x,y) \end 
  práve vtedy, keď \ft x \end je prvkom \ft xs \end a  \ft y \end je prvkom 
  \ft ys \end. 
  \eq* 
    Set(xs) & Set(ys) -> Rel Tex2_cartesian(xs,ys)
  \end
  \eq* 
    Set(xs) & Set(ys) -> Paren(x,y) in Tex2_cartesian(xs,ys) <-> 
    Member(x,xs) & Member(y,ys)
  \end
  \para* \bf  c)  \end (1 bod) \header* fun/2 Cartesian  \end Naprogramujte 
  funkciu \ft Tex2_equiv(Cartesian(xs,ys),Tex2_cartesian(xs,ys)) \end, ktorej 
  hodnotou je karteziánsky súčin konečných množín \ft xs \end a 
  \ft ys \end. 
  \para Využite, ale netestujte, že \ft xs \end a \ft ys \end sú konečné 
  množiny. Budete potrebovať pomocnú funkciu a zreťazenie. 

fun/2 Cartesian 'Tex2_cartesian'
  Cartesian(xs,ys) = Foo

rem 
  \para* \bf  \it  Definícia.  \end  \end \it  Obrazom  \end konečnej množiny 
  \ft xs \end v konečnej relácii \ft r \end je konečná množina 
  \ft Tex2_image(r,xs) \end, ktorá pre každý prvok \ft Member(x,xs) \end 
  obsahuje práve tie prvky \ft y \end, pre ktoré dvojica \ft Paren(x,y) \end 
  patrí do \ft r \end. 
  \eq* 
    Rel(r) & Set(xs) -> Set Tex2_image(r,xs)
  \end
  \eq* 
    Rel(r) & Set(xs) -> Member(y,Tex2_image(r,xs)) <-> 
    Member(x,xs) & Paren(x,y) in r
  \end
  \para Napríklad obrazom konečnej množiny \ft 2,3,5,0 \end vo vyššie 
  uvedenej konečnej relácii \ft R1 \end je množina \ft 5,7,11,12,0 \end. 
  Obrazom množín \ft xs = 3,0 \end, \ft ys = 9,15,222,0 \end, \ft zs = 0 \end 
  v relácii \ft R1 \end je \ft 0 \end. 
  \para* \bf  d)  \end (1+1 bod) \header* fun/2 Image  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Image(r,xs),Tex2_image(r,xs)) \end, ktorej hodnotou je obraz 
  konečnej množiny \ft xs \end v relácii \ft r \end. Využite, ale 
  netestujte, že \ft r \end je konečná relácia a \ft xs \end je konečná 
  množina. (1 bod) 
  \para Budete potrebovať pomocnú funkciu (obraz prvku) a niektorú z 
  množinových operácií. 
  \para Za maximálne využitie vlastností množín a relácií na skrátenie 
  výpočtu dostanete ďalší 1 bod. Vyžaduje si tupling v pomocnej funkcii 
  alebo triedenie. 

fun/2 Image 'Tex2_image'
  Image(r,xs) = Foo

rem 
  \para* \bf  \it  Definícia.  \end  \end \it  Zložením  \end konečných 
  relácií \ft r \end a \ft s \end je konečná relácia 
  \ft Tex2_composition(r,s) \end, ktorá obsahuje dvojicu \ft Paren(x,z) \end 
  práve vtedy, keď pre nejaký prvok \ft y \end relácia \ft r \end obsahuje 
  dvojicu \ft Paren(x,y) \end a relácia \ft s \end obsahuje 
  \ft Paren(y,z) \end. 
  \eq* 
    Rel(r) & Rel(s) -> Rel Tex2_composition(r,s)
  \end
  \eq* 
    Paren(x,z) in Tex2_composition(r,s) <-> 
    \e y(Paren(x,y) in r & Paren(y,z) in s)
  \end
  \para Napríklad 
  \eq* 
    R1 = (0,3),(1,2),(2,5),(2,7),(2,12),(4,4),(4,13),(5,7),(5,11),0
  \end
  \eq* 
    R2 = (0,1),(1,0),(2,3),(3,2),(3,8),(4,5),(5,4),(6,7),(7,6),0
  \end
  \eq* 
    Tex2_composition(R1,R2) = (0,2),(0,8),(1,3),(2,4),(2,6),(4,5),(5,6),0
  \end
  \para* \bf  e)  \end (1 bod) \header* fun/2 Composition  \end Zadefinujte 
  funkciu \ft Tex2_equiv(Composition(r,s),Tex2_composition(r,s)) \end, ktorej 
  hodnotou je zloženie konečných relácií \ft r \end a \ft s \end. 
  \para Využite, ale netestujte, že \ft r \end a \ft s \end sú konečné 
  relácie. Využite obraz, karteziánsky súčin a zreťazenie. 

fun/2 Composition 'Tex2_composition'
  Composition(r,s) = Foo

fun/0 R2 
  R2 = (0,1),(1,0),(2,3),(3,2),(3,8),(4,5),(5,4),(6,7),(7,6),0

