mod Ex06a

rem 
  \para \bf  6. CVIČENIE (DOMÁCA ÚLOHA) Z PREDMETU ÚVOD DO DEKLARATÍVNEHO 
  PROGRAMOVANIA LS 2013/2014  \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex06.zip 

loc rem 
  \para* \it  Dátum:  \end 27. 3. 2014 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované triedeniu 
  zoznamov ( \it  ex06a  \end) a reprezentácii konečných množín 
  usporiadanými zoznamami bez opakovania ( \it  ex06b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2013/2014. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2014.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting06

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

pred/0 Quux 'Tex0_foo'
  Quux <-> \f

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,0,Op(Ent('equiv'),0),Arg(1))

appldisp/2 Tex2_count
  Prefix(90,2,Subsup(Op('#',0),99,Arg(0),None),Arg(1))

appldisp/2 Tex2_perm
  Infix(Arg(0),15,0,Op(Ent('sim'),0),Arg(1))

appldisp/2 Tex2_sub
  Prefix(70,2,Arg(0),Fenced(Op('[',0),Arg(1),Op(']',0)))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  11. PREDIKÁTY  \end 

rem 
  \para \bf  \it  Prvok zoznamu.  \end  \end Zabudovaný predikát 
  \ft a in xs \end platí práve vtedy, keď \ft a \end je prvkom zoznamu 
  \ft xs \end, teda 
  \eq* 
    a in xs <-> \e ys\e zs xs = ys++(a,zs)
  \end
  \para Tento predikát je zadefinovaný zoznamovou rekurziou nasledovne: 
  \def* 
    In(a,x,xs) <- a = x
    In(a,x,xs) <- a != x & In(a,xs)
  \end
  \para Predikát \ft a in xs \end zapisujeme „ \ft a \end in \ft xs \end “, 
  jeho negáciu \ft a !in xs \end zapisujeme „ \ft a \end  !in \ft xs \end 
  “. 
  \para Budeme ho používať \bf  iba  \end na špecifikáciu a definovanie 
  špecifikačných predikátov. \bf  Nepoužívajte  \end tento predikát vo 
  funkciách, znížite tým ich efektivitu. 

rem 
  \para \bf  12. TRIEDENIE ZOZNAMOV  \end 

rem 
  \para \bf  12.1. Špecifikácia triedenia  \end 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Count  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Count(a,xs),Tex2_count(a,xs)) \end, ktorá zistí počet 
  výskytov prvku \ft a \end v zozname \ft xs \end. 
  \para* Špecifikácia: 
  \eq* 
    Count(a,0) = 0
  \end
  \eq* 
    Count(a,xs++(a,ys)) = 1+Count(a,xs++ys)
  \end
  \eq* 
    a != x -> Count(a,xs++(x,ys)) = Count(a,xs++ys)
  \end
  \para* \header* fun/2 Count 'Tex2_count' \end Napríklad 
  \ft Count(1,6,3,1,2,7,1,0) = 2 \end a \ft Count(9,6,3,1,2,7,1,0) = 0 \end. 
  \para* Testovanie: 
  \verbatim 
      Count_test = r:Results
  \end

fun/2 Count 'Tex2_count'
  Count(a,xs) = Foo

fun/0 Count_test 
  Count_test = 
  Check(Count(1,0),0),Check(Count(1,7,0),0),Check(Count(1,1,0),1),
  Check(Count(1,1,7,0),1),Check(Count(1,7,1,0),1),
  Check(Count(1,6,3,1,2,7,1,0),2),Check(Count(9,6,3,1,2,7,1,0),0),0

rem 
  \para \bf  \it  Permutácia zoznamu.  \end  \end Predikát 
  \ft Tex2_perm(xs,ys) \end platí práve vtedy, keď zoznam \ft xs \end je 
  permutáciou zoznamu \ft ys \end. Táto vlastnosť sa dá vyjadriť 
  porovnaním počtu výskytov prvkov v oboch zoznamoch nasledujúcou 
  definíciou, podľa ktorej ale nie je možné platnosť predikátu počítať. 
  \para \it  Poznámka.  \end Vypočítateľná definícia je predmetom častí 
  a) a b) prémiovej domácej úlohy na konci tohto súboru. 

pred/2 Perm0 'Tex2_perm'
  Perm0(xs,ys) <-> \a a Count(a,xs) = Count(a,ys)

rem 
  \para \bf  Úloha.  \end Zadefinujte predikát \ft Ord(xs) \end, ktorý platí 
  práve vtedy, keď je \ft xs \end vzostupne usporiadaný zoznam, v ktorom sa 
  prvky môžu opakovať. 
  \para* Formálne: 
  \eq* 
    Ord(xs) <-> \a ys\a a\a b\a zs(xs = ys++(a,b,zs) -> a <= b)
  \end
  \para* Napríklad 
  \eq* 
    Ord(0,2,2,3,4,4,0)
  \end
  \eq* 
    ~Ord(4,4,3,2,2,0,0)
  \end
  \eq* 
    ~Ord(0,2,1,3,0)
  \end
  \para* Testovanie: 
  \verbatim 
      Ord_test = r:Results
  \end
  \para Predikát sa testuje prostredníctvom jeho charakteristickej funkcie 
  \ft Ord_ \end. Jej definíciu nemeňte. 

pred Ord 
  Ord(xs) <- Quux

fun Ord_ 
  Ord_(xs) = 1 <- Ord(xs)
  Ord_(xs) = 0 <- ~Ord(xs)

fun/0 Ord_test 
  Ord_test = 
  Check(Ord_(0),1),Check(Ord_(0,0),1),Check(Ord_(1,1,0),1),
  Check(Ord_(0,0,1,0),1),Check(Ord_(5,5,4,0),0),Check(Ord_(0,2,2,3,4,4,0),1),
  Check(Ord_(4,4,3,2,2,0,0),0),Check(Ord_(0,2,1,3,0),0),0

rem 
  \para \bf  \it  Definícia.  \end  \end Hovoríme, že funkcia 
  \ft Sort(xs) \end je \it  triedením zoznamov  \end, ak platí 
  \eq* 
    Ord Sort(xs)
  \end
  \eq* 
    Perm0(xs,Sort(xs))
  \end

rem 
  \para \bf  12.2. Triedenie vsúvaním – insertion sort  \end 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Ins  \end Zadefinujte funkciu 
  \ft Ins(a,xs) \end, ktorá vsunie prvok \ft a \end do \it  utriedeného  \end 
  zoznamu \ft xs \end tak, aby výsledný zoznam bol utriedený. 
  \para* Predpokladajte a využite, že zoznam \ft xs \end je utriedený, ale 
  jeho utriedenie netestujte ani nijak inak nezabezpečujte. Správaním funkcie 
  \ft Ins \end na neutriedenom zozname sa nezaoberajte. 
  \para* Špecifikácia: 
  \eq* 
    Ord(xs) -> Ord Ins(a,xs)
  \end
  \eq* 
    Ord(xs) -> Perm0(Paren(a,xs),Ins(a,xs))
  \end
  \para* Napríklad \ft Ins(4,Paren(1,2,3,6,12,0)) = 1,2,3,4,6,12,0 \end, 
  \ft Ins(3,Paren(1,2,3,6,12,0)) = 1,2,3,3,6,12,0 \end a 
  \ft Ins(24,Paren(1,2,3,6,12,0)) = 1,2,3,6,12,24,0 \end 
  \para* Testovanie: 
  \verbatim 
      Ins_test = r:Results
  \end

fun/2 Ins 
  Ins(a,xs) = Foo

fun/0 Ins_test 
  Ins_test = 
  Check(Ins(0,0),0,0),Check(Ins(0,Paren(1,0)),Paren(0,1,0)),
  Check(Ins(2,Paren(1,0)),Paren(1,2,0)),Check(Ins(2,Paren(2,0)),Paren(2,2,0)),
  Check(Ins(4,Paren(1,2,3,6,12,0)),1,2,3,4,6,12,0),
  Check(Ins(3,Paren(1,2,3,6,12,0)),1,2,3,3,6,12,0),
  Check(Ins(24,Paren(1,2,3,6,12,0)),1,2,3,6,12,24,0),0

rem 
  \para \bf  Úloha.  \end Použitím funkcie \ft Ins \end zadefinujte funkciu 
  \ft Isort(xs) \end, ktorá utriedi ľubovoľný zoznam \ft xs \end vsúvaním. 
  \para* Funkcia spĺňa vyššie uvedenú špecifikáciu triedenia: 
  \eq* 
    Ord Isort(xs)
  \end
  \eq* 
    Perm0(xs,Isort(xs))
  \end
  \para* Testovanie: 
  \verbatim 
      Isort_test = r:Results
  \end

fun Isort 
  Isort(xs) = Foo

fun/0 Isort_test 
  Isort_test = 
  Check(Isort(0),0),Check(Isort(3,0),3,0),Check(Isort(0,0,0),0,0,0),
  Check(Isort(2,1,3,0),1,2,3,0),
  Check(Isort(3,12,3,6,9,1,3,1,0),1,1,3,3,3,6,9,12,0),
  Check(Isort(1,1,3,3,3,6,9,12,0),1,1,3,3,3,6,9,12,0),0

rem 
  \para \bf  12.3. Triedenie zlučovaním – merge sort  \end 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Msplit(xs) \end, ktorá 
  rozdelí zoznam \ft xs \end na dva zoznamy \ft ys \end a \ft zs \end tak, aby 
  sa prvky z párnych miest v zozname \ft xs \end nachádzali v \ft ys \end a 
  aby sa prvky z nepárnych miest v zozname \ft xs \end nachádzali v 
  \ft zs \end (poradie počítame od 0). 
  \para* Funkcia vždy vráti dvojicu zoznamov. Nepoužite žiadne pomocné 
  funkcie ani predikáty. 
  \para* Špecifikácia: 
  \eq* 
    \e ys\e zs Msplit(xs) = Paren(ys,zs)
  \end
  \eq* 
    Msplit(xs) = Paren(ys,zs) -> Perm0(xs,ys++zs)
  \end
  \eq* 
    Msplit(xs) = Paren(ys,zs) -> L(ys) = L(zs) \/ L(ys) = L(zs)+1
  \end
  \eq* 
    Msplit(xs) = Paren(ys,zs) -> 
    \a i(Tex2_sub(xs,2*i) = Tex2_sub(ys,i) & Tex2_sub(xs,2*i+1) = Tex2_sub(zs,i))
  \end
  \para* Napríklad \ft Msplit(7,3,0,1,5,5,0) = (7,0,5,0),Paren(3,1,5,0) \end a 
  \ft Msplit(7,3,0,1,5,5,9,0) = (7,0,5,9,0),Paren(3,1,5,0) \end. 
  \para* Testovanie: 
  \verbatim 
      Msplit_test = r:Results
  \end

fun Msplit 
  Msplit(xs) = Foo,Foo

fun/0 Msplit_test 
  Msplit_test = 
  Check(Msplit(0),0,0),Check(Msplit(3,0),(3,0),0),
  Check(Msplit(7,9,0),(7,0),Paren(9,0)),
  Check(Msplit(4,6,1,0),(4,1,0),Paren(6,0)),
  Check(Msplit(7,3,0,1,5,5,0),(7,0,5,0),Paren(3,1,5,0)),
  Check(Msplit(7,3,0,1,5,5,9,0),(7,0,5,9,0),Paren(3,1,5,0)),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Merge  \end Zadefinujte funkciu 
  \ft Merge(xs,ys) \end, ktorá zlúči dva utriedené zoznamy do utriedeného 
  zoznamu. 
  \para* Funkcia prechádza oboma zoznamami súčasne a nevyužíva žiadne 
  pomocné funkcie ani predikáty. Splnenie požiadavky na utriedenie 
  \ft xs \end a \ft ys \end predpokladajte, ale netestujte ani nezabezpečujte. 
  \para* Špecifikácia: 
  \eq* 
    Ord(xs) & Ord(ys) -> Ord Merge(xs,ys)
  \end
  \eq* 
    Ord(xs) & Ord(ys) -> Perm0(xs++ys,Merge(xs,ys))
  \end
  \para* Napríklad 
  \ft Merge((1,5,6,7,8,10,0),Paren(2,3,4,8,9,0)) = 1,2,3,4,5,6,7,8,8,9,10,0 \end. 
  \para* Testovanie: 
  \verbatim 
      Merge_test = r:Results
  \end

fun/2 Merge 
  Merge(xs,ys) = Foo

fun/0 Merge_test 
  Merge_test = 
  Check(Merge(0,Paren(3,6,6,0)),Paren(3,6,6,0)),
  Check(Merge((8,8,0),0),Paren(8,8,0)),
  Check(Merge((4,6,0),Paren(4,5,0)),Paren(4,4,5,6,0)),
  Check(Merge((4,5,0),Paren(4,6,0)),Paren(4,4,5,6,0)),
  Check(Merge((0,1,1,0),Paren(1,0)),Paren(0,1,1,1,0)),
  Check(Merge((1,5,6,7,8,10,0),Paren(2,3,4,8,9,0)),
        Paren(1,2,3,4,5,6,7,8,8,9,10,0)),
  Check(Merge((2,3,4,8,9,0),Paren(1,5,6,7,8,10,0)),
        Paren(1,2,3,4,5,6,7,8,8,9,10,0)),0

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Msort(xs) \end, ktorá 
  utriedi ľubovoľný zoznam \ft xs \end zlučovaním. 
  \para* Použite funkcie \ft Msplit \end a \ft Merge \end. Pozor na zacyklenie. 
  \para* Funkcia spĺňa vyššie uvedenú špecifikáciu triedenia: 
  \eq* 
    Ord Msort(xs)
  \end
  \eq* 
    Perm0(xs,Msort(xs))
  \end
  \para* Testovanie: 
  \verbatim 
      Msort_test = r:Results
  \end

fun Msort 
  Msort(xs) = Foo

fun/0 Msort_test 
  Msort_test = 
  Check(Msort(0),0),Check(Msort(3,0),3,0),Check(Msort(0,0,0),0,0,0),
  Check(Msort(2,1,3,0),1,2,3,0),
  Check(Msort(3,12,3,6,9,1,3,1,0),1,1,3,3,3,6,9,12,0),
  Check(Msort(1,1,3,3,3,6,9,12,0),1,1,3,3,3,6,9,12,0),0

rem 
  \para \bf  Rýchle triedenie – quick sort  \end 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Qsplit  \end Zadefinujte funkciu 
  \ft Qsplit(p,xs) \end, ktorá rozdelí zoznam \ft xs \end na zoznamy 
  \ft ys \end a \ft zs \end tak, aby \ft ys \end obsahoval prvky \ft xs \end 
  menšie alebo rovnaké ako \ft p \end a \ft zs \end obsahoval prvky väčšie 
  ako \ft p \end. 
  \para* Funkcia vždy vráti dvojicu zoznamov. Prvok \ft p \end nepridávajte 
  do žiadneho z výstupných zoznamov (ak sa nevyskytuje v \ft xs \end). 
  Nepoužite žiadne pomocné funkcie. 
  \para* Špecifikácia: 
  \eq* 
    \e ys\e zs Qsplit(p,xs) = Paren(ys,zs)
  \end
  \eq* 
    Qsplit(p,xs) = Paren(ys,zs) -> Perm0(xs,ys++zs)
  \end
  \eq* 
    Qsplit(p,xs) = Paren(ys,zs) -> 
    \a a(a in ys -> a <= p) & \a a(a in zs -> a > p)
  \end
  \para* Napríklad 
  \ft Qsplit(5,Paren(3,7,9,2,0,8,8,4,0)) = (3,2,0,4,0),Paren(7,9,8,8,0) \end. 
  \para* Testovanie: 
  \verbatim 
      Qsplit_test = r:Results
  \end

fun/2 Qsplit 
  Qsplit(p,xs) = Foo,Foo

fun/0 Qsplit_test 
  Qsplit_test = 
  Check(Qsplit(8,0),0,0),Check(Qsplit(0,Paren(0,0,0)),(0,0,0),0),
  Check(Qsplit(6,Paren(7,8,9,17,7,0)),0,Paren(7,8,9,17,7,0)),
  Check(Qsplit(5,Paren(3,7,9,2,0,8,8,4,0)),(3,2,0,4,0),Paren(7,9,8,8,0)),
  Check(Qsplit(5,Paren(8,1,2,12,0,0,5,0)),(1,2,0,0,5,0),Paren(8,12,0)),0

rem 
  \para \bf  Úloha.  \end Naprogramujte funkciu \ft Qsort(xs) \end, ktorá 
  utriedi ľubovoľný zoznam \ft xs \end algoritmom quick sort. 
  \para* Ako pivot použite prvý prvok zoznamu. Použite funkciu 
  \ft Qsplit \end na rozdelenie zoznamu podľa pivota. Rekurzívne utrieďte 
  časti zoznamu a spojte ich navzájom a s pivotom pomocou zreťazenia a 
  párovania. 
  \para* Funkcia spĺňa vyššie uvedenú špecifikáciu triedenia: 
  \eq* 
    Ord Qsort(xs)
  \end
  \eq* 
    Perm0(xs,Qsort(xs))
  \end
  \para* Testovanie: 
  \verbatim 
      Qsort_test = r:Results
  \end

fun Qsort 
  Qsort(xs) = Foo

fun/0 Qsort_test 
  Qsort_test = 
  Check(Qsort(0),0),Check(Qsort(3,0),3,0),Check(Qsort(0,0,0),0,0,0),
  Check(Qsort(2,1,3,0),1,2,3,0),
  Check(Qsort(3,12,3,6,9,1,3,1,0),1,1,3,3,3,6,9,12,0),
  Check(Qsort(1,1,3,3,3,6,9,12,0),1,1,3,3,3,6,9,12,0),0

rem 
  \para \bf  Prémiová domáca úloha \it  du06  \end.  \end (1 + 1 + 1 + (1+1) 
  + 1 = 6 bodov) 
  \para Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp/#pdu  \end 
  \para Jednotlivé časti úlohy budeme hodnotiť samostatne. 
  \para Časti c), d), e) sa nachádzajú v súbore \it  ex06b.cl  \end. 
  \para V tejto časti sa vrátime k špecifikácii triedenia. 

rem 
  \para \bf  a)  \end (1 bod) \header* pred/3 Eq_counts  \end Zadefinujte 
  predikát \ft Eq_counts(zs,xs,ys) \end, ktorý platí práve vtedy, keď pre 
  každý prvok \ft z \end zoznamu \ft zs \end je počet výskytov \ft z \end 
  v zoznamoch \ft xs \end a \ft ys \end rovnaký. 
  \para* Formálne: 
  \eq* 
    Eq_counts(zs,xs,ys) <-> \a z(z in zs -> Count(z,xs) = Count(z,ys))
  \end
  \para* Napríklad 
  \eq* 
    Eq_counts((4,2,9,0),(3,4,0,2,2,4,0),Paren(0,2,2,4,4,5,0))
  \end
  \eq* 
    ~Eq_counts((0,3,5,0),(3,4,0,2,2,4,0),Paren(0,2,2,4,4,5,0))
  \end
  \para Návod nájdete v [1, §12.1]. 
  \para Testovanie: 
  \verbatim 
      Eq_counts_test = r:Results
  \end

pred/3 Eq_counts 
  Eq_counts(zs,xs,ys) <- Quux

fun/3 Eq_counts_ 
  Eq_counts_(zs,xs,ys) = 1 <- Eq_counts(zs,xs,ys)
  Eq_counts_(zs,xs,ys) = 0 <- ~Eq_counts(zs,xs,ys)

fun/0 Eq_counts_test 
  Eq_counts_test = 
  Check(Eq_counts_(0,(3,4,0,2,2,4,0),Paren(0,2,2,4,4,5,0)),1),
  Check(Eq_counts_((4,0),(3,4,0,2,2,4,0),Paren(0,2,2,4,4,5,0)),1),
  Check(Eq_counts_((5,0),(3,4,0,2,2,4,0),Paren(0,2,2,4,4,5,0)),0),
  Check(Eq_counts_((4,2,9,0),(3,4,0,2,2,4,0),Paren(0,2,2,4,4,5,0)),1),
  Check(Eq_counts_((0,3,5,0),(3,4,0,2,2,4,0),Paren(0,2,2,4,4,5,0)),0),0

rem 
  \para \bf  b)  \end (1 bod) \header* pred/2 Perm  \end Zadefinujte predikát 
  \ft Tex2_equiv(Perm(xs,ys),Tex2_perm(xs,ys)) \end, ktorý platí práve vtedy, 
  keď je zoznam \ft xs \end permutáciou zoznamu \ft ys \end, teda keď pre 
  každé číslo \ft a \end je počet výskytov \ft a \end v zoznamoch 
  \ft xs \end a \ft ys \end rovnaký. 
  \para* \header* pred/2 Perm 'Tex2_perm' \end Formálne: 
  \eq* 
    Perm(xs,ys) <-> \a a Count(a,xs) = Count(a,ys)
  \end
  \para* Použite predikát \ft Eq_counts(zs,xs,ys) \end s vhodne zvoleným 
  zoznamom \ft zs \end, viď tiež [1, §12.1]. 
  \para* Napríklad 
  \eq* 
    Perm((3,4,0,2,2,4,0),0,2,2,3,4,4,0)
  \end
  \eq* 
    ~Perm((3,4,0,2,2,4,0),4,4,2,2,0,0)
  \end
  \eq* 
    ~Perm((3,4,0,2,2,4,0),5,4,4,3,2,2,0,0)
  \end
  \para Testovanie: 
  \verbatim 
      Perm_test = r:Results
  \end

pred/2 Perm 'Tex2_perm'
  Perm(xs,ys) <- Quux

fun/2 Perm_ 
  Perm_(xs,ys) = 1 <- Perm(xs,ys)
  Perm_(xs,ys) = 0 <- ~Perm(xs,ys)

fun/0 Perm_test 
  Perm_test = 
  Check(Perm_(0,0),1),Check(Perm_(0,0,0),0),Check(Perm_((0,0),0),0),
  Check(Perm_((1,0,8,0),0,8,1,0),1),Check(Perm_((0,8,1,0),1,0,8,0),1),
  Check(Perm_((8,1,0,0),1,8,0),0),Check(Perm_((1,8,0),8,1,0,0),0),
  Check(Perm_((3,4,0,2,2,4,0),0,2,2,3,4,4,0),1),
  Check(Perm_((0,2,2,3,4,4,0),3,4,0,2,2,4,0),1),
  Check(Perm_((3,4,0,2,2,4,0),4,4,2,2,0,0),0),
  Check(Perm_((3,4,0,2,2,4,0),5,4,4,3,2,2,0,0),0),0

