mod Ex04b

rem 
  \para \bf  4. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2013/2014  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex04.zip 

loc rem 
  \para* \it  Dátum:  \end 11. a 12. 3. 2014 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované aritmetickým 
  operáciám na binárnom zápise čísel ( \it  ex04a  \end) a tuplingu ( 
  \it  ex04b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2013/2014. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2014.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting04

appldisp/0 Tex0_foo
  Std('?',0)

appldisp/0 Tex0_tau
  Id(0,Ent('tau'),0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/0 Tex0_ldots
  Op(Ent('hellip'),0)

appldisp/1 Tex1_paren_cdots_paren_around
  Fenced(Op('(',Ent('ctdot'),'(',0),Arg(0),Op(')',Ent('ctdot'),')',0))

appldisp/1 Tex1_fib
  Subsup(Id(0,'fib',0),75,Arg(0),None)

appldisp/2 Tex2_idx
  Subsup(Arg(0),75,Arg(1),None)

appldisp/2 Tex2_lt
  Infix(Arg(0),25,3,Op(Ent('lt'),0),Arg(1))

appldisp/2 Tex2_le
  Infix(Arg(0),25,3,Op(Ent('lE'),0),Arg(1))

appldisp/2 Tex2_exp
  Subsup(Arg(0),75,None,Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  9. PÁROVANIE  \end 

rem 
  \para \bf  9.2. Párovacie funkcie  \end 

rem 
  \para \bf  9.2.1. Párovacia funkcia CL  \end 

rem 
  \para \bf  \it  [CL] Zabudovaná párovacia funkcia.  \end  \end Párovacia 
  funkcia zabudovaná do CL je založená na enumerácii (očíslovaní) 
  binárnych stromov. Zapisuje sa binárnym infixovým operátorom „ \bf  , 
   \end “ (čiarka), napríklad 
  \eq* 
    1,3
  \end
  \para Operátor „ , “ má veľmi nízku prioritu a implicitne sa 
  zátvorkuje doprava: 
  \eq* 
    Tex2_equiv((1+2,3+4),Tex1_paren(Tex1_paren(1+2),Tex1_paren(3+4)))
  \end
  \eq* 
    Tex2_equiv((1,2,3,4),Tex1_paren(1,Tex1_paren(2,Tex1_paren(3,4))))
  \end

rem 
  \para \bf  \it  Vlastnosti párovacej funkcie CL.  \end  \end Podobne ako pre 
  iné párovacie funkcie, aj funkcia \ft Paren(x,y) \end má párovacie 
  vlastnosti: 
  \items 
   \item \para ak sa dva páry rovnajú, rovnajú sa po zložkách: 
         \eq (1)
           Paren(x,y) = Paren(u,v) -> x = u & y = v
         \end
   \item \para zložky páru sú menšie ako pár: 
         \eq (2)
           x < Paren(x,y) & y < Paren(x,y)
         \end
   \item \para každé nenulové číslo je pár: 
         \eq (3)
           x = 0 \/ \e y\e z x = Paren(y,z)
         \end
  \end
  \para Z vlastnosti (2) vyplýva: 
  \eq (4)
    0 != Paren(x,y)
  \end

rem 
  \para \bf  [CL] Úloha.  \end CL nepočíta číselnú hodnotu párovacej 
  funkcie, pokiaľ nie je priamo potrebná. Vyskúšajte napríklad dopyt 
  (query): 
  \verbatim 
      1+1,2+2 = x
  \end
  \para Ak chcete poznať hodnotu párovacej funkcie pre nejaké čísla, 
  môžete využiť napríklad formát \ft N \end, ktorý každé číslo (aj 
  výsledok párovania) zobrazí v desiatkovom zápise: 
  \verbatim 
      1+1,2+2 = x:N
  \end
  \para alebo použiť párovanie ako argument aritmetickej operácie: 
  \verbatim 
      (1+1,2+2)+0 = x
  \end
  \para Pri bežnom programovaní nie je vyčíslenie párovacej funkcie 
  potrebné. 

rem 
  \para \bf  9.2.2. Programovanie s párovacou funkciou  \end 

rem 
  \para \bf  \it  [CL] Párová diskriminácia.  \end  \end Na definovanie 
  funkcií, ktoré spracúvajú vstup vytvorený párovaním budeme používať 
  párovú diskrimináciu: 
  \def* 
    Tex1_cdots(t) <- Tex0_tau = 0
    Tex1_cdots(t) <- Tex0_tau = x,y
  \end
  \para kde \ft Tex0_tau \end je ľubovoľný term a \ft x \end a \ft y \end sú 
  nové premenné. 
  \para Párovú diskrimináciu umožňujú vlastnosti (3) a (4) 
  z predchádzajúceho odseku. 

rem 
  \para \bf  [CL] Úloha.  \end Porovnávania so vzorom z párovej 
  diskriminácie môžete použiť aj v dopytoch (queries). Vyskúšajte 
  napríklad: 
  \verbatim 
      0 = x & x = 0
      0 = x & x = u,v
      8,3 = x & x = 0
      8,3 = x & x = u,v
      42 = x & x = 0
      42 = x & x = u,v
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Sum_pair(x) \end, ktorá 
  sčíta zložky páru \ft x \end. Ak \ft x \end nie je pár, hodnotou 
  \ft Sum_pair(x) \end je \ft 0 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Sum_pair_test = r:Results
  \end

fun Sum_pair 
  Sum_pair(x) = Foo

fun/0 Sum_pair_test 
  Sum_pair_test = 
  Check(Sum_pair(0),0),Check(Sum_pair(1),0),Check(Sum_pair(2),1),
  Check(Sum_pair(3),1),Check(Sum_pair(0,0),0),Check(Sum_pair(0,1),1),
  Check(Sum_pair(0,1),1),Check(Sum_pair(10,5),15),Check(Sum_pair(42),4),0

rem 
  \para \bf  Úloha.  \end \header* fun/2 Sprod3  \end Zadefinujte funkciu 
  \ft Sprod3(x,y) \end, ktorá vypočíta skalárny súčin 3-rozmerných 
  vektorov \ft x \end a \ft y \end. 3-rozmerný vektor pomocou párovania 
  zakódujeme ako trojicu (dva doprava vnorené páry): 
  \ft x1,x2,x3 = Paren(x1,Paren(x2,x3)) \end. Prípady, keď číslo \ft x \end 
  alebo \ft y \end nie je trojica, nepíšte, ale prenechajte ich na tzv. \it  
  default  \end – CL automaticky doplní výsledok \ft 0 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Sprod3_test = r:Results
  \end

fun/2 Sprod3 
  Sprod3(x,y) = Foo

fun/0 Sprod3_test 
  Sprod3_test = 
  Check(Sprod3(0,0),0),Check(Sprod3((1,0),0),0),Check(Sprod3(0,Paren(1,0)),0),
  Check(Sprod3((1,0),Paren(1,0)),0),Check(Sprod3((1,1,1),Paren(1,0)),0),
  Check(Sprod3((0,0),Paren(1,1,1)),0),Check(Sprod3((1,1,1),Paren(1,1,1)),3),
  Check(Sprod3((2,4,6),Paren(1,3,5)),44),0

rem 
  \para \bf  \it  Fibonacciho postupnosť.  \end  \end 

fun Fib 'Tex1_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n+1)+Fib(n)

rem 
  \para \bf  Úloha.  \end Zadefinujte primitívnou rekurziou funkciu 
  \eq* 
    Twofib(n) = Paren(Fib(n),Fib(n+1))
  \end
  \para \bf  bez použitia  \end funkcie \ft Fib(n) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Twofib_test = r:Results_pn
  \end

fun Twofib 
  Twofib(n) = Foo,Foo

fun/0 Twofib_test 
  Twofib_test = 
  Check(Twofib(0),Paren(0,1)),Check(Twofib(1),1,1),Check(Twofib(2),1,2),
  Check(Twofib(3),Paren(2,3)),Check(Twofib(4),3,5),Check(Twofib(5),5,8),
  Check(Twofib(6),Paren(8,13)),Check(Twofib(7),13,21),Check(Twofib(8),21,34),
  Check(Twofib(42),Paren(267914296,433494437)),0

rem 
  \para \bf  9.2.3. Tupling  \end 

rem 
  \para \bf  \it  Celočíselné delenie a zvyšok všeobecnou rekurziou.  \end 
   \end 

fun/2 Div 
  Div(x,y) = 0 <- y = 0
  Div(x,y) = 0 <- y != 0 & x < y
  Div(x,y) = Div(x-y,y)+1 <- y != 0 & x >= y

fun/2 Mod 
  Mod(x,y) = 0 <- y = 0
  Mod(x,y) = x <- y != 0 & x < y
  Mod(x,y) = Mod(x-y,y) <- y != 0 & x >= y

rem 
  \para \bf  Úloha.  \end \header* fun/2 Divmod  \end Zadefinujte všeobecnou 
  rekurziou funkciu 
  \eq* 
    Divmod(x,y) = Paren(Div(x,y),Mod(x,y))
  \end
  \para \bf  bez použitia  \end funkcií \ft Div \end, \ft Mod \end 
  a operátorov / a mod. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Divmod_test = r:Results_pn
  \end

fun/2 Divmod 
  Divmod(x,y) = Foo,Foo

fun/0 Divmod_test 
  Divmod_test = 
  Check(Divmod(0,0),0,0),Check(Divmod(2,0),0,0),Check(Divmod(35,0),0,0),
  Check(Divmod(0,1),0,0),Check(Divmod(2,1),2,0),Check(Divmod(35,1),35,0),
  Check(Divmod(0,7),0,0),Check(Divmod(2,7),0,2),Check(Divmod(34,7),4,6),
  Check(Divmod(35,7),5,0),Check(Divmod(36,7),5,1),0

rem 
  \para \bf  \it  Najvýznamnejšia číslica a zvyšok čísla.  \end  \end 
  V pozičnej sústave so základom \ft b >= 2 \end sa každé číslo 
  \ft n > 0 \end dá \it  jednoznačne  \end zapísať ako postupnosť číslic 
  \ft Tex2_idx(d,k) \end \ft Tex2_idx(d,k-1) \end … \ft d1 \end 
  \ft Tex2_idx(d,0) \end, kde \ft Tex2_le(0,Tex2_lt(Tex2_idx(d,i),b)) \end pre 
  všetky \ft i \end, \ft Tex2_le(0,Tex2_le(i,k)) \end, \bf  a 
  \ft Tex2_idx(d,k) > 0 \end  \end. Platí teda: 
  \eq* 
    n = 
    Tex2_idx(d,k)*Tex2_exp(b,k)+Tex2_idx(d,k-1)*Tex2_exp(b,k-1)+Tex0_cdots+
    d1*Tex2_exp(b,1)+Tex2_idx(d,0)*Tex2_exp(b,0)
  \end
  \para Číslica \ft Tex2_idx(d,k) \end sa nazýva \it  najvýznamnejšia  \end 
  (angl. \it  most significant digit  \end). 

rem 
  \para \bf  Úloha.  \end \header* fun/2 Msd_lsds  \end Zadefinujte všeobecnou 
  rekurziou funkciu \ft Msd_lsds(n,b) \end, ktorej hodnotou pre \ft b >= 2 \end 
  a \ft n > 0 \end je dvojica \ft Paren(msd,lsds) \end, kde \ft msd \end je 
  najvýznamnejšia číslica a  \ft lsds \end je zvyšok čísla \ft n \end 
  pozostávajúci zo \it  všetkých  \end  menej významných číslic. 
  \eq* 
    b >= 2 & n > 0 -> 
    Msd_lsds(Tex2_idx(d,k)*Tex2_exp(b,k)+Tex2_idx(d,k-1)*Tex2_exp(b,k-1)+
             Tex0_cdots+d1*Tex2_exp(b,1)+Tex2_idx(d,0)*Tex2_exp(b,0),b) = 
    Paren(Tex2_idx(d,k),
          Tex2_idx(d,k-1)*Tex2_exp(b,k-1)+Tex0_cdots+d1*Tex2_exp(b,1)+
          Tex2_idx(d,0)*Tex2_exp(b,0))
  \end
  \para Pre \ft b >= 2 \end a \ft n = 0 \end je \ft Msd_lsds(n,b) = 0,0 \end. 
  Prípad \ft b < 2 \end prenechajte na default. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Msd_lsds_test = r:Results
  \end

fun/2 Msd_lsds 
  Msd_lsds(x,b) = Foo

fun/0 Msd_lsds_test 
  Msd_lsds_test = 
  Check(Msd_lsds(7,0),0),Check(Msd_lsds(7,1),0),Check(Msd_lsds(0,2),0,0),
  Check(Msd_lsds(0,10),0,0),Check(Msd_lsds(5,10),5,0),
  Check(Msd_lsds(10,10),1,0),Check(Msd_lsds(17,10),1,7),
  Check(Msd_lsds(98,10),9,8),Check(Msd_lsds(256,10),2,56),
  Check(Msd_lsds(54321,10),5,4321),Check(Msd_lsds(256,16),1,0),
  Check(Msd_lsds(4*256+10*16+3,16),4,10*16+3),0

rem 
  \para \bf  Prémiová domáca úloha \it  du04  \end.  \end (2+1+1+2 body) 
  Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp#pdu  \end 
  \para Časti a) – c) nájdete v \it  ex04a.cl  \end. Jednotlivé časti 
  môžete odovzdať nezávisle od seba. 
  \para* \bf  d)  \end (2 body) \header* fun/2 Divmodb  \end Naprogramujte 
  funkciu \ft Divmodb(x,y) = Paren(x/y,x mod y) \end, ktorá pomocou \it  
  rekurzie na binárnom zápise čísel  \end a pomocou tuplingu počíta 
  súčasne podiel a zvyšok po delení čísla \ft x \end číslom \ft y \end. 
  \para Môžete použiť \bf  iba  \end binárnu, dichotomickú ( 
  \ft x >= y \end | \ft x < y \end) a párovú diskrimináciu, \it  binárnu 
  rekurziu  \end, zabudované odčítanie ( \ft a-b \end), párovanie ( 
  \ft a,b \end), binárne konštruktory \ft S0 \end, \ft S1 \end a konštantu 
  \ft 0 \end. 
  \para \it  Návod.  \end Použite podobný postup ako ste sa učili na 
  základnej škole. Binárnu rekurziu použite na delenca ( \ft x \end), 
  deliteľ ( \ft y \end) je konštantným parametrom. Podstatné časti 
  výpočtu sa dejú pri vynáraní z rekurzie. 
  \para \it  Testovanie.  \end 
  \verbatim 
      Divmodb_test = r:Results_pn
  \end

fun/2 Divmodb 
  Divmodb(x,y) = Foo,Foo

fun/0 Divmodb_test 
  Divmodb_test = 
  Check(Divmodb(0,0),0,0),Check(Divmodb(2,0),0,0),Check(Divmodb(35,0),0,0),
  Check(Divmodb(0,1),0,0),Check(Divmodb(2,1),2,0),Check(Divmodb(35,1),35,0),
  Check(Divmodb(0,7),0,0),Check(Divmodb(2,7),0,2),Check(Divmodb(34,7),4,6),
  Check(Divmodb(35,7),5,0),Check(Divmodb(36,7),5,1),
  Check(Divmodb(x,7),x/7,x mod 7),Check(Divmodb(x,7000),x/7000,x mod 7000),
  Check(Divmodb(x,7000000),x/7000000,x mod 7000000),0 <- 
    123456*7000000+123456 = x

