mod Ex05b

loc rem 
  \para \bf  5. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2012/2013  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex05.zip 

loc rem 
  \para* \it  Dátum:  \end 11. 3. 2013 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované symbolickým 
  operáciám na dyadickom zápise čísel ( \it  ex05a  \end) a párovaniu ( 
  \it  ex05b  \end). 

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2012/2013. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2013.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Mtesting05

appldisp/0 Tex0_foo
  Std('?',0)

appldisp/0 Tex0_tau
  Id(0,Ent('tau'),0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/2 Tex2_equiv
  Infix(Arg(0),25,3,Op(Ent('equiv'),0),Arg(1))

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

fun Paren 'Tex1_paren'
  Paren(x) = x

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_fib
  Subsup(Id(0,'fib',0),75,Arg(0),None)

appldisp/2 Tex2_conc
  Infix(Arg(0),35,0,Op(Ent('star'),0),Arg(1))

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  10. PÁROVANIE  \end 

rem 
  \para \bf  10.2. Párovacie funkcie  \end 

rem 
  \para \bf  10.2.1. Párovacia funkcia CL  \end 

rem 
  \para \it  [CL] Zabudovaná párovacia funkcia.  \end Párovacia funkcia 
  zabudovaná do CL je založená na enumerácii (očíslovaní) binárnych 
  stromov. Zapisuje sa binárnym infixovým operátorom “ \bf  ,  \end ” 
  (čiarka), napríklad 
  \eq* 
    1,3
  \end
  \para Operátor “,” má veľmi nízku prioritu a implicitne sa zátvorkuje 
  doprava: 
  \eq* 
    Tex2_equiv((1+2,3+4),Tex1_paren(Tex1_paren(1+2),Tex1_paren(3+4)))
  \end
  \eq* 
    Tex2_equiv((1,2,3,4),Tex1_paren(1,Tex1_paren(2,Tex1_paren(3,4))))
  \end

rem 
  \para \it  Vlastnosti párovacej funkcie CL.  \end Podobne ako pre iné 
  párovacie funkcie, aj funkcia \ft Paren(x,y) \end má párovacie vlastnosti: 
  \items 
   \item \para ak sa dva páry rovnajú, rovnajú sa po zložkách: 
         \eq (1)
           Paren(x,y) = Paren(u,v) -> x = u & y = v
         \end
   \item \para zložky páru sú menšie ako pár: 
         \eq (2)
           x < Paren(x,y) & y < Paren(x,y)
         \end
   \item \para každé nenulové číslo je pár: 
         \eq (3)
           x = 0 \/ \e y\e z x = Paren(y,z)
         \end
  \end
  \para Z vlastnosti (2) vyplýva: 
  \eq (4)
    0 != Paren(x,y)
  \end

rem 
  \para \bf  [CL] Úloha.  \end CL nepočíta číselnú hodnotu párovacej 
  funkcie, pokiaľ nie je priamo potrebná. Vyskúšajte napríklad dopyt 
  (query): 
  \verbatim 
      1+1,2+2 = x
  \end
  \para Ak chcete poznať hodnotu párovacej funkcie pre nejaké čísla, 
  môžete využiť napríklad formát \ft N \end, ktorý každé číslo (aj 
  výsledok párovania) zobrazí v desiatkovom zápise: 
  \verbatim 
      1+1,2+2 = x:N
  \end
  \para alebo použiť párovanie ako argument aritmetickej operácie: 
  \verbatim 
      (1+1,2+2)+0 = x
  \end
  \para Pri bežnom programovaní nie je vyčíslenie párovacej funkcie 
  potrebné. 

rem 
  \para \bf  10.2.2. Programovanie s párovacou funkciou  \end 

rem 
  \para \it  [CL] Párová diskriminácia.  \end Na definovanie funkcií, ktoré 
  spracúvajú vstup vytvorený párovaním budeme používať párovú 
  diskrimináciu: 
  \def* 
    Tex1_cdots(t) <- Tex0_tau = 0
    Tex1_cdots(t) <- Tex0_tau = x,y
  \end
  \para kde \ft Tex0_tau \end je ľubovoľný term a \ft x \end a \ft y \end sú 
  nové premenné. 
  \para Párovú diskrimináciu umožňujú vlastnosti (3) a (4) 
  z predchádzajúceho odseku. 

rem 
  \para \bf  [CL] Úloha.  \end Porovnávania so vzorom z dyadickej 
  diskriminácie môžete použiť aj v dopytoch (queries). Vyskúšajte 
  napríklad: 
  \verbatim 
      0 = x & x = 0
      0 = x & x = u,v
      8,3 = x & x = 0
      8,3 = x & x = u,v
      126 = x & x = 0
      126 = x & x = u,v
  \end

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Sum_pair(x) \end, ktorá 
  sčíta zložky páru \ft x \end. Ak \ft x \end nie je pár, hodnotou 
  \ft Sum_pair(x) \end je \ft 0 \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Sum_pair_test = r:Results
  \end

fun Sum_pair 
  Sum_pair(x) = Foo

fun/0 Sum_pair_test 
  Sum_pair_test = 
  Check(Sum_pair(0),0),Check(Sum_pair(1),0),Check(Sum_pair(2),1),
  Check(Sum_pair(3),1),Check(Sum_pair(0,0),0),Check(Sum_pair(0,1),1),
  Check(Sum_pair(0,1),1),Check(Sum_pair(10,5),15),Check(Sum_pair(42),4),0

rem 
  \para \it  Fibonacciho postupnosť.  \end 

fun Fib 'Tex1_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n+1)+Fib(n)

rem 
  \para \bf  Úloha.  \end Zadefinujte primitívnou rekurziou funkciu 
  \eq* 
    Twofib(n) = Paren(Fib(n),Fib(n+1))
  \end
  \para \bf  bez použitia  \end funkcie \ft Fib(n) \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Twofib_test = r:Results_pn
  \end

fun Twofib 
  Twofib(n) = Foo,Foo

fun/0 Twofib_test 
  Twofib_test = 
  Check(Twofib(0),Paren(0,1)),Check(Twofib(1),1,1),Check(Twofib(2),1,2),
  Check(Twofib(3),Paren(2,3)),Check(Twofib(4),3,5),Check(Twofib(5),5,8),
  Check(Twofib(6),Paren(8,13)),Check(Twofib(7),13,21),Check(Twofib(8),21,34),
  Check(Twofib(42),Paren(267914296,433494437)),0

rem 
  \para \bf  10.2.3. Tupling  \end 

rem 
  \para \it  Celočíselné delenie a zvyšok všeobecnou rekurziou.  \end 

fun/2 Div 
  Div(x,y) = 0 <- y = 0
  Div(x,y) = 0 <- y != 0 & x < y
  Div(x,y) = Div(x-y,y)+1 <- y != 0 & x >= y

fun/2 Mod 
  Mod(x,y) = 0 <- y = 0
  Mod(x,y) = x <- y != 0 & x < y
  Mod(x,y) = Mod(x-y,y) <- y != 0 & x >= y

rem 
  \para \bf  Úloha.  \end \header* fun/2 Divmod  \end Zadefinujte všeobecnou 
  rekurziou funkciu 
  \eq* 
    Divmod(x,y) = Paren(Div(x,y),Mod(x,y))
  \end
  \para \bf  bez použitia  \end funkcií \ft Div \end, \ft Mod \end 
  a operátorov / a mod. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Divmod_test = r:Results_pn
  \end

fun/2 Divmod 
  Divmod(x,y) = Foo,Foo

fun/0 Divmod_test 
  Divmod_test = 
  Check(Divmod(0,0),0,0),Check(Divmod(2,0),0,0),Check(Divmod(35,0),0,0),
  Check(Divmod(0,1),0,0),Check(Divmod(2,1),2,0),Check(Divmod(35,1),35,0),
  Check(Divmod(0,7),0,0),Check(Divmod(2,7),0,2),Check(Divmod(34,7),4,6),
  Check(Divmod(35,7),5,0),Check(Divmod(36,7),5,1),0

rem 
  \para \it  Prvý symbol a zvyšok dyadického reťazca.  \end V  \it  ex05a 
   \end ste naprogramovali funkciu \ft First(x) \end, ktorej hodnotou je prvý 
  symbol dyadického reťazca \ft x \end. 
  \eq* 
    d = S1(0) \/ d = S2(0) -> First Tex1_conc(d,x) = d
  \end
  \para Napríklad \ft First S1 S2 S1 S2(0) = 2 \end. 
  \para Podobným spôsobom sa dá naprogramovať funkcia \ft Rest(x) \end, 
  ktorej hodnotou je časť dyadického reťazca \ft x \end okrem prvého 
  symbolu. 
  \eq* 
    d = S1(0) \/ d = S2(0) -> Rest Tex1_conc(d,x) = x
  \end
  \para Napríklad \ft Rest S1 S2 S1 S2(0) = S1 S2 S1(0) \end. 

rem 
  \para \bf  Úloha.  \end Zadefinujte dyadickou rekurziou funkciu 
  \eq* 
    Firstrest(x) = Paren(First(x),Rest(x))
  \end
  \para \bf  bez použitia  \end funkcií \ft First \end a \ft Rest \end. 
  \para* \it  Testovanie.  \end 
  \verbatim 
      Firstrest_test = r:Results_pn2
  \end

fun Firstrest 
  Firstrest(x) = Foo,Foo

fun/0 Firstrest_test 
  Firstrest_test = 
  Check(Firstrest(0),0,0),Check(Firstrest S1(0),S1(0),0),
  Check(Firstrest S2(0),S2(0),0),Check(Firstrest S2 S1(0),S1(0),S2(0)),
  Check(Firstrest S1 S2(0),S2(0),S1(0)),
  Check(Firstrest S1 S1 S2 S2 S1(0),S1(0),S1 S1 S2 S2(0)),
  Check(Firstrest S1 S1 S2 S2 S1 S2(0),S2(0),S1 S1 S2 S2 S1(0)),0

rem 
  \para \bf  Prémiová domáca úloha \it  du05b  \end.  \end (2 body) 
  Pravidlá pre prémiové domáce úlohy nájdete na \it  
  http://dai.fmph.uniba.sk/courses/udp#pdu  \end 
  \para \header* fun/2 Divmod2  \end Naprogramujte funkciu 
  \ft Divmod2(x,y) = Paren(x/y,x mod y) \end, ktorá pomocou \it  rekurzie na 
  dyadickom zápise čísel  \end a pomocou tuplingu počíta súčasne podiel 
  a zvyšok po delení čísla \ft x \end číslom \ft y \end. 
  \para Môžete použiť \bf  iba  \end dyadickú, dichotomickú a párovú 
  diskrimináciu, \it  dyadickú rekurziu  \end, zabudované odčítanie ( 
  \ft a-b \end), násobenie dvomi ( \ft 2*a \end) a párovanie ( \ft a,b \end), 
  dyadické konštruktory \ft S1 \end, \ft S2 \end a konštantu \ft 0 \end. 
  \para \it  Návod.  \end Použite podobný postup ako ste sa učili na 
  základnej škole. 
  \para \it  Testovanie.  \end 
  \verbatim 
      Divmod2_test = r:Results_pn
  \end

fun/2 Divmod2 
  Divmod2(x,y) = Foo,Foo

fun/0 Divmod2_test 
  Divmod2_test = 
  Check(Divmod2(0,0),0,0),Check(Divmod2(2,0),0,0),Check(Divmod2(35,0),0,0),
  Check(Divmod2(0,1),0,0),Check(Divmod2(2,1),2,0),Check(Divmod2(35,1),35,0),
  Check(Divmod2(0,7),0,0),Check(Divmod2(2,7),0,2),Check(Divmod2(34,7),4,6),
  Check(Divmod2(35,7),5,0),Check(Divmod2(36,7),5,1),
  Check(Divmod2(x,7),x/7,x mod 7),0 <- 
    123456*7000000+123456 = x

