mod Ex12b

loc rem 
  \para \bf  12. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
  LS 2011/2012  \end 
  \para* \bf  ČASŤ B  \end 
  \para* http://dai.fmph.uniba.sk/courses/udp/ex/ex12.zip 

loc rem 
  \para* \it  Dátum:  \end 6. 5. 2012 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.20  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované úplným binárnym
  stromom a číslovaniu uzlov binárnych stromov (ex12a) a všeobecným stromom
  (ex12b).

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] J. Kľuka. Prednášky z Úvodu do deklaratívneho programovania 
  LS 2011/2012. 
  \para http://dai.fmph.uniba.sk/courses/udp/udp-prednasky-2012.pdf 
  \para* [2] D. Guller. Poznámky k prednáškam z CL. 
  \para* [3] J. Komara and P. J. Voda. Metamathematics of Computer 
  Programming. 2001. 

loc rem 
  \para \it  Poznámka.  \end Nadpisy sú číslované podľa [1]. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

incl Maux12

incl Mtesting12

incl Maux12b

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  16. VŠEOBECNÉ STROMY  \end 

rem 
  \para \bf  16.1. Kódovanie všeobecných stromov  \end 

rem 
  \para \bf  \it  Konštruktor všeobecných stromov.  \end  \end Všeobecné 
  stromy kódujeme jediným konštruktorom 
  \ft Tex2_equiv(Tex2_gnd_std(x,ts),Tex2_gnd(x,ts)) \end, kde \ft x \end je 
  hodnota uložená uzle a \ft ts \end je zoznam podstromov. 
  \para* Konštruktor je zadefinovaný v module \ft Maux12b \end nasledovne: 
  \def 
    fun/2 Gnd 'Tex2_gnd'
    Gnd(x,ts) = 1,x,ts
  \end

rem 
  \para \bf  \it  [CL] Diskriminácia na konštruktor všeobecných stromov. 
   \end  \end Pretože \ft Gnd \end je párovací konštruktor (viď 
  [1, §15.1]), CL umožňuje nasledujúcu diskrimináciu s jedným prípadom: 
  \def 
    fun F 'Tex1_f'
    F Gnd(x,ts) = Foo
  \end
  \para Často budeme potrebovať skombinovať túto diskrimináciu so 
  zoznamovou: 
  \def 
    fun Fl 'Tex1_fl'
    Fl(0) = Foo
    Fl(Gnd(x1,ts1),ts2) = Foo
  \end

rem 
  \para \bf  \it  Kódy všeobecných stromov.  \end  \end Predikát 
  \ft Lgt(ts) \end platí, ak \ft ts \end je zoznamom všeobecných stromov. 
  Predikát \ft Gt(t) \end platí, ak \ft t \end je všeobecným stromom 
  (presnejšie kódom všeobecného stromu). 

pred Lgt 
  Lgt(0)
  Lgt(Gnd(x1,ts1),ts2) <- N(x1) & Lgt(ts1) & Lgt(ts2)

pred Gt 
  Gt Gnd(x,ts) <- N(x) & Lgt(ts)

rem 
  \para Platí 
  \eq* 
    Gt Gnd(x,ts) <-> \a t(t in ts -> Gt(t))
  \end

rem 
  \para \it  [CL] Formáty výsledkov testov so všeobecnými stromami.  \end 
  Preskočte. 

pred Results_lgt 
  Results_lgt(0)
  Results_lgt(Result_ok(x,y,t),rs) <- 
    Lgt(x) & Lgt(y) & Type(t) & Results_lgt(rs)
  Results_lgt(Result_failed(x,y,t),rs) <- 
    Lgt(x) & Lgt(y) & Type(t) & Results_lgt(rs)

pred Results_gt 
  Results_gt(0)
  Results_gt(Result_ok(x,y,t),rs) <- Gt(x) & Gt(y) & Type(t) & Results_gt(rs)
  Results_gt(Result_failed(x,y,t),rs) <- 
    Gt(x) & Gt(y) & Type(t) & Results_gt(rs)

rem 
  \para \bf  \it  [CL] Formátovanie kódov všeobecných stromov.  \end  \end 
  Predikát \ft Gt \end môžeme použiť ako formát na zobrazenie čísel vo 
  forme všeobecných stromov. 

rem 
  \para \bf  Úloha.  \end Vyskúšajte nasledujúce dopyty (queries): 
  \verbatim 
     223759839492 = t:Gt
  \end
  \verbatim 
     1,1,(1,2,0),(1,3,0),(1,4,0),0 = t:Gt
  \end
  \para Predikát \ft Lgt \end môžeme podobne použiť na zobrazenie čísel 
  vo forme zoznamov všeobecných stromov. 

rem 
  \para \bf  \it  [CL] Formátovanie kódov všeobecných stromov so znakmi 
  v uzloch.  \end  \end Predikát \ft Gtc \end zadefinovaný v module 
  \ft Maux12b \end môžeme použiť ako formát na zobrazenie čísel vo forme 
  všeobecných stromov so znakmi v uzloch (znak je v CL číslo menšie 
  ako 256). 

rem 
  \para \bf  Úloha.  \end Vyskúšajte nasledujúce dopyty (queries): 
  \verbatim 
     1,102,(1,120,0),(1,121,0),0 = t:Gtc
  \end
  \verbatim 
     Gnd(102,Gnd(120,0),Gnd(121,0),0) = t:Gtc
  \end

rem 
  \para \bf  \it  Pomôcka na testovanie – syntaktické stromy aplikačných 
  výrazov.  \end  \end V module \ft Maux12b \end je zadefinovaná funkcia 
  \ft S2gtc(s) \end, ktorej hodnotou pre reťazec \ft s \end obsahujúci dobre 
  uzátvorkovaný aplikačný výraz je syntaktický strom tohto výrazu. 
  Aplikačný výraz je tvorený premennými a aplikáciami funkcií na 
  aplikačné výrazy. Mená premenných a funkcií vo výrazoch sú 
  jednoznakové. Tieto znaky sú uložené v uzloch syntaktického stromu. 
  \para Stromy vytvorené funkciou \ft S2gtc \end budeme v tomto cvičení 
  využívať na testovanie. 

rem 
  \para \bf  Úloha.  \end Vyskúšajte nasledujúce dopyty (queries): 
  \verbatim 
     'f(x,y)' = s:Str  & S2gtc(s) = t:Gtc
  \end
  \verbatim 
     'f(g(x,y),z,h(u))' = s:Str & S2gtc(s) = t:Gtc
  \end
  \verbatim 
     'f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))' = s:Str  & S2gtc(s) = t:Gtc
  \end

rem 
  \para \bf  16.2. Programovanie so všeobecnými stromami  \end 

rem 
  \para \bf  Úloha. Veľkosť všeobecného stromu.  \end Zadefinujte funkciu 
  \ft Tex2_equiv(Sz(t),Tex1_gsz(t)) \end, ktorej hodnotou je veľkosť 
  všeobecného stromu \ft t \end. Naprogramujte a použite všeobecnejšiu 
  funkciu \ft Tex2_equiv(Szl(ts),Tex1_gszl(ts)) \end, ktorej hodnotou je súčet 
  veľkostí všeobecných stromov v zozname \ft ts \end. 
  \para Postup, keď najprv naprogramujeme operáciu na zozname všeobecných 
  stromov a potom ju špecializujeme na všeobecný strom, použijeme aj 
  v ďalších úlohách. 
  \para Testovanie: 
  \verbatim 
      Sz_test = r:Results
  \end

fun Szl 'Tex1_gszl'
  Szl(ts) = Foo

fun Sz 'Tex1_gsz'
  Sz(t) = Foo

fun/0 Sz_test 
  Sz_test = 
  Check(Sz Gnd(0,0),1),Check(Sz S2gtc('f(x,y)'),3),
  Check(Sz S2gtc('f(g(x,y),z,h(u))'),7),
  Check(Sz S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),16),0

rem 
  \para \bf  Úloha. Hĺbka všeobecného stromu.  \end \header* fun Dp '' \end 
  Zadefinujte funkciu \ft Tex2_equiv(Dp(t),Tex1_gdp(t)) \end, ktorej hodnotou je 
  hĺbka všeobecného stromu \ft t \end. 
  \para Testovanie: 
  \verbatim 
      Dp_test = r:Results
  \end

fun Dpl 'Tex1_gdpl'
  Dpl(ts) = Foo

fun Dp 'Tex1_gdp'
  Dp(t) = Foo

fun/0 Dp_test 
  Dp_test = 
  Check(Dp Gnd(0,0),1),Check(Dp S2gtc('f(x,y)'),2),
  Check(Dp S2gtc('f(g(x,y),z,h(u))'),3),
  Check(Dp S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),4),0

rem 
  \para \bf  Úloha. Prvky všeobecného stromu.  \end Zadefinujte predikát 
  \ft Tex2_equiv(Ingt(x,t),Tex2_ingt(x,t)) \end, ktorý platí, ak je číslo 
  \ft x \end prvkom všeobecného stromu \ft t \end. 
  \eq* 
    Ingtl(x,Gnd(y1,ts1),ts2) <-> x = y1 \/ Ingtl(x,ts1) \/ Ingtl(x,ts2)
  \end
  \eq* 
    Ingt(x,Gnd(y,ts)) <-> x = y \/ Ingtl(x,ts)
  \end
  \para Testovanie: 
  \verbatim 
      Ingt_test = r:Results
  \end

pred/2 Ingtl 'Tex2_ingtl'
  Ingtl(x,ts) <- Quux

pred/2 Ingt 'Tex2_ingt'
  Ingt(x,t) <- Quux

fun/2 Ingt_ 'Tex2_ingt_'
  Ingt_(x,t) = 0 <- ~Ingt(x,t)
  Ingt_(x,t) = 1 <- Ingt(x,t)

fun/0 Ingt_test 
  Ingt_test = 
  Check(Ingt_(0,Gnd(0,0)),1),Check(Ingt_(1,Gnd(0,0)),0),
  Check(Ingt_("x",S2gtc('f(x,y)')),1),Check(Ingt_("y",S2gtc('f(x,y)')),1),
  Check(Ingt_("z",S2gtc('f(x,y)')),0),
  Check(Ingt_("f",S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))')),1),
  Check(Ingt_("q",S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))')),1),
  Check(Ingt_("y",S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))')),1),
  Check(Ingt_("d",S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))')),1),
  Check(Ingt_("e",S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))')),1),
  Check(Ingt_("k",S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))')),0),0

rem 
  \para \bf  Úloha. Zrkadlový obraz všeobecného stromu.  \end Zadefinujte 
  funkciu \ft Reflect(t) \end, ktorej hodnotou je zrkadlový obraz stromu 
  \ft t \end. 
  \para Testovanie: 
  \verbatim 
      Reflect_test = r:Results_gtc
  \end

fun Reflectl 'Tex1_reflectl'
  Reflectl(ts) = Foo

fun Reflect 
  Reflect(t) = Foo

fun/0 Reflect_test 
  Reflect_test = 
  Check(Reflect Gnd("x",0),Gnd("x",0)),
  Check(Reflect S2gtc('f(x,y)'),S2gtc('f(y,x)')),
  Check(Reflect S2gtc('f(g(x,y),z,h(u))'),S2gtc('f(h(u),z,g(y,x))')),
  Check(Reflect S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),
        S2gtc('f(q(r(e),d),h(w,p(c,b,a),u),z,g(y,x))')),0

rem 
  \para \bf  Úloha. Efektívny program pre zrkadlový obraz.  \end Zadefinujte 
  efektívnu verziu \ft Reflect_efficient(t) \end funkcie \ft Reflect(t) \end. 
  \header* fun/2 Reflectal 'Tex2_reflectal' \end Využite pomocnú funkciu 
  \ft Reflectal(ts,rts) \end, ktorá má vlastnosť: 
  \eq* 
    Lgt(ts) -> Reflectal(ts,rts) = Reflectl(ts)++rts
  \end
  \para Pri definícii nepoužite zreťazenie, ale využite akumulátor 
  \ft rts \end. 
  \para Testovanie: 
  \verbatim 
      Reflectal_test = r:Results_lgtc
      Reflect_efficient_test = r:Results_gtc
  \end

fun/2 Reflectal 'Tex2_reflectal'
  Reflectal(ts,rts) = Foo

fun Reflect_efficient 
  Reflect_efficient(t) = Foo

fun/0 Reflectal_test 
  Reflectal_test = 
  Check(Reflectal(0,Paren(Gnd("@",0),Gnd("#",0),0)),Gnd("@",0),Gnd("#",0),0),
  Check(Reflectal((S2gtc('x'),S2gtc('y'),0),Paren(Gnd("@",0),Gnd("#",0),0)),
        S2gtc('y'),S2gtc('x'),Gnd("@",0),Gnd("#",0),0),
  Check(Reflectal((S2gtc('f(x,y)'),0),Paren(Gnd("@",0),Gnd("#",0),0)),
        S2gtc('f(y,x)'),Gnd("@",0),Gnd("#",0),0),
  Check(Reflectal((S2gtc('g(x,y)'),S2gtc('z'),S2gtc('h(u)'),0),
                  Paren(Gnd("@",0),Gnd("#",0),0)),S2gtc('h(u)'),S2gtc('z'),
        S2gtc('g(y,x)'),Gnd("@",0),Gnd("#",0),0),
  Check(Reflectal((S2gtc('f(g(x,y),z,h(u))'),
                   S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),0),
                  Paren(Gnd("@",0),Gnd("#",0),0)),
        S2gtc('f(q(r(e),d),h(w,p(c,b,a),u),z,g(y,x))'),S2gtc('f(h(u),z,g(y,x))'),
        Gnd("@",0),Gnd("#",0),0),0

fun/0 Reflect_efficient_test 
  Reflect_efficient_test = 
  Check(Reflect_efficient Gnd("x",0),Gnd("x",0)),
  Check(Reflect_efficient S2gtc('f(x,y)'),S2gtc('f(y,x)')),
  Check(Reflect_efficient S2gtc('f(g(x,y),z,h(u))'),S2gtc('f(h(u),z,g(y,x))')),
  Check(Reflect_efficient S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),
        S2gtc('f(q(r(e),d),h(w,p(c,b,a),u),z,g(y,x))')),0

rem 
  \para \bf  Úloha. Prechody všeobecnými stromami.  \end Zadefinujte funkcie 
  \ft Preorder(t) \end a \ft Postorder(t) \end. Hodnotou funkcie 
  \ft Preorder(t) \end je zoznam prvkov stromu \ft t \end v poradí preorder. 
  Zadanie pre funkciu \ft Postorder \end je analogické. 
  \para Testovanie: 
  \verbatim 
      Preorder_test = r:Results_str
      Postorder_test = r:Results_str
  \end

fun Preorderl 'Tex1_preorderl'
  Preorderl(ts) = Foo

fun Preorder 
  Preorder(t) = Foo

fun Postorderl 'Tex1_postorderl'
  Postorderl(ts) = Foo

fun Postorder 
  Postorder(t) = Foo

fun/0 Preorder_test 
  Preorder_test = 
  Check(Preorder Gnd("x",0),'x'),Check(Preorder S2gtc('f(x,y)'),'fxy'),
  Check(Preorder S2gtc('f(g(x,y),z,h(u))'),'fgxyzhu'),
  Check(Preorder S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),'fgxyzhupabcwqdre'),
  0

fun/0 Postorder_test 
  Postorder_test = 
  Check(Postorder Gnd("x",0),'x'),Check(Postorder S2gtc('f(x,y)'),'xyf'),
  Check(Postorder S2gtc('f(g(x,y),z,h(u))'),'xygzuhf'),
  Check(Postorder S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),'xygzuabcpwhderqf'),
  0

rem 
  \para \bf  Úloha. Efektívne prechody.  \end 
  \header* fun/2 Preorderal 'Tex2_preorderal' \end 
  \header* fun/2 Postorderal 'Tex2_postorderal' \end Zadefinujte efektívne 
  verzie funkcií \ft Preorder \end a \ft Postorder \end pomocou funkcií 
  \ft Preorderal \end a \ft Postorderal \end, ktoré majú vlastnosti 
  \eq* 
    Lgt(ts) -> Preorderal(ts,as) = Preorderl(ts)++as
  \end
  \eq* 
    Lgt(ts) -> Postorderal(ts,as) = Postorderl(ts)++as
  \end
  \para Pri definíciách nepoužite zreťazenie, ale využite akumulátor 
  \ft as \end. 
  \para Testovanie: 
  \verbatim 
      Preorderal_test = r:Results_str
      Preorder_efficient_test = r:Results_str
      Postorderal_test = r:Results_str
      Postorder_efficient_test = r:Results_str
  \end

fun/2 Preorderal 'Tex2_preorderal'
  Preorderal(ts,as) = Foo

fun Preorder_efficient 
  Preorder_efficient(t) = Foo

fun/2 Postorderal 'Tex2_postorderal'
  Postorderal(ts,as) = Foo

fun Postorder_efficient 
  Postorder_efficient(t) = Foo

fun/0 Preorderal_test 
  Preorderal_test = 
  Check(Preorderal(0,'@#'),'@#'),Check(Preorderal((S2gtc('x'),S2gtc('y'),0),'@#'),'xy@#'),
  Check(Preorderal((S2gtc('f(x,y)'),0),'@#'),'fxy@#'),
  Check(Preorderal((S2gtc('g(x,y)'),S2gtc('z'),S2gtc('h(u)'),0),'@#'),'gxyzhu@#'),
  Check(Preorderal((S2gtc('f(g(x,y),z,h(u))'),
                    S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),0),'@#'),
        'fgxyzhufgxyzhupabcwqdre@#'),0

fun/0 Preorder_efficient_test 
  Preorder_efficient_test = 
  Check(Preorder_efficient Gnd("x",0),'x'),
  Check(Preorder_efficient S2gtc('f(x,y)'),'fxy'),
  Check(Preorder_efficient S2gtc('f(g(x,y),z,h(u))'),'fgxyzhu'),
  Check(Preorder_efficient S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),
        'fgxyzhupabcwqdre'),0

fun/0 Postorderal_test 
  Postorderal_test = 
  Check(Postorderal(0,'@#'),'@#'),Check(Postorderal((S2gtc('x'),S2gtc('y'),0),'@#'),'xy@#'),
  Check(Postorderal((S2gtc('f(x,y)'),0),'@#'),'xyf@#'),
  Check(Postorderal((S2gtc('g(x,y)'),S2gtc('z'),S2gtc('h(u)'),0),'@#'),'xygzuh@#'),
  Check(Postorderal((S2gtc('f(g(x,y),z,h(u))'),
                     S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),0),'@#'),
        'xygzuhfxygzuabcpwhderqf@#'),0

fun/0 Postorder_efficient_test 
  Postorder_efficient_test = 
  Check(Postorder_efficient Gnd("x",0),'x'),
  Check(Postorder_efficient S2gtc('f(x,y)'),'xyf'),
  Check(Postorder_efficient S2gtc('f(g(x,y),z,h(u))'),'xygzuhf'),
  Check(Postorder_efficient S2gtc('f(g(x,y),z,h(u,p(a,b,c),w),q(d,r(e)))'),
        'xygzuabcpwhderqf'),0

rem 
  \para \bf  \it  Izomorfné všeobecné stromy.  \end  \end 
  \header* pred/2 Isomorphic 'Tex2_isomorphic' \end Pre dané všeobecné stromy 
  \ft t1 \end a \ft t2 \end platí predikát \ft Isomorphic(t1,t2) \end práve 
  vtedy, keď sú tieto stromy izomorfné, teda majú rovnaký tvar, ale nie 
  nutne rovnaké hodnoty uložené v uzloch. 

pred/2 Isomorphicl 'Tex2_isomorphicl'
  Isomorphicl(0,0)
  Isomorphicl((Gnd(x11,ts11),ts12),Gnd(x21,ts21),ts22) <- 
    Isomorphicl(ts11,ts21) & Isomorphicl(ts12,ts22)

pred/2 Isomorphic 'Tex2_isomorphic'
  Isomorphic(Gnd(x1,ts1),Gnd(x2,ts2)) <- Isomorphicl(ts1,ts2)

rem 
  \para Predikát \ft Isomorphicl(ts1,ts2) \end je reláciou ekvivalencie na 
  zoznamoch všeobecných stromov. Predikát \ft Isomorphic(t1,t2) \end je 
  reláciou ekvivalencie na všeobecných stromoch. Navyše platí 
  \eq* 
    Lgt(ts1) & Isomorphicl(ts1,ts2) -> Lgt(ts2)
  \end
  \eq* 
    Isomorphicl(ts1,ts2) -> Szl(ts1) = Szl(ts2)
  \end
  \eq* 
    Isomorphicl(ts1,ts2) -> Dpl(ts1) = Dpl(ts2)
  \end
  \para a 
  \eq* 
    Gt(t1) & Isomorphic(t1,t2) -> Gt(t2)
  \end
  \eq* 
    Isomorphic(t1,t2) -> Sz(t1) = Sz(t2)
  \end
  \eq* 
    Isomorphic(t1,t2) -> Dp(t1) = Dp(t2)
  \end

rem 
  \para \bf  \it  Číslovanie uzlov vo všeobecných stromoch.  \end  \end 
  V nasledujúcich úlohách budeme číslovať uzly vo všeobecných stromoch. 
  To znamená, že pre daný strom vytvoríme izomorfný strom, v ktorom sú 
  hodnoty v uzloch nahradené číslami \ft 0,1,2,Tex0_ldots \end 
  v predpísanom poradí. 

rem 
  \para \bf  Úloha.  \end Zadefinujte funkciu \ft Num_pre(t) \end, ktorá 
  očísluje uzly všeobecného stromu \ft t \end tak, aby pri výpise 
  v poradí \it  preorder  \end tvorili súvislý interval prirodzených 
  čísel \ft 0,1,2,Tex0_ldots \end. 
  \para* Špecifikácia: 
  \eq* 
    Gt(t) -> Isomorphic(Num_pre(t),t)
  \end
  \eq* 
    Gt(t) -> Preorder Num_pre(t) = Interval(0,Sz(t))
  \end
  \para \it  Návod.  \end \header* fun/2 Num_pre1  \end Zadefinujte a použite 
  pomocnú funkciu \ft Num_prel(ts,m) \end, ktorá očísluje uzly stromov 
  v zozname \ft ts \end tak, aby pri výpise v poradí preorder tvorili 
  súvislý interval prirodzených čísel \ft m,m+1,m+2,Tex0_ldots \end. 
  Využite funkciu \ft Sz(t) \end alebo \ft Szl(ts) \end (podľa uváženia). 
  \para* Špecifikácia: 
  \eq* 
    Lgt(ts) -> Isomorphicl(Num_prel(ts,m),ts)
  \end
  \eq* 
    Lgt(ts) -> Preorderl Num_prel(ts,m) = Interval(m,m+Szl(ts))
  \end
  \para Testovanie: 
  \verbatim 
      Num_prel_test = r:Results_lgt
      Num_pre_test = r:Results_gt
  \end

fun/2 Num_prel 'Tex2_num_prel'
  Num_prel(ts,m) = Foo

fun Num_pre 
  Num_pre(t) = Foo

fun/0 Num_prel_test 
  Num_prel_test = 
  Check(Num_prel(0,8),0),
  Check(Num_prel((S2gtc('x'),S2gtc('y'),0),3),Gnd(3,0),Gnd(4,0),0),
  Check(Num_prel((S2gtc('f(x,y)'),0),3),Gnd(3,Gnd(4,0),Gnd(5,0),0),0),
  Check(Num_prel((S2gtc('g(x,y)'),S2gtc('z'),S2gtc('h(u)'),0),3),
        Gnd(3,Gnd(4,0),Gnd(5,0),0),Gnd(6,0),Gnd(7,Gnd(8,0),0),0),0

fun/0 Num_pre_test 
  Num_pre_test = 
  Check(Num_pre(Gnd('q',0)),Gnd(0,0)),
  Check(Num_pre(S2gtc('f(x,y)')),Gnd(0,Gnd(1,0),Gnd(2,0),0)),
  Check(Num_pre(S2gtc('f(g(x,y),z,h(u))')),
        Gnd(0,Gnd(1,Gnd(2,0),Gnd(3,0),0),Gnd(4,0),Gnd(5,Gnd(6,0),0),0)),0

rem 
  \para \bf  Úloha.  \end Analogicky k predchádzajúcej funkcii 
  \ft Num_pre \end zadefinujte funkciu \ft Num_post(t) \end, ktorá spĺňa 
  špecifikáciu: 
  \eq* 
    Gt(t) -> Isomorphic(Num_post(t),t)
  \end
  \eq* 
    Gt(t) -> Postorder Num_post(t) = Interval(0,Sz(t))
  \end
  \para Testovanie: 
  \verbatim 
      Num_postl_test = r:Results_lgt
      Num_post_test = r:Results_gt
  \end

fun/2 Num_postl 'Tex2_num_postl'
  Num_postl(ts,m) = Foo

fun Num_post 
  Num_post(t) = Foo

fun/0 Num_postl_test 
  Num_postl_test = 
  Check(Num_postl(0,8),0),
  Check(Num_postl((S2gtc('x'),S2gtc('y'),0),3),Gnd(3,0),Gnd(4,0),0),
  Check(Num_postl((S2gtc('f(x,y)'),0),3),Gnd(5,Gnd(3,0),Gnd(4,0),0),0),
  Check(Num_postl((S2gtc('g(x,y)'),S2gtc('z'),S2gtc('h(u)'),0),3),
        Gnd(5,Gnd(3,0),Gnd(4,0),0),Gnd(6,0),Gnd(8,Gnd(7,0),0),0),0

fun/0 Num_post_test 
  Num_post_test = 
  Check(Num_post Gnd('q',0),Gnd(0,0)),
  Check(Num_post S2gtc('f(x,y)'),Gnd(2,Gnd(0,0),Gnd(1,0),0)),
  Check(Num_post S2gtc('f(g(x,y),z,h(u))'),
        Gnd(6,Gnd(2,Gnd(0,0),Gnd(1,0),0),Gnd(3,0),Gnd(5,Gnd(4,0),0),0)),0

rem 
  \para \bf  PRÉMIOVÁ DOMÁCA ÚLOHA \it du12b \end.  \end
  \para \bf Hodnota: \end 3 body
  \para \bf Termín odovzdania: \end pondelok 14. 5. 2012 12:00
  \para Zadefinujte funkciu \ft Num_post1(t) \end, ktorej hodnota je rovnaká
  ako \ft Num_post(t) \end, teda spĺňa špecifikáciu:
  \eq* 
    Gt(t) -> Isomorphic(Num_post1(t),t)
  \end
  \eq* 
    Gt(t) -> Postorder Num_post1(t) = Interval(0,Sz(t))
  \end
  \para \bf Nepoužite \end funkciu veľkosť stromu \ft Sz(t) \end ani veľkosť zoznamu stromov \ft Szl(ts) \end! 
  \para \it  Návod.  \end \header* fun/2 Num_postl1 \end Využite pomocnú
  funkciu \ft Num_postl1(ts,m) \end s vlastnosťou:
  \eq* 
    Lgt(ts1) -> 
    \e ts2(Num_postl1(ts1,m) = ts2,m+Szl(ts1) & Isomorphicl(ts2,ts1) & 
           Postorderl(ts2) = Interval(m,m+Szl(ts1)))
  \end
  \para Samozrejme, ani v tejto funkcii nepoužite \ft Sz(t) \end ani 
  \ft Szl(ts) \end.

fun/2 Num_postl1 
  Num_postl1(ts,m) = Foo,Foo

fun Num_post1 
  Num_post1(t) = Foo

