mod Ex04a

loc rem 
  \para \bf  5. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/ex/ex05.zip 

loc rem 
  \para* \it  Dátum:  \end streda 16. 3. 2011 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované párovacej 
  funkcii. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  ex05*.cl  \end obsahujú úlohy, ktoré máte 
         riešiť na tomto cvičení. 
  \end

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] D. Guller. Poznámky k prednáškam z CL. 
  \para* [2] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

rem 
  \para \it  [CL] CL-TeX.  \end 

appldisp/0 Tex_f0_foo
  Std('?',0)

appldisp/0 Tex_p0_poo
  Std('?',0)

fun/0 Foo 'Tex_f0_foo'
  Foo = 0

pred/0 Poo 'Tex_p0_poo'
  Poo <-> \f

appldisp/0 Tex0_dotsc
  Op(Ent('hellip'),0)

appldisp/1 Tex_f1_n_sgn
  Std('sgn',0)

appldisp/1 Tex_f1_n_sqrt
  Fenced(Op(Ent('lfloor'),0),Root(None,Arg(0)),Op(Ent('rfloor'),0))

appldisp/1 Tex_f1_pp_triang
  Subsup(Id(0,'T',0),75,Arg(0),None)

appldisp/1 Tex_f1_pp_itriang
  Subsup(Id(0,'T',0),75,Arg(0),Prefix(90,0,Op(Ent('minus'),0),Num('1',0)))

appldisp/2 Tex_f2_pp_pair
  Fenced(Id(0,Ent('lang'),0),Infix(Arg(0),30,0,Id(0,',',0),Arg(1)),Id(0,Ent('rang'),0))

appldisp/1 Tex_f1_pp_diag
  Std('d',0)

appldisp/1 Tex_f1_pp_proj1
  Prefix(90,2,Subsup(Id(0,Ent('pi'),0),75,Num('1',0),None),Arg(0))

appldisp/1 Tex_f1_pp_proj2
  Prefix(90,2,Subsup(Id(0,Ent('pi'),0),75,Num('2',0),None),Arg(0))

appldisp/1 Tex_f1_n_fib
  Subsup(Id(0,'fib',0),75,Arg(0),None)

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  Chapter. Beginning of Arithmetization.  \end 

rem 
  \para \bf  Section. Pairing Functions.  \end 

rem 
  \para \bf  Subsection. Cantor Pairing Function.  \end 

rem 
  \para \bf  Integer square root.  \end \header* fun Sqrt 'Tex_f1_n_sqrt' \end 
  \eq* 
    Sq Tex_f1_n_sqrt(x) <= x & x < Sq(Tex_f1_n_sqrt(x)+1)
  \end

fun Sgn 'Tex_f1_n_sgn'
  Sgn(0) = 0
  Sgn(x) = 1 <- x != 0

fun Sqrt 'Tex_f1_n_sqrt'
  Sqrt(x) = Sgn(z) <- x = 4*y+z & 0 <= z & z <= 3 & y = 0
  Sqrt(x) = r <- 
    x = 4*y+z & 0 <= z & z <= 3 & y != 0 & 2*Sqrt(y) = r & x < Sq(r+1)
  Sqrt(x) = r+1 <- 
    x = 4*y+z & 0 <= z & z <= 3 & y != 0 & 2*Sqrt(y) = r & x >= Sq(r+1)

rem 
  \para \bf  Triangular numbers.  \end 
  \header* fun Triang 'Tex_f1_pp_triang' \end 
  \eq* 
    Tex_f1_pp_triang(n) = 1+2+3+Tex0_dotsc+(n-1)+n
  \end

fun Triang 'Tex_f1_pp_triang'
  Triang(n) = n*(n+1)/2

rem 
  \para \bf  The right inverse of the triangular function.  \end 
  \header* fun Itriang 'Tex_f1_pp_itriang' \end Define the unary function 
  \ft Itriang(n) \end such that 
  \eq* 
    Triang Itriang(n) <= n & n < Triang(Itriang(n)+1)
  \end
  \para \it  Hint.  \end Derivation of \ft Itriang(n) \end is based on the 
  following property of triangular numbers 
  \eq* 
    8*Triang(n)+1 = Sq(2*n+1)
  \end
  \para Define the function with the help of the integer square root function 
  \ft Sqrt(x) \end. 

fun Itriang 'Tex_f1_pp_itriang'
  Itriang(n) = Foo

rem 
  \para \bf  Pairing function.  \end Define the modified Cantor pairing function 
  \ft Tex_f2_pp_pair(x,y) \end. 

fun/2 Pair 'Tex_f2_pp_pair'
  Pair(x,y) = Foo

rem 
  \para \bf  Basic properties of the pairing function.  \end We have 
  \eq* 
    Pair(x1,x2) = Pair(y1,y2) -> x1 = y1 & x2 = y2
  \end
  \eq* 
    x < Pair(x,y) & y < Pair(x,y)
  \end
  \eq* 
    x = 0 \/ \e y\e z x = Pair(y,z)
  \end

rem 
  \para \bf  Ordering properties of the pairing function.  \end We have 
  \eq* 
    Pair(x1,x2) <= Pair(y1,y2) <-> x1+x2 < y1+y2 \/ x1+x2 = y1+y2 & x1 <= y1
  \end
  \eq* 
    Pair(x1,x2) < Pair(y1,y2) <-> x1+x2 < y1+y2 \/ x1+x2 = y1+y2 & x1 < y1
  \end

rem 
  \para \bf  Diagonal function.  \end \header* fun Diag 'Tex_f1_pp_diag' \end 
  Define the unary function \ft Diag(x) \end satisfying 
  \eq* 
    Diag Pair(y,z) = y+z
  \end

fun Diag 'Tex_f1_pp_diag'
  Diag(x) = Foo

rem 
  \para \bf  Projections.  \end Define the projection functions of the pairing 
  function which are unary functions \ft Tex_f1_pp_proj1(x) \end and 
  \ft Tex_f1_pp_proj2(x) \end such that 
  \eq* 
    Tex_f1_pp_proj1(x) = y <-> x = 0 & y = 0 \/ \e z x = Pair(y,z)
  \end
  \eq* 
    Tex_f1_pp_proj2(x) = z <-> x = 0 & z = 0 \/ \e y x = Pair(y,z)
  \end

fun Proj1 'Tex_f1_pp_proj1'
  Proj1(x) = Foo

fun Proj2 'Tex_f1_pp_proj2'
  Proj2(x) = Foo

rem 
  \para \bf  Subsection. Exercises.  \end 

rem 
  \para \bf  Fibonacci numbers.  \end 

fun Fib 'Tex_f1_n_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n+1)+Fib(n)

rem 
  \para \bf  Exercise.  \end Find a primitive recursive definition of the 
  following function 
  \eq* 
    Twofib(n) = Pair(Fib(n),Fib(n+1))
  \end
  \para which does not contain any application of \ft Fib(n) \end. 

fun Twofib 
  Twofib(n) = Foo

