mod Ex04a

loc rem 
  \para \bf  4. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* \bf  ČASŤ A  \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/1011ls/ex/ex04.zip 

loc rem 
  \para* \it  Dátum:  \end streda 9. 3. 2011 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end http://dai.fmph.uniba.sk/courses/udp/ 
  \para* \it  Kontakt:  \end udp(zavináč)lists.dai.fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované dyadickej 
  reprezentácii čísel. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  ex04*.cl  \end obsahujú úlohy, ktoré máte 
         riešiť na tomto cvičení. 
  \end

loc rem 
  \para \it  Literatúra.  \end 
  \para* [1] D. Guller. Poznámky k prednáškam z CL. 
  \para* [2] J. Komara and P. J. Voda. Metamathematics of Computer Programming. 
  2001. 

loc rem 
  \para Preskočte nasledujúce komponenty po nadpis „CVIČENIE“. 

rem 
  \para \it  [CL] CL-TeX.  \end 

appldisp/0 Tex0_foo
  Std('?',0)

fun/0 Foo 'Tex0_foo'
  Foo = 0

appldisp/0 Tex0_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots
  Op(Ent('ctdot'),0)

appldisp/2 Tex2_cdots
  Op(Ent('ctdot'),0)

appldisp/1 Tex1_cdots_around
  Fenced(Op(Ent('ctdot'),0),Arg(0),Op(Ent('ctdot'),0))

appldisp/1 Tex1_paren_cdots_paren_around
  Fenced(Op('(',Ent('ctdot'),'(',0),Arg(0),Op(')',Ent('ctdot'),')',0))

appldisp/1 Tex1_set
  Fenced(Op('{',0),Arg(0),Op('}',0))

appldisp/2 Tex2_in
  Infix(Arg(0),25,0,Op(Ent('isin'),0),Arg(1))

appldisp/1 Tex1_f
  Std('f',0)

appldisp/1 Tex1_s1
  Std('S1',0)

appldisp/1 Tex1_s2
  Std('S2',0)

appldisp/2 Tex2_equiv
  Infix(Arg(0),26,3,Op(Ent('equiv'),0),Arg(1))

appldisp/2 Tex2_exp
  Subsup(Arg(0),75,None,Arg(1))

appldisp/2 Tex2_idx
  Subsup(Arg(0),75,Arg(1),None)

rem 
  \para \bf  C V I Č E N I E  \end 

rem 
  \para \bf  DYADICKÁ REPREZENTÁCIA ČÍSEL  \end 

rem 
  \para \it  Dyadická reprezentácia.  \end Každé prirodzené číslo \ft n \end 
  možno jednoznačne zapísať v tvare 
  \eq* 
    n = 2*(2*Tex1_paren_cdots_paren_around(2*(2*0+Tex2_idx(d,k))+Tex2_idx(d,k-1))+d1)+
    Tex2_idx(d,0)
  \end
  \para kde \ft Tex2_in(Tex2_idx(d,i),Tex1_set(1,2)) \end pre všetky 
  \ft i <= k \end. 
  \para Postupnosť \ft 0 \end \ft Tex2_idx(d,k) \end \ft Tex2_idx(d,k-1) \end 
  … \ft d1 \end \ft Tex2_idx(d,0) \end nazývame \it  dyadická reprezentácia  \end 
  (dyadický zápis) čísla \ft n \end. 
  \para Napríklad 
  \eq* 
    17 = 2*(2*(2*(2*0+1)+1)+2)+1
  \end
  \para Dyadická reprezentácia čísla \ft 17 \end je teda 
  \eq* 
    S1 S2 S1 S1(0)
  \end

rem 
  \para \it  [CL] Dyadické konštruktory.  \end V CL sú preddefinované 
  funkcie 
  \eq* 
    Tex2_equiv(Tex1_s1(x),S1(x)) = 2*x+1
  \end
  \eq* 
    Tex2_equiv(Tex1_s2(x),S2(x)) = 2*x+2
  \end
  \para nazývané \it  dyadické konštruktory  \end. Pomocou nich môžeme 
  konštruovať dyadickú reprezentáciu čísel. Funkciu \ft Tex1_s1(n) \end môžeme 
  chápať ako „pridaj číslicu 1 na koniec dyadickej reprezentácie 
  čísla \ft n \end “. Tomu zodpovedá aj spôsob jej zobrazenia: \ft S1(n)\end.
  Význam \ft S2 \end sa dá chápať analogicky. 

rem 
  \para \bf  [CL] Úloha  \end. Vyhodnoťte nasledujúce dotazy (queries): 
  \verbatim 
  S1 S2 S1 S1(0) = n
  \end
  \verbatim 
  S1 S2 S1 S1(0) = n & S1(n) = p & S2(n) = q
  \end

rem 
  \para \it  [CL] Dyadický formát.  \end CL dokáže zobraziť hodnotu 
  premennej v query v dyadickej reprezentácii pomocou \it  dyadického formátu 
   \end \ft N2 \end. 
  \para Syntax: 
  \verbatim 
      hodnota = premenna:N2
  \end
  \para Hodnota sa zobrazí akoby bola skonštruovaná z 0 pomocou 
  konštruktorov \ft S1 \end a \ft S2 \end. 

rem 
  \para \bf  [CL] Úloha  \end. Vyhodnoťte nasledujúce dotazy (queries): 
  \verbatim 
  17 = n:N2
  \end
  \verbatim 
  17+12 = n & n = m:N2
  \end
  \verbatim 
  S1 S2 S1 S2 S1(0) = n & n = m:N2
  \end

rem 
  \para \it  [CL] Dyadická diskriminácia.  \end Každé prirodzené číslo je
  buď \ft 0 \end alebo dyadická reprezentácia \ft n \end končí číslicou 1 alebo
  dyadická reprezentácia \ft n \end končí číslicou 2. Tieto možnosti sú vzájomne
  výlučné.
  \eq* n = 0 \/ \e m n = S1(m) \/ \e m n = S2(m)\end
  \eq*
    ~(n = 0) & ~(\e m n = S1(m)) \/ ~(n = 0) & ~(\e m n = S2(m)) \/ ~(\e m n = S1(m)) & ~(\e m n = S2(m))
  \end
  \para Tieto 3 možnosti tvoria \it dyadickú diskrimináciu\end. CL pozná túto
  diskrimináciu. Používame ju v tvare
  \def* 
    Tex1_cdots(t) <- t = 0
    Tex1_cdots(t) <- t = S1(m)
    Tex1_cdots(t) <- t = S2(m)
  \end
  \para kde \ft t \end je ľubovoľný výraz (obyčajne argument funkcie) a
  \ft m \end je \it nová \end premenná (podobne ako pri monadickej
  diskriminácii).
  \para Dyadickú diskrimináciu možno dosadiť do argumentov definovanej funkcie:
  \def* 
    Tex1_f(0) = Tex0_cdots
    Tex1_f(S1(m)) = Tex1_cdots_around(m)
    Tex1_f(S2(m)) = Tex1_cdots_around(m)
  \end
  \para V tomto cvičení používajte \bf iba dyadickú diskrimináciu \end!

rem 
  \para \bf  [CL] Úloha  \end. Zadajte nasledujúce dotazy (queries) pre viacero
  rôznych hodnôt \ft n \end: 
  \verbatim 
  17 = n:N2 & n = 0
  \end
  \verbatim 
  17 = n:N2 & n = S1(m)
  \end
  \verbatim 
  17 = n:N2 & n = S1(m:N2)
  \end
  \verbatim 
  17 = n:N2 & n = S2(m)
  \end
  \verbatim 
  17 = n:N2 & n = S2(m:N2)
  \end

rem 
  \para \it  Dyadická rekurzia.  \end Ak funkciu zadefinujeme tak, že
  všetky \it rekurzívne volania majú menší počet dyadických číslic \end ako
  pôvodný argument, teda
  \def* 
    Tex1_f(0) = Tex0_cdots
    Tex1_f(S1(m)) = Tex1_cdots_around(Tex1_f(m))
    Tex1_f(S2(m)) = Tex1_cdots_around(Tex1_f(m))
  \end
  \para hovoríme o \it dyadickej rekurzii \end. Dyadická rekurzia je špeciálnym
  prípadom course-of-values rekurzie, pretože
  \eq* m < S1(m) & m < S2(m) \end
  \para Všetky funkcie v tomto cvičení definujte \bf iba dyadickou rekurziou \end!

rem 
  \para \bf  Aritmetika na dyadickej reprezentácii  \end 

rem
  \para \it Poznámka. \end Dyadickou rekurziou môžeme zadefinovať
  \it efektívne \end aritmetické
  operácie na prirodzených číslach s neobmedzenou presnosťou. Počet krokov
  potrebných na takto zadefinované operácie lineárne závisí od počtu číslic
  v dyadickej reprezentácii argumentov operácie, nie od hodnoty argumentov.

rem 
  \para \bf  Úloha. Nasledovník. \end Dyadickou rekurziou zadefinujte funkciu nasledovník
  \ft Succ(x) = x+1 \end.
  \para* \it Návod. \end Predstavte si dyadickú verziu sčítania, ako ste sa ho
  učili na základnej škole. Uvedomte si, kedy nastáva prenos do vyššieho rádu.
  \verbatim
    0211 (11)     0212 (12)      0222 (14)
    +  1          +  1          +   1     
    ----          ----          -----     
    0212 (12)     0221 (13)     01111 (15)
  \end

fun Succ 
  Succ(0) = Foo
  Succ S1(x) = Foo
  Succ S2(x) = Foo

rem 
  \para \bf  Úloha. Sčítanie.  \end \header* fun/2 Add  \end Dyadickou rekurziou
  zadefinujte funkciu sčítanie \ft Add(x,y) = x+y \end.
  \para* \it Návod. \end Predstavte si dyadickú verziu sčítania, ako ste sa ho
  učili na základnej škole. Rozoberte jednotlivé prípady:
  \verbatim
      0    x1    x1    x1    x2    x2    x2
    + y   + 0   +y1   +y2   + 0   +y1   +y2
    ---   ---   ---   ---   ---   ---   ---
     ??    ??    ??    ??    ??    ??    ??
  \end
  \para Na prenos do vyššieho rádu použite funkciu nasledovník.

fun/2 Add 
  Add(0,y) = Foo
  Add(S1(x),0) = Foo
  Add(S1(x),S1(y)) = Foo
  Add(S1(x),S2(y)) = Foo
  Add(S2(x),0) = Foo
  Add(S2(x),S1(y)) = Foo
  Add(S2(x),S2(y)) = Foo
  
rem 
  \para \bf  Úloha. Dvojnásobok. \end Dyadickou rekurziou
  zadefinujte funkciu dvojnásobok \ft Twice(x) = 2*x \end. Nepoužite žiadne
  pomocné funkcie, ani tie, ktoré ste doteraz naprogramovali.
  \para* \it Návod. \end Uvedomte si, že \ft S1(x) = 2*x+1 \end
  a teda \ft Twice(S1(x)) = 2*(2*x+1) \end.
  Upravte tento výraz tak, aby sa dal
  zapísať iba pomocou \ft S1 \end, \ft S2 \end a rekurzívneho volania \ft
  Twice(x)\end, ktoré má hodnotu \ft 2*x \end.
  Podobne postupujte pri \ft Twice(S2(x)) = 2*(2*x+2) \end.

fun Twice 
  Twice(x) = Foo

rem 
  \para \bf  Úloha. Násobenie. \end \header* fun/2 Mul  \end Dyadickou rekurziou
  zadefinujte funkciu násobenie \ft Mul(x,y) = x*y \end.
  \para* \it Návod. \end Postupujte podobne ako pri funkcii \ft Twice \end.
  Použite funkcie \ft Twice \end a \ft Add \end. Dyadickú diskrimináciu použite
  iba na jeden argument.

fun/2 Mul 
  Mul(x,y) = Foo

rem 
  \para \bf  Úloha. Umocnenie. \end \header* fun/2 Exp  \end Dyadickou rekurziou
  zadefinujte funkciu umocnenie \ft Exp(x,y) = Tex2_exp(x,y) \end. 
  \para* \it Návod. \end Postupujte podobne ako pri funkcii dvojnásobok, teda
  vyjadrite pomocou už zadefinovaných operácií a rekurzie \ft Exp(x,y) \end
  hodnoty \ft Exp(x,S1(y)) = Tex2_exp(x,2*y+1) \end
  a \ft Exp(x,S2(y)) = Tex2_exp(x,2*y+2) \end. Namiesto dvoch rovnakých rekurzívnych
  volaní použite priradenie do novej premennej (viď úvod ex03a).

fun/2 Exp 
  Exp(x,y) = Foo
