mod Ex11

incl Strings

incl Xml_mod

incl Cd_catalog

rem 
  \para \bf  11. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/0607ls/ex/ex11.zip 

rem 
  \para* \it  Dátum:  \end 2. a 4. 5. 2007 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.19  \end 
  \para* \it  WWW stránka predmetu:  \end 
  http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/0607ls?lang=sk 

appldisp/0 Cdots
  Op(Ent('ctdot'),0)

fun/0 Fill_in 'Cdots'
  Fill_in = 20070502

pred/0 Fill__in 'Cdots'
  Fill__in

rem 
  \para \bf  INTERAKTÍVNA APLIKÁCIA — EDITOR KATALÓGU CD  \end 

rem 
  \para V tomto cvičení budeme pracovať s katalógom CDčok podobne ako v 
  cvičení ex08. Základný katalóg je obsahom konštanty 
  \ft X_cd_catalog \end z modulu \ft Cd_catalog \end (môžete si ju pozrieť 
  kliknutím na [Expand] modulu \ft Cd_catalog \end). Katalóg je XML dokument s 
  nasledujúcou štruktúrou: 
  \para Koreňový element CATALOG obsahuje elementy CD. Každý element CD 
  obsahuje nasledujúcu postupnosť elementov (všetky v tomto poradí): 
  \points 
   \item \para TITLE – názov; 
   \item \para ARTIST – interpret; 
   \item \para COUNTRY – krajina vydania; 
   \item \para COMPANY – vydavateľstvo; 
   \item \para PRICE – cena; 
   \item \para YEAR – rok vydania. 
  \end
  \para Tieto elementy obsahujú iba text. 

rem 
  \para \bf  Vašou úlohou  \end je naprogramovať editor katalógu, ktorý 
  umožňuje pridávať nové záznamy a mazať existujúce. 

rem 
  \para Spracúvanie priamočiaro zakódovaného XML ( \ft Xe \end, \ft Xs \end) 
  je pomerne prácne a náchylné na chyby. Zadefinujeme si preto zjednodušenú 
  štruktúru. 
  \para Katalóg CD je zoznam záznamov o jednotlivých CD, pričom každý 
  záznam je šestica tvorená štyrmi reťazcami (title, artist, country, 
  company) a dvoma číslami (price, year). Na zakódovanie tejto šestice 
  použijeme konštruktor \ft Is(Cd,(Str,Str,Str,Str,N,N -> Cd)) \end. 
  Predikát-formát \ft Lcd \end hovorí, aké zoznamy sú zoznamami záznamov o 
  CD, teda opisuje typ \ft Lst(Cd) \end. 
  \para Cena je nezáporné racionálne číslo s pevným počtom desatinných 
  miest (2). V našej štruktúre ju zakódujeme pomocou jej 100-násobku. To je 
  jednoduchý príklad reprezentácie čísel s pevnou rádovou čiarkou 
  (fixed-point number representation). 

fun/6 Cd 
  Cd(t,a,c,m,p,y) = 0,t,a,c,m,p,y

pred Lcd 
  Lcd(0)
  Lcd(Cd(t,a,c,m,p,y),x) <- 
    Str(t) & Str(a) & Str(c) & Str(m) & N(p) & N(y) & Lcd(x)

rem 
  \para \bf  a) Konverzia \ft Xml \end do \ft Lst(Cd) \end  \end 

rem 
  \para Nasledujúce funkcie konvertujú \ft Xml \end katalógu CD do typu 
  \ft Lst(Cd) \end. Hlavná funkcia je \ft In_catalog \end. Táto konverzia bola 
  súčasťou 8. cvičenia. Konverziu neskôr použijeme na inicializáciu 
  editora. 

fun/2 In_leaf 
  In_leaf(nm,Xe(lnm,a,cs)) = Value_of(cs) <- nm = lnm

fun In_cd 
  In_cd(tx,ax,cx,mx,px,yx,0) = Cd(t,a,c,m,Read_fix(p,2),Read_fix(y,0)) <- 
    In_leaf('TITLE',tx) = t & In_leaf('ARTIST',ax) = a & In_leaf('COUNTRY',cx) = c & 
    In_leaf('COMPANY',mx) = m & In_leaf('PRICE',px) = p & In_leaf('YEAR',yx) = y

fun In_lcd 
  In_lcd(0) = 0
  In_lcd(Xe('CD',a,cs),xs) = In_cd(cs),In_lcd(xs)

fun In_catalog 
  In_catalog(Xe('CATALOG',a,cs),0) = In_lcd(cs)

rem 
  \para \bf  b) Generovanie XHTML  \end (1 bod) 

rem 
  \para \ft Is(Ht_catalog,(Lst(Cd) -> Lst(X))) \end 
  \para Funkcia \ft Ht_catalog(cd) \end skonštruuje XHTML dokument, ktorý 
  umožňuje editovať katalóg CD. Dokument tvorí jeden formulár, ktorý 
  obsahuje tabuľku podľa nasledujúceho náčrtu: 
  \verbatim 
     |      Title       |    Artist    | Country |   Company   | Price  |  Year  |  Action  |
     | [______________] | [__________] | [____]  | [_________] | [____] | [____] | [Add]    |
     | Empire Burlesque | Bob Dylan    | USA     | Columbia    | 10.90  | 1985   | [Delete] |
     | Hide your heart  | Bonnie Tyler | UK      | CBS Records | 9.90   | 1988   | [Delete] |
     ...
     | Unchain my heart | Joe Cocker   | USA     | EMI         | 8.20   | 1987   | [Delete] |
  
     [Init]
  \end
  \para Tabuľka obsahuje hlavičkový riadok, riadok na pridanie nového 
  záznamu (tvorený textovými poliami a tlačidlom \it  Add  \end) a riadky 
  pre jednotlivé CD zo zoznamu \ft cd \end. Okrem údajov o CD obsahuje každý 
  z týchto riadkov tlačidlo \it  Delete  \end. Pod tabuľkou (ale stále vo 
  vnútri formulára) sa nachádza tlačidlo \it  Init  \end. 
  \para Na skonštruovanie editovacieho dokumentu použite pomocné funkcie 
  podľa svojho uváženia. 
  \para Uvedomte si, že tlačidlá \it  Delete  \end musia byť navzájom 
  rozlíšiteľné. Jednoduchý spôsob ako to dosiahnuť je pri generovaní 
  riadkov tabuľky počítať ich čísla. Pre dané číslo riadka potom 
  vygenerujete tlačidlo, ktorého meno (atribút name) je 'delete', hodnota 
  (atribút value) je číslo riadku a nápis na tlačidle je \it  Delete  \end. 
  Takéto tlačidlá sa nedajú generovať ako element \it  input  \end, ale 
  treba použiť element \it  button  \end. 
  \para V module \ft Xml_mod \end je preddefinovaná funkcia 
  \ft Button(meno,hodnota,napis) \end, ktorá vyrobí element <button 
  type='submit' name=' \ft meno \end ' value=' \ft hodnota \end '> 
  \ft napis \end </button>. Argument \ft napis \end je reťazec. Číslo riadku 
  nezabudnite prekonvertovať na reťazec funkciou \ft Show \end z modulu 
  \ft Strings \end. 
  \para Tlačidlo \it  Add  \end v riadku na pridanie nového záznamu môžete 
  generovať buď ako \it  input  \end alebo ako \it  button  \end. Jeho meno 
  (atribút name) nastavte na 'add', hodnota (atribút value) je ľubovoľná 
  ale neprázdna. Obdobne skonštruujte aj tlačidlo \it  Init  \end pod 
  tabuľkou. Jednotlivým textovým poliam dajte vhodné názvy a prázdne 
  hodnoty. 

fun Ht_catalog 
  Ht_catalog(cds) = Fill_in

rem 
  \para \bf  c) Spracovanie udalostí z formulára  \end (1 bod) 

rem 
  \para \ft Is(Process,(Attrs,Lst(Cd) -> Lst(Cd))) \end 
  \header* fun/2 Process  \end 
  \para Funkcia \ft Process(req,cds) \end upraví katalóg \ft cds \end podľa 
  udalosti, ktorá je opísaná jej argumentom \ft req \end (hodnotou 
  špeciálnej premennej \ft request \end). Teda ak bolo stlačené tlačidlo 
  \items 
   \item \para \it  Init  \end, vráti katalóg z konštanty \it  X_cd_catalog 
          \end; 
   \item \para \it  Add  \end, pridá nové CD do katalógu, pričom jeho dáta 
         získa z príslušných textových polí formulára; 
   \item \para \it  Delete  \end, zmaže príslušné CD z katalógu. 
  \end
  \para Ak nenastane žiadna z týchto možností, \it  Process  \end by mala 
  vrátiť nezmenený katalóg. 
  \para Každú z uvedených akcií odporúčame realizovať samostatnou 
  funkciou. Funkcia \ft Process \end potom iba rozhodne, ktorá z pomocných 
  funkcií sa má zavolať a odovzdá jej potrebné parametre. 
  \para Pri volaní zmazania a pri pridávaní CD nezabudnite na konverziu 
  reťazcov na čísla (funkcia \ft Read_fix(retazec,pocetdesatinnychmiest) \end 
  z modulu \ft Strings \end) v prípadoch, kde je to potrebné. 

fun/0 Process_init 
  Process_init = Fill_in

fun/2 Process_add 
  Process_add(req,cds) = Fill_in

fun/2 Process_delete 
  Process_delete(n,cds) = Fill_in

fun/2 Process 
  Process(req,cds) = Fill_in

rem 
  \para \bf  d) Hlavná funkcia  \end 

rem 
  \para \ft Is(Main,(Attrs,Lst(Cd) -> Lst(X),Lst(Cd))) \end 
  \header* fun/2 Main  \end 
  \para \ft Main(request,data) \end spracuje udalosť opísanú požiadavkou 
  \ft request \end pomocou funkcie \ft Process \end. Na základe upravených 
  dát, vrátených funkciou \ft Process \end, vygeneruje XHTML dokument na 
  editovanie katalógu funkciou \ft Ht_catalog \end. Vráti dvojicu tvorenú 
  týmto dokumentom a upravenými dátami. 

fun/2 Main 
  Main(req,dat) = Fill_in,Fill_in

