mod Ex09

incl Strings

incl Xml_mod

incl Sidonie

incl Baske

rem 
  \para \bf  9. CVIČENIE Z PREDMETU ÚVOD DO DEKLARATÍVNEHO PROGRAMOVANIA 
   \end 
  \para* http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/0607ls/ex/ex09.zip 

rem 
  \para* \it  Dátum:  \end 11. a 13. 4. 2007 
  \para* \it  Odporúčaná verzia CL:  \end \bf  5.81.18  \end 
  \para* \it  WWW stránka predmetu:  \end 
  http://ii.fmph.uniba.sk/cl/courses/1-AIN-505-udp/0607ls?lang=sk 

appldisp/0 Cdots
  Op(Ent('ctdot'),0)

fun/0 Fill_in 'Cdots'
  Fill_in = 20070411

pred/0 Fill__in 'Cdots'
  Fill__in

rem 
  \para \bf  ZOBRAZENIE XML TRANSFORMÁCIOU DO XHTML, II. ČASŤ  \end 
  \para* \bf  KOMENTOVANÁ GALÉRIA OBRÁZKOV Z VÝLETU  \end 

rem 
  \para \bf  Štruktúra XML.  \end Podobne ako v minulom cvičení, aj v tomto 
  budeme formátovať dáta z XML do XHTML. Tentoraz XML obsahuje komentovaný 
  zoznam obrázkov z výletu. Má nasledujúcu štruktúru: 
  \para Koreňový element \it  hike  \end má atribúty \it  title  \end 
  (názov výletu) a \it  date  \end (dátum vo formáte DD-MM-RRRR). Prípadné 
  ďalšie atribúty nie sú pre toto cvičenie zaujímavé. Element \it  hike 
   \end obsahuje v ľubovoľnom poradí ľubovoľný počet elementov \it  pict 
   \end a \it  ht  \end. 
  \items 
   \item \para Element \it  pict  \end opisuje jeden obrázok. Má (okrem 
         iných, ktoré nie sú potrebné) atribút \it  img  \end, ktorého 
         hodnotou je názov súboru s obrázkom. Element \it  pict  \end môže 
         obsahovať v akomkoľvek poradí najviac jeden element \it  c  \end a 
         akýkoľvek počet elementov \it  cref  \end. 
         \items 
          \item \para Element \it  c  \end obsahuje komentár k obrázku vo 
                forme fragmentu XHTML. Nemá žiadne atribúty. 
          \item \para Elementy \it  cref  \end budeme ignorovať. 
         \end
   \item \para Element \it  ht  \end obsahuje „globálny“ komentár 
         týkajúci sa celého výletu alebo viacerých nasledujúcich obrázkov 
         a má formu fragmentu XHTML. 
  \end

rem 
  \para \bf  ÚLOHA.  \end Vašou úlohou je naprogramovať funkciu 
  \ft Main \end, ktorá zoberie adresárový prefix URL (viď nižšie) a CL 
  kód XML podľa schémy z predošlého odseku, prekóduje ho do jednoduchšej 
  štruktúry, ktorú opíšeme nižšie, a z nej vygeneruje CL kód XHTML s 
  týmto obsahom (nazveme ho \bf  štandardné formátovanie  \end): 
  \items 
   \item \para Nadpis obsahujúci názov a dátum výletu. 
   \item \para Tabuľka malých náhľadov, obsahujúca po 3 náhľady v riadku. 
   \item \para Postupnosť globálnych komentárov a stredne veľkých 
         náhľadov (s ich lokálnymi komentármi) v rovnakom poradí, ako sú 
         uvedené vo vstupnom XML. 
   \item \para Každý náhľad (malý v tabuľke aj stredne veľký v hlavnom 
         obsahu dokumentu) má atribút \it  id  \end, ktorého hodnota je 
         jednoznačná v celom dokumente (názov súboru s prefixom tn_ resp. 
         md_). Alternatívne môžete vytvoriť explicitnú kotvu <a name="..." 
         id="...">...</a> obsahujúcu element \it  img  \end. 
   \item \para Malý náhľad je odkazom na zodpovedajúci stredne veľký 
         náhľad v rámci dokumentu (URL v tvare \it  #id_ciela  \end) a 
         naopak, každý stredne veľký náhľad je odkazom na malý náhľad. 
  \end
  \para Ak ste vyriešili celé cvičenie \it  ex07  \end, generovanie tabuľky 
  malých náhľadov môžete s drobnými úpravami prevziať odtiaľ. 
  \para* \bf  Alternatívne formátovanie.  \end Ak pohŕdate formátovacími 
  tabuľkami a máte dostatočné skúsenosti s CSS, môžete vstup 
  sformátovať nasledujúcim alternatívnym spôsobom: 
  \items 
   \item \para Nadpis obsahujúci názov a dátum výletu. 
   \item \para Postupnosť globálnych komentárov a obrázkov v rovnakom 
         poradí ako vo vstupnom XML. 
         \items 
          \item \para Malý náhľad na každý obrázok je spolu so svojím 
                lokálnym komentárom umiestnený v elemente \it  div  \end, 
                ktorý je naštýlovaný ako plávajúci blok (CSS vlastnosť 
                \it  float  \end). 
          \item \para Globálne komentáre sú umiestnené v elementoch \it  div 
                 \end naštýlovaných tak, aby sa všetky predchádzajúce 
                obrázky zobrazili skôr ako globálny komentár (CSS vlastnosť 
                \it  clear  \end). 
         \end
   \item \para Za všetkými komentármi a malými náhľadmi obrázkov 
         nasleduje vhodný oddeľujúci nadpis (napr. \it  Väčšie obrázky 
          \end) a všetky stredne veľké náhľady. 
   \item \para Malé a stredne veľké náhľady sú prepojené linkami ako pri 
         štandardnom formátovaní. 
  \end

rem 
  \para \bf  Príklady vstupného XML.  \end V tomto súbore s cvičením sú 
  vložené moduly \ft Sidonie \end a \ft Baske \end obsahujúce konštanty 
  \ft X_sidonie \end, \ft X_sidonie_mini \end a \ft X_baske \end. Každá z nich 
  je CL kódom XML dokumentu zodpovedajúceho vyššie opísanej schéme. 
  Konštanta \ft X_sidonie_mini \end je skrátenou verziou \ft X_sidonie \end 
  vhodnejšou na testovanie. 

rem 
  \para \bf  Pomocná dátová štruktúra.  \end Zjednodušená dátová 
  štruktúra, do ktorej chceme prekonvertovať vstupné XML, je opísaná 
  predikátom – typom \ft Litem \end (list of items, \ft Lst(Item) \end). Je 
  to zoznam položiek, z ktorých každá je obrázkom ( \ft Pict \end) alebo 
  globálnym komentárom ( \ft Ht \end). Konštruktor \ft Pict \end kódujúci 
  obrázok má dva argumenty: názov súboru obrázka (reťazec) a zreťazený 
  obsah komentárov k obrázku (XML, fragment XHTML). Konštruktor kódujúci 
  globálny komentár má jediný argument: text komentára (XML, fragment 
  XHTML). 

fun/2 Pict 
  Pict(fnm,text) = 0,fnm,text

fun Ht 
  Ht(text) = 1,text

pred Item 
  Item Pict(fnm,text) <- Str(fnm) & Xml(text)
  Item Ht(text) <- Xml(text)

pred Litem 
  Litem(0)
  Litem(Pict(fnm,text),x) <- Str(fnm) & Xml(text) & Litem(x)
  Litem(Ht(text),x) <- Xml(text) & Litem(x)

rem 
  \para \bf  a) Konverzia \ft Lst(X) \end do \ft Lst(Item) \end  \end 
  \para Podobne ako v cvičení ex08 odporúčame postupovať od hlavnej 
  konverznej funkcie \ft In_hike \end k pomocným funkciám. 
  \para Na čítanie hodnôt atribútov používajte funkciu \ft Fva \end z 
  modulu \ft Xml_mod \end. 

rem 
  \para \ft Is(In_c,(Lst(X) -> Lst(X))) \end 
  \para Funkcia zoberie zoznam detí elementu \it  pict  \end (teda zoznam 
  elementov \it  c  \end a \it  cref  \end) a vráti obsah elementu \it  c 
   \end, ak sa medzi nimi vyskytuje. Inak vráti prázdny zoznam. 

fun In_c 
  In_c(x) = Fill_in

rem 
  \para \ft Is(In_items,(Lst(X) -> Lst(Item))) \end 
  \para Konvertuje zoznam XML elementov \it  pict  \end a \it  ht  \end na 
  \ft Lst(Item) \end, teda zoznam položiek tvorených konštruktormi 
  \ft Pict \end a \ft Ht \end. Extrahuje pritom podstatné informácie funkciami 
  \ft Fva \end a \ft In_c \end. 

fun In_items 
  In_items(x) = Fill_in

rem 
  \para \ft Is(In_hike,(Lst(X) -> Str,Str,Lst(Item))) \end 
  \para Vráti trojicu: názov výletu, dátum a zoznam položiek (obrázkov a 
  globálnych komentárov). Na načítanie zoznamu použije \ft In_items \end, 
  ktorej odovzdá deti koreňového elementu \it  hike  \end. 

fun In_hike 
  In_hike(x) = Fill_in,Fill_in,Fill_in <- Fill__in

rem 
  \para \bf  b) Generovanie XHTML z \ft Lst(Item) \end  \end 
  \para Nasledujúce pomocné funkcie sú odporúčané pre štandardné 
  formátovanie. Niektoré sa hodia aj pri alternatívnom formátovaní. 

rem 
  \para \bf  URL obrázkov.  \end Obrázky odkazované z XML sa nachádzajú na 
  našom serveri v troch verziách: originál, stredne veľký náhľad a malý 
  náhľad. Originály nebudeme používať. 
  \para Úplné URL stredného alebo malého náhľadu získate zreťazením: 
  \items 
   \item \para adresárového prefixu z konštanty \ft Pref_sidonie \end (resp. 
         \ft Pref_baske \end), 
   \item \para reťazca \ft 'md_' \end pre stredne veľký alebo \ft 'tn_' \end 
         pre malý náhľad, 
   \item \para názvu súboru z atribútu \it  img  \end elementu \it  pict 
          \end 
   \item \para a prípony \ft '.jpg' \end. 
  \end

rem 
  \para \ft Is(Img,(Str,Str -> X)) \end 
  \para Vráti jeden element \it  img  \end s dvoma atribútmi: 
  \items 
   \item \para \it  src  \end, ktorého hodnotou je URL (náhľadu) obrázka 
         skonštruované z prefixu (prvý argument), mena súboru (druhý 
         argument, očakávame, že obsahuje aj tn_ alebo md_) a prípony .jpg; 
   \item \para \it  id  \end, ktorého hodnotou je meno súboru. 
  \end

fun/2 Img 
  Img(dirpref,fname) = Fill_in

rem 
  \para \ft Is(Aimg,(Str,Str,Str,Str -> X)) \end \header* fun/4 Aimg  \end 
  \para \ft Aimg(dirpref,srcpref,targetpref,name) \end skonštruuje odkaz v 
  rámci dokumentu (<a href="#...">...</a>) z malého náhľadu na stredne 
  veľký (alebo naopak), ktorého obsahom je malý náhľad (alebo stredný 
  náhľad). Potrebuje na to adresárový prefix, prefix zdrojového náhľadu 
  (tn_/md_), prefix cieľového náhľadu (md_/tn_) a samotné meno súboru 
  obrázka. 

fun/4 Aimg 
  Aimg(dirpref,srcpref,targetpref,name) = Fill_in

rem 
  \para \ft Is(Thumb_tds,(Str,N,Lst(Items) -> Lst(X),Lst(Items))) \end 
  \header* fun/3 Thumb_tds  \end 
  \para \ft Thumb_tds(dirpref,n,is) \end prechádza zoznamom položiek \it  is 
   \end, hľadá v ňom konštruktory \ft Pict \end a preskakuje \ft Ht \end. 
  Pre každý nájdený \ft Pict \end vygeneruje element \it  td  \end 
  obsahujúci malý náhľad (s príslušným id a odkazom ako je opísané v 
  zadaní úlohy) pomocou \ft Aimg \end. 
  \para Funkcia vráti dvojicu \ft tds,is1 \end, v ktorej \ft tds \end je 
  najviac \ft n \end-prvkový zoznam elementov \it  td  \end s náhľadmi a 
  \ft is1 \end sú zatiaľ nepoužité položky. 

fun/3 Thumb_tds 
  Thumb_tds(dirpref,n,is) = Fill_in,Fill_in <- Fill__in

rem 
  \para \ft Is(Thumb_rows,(Str,Lst(Items) -> Lst(X))) \end 
  \para Funkcia generuje riadky (elementy \it  tr  \end) tabuľky s malými 
  náhľadmi. Na výrobu obsahu riadkov s najviac troma náhľadmi používa 
  \ft Thumb_tds \end. 

fun/2 Thumb_rows 
  Thumb_rows(dirpref,is) = Fill_in <- Fill__in

rem 
  \para \ft Is(Hike_body,(Str,Lst(Items) -> Lst(X))) \end 
  \para Funkcia vygeneruje hlavný obsah XHTML o výlete: postupnosť 
  globálnych komentárov a stredne veľkých náhľadov obrázkov s lokálnymi 
  komentármi. Okrem zoznamu položiek na to potrebuje adresárový prefix URL. 
  Nezabudnite, že každý stredne veľký náhľad je odkazom na malý 
  náhľad. 

fun/2 Hike_body 
  Hike_body(dirpref,is) = Fill_in

rem 
  \para \ft Is(Main,(Str,Lst(X) -> Lst(X))) \end 
  \para Hlavná funkcia. Viď zadanie úlohy na začiatku tohto cvičenia. 

fun/2 Main 
  Main(dirpref,x) = Fill_in

