mod Ex11 logic: 'cl'

incl Mtex

incl Mtexg

incl Mtexnt

incl Maux

loc rem 
  \para \bf  11. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21.2 
  \para* \it  Dátum:  \end pondelok 19.5.2025 
  \para* \it  WWW:  \end 
  https://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/2425ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované symbolickým 
  výrazom. Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Počet bodov za úlohy v tomto súbore: 0 
   \item \para Počet bodov za prémiove úlohy v tomto súbore: 2 
  \end
  \para Odovzdať do 24.5.2025 (sobota). 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end Ján Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
   \item \para \it  [3]  \end Ján Komara. Recursive Functions. Online. 
  \end

rem 
  \para \bf  [CL] CL-TeX.  \end 

appldisp/1 Tex1_appl_mu_sb
  Prefix(80,0,Id(0,Ent('mu'),0),Fenced(Op('[',0),Arg(0),Op(']',0)))

rem 
  \para \bf  Chapter. Programs Operating on Symbolic Expressions.  \end 

rem 
  \para \bf  Section. Numeric Terms.  \end 

rem 
  \para \bf  Subsection. Arithmetization of Numeric Terms.  \end 

rem 
  \para \bf  Constructors of numeric terms.  \end 

fun Vt 'Tex_f1_nt_vt'
  Vt(i) = 0,i

fun Ct 'Tex_f1_nt_ct'
  Ct(n) = 1,n

fun/2 At 'Tex_f2_nt_at'
  At(t1,t2) = 2,t1,t2

fun/2 Mt 'Tex_f2_nt_mt'
  Mt(t1,t2) = 3,t1,t2

rem 
  \para \bf  [CL] Discrimination on the constructors of numeric terms.  \end 
  Example(s): 
  \def 
    fun F 'Tex_f1_f'
    F Vt(i) = Foo
    F Ct(n) = Foo
    F At(t1,t2) = Foo
    F Mt(t1,t2) = Foo
  \end

rem 
  \para \bf  Numeric terms.  \end 

pred Term 
  Term Vt(i) <- N(i)
  Term Ct(n) <- N(n)
  Term At(t1,t2) <- Term(t1) & Term(t2)
  Term Mt(t1,t2) <- Term(t1) & Term(t2)

rem 
  \para \bf  [CL] Formatting the output.  \end Use the format \ft Term \end to 
  display numbers as numeric terms. Try out the following simple queries 
  \verbatim 
     98041654 = t:Term
  \end
  \verbatim 
     3,(2,(0,1),1,2),0,3 = t:Term
  \end

rem 
  \para \bf  [CL] Structural case analysis on numeric terms.  \end Syntax: 
  \eq* 
    'case Term ; <term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(Term,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_assum Term(t),
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,
                                                                           Vt(i)),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,
                                                                                             Ct(n)),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_and(Tex_f2_g_eq(t,
                                                                                                                            At(t1,
                                                                                                                               t2)),
                                                                                                                Tex_f2_g_and(Term(t1),
                                                                                                                             Term(t2))),
                                                                                  Tex_f1_g_x_assum Tex_f2_g_and(Tex_f2_g_eq(t,
                                                                                                                            Mt(t1,
                                                                                                                               t2)),
                                                                                                                Tex_f2_g_and(Term(t1),
                                                                                                                             Term(t2)))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  Structural induction on numeric terms.  \end Show that the 
  principle of structural induction over numeric terms is admissible in Peano 
  arithmetic. 
  \para \it  Remark.  \end Prove the claim for the special case in the following 
  theory. 
  \para \it  [CL] Hint.  \end Reduce structural induction on \ft t \end to 
  course of values induction with measure \ft |t| \end. Recall that the pair 
  size function \ft |x| \end, written as \it  |x|  \end, is defined in the 
  module \it  Standard  \end. 

theory Structural_induction_on_numeric_terms

pred A 'Tex1_g_appl_phi_sb'

axiom Base_case_vt
  A Vt(i)

axiom Base_case_ct
  A Ct(n)

axiom Induction_step_at
  A(t1) & A(t2) -> A At(t1,t2)

axiom Induction_step_mt
  A(t1) & A(t2) -> A Mt(t1,t2)

thm Conclusion
  Term(t) -> A(t)

end theory Structural_induction_on_numeric_terms

rem 
  \para \bf  [CL] Structural induction on numeric terms.  \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind Term ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Term,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Term(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R Vt(i),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal R Ct(n),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(R(t1),
                                                                                                                            R(t2)),
                                                                                                               R At(t1,
                                                                                                                    t2)),
                                                                                  Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(R(t1),
                                                                                                                            R(t2)),
                                                                                                               R Mt(t1,
                                                                                                                    t2))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Tex_f2_g_x_sc(Term,t),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Term(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R Vt(i),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal R Ct(n),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(Tex_f2_g_forall(a,
                                                                                                                                            R(t1)),
                                                                                                                            Tex_f2_g_forall(a,
                                                                                                                                            R(t2))),
                                                                                                               R At(t1,
                                                                                                                    t2)),
                                                                                  Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(Tex_f2_g_forall(a,
                                                                                                                                            R(t1)),
                                                                                                                            Tex_f2_g_forall(a,
                                                                                                                                            R(t2))),
                                                                                                               R Mt(t1,
                                                                                                                    t2))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  [CL] Structural induction on numeric terms (2nd form).  \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind* Term ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_inds Tex_f2_g_x_sc(Term,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Term(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R Vt(i),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal R Ct(n),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and3(Tex_f2_g_and3(Term(t1),
                                                                                                                                           R(t1)),
                                                                                                                             Tex_f2_g_and3(Term(t2),
                                                                                                                                           R(t2))),
                                                                                                               R At(t1,
                                                                                                                    t2)),
                                                                                  Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and3(Tex_f2_g_and3(Term(t1),
                                                                                                                                           R(t1)),
                                                                                                                             Tex_f2_g_and3(Term(t2),
                                                                                                                                           R(t2))),
                                                                                                               R Mt(t1,
                                                                                                                    t2))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
   \item \para \ft Tex_f1_g_x_inds Tex_f2_g_x_sc(Tex_f2_g_x_sc(Term,t),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Term(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R Vt(i),
                                              Tex_f2_g_x_branch(Tex_f1_g_x_goal R Ct(n),
                                                                Tex_f2_g_x_branch(Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and3(Tex_f2_g_and3(Term(t1),
                                                                                                                                           Tex_f2_g_forall(a,
                                                                                                                                                           R(t1))),
                                                                                                                             Tex_f2_g_and3(Term(t2),
                                                                                                                                           Tex_f2_g_forall(a,
                                                                                                                                                           R(t2)))),
                                                                                                               R At(t1,
                                                                                                                    t2)),
                                                                                  Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and3(Tex_f2_g_and3(Term(t1),
                                                                                                                                           Tex_f2_g_forall(a,
                                                                                                                                                           R(t1))),
                                                                                                                             Tex_f2_g_and3(Term(t2),
                                                                                                                                           Tex_f2_g_forall(a,
                                                                                                                                                           R(t2)))),
                                                                                                               R Mt(t1,
                                                                                                                    t2))))))
         \end
         \para where \ft i \end, \ft n \end, \ft t1 \end and \ft t2 \end are new 
         variables \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  Subsection. Basic Operations and Predicates.  \end 

rem 
  \para \bf  Size of numeric terms.  \end 

fun Sz 'Tex_f1_nt_sz'
  Sz Vt(i) = 1
  Sz Ct(n) = 1
  Sz At(t1,t2) = Sz(t1)+Sz(t2)+1
  Sz Mt(t1,t2) = Sz(t1)+Sz(t2)+1

rem 
  \para \bf  Denotation of numeric terms.  \end 

fun/2 Den 'Tex_f2_nt_den'
  Den(Vt(i),v) = Sub(v,i)
  Den(Ct(n),v) = n
  Den(At(t1,t2),v) = Den(t1,v)+Den(t2,v)
  Den(Mt(t1,t2),v) = Den(t1,v)*Den(t2,v)

rem 
  \para \bf  Free variables.  \end 

fun Fv 'Tex_f1_nt_fv'
  Fv Vt(i) = i,0
  Fv Ct(n) = 0
  Fv At(t1,t2) = Fv(t1)++Fv(t2)
  Fv Mt(t1,t2) = Fv(t1)++Fv(t2)

rem 
  \para \bf  Coincidence of assignments.  \end 
  \header* pred/3 Equiv 'Tex_p3_nt_equiv' \end 
  \eq* 
    Equiv(v1,v2,is) <-> \a i(i in is -> Sub(v1,i) = Sub(v2,i))
  \end

pred/3 Equiv 'Tex_p3_nt_equiv'
  Equiv(v1,v2,0)
  Equiv(v1,v2,i,is) <- Sub(v1,i) = Sub(v2,i) & Equiv(v1,v2,is)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Term(t) & Equiv(v1,v2,Fv(t)) -> Den(t,v1) = Den(t,v2)
  \end

thm Equiv_den_term
  Term(t) & Equiv(v1,v2,Fv(t)) -> Den(t,v1) = Den(t,v2)

rem 
  \para \bf  Subsection. Additive Normal Form.  \end 

rem 
  \para \bf  Multiplicative terms.  \end 

pred Mterm 
  Mterm Ct(n)
  Mterm Vt(i)
  Mterm Mt(t1,t2) <- Mterm(t1) & Mterm(t2)

rem 
  \para \it  [CL] Remark.  \end The predicate \ft Mterm \end is an inductive 
  predicate. 

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Mterm(t) -> Term(t)
  \end
  \para \it  Hint.  \end Prove the claim by \ft Mterm \end-induction. 

thm Mterm_is_term
  Mterm(t) -> Term(t)

rem 
  \para \bf  Terms in additive normal form.  \end 

pred Anf 
  Anf(t) <- Mterm(t)
  Anf(t) <- ~Mterm(t) & t = At(t1,t2) & Anf(t1) & Anf(t2)

rem 
  \para \it  [CL] Remark.  \end The predicate \ft Anf \end is an inductive 
  predicate. 

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Anf(t) -> Term(t)
  \end
  \para \it  Hint.  \end Prove the claim by \ft Anf \end-induction. 

thm Anf_is_term
  Anf(t) -> Term(t)

rem 
  \para \bf  Exercise.  \end \header* fun/2 Mul_ma  \end Define the function 
  \ft Mul_ma(s,t) \end such that 
  \eq* 
    Mterm(s) & Anf(t) -> Anf Mul_ma(s,t)
  \end
  \eq* 
    Mterm(s) & Anf(t) -> Den(Mul_ma(s,t),v) = Den(Mt(s,t),v)
  \end
  \para Verify your implementation! 

fun/2 Mul_ma 
  Mul_ma(s,t) = Foo <- Mterm(t)
  Mul_ma(s,t) = Foo <- ~Mterm(t) & t = At(t1,t2)

thm Mul_ma_anf
  Mterm(s) & Anf(t) -> Anf Mul_ma(s,t)

thm Mul_ma_den
  Mterm(s) & Anf(t) -> Den(Mul_ma(s,t),v) = Den(Mt(s,t),v)

rem 
  \para \bf  Exercise.  \end \header* fun/2 Mul_aa  \end Define the function 
  \ft Mul_aa(s,t) \end such that 
  \eq* 
    Anf(s) & Anf(t) -> Anf Mul_aa(s,t)
  \end
  \eq* 
    Anf(s) & Anf(t) -> Den(Mul_aa(s,t),v) = Den(Mt(s,t),v)
  \end
  \para Verify your implementation! 

fun/2 Mul_aa 
  Mul_aa(s,t) = Foo <- Mterm(s)
  Mul_aa(s,t) = Foo <- ~Mterm(s) & s = At(s1,s2)

thm Mul_aa_anf
  Anf(s) & Anf(t) -> Anf Mul_aa(s,t)

thm Mul_aa_den
  Anf(s) & Anf(t) -> Den(Mul_aa(s,t),v) = Den(Mt(s,t),v)

rem 
  \para \bf  Rearranging terms into additive normal form. \it  (bonus 2 points) 
   \end  \end Define the function \ft Anf_from(t) \end such that 
  \eq* 
    Term(t) -> Anf Anf_from(t)
  \end
  \eq* 
    Term(t) -> Den(Anf_from(t),v) = Den(t,v)
  \end
  \para Verify your implementation! 

fun Anf_from 
  Anf_from Vt(i) = Foo
  Anf_from Ct(n) = Foo
  Anf_from At(t1,t2) = Foo
  Anf_from Mt(t1,t2) = Foo

thm Anf_from_anf
  Term(t) -> Anf Anf_from(t)

thm Anf_from_den
  Term(t) -> Den(Anf_from(t),v) = Den(t,v)

rem 
  \para \bf  Subsection. Left Associated Addition.  \end 

rem 
  \para \bf  Terms with left associated addition.  \end 

pred Lassoc 
  Lassoc Vt(i)
  Lassoc Ct(n)
  Lassoc At(t,Vt(i)) <- Lassoc(t)
  Lassoc At(t,Ct(n)) <- Lassoc(t)
  Lassoc At(t,Mt(t1,t2)) <- Lassoc(t)
  Lassoc Mt(t1,t2)

rem 
  \para \bf  Rearranging terms into expressions with left associated addition. 
   \end 

fun Lassoc_from 
  Lassoc_from(t) = Foo

rem 
  \para \bf  Remark.  \end \header* fun M1 'Tex1_appl_mu_sb' \end Note that the 
  function \ft Lassoc_from(t) \end is defined by recursion with a suitable 
  measure \ft M1(t) \end: 

fun M1 'Tex1_appl_mu_sb'
  M1(t) = Foo

thm Condition_of_regularity_at_vt
  M1(t1) < M1 At(t1,Vt(i))

thm Condition_of_regularity_at_ct
  M1(t1) < M1 At(t1,Ct(n))

thm Condition_of_regularity_at_mt
  M1(t1) < M1 At(t1,Mt(t2,t3))

thm Condition_of_regularity_at_at
  M1 At(At(t1,t2),t3) < M1 At(t1,At(t2,t3))

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Term(t) -> Term Lassoc_from(t)
  \end
  \eq* 
    Term(t) -> Lassoc Lassoc_from(t)
  \end
  \eq* 
    Term(t) -> Den(Lassoc_from(t),v) = Den(t,v)
  \end

thm Lassoc_from_term
  Term(t) -> Term Lassoc_from(t)

thm Lassoc_from_lassoc
  Term(t) -> Lassoc Lassoc_from(t)

thm Lassoc_from_den
  Term(t) -> Den(Lassoc_from(t),v) = Den(t,v)

rem 
  \para \bf  Subsection. Postfix Machine.  \end 

rem 
  \para \bf  Instructions.  \end 

fun Vi 'Tex_f1_nt_vi'
  Vi(i) = 0,i

fun Ci 'Tex_f1_nt_ci'
  Ci(n) = 1,n

fun/0 Ai 'Tex_f0_nt_ai'
  Ai = 2,0

fun/0 Mi 'Tex_f0_nt_mi'
  Mi = 3,0

pred Instr 
  Instr Vi(i) <- N(i)
  Instr Ci(n) <- N(n)
  Instr(Ai)
  Instr(Mi)

rem 
  \para \bf  Programs.  \end 

pred Program 
  Program(0)
  Program(i,p) <- Instr(i) & Program(p)

rem 
  \para \bf  Compilation.  \end 

fun Cmp 
  Cmp Vt(i) = Foo
  Cmp Ct(n) = Foo
  Cmp At(t1,t2) = Foo
  Cmp Mt(t1,t2) = Foo

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Term(t) -> Program Cmp(t)
  \end

thm Cmp_program
  Term(t) -> Program Cmp(t)

rem 
  \para \bf  One-step evaluation.  \end 

fun/3 Run 
  Run(p,v,s) = Foo

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Term(t) -> Den(t,v) = Run(Cmp(t),v,0)
  \end

thm Den_run
  Term(t) -> Den(t,v) = Run(Cmp(t),v,0)

rem 
  \para \bf  Decompilation.  \end Define the function \ft Decmp(t) \end such 
  that 
  \eq* 
    Term(t) -> Decmp Cmp(t) = t
  \end
  \para Verify your implementation! 
  \para \it  Hint.  \end \header* fun/2 Decmp1 'Tex_f2_f' \end Define first an 
  auxiliary binary function \ft Decmp1(p,s) \end such that 
  \eq* 
    Term(t) -> Decmp1(Cmp(t)++p,s) = Decmp1(p,t,s)
  \end

fun/2 Decmp1 'Tex_f2_f'
  Decmp1(p,s) = Foo

fun Decmp 
  Decmp(p) = Foo

thm Invariant_decmp1
  Term(t) -> Decmp1(Cmp(t)++p,s) = Decmp1(p,t,s)
proof  proved.

thm Decmp_cmp
  Term(t) -> Decmp Cmp(t) = t

loc rem 
  ******************************************************************************
  ********************************* DEBUGGING **********************************
  ******************************************************************************

loc rem 
  \para \bf  Rearranging terms into additive normal form.  \end 

loc fun/0 T11 
  T11 = Mt(At(Vt(0),Vt(1)),At(Vt(1),Vt(2)))

loc fun/0 T12 
  T12 = Mt(Vt(0),Mt(Ct(2),At(Vt(0),Vt(1))))

loc fun/0 T13 
  T13 = 
  Mt(At(Mt(Vt(1),Vt(0)),At(Vt(2),Ct(10))),At(Mt(Ct(3),Vt(3)),At(Vt(4),Ct(4))))

loc rem 
  \para \bf  Rearranging terms into expressions with left associated addition. 
   \end 

loc fun/0 T21 
  T21 = At(Vt(1),At(Vt(2),Vt(3)))

loc fun/0 T22 
  T22 = At(At(Vt(1),Vt(2)),At(Vt(3),Vt(4)))

loc fun/0 T23 
  T23 = 
  At(At(Vt(1),At(Vt(2),At(Vt(3),Vt(4)))),At(Vt(5),At(Vt(6),At(Vt(7),Vt(8)))))

