mod Ex10 logic: 'cl'

incl Mtex

incl Mtexbt

incl Mtexg

incl Maux

loc rem 
  \para \bf  10. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21.2 
  \para* \it  Dátum:  \end štvrtok 15.5.2025 
  \para* \it  WWW:  \end 
  https://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/2425ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované týmto 
  témam: 
  \items 
   \item \para binárne stromy. 
  \end
  \para Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Počet bodov za úlohy v tomto súbore: 0 
   \item \para Počet bodov za prémiove úlohy v tomto súbore: 2 
  \end
  \para Odovzdať do 20.5.2025 (utorok). 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end Ján Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
   \item \para \it  [3]  \end Ján Komara. Recursive Functions. Online. 
  \end

rem 
  \para \bf  [CL] CL-TeX.  \end 

appldisp/1 Tex1_appl_mu_sb
  Prefix(80,0,Id(0,Ent('mu'),0),Fenced(Op('[',0),Arg(0),Op(']',0)))

rem 
  \para \bf  Chapter. Programs Operating on Trees.  \end 

rem 
  \para \bf  Section. Binary Trees.  \end 

rem 
  \para \bf  Subsection. Arithmetization of Binary Trees.  \end 

rem 
  \para \bf  Constructors of binary trees.  \end 

fun/0 E 'Tex_f0_bt_e'
  E = 0,0

fun/3 Nd 'Tex_f3_bt_nd'
  Nd(x,l,r) = 1,x,l,r

rem 
  \para \bf  [CL] Discrimination on the constructors of binary trees.  \end 
  Example(s): 
  \def 
    fun F 'Tex_f1_f'
    F(E) = Foo
    F Nd(x,l,r) = Foo
  \end

rem 
  \para \bf  Binary trees.  \end 

pred Bt 
  Bt(E)
  Bt Nd(x,l,r) <- N(x) & Bt(l) & Bt(r)

rem 
  \para \bf  [CL] Formatting the output.  \end Use the format \ft Bt \end to 
  display numbers as binary trees. Try out the following simple queries 
  \verbatim 
      171386336145149 = t:Bt
  \end
  \verbatim 
      1,10,(1,11,(0,0),0,0),(1,12,(0,0),0,0) = t:Bt
  \end

rem 
  \para \bf  [CL] Structural case analysis on binary trees.  \end Syntax: 
  \eq* 
    'case Bt ; <term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(Bt,t) \end 
         \eq* 
           Tex_f3_g_x_nrule(Tex_f1_g_x_assum Bt(t),
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,E),
                                              Tex_f1_g_x_assum Tex_f2_g_and(Tex_f2_g_eq(t,
                                                                                        Nd(x,
                                                                                           l,
                                                                                           r)),
                                                                            Tex_f2_g_and(Bt(l),
                                                                                         Bt(r)))),
                            Tex_f0_g_x_nothing)
         \end
         \para where \ft x \end, \ft l \end and \ft r \end are new variables 
         \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  Structural induction on binary trees.  \end Show that the principle 
  of structural induction over binary trees is admissible in Peano arithmetic. 
  \para \it  Remark.  \end Prove the claim for the special case in the following 
  theory. 
  \para \it  [CL] Hint.  \end Reduce structural induction on \ft t \end to 
  course of values induction with measure \ft |t| \end. Recall that the pair 
  size function \ft |x| \end, written as \it  |x|  \end, is defined in the 
  module \it  Standard  \end. 

theory Structural_induction_on_binary_trees

pred A 'Tex1_g_appl_phi_sb'

axiom Base_case
  A(E)

axiom Induction_step
  A(l) & A(r) -> A Nd(x,l,r)

thm Conclusion
  Bt(t) -> A(t)

end theory Structural_induction_on_binary_trees

rem 
  \para \bf  [CL] Structural induction on binary trees.  \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind Bt ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Bt,t) \end 
         \eq* 
           Tex_f3_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Bt(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(E),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(R(l),
                                                                                        R(r)),
                                                                           R Nd(x,
                                                                                l,
                                                                                r))),
                            Tex_f0_g_x_nothing)
         \end
         \para where \ft x \end, \ft l \end and \ft r \end are new variables 
         \it  (eigen-variables)  \end. 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Tex_f2_g_x_sc(Bt,t),a) \end 
         \eq* 
           Tex_f3_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Bt(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(E),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(Tex_f2_g_forall(a,
                                                                                                        R(l)),
                                                                                        Tex_f2_g_forall(a,
                                                                                                        R(r))),
                                                                           R Nd(x,
                                                                                l,
                                                                                r))),
                            Tex_f0_g_x_nothing)
         \end
         \para where \ft x \end, \ft l \end and \ft r \end are new variables 
         \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  [CL] Structural induction on binary trees (2nd form).  \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind* Bt ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_inds Tex_f2_g_x_sc(Bt,t) \end 
         \eq* 
           Tex_f3_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Bt(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(E),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(Bt(l),
                                                                                        Tex_f2_g_and(R(l),
                                                                                                     Tex_f2_g_and(Bt(r),
                                                                                                                  R(r)))),
                                                                           R Nd(x,
                                                                                l,
                                                                                r))),
                            Tex_f0_g_x_nothing)
         \end
         \para where \ft x \end, \ft l \end and \ft r \end are new variables 
         \it  (eigen-variables)  \end. 
   \item \para \ft Tex_f1_g_x_inds Tex_f2_g_x_sc(Tex_f2_g_x_sc(Bt,t),a) \end 
         \eq* 
           Tex_f3_g_x_nrule(Tex_f1_g_x_goal Tex_f2_g_imp(Bt(t),R(t)),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(E),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_and(Bt(l),
                                                                                        Tex_f2_g_and(Tex_f2_g_forall(a,
                                                                                                                     R(l)),
                                                                                                     Tex_f2_g_and(Bt(r),
                                                                                                                  Tex_f2_g_forall(a,
                                                                                                                                  R(r))))),
                                                                           R Nd(x,
                                                                                l,
                                                                                r))),
                            Tex_f0_g_x_nothing)
         \end
         \para where \ft x \end, \ft l \end and \ft r \end are new variables 
         \it  (eigen-variables)  \end. 
  \end

rem 
  \para \bf  Subsection. Basic Operations and Predicates.  \end 

rem 
  \para \bf  Size and depth of binary trees.  \end 

fun Sz 'Tex_f1_bt_sz'
  Sz(E) = 0
  Sz Nd(x,l,r) = Sz(l)+Sz(r)+1

fun Dp 'Tex_f1_bt_dp'
  Dp(E) = 0
  Dp Nd(x,l,r) = Max(Dp(l),Dp(r))+1

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Bt(t) -> Dp(t) <= Sz(t) & Sz(t) < Exp2 Dp(t)
  \end
  \para \it  [CL] Hint.  \end In the proof you will need the following simple 
  properties of the maximum function: 
  \eq Max_le
    Max(x,y) <= z <-> x <= z & y <= z
  \end
  \eq Spec_max_ge
    Max(x,y) >= x & Max(x,y) >= y
  \end
  \eq Exp2_max
    Exp2 Max(x,y) = Max(Exp2(x),Exp2(y))
  \end

thm Dp_sz
  Bt(t) -> Dp(t) <= Sz(t) & Sz(t) < Exp2 Dp(t)

rem 
  \para \bf  Membership in binary trees.  \end 

pred/2 Inbt 'Tex_p2_bt_in'
  Inbt(x,Nd(y,l,r)) <- x = y
  Inbt(x,Nd(y,l,r)) <- x != y & Inbt(x,l)
  Inbt(x,Nd(y,l,r)) <- x != y & ~Inbt(x,l) & Inbt(x,r)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    ~Inbt(x,E)
  \end
  \eq* 
    Inbt(x,Nd(y,l,r)) <-> x = y \/ Inbt(x,l) \/ Inbt(x,r)
  \end

thm Inbt_e
  ~Inbt(x,E)
proof  proved.

thm Inbt_nd
  Inbt(x,Nd(y,l,r)) <-> x = y \/ Inbt(x,l) \/ Inbt(x,r)

rem 
  \para \bf  Counting the labels in binary trees.  \end 

fun/2 Count 'Tex_f2_bt_count'
  Count(x,E) = 0
  Count(x,Nd(y,l,r)) = Count(x,l)+Count(x,r)+Eqf(x,y)

rem 
  \para \bf  Reflection function.  \end 

fun Reflect 
  Reflect(E) = E
  Reflect Nd(x,l,r) = Nd(x,Reflect(r),Reflect(l))

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Bt(t) -> Bt Reflect(t)
  \end
  \eq* 
    Bt(t) -> Sz Reflect(t) = Sz(t)
  \end
  \eq* 
    Bt(t) -> Dp Reflect(t) = Dp(t)
  \end
  \eq* 
    Bt(t) -> Inbt(x,Reflect(t)) <-> Inbt(x,t)
  \end
  \eq* 
    Bt(t) -> Count(x,Reflect(t)) = Count(x,t)
  \end
  \eq* 
    Bt(t) -> Reflect Reflect(t) = t
  \end
  \eq* 
    Bt(t1) & Bt(t2) & Reflect(t1) = Reflect(t2) -> t1 = t2
  \end
  \eq* 
    Bt(t1) -> \e t2 Reflect(t2) = t1
  \end

thm Reflect_bt
  Bt(t) -> Bt Reflect(t)

thm Reflect_sz
  Bt(t) -> Sz Reflect(t) = Sz(t)

thm Reflect_dp
  Bt(t) -> Dp Reflect(t) = Dp(t)

thm Reflect_inbt
  Bt(t) -> Inbt(x,Reflect(t)) <-> Inbt(x,t)

thm Reflect_count
  Bt(t) -> Count(x,Reflect(t)) = Count(x,t)

thm Reflect_reflect
  Bt(t) -> Reflect Reflect(t) = t

thm Reflect_injective
  Bt(t1) & Bt(t2) & Reflect(t1) = Reflect(t2) -> t1 = t2

thm Reflect_surjective
  Bt(t1) -> \e t2 Reflect(t2) = t1

rem 
  \para \bf  Subsection. Traversals of Binary Trees.  \end 

rem 
  \para \bf  Basic traversals of binary trees.  \end 

fun Preorder 
  Preorder(E) = 0
  Preorder Nd(x,l,r) = (x,0)++Preorder(l)++Preorder(r)

fun Inorder 
  Inorder(E) = 0
  Inorder Nd(x,l,r) = Inorder(l)++(x,0)++Inorder(r)

fun Postorder 
  Postorder(E) = 0
  Postorder Nd(x,l,r) = Postorder(l)++Postorder(r)++(x,0)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq [NH]
    Bt(t) -> Preorder(t) = Rev Postorder Reflect(t)
  \end
  \eq [MK]
    Bt(t) -> Postorder(t) = Rev Preorder Reflect(t)
  \end

thm Preorder_postorder
  Bt(t) -> Preorder(t) = Rev Postorder Reflect(t)

thm Postorder_preorder
  Bt(t) -> Postorder(t) = Rev Preorder Reflect(t)

rem 
  \para \bf  Fast programs for tree traversals.  \end 

rem 
  \para \bf  Case: preorder traversal.  \end 

fun/2 Preordera 'Tex_f2_f'
  Preordera(E,a) = a
  Preordera(Nd(x,l,r),a) = x,Preordera(l,Preordera(r,a))

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Bt(t) -> Preorder(t) = Preordera(t,0)
  \end

lemma Invariant_preordera
  Bt(t) -> Preordera(t,a) = Preorder(t)++a

thm Preorder_by_preordera
  Bt(t) -> Preorder(t) = Preordera(t,0)

rem 
  \para \bf  Case: inorder traversal.  \end 

rem 
  \para \bf  Exercise.  \end Save the concatenation in the definition of the 
  function \ft Inorder(t) \end with help of an accumulator function and verify 
  your implementation. 

fun/2 Inordera 'Tex_f2_f'
  Inordera(t,a) = Foo

thm Inorder_by_inordera
  Bt(t) -> Inorder(t) = Inordera(t,0)

rem 
  \para \bf  Case: postorder traversal.  \end 

rem 
  \para \bf  Exercise.  \end Save the concatenation in the definition of the 
  function \ft Postorder(t) \end with help of an accumulator function and verify 
  your implementation. 

fun/2 Postordera 'Tex_f2_f'
  Postordera(t,a) = Foo

thm Postorder_by_postordera
  Bt(t) -> Postorder(t) = Postordera(t,0)

rem 
  \para \bf  Subsection. Perfect Binary Trees.  \end 

rem 
  \para \bf  Perfect binary trees.  \end A binary tree \ft t \end is said to be 
  \it  perfect  \end if 
  \eq* 
    Sz(t)+1 = Exp2 Dp(t)
  \end

rem 
  \para \bf  Exercise.  \end \header* fun/2 Fs 'Tex_f2_f' \end Define the 
  function \ft Fs(n,x) \end such that 
  \eq* 
    Bt Fs(n,x)
  \end
  \eq* 
    Dp Fs(n,x) = n & Sz Fs(n,x)+1 = Exp2(n)
  \end
  \eq* 
    Inbt(y,Fs(n,x)) -> y = x
  \end

fun/2 Fs 'Tex_f2_f'
  Fs(0,x) = E
  Fs(n+1,x) = Nd(x,Fs(n,x),Fs(n,x))

thm Fs_bt
  Bt Fs(n,x)

thm Fs_perfect
  Dp Fs(n,x) = n & Sz Fs(n,x)+1 = Exp2(n)

thm Fs_inbt
  Inbt(y,Fs(n,x)) -> y = x

rem 
  \para \bf  Exercise.  \end \header* fun Fpr 'Tex_f1_f' \end Define the 
  function \ft Fpr(n) \end such that 
  \eq* 
    Bt Fpr(n)
  \end
  \eq* 
    Dp Fpr(n) = n & Sz Fpr(n)+1 = Exp2(n)
  \end
  \eq* 
    Preorder Fpr(n) = Interval(0,Exp2(n)-1)
  \end
  \para \it  Hint.  \end \header* fun/2 Fpr1 'Tex_f2_g' \end Define first an 
  auxiliary function \ft Fpr1(n,m) \end such that 
  \eq* 
    Bt Fpr1(n,m)
  \end
  \eq* 
    Dp Fpr1(n,m) = n & Sz Fpr1(n,m)+1 = Exp2(n)
  \end
  \eq* 
    Preorder Fpr1(n,m) = Interval(m,m+Exp2(n)-1)
  \end
  \para \it  [CL] Hint.  \end In the proof you will need the following property 
  of exponentiation 
  \eq Exp2_is_not_zero
    Exp2(x) != 0
  \end
  \para from the module \it  Maux*  \end. 

fun/2 Fpr1 'Tex_f2_g'
  Fpr1(0,m) = E
  Fpr1(n+1,m) = Nd(m,Fpr1(n,m+1),Fpr1(n,m+Exp2(n)))

fun Fpr 'Tex_f1_f'
  Fpr(n) = Fpr1(n,0)

lemma Fpr1_bt
  Bt Fpr1(n,m)

lemma Fpr1_perfect
  Dp Fpr1(n,m) = n & Sz Fpr1(n,m)+1 = Exp2(n)

lemma Fpr1_preorder
  Preorder Fpr1(n,m) = Interval(m,m+Exp2(n)-1)

thm Fpr_bt
  Bt Fpr(n)

thm Fpr_perfect
  Dp Fpr(n) = n & Sz Fpr(n)+1 = Exp2(n)

thm Fpr_preorder
  Preorder Fpr(n) = Interval(0,Exp2(n)-1)

rem 
  \para \bf  Exercise.  \end \header* fun Fin 'Tex_f1_f' \end Define the 
  function \ft Fin(n) \end such that 
  \eq* 
    Bt Fin(n)
  \end
  \eq* 
    Dp Fin(n) = n & Sz Fin(n)+1 = Exp2(n)
  \end
  \eq* 
    Inorder Fin(n) = Interval(0,Exp2(n)-1)
  \end

fun/2 Fin1 'Tex_f2_g'
  Fin1(n,m) = Foo

fun Fin 'Tex_f1_f'
  Fin(n) = Foo

thm Fin_bt
  Bt Fin(n)

thm Fin_perfect
  Dp Fin(n) = n & Sz Fin(n)+1 = Exp2(n)

thm Fin_inorder
  Inorder Fin(n) = Interval(0,Exp2(n)-1)

rem 
  \para \bf  Exercise.  \end \header* fun Fpo 'Tex_f1_f' \end Define the 
  function \ft Fpo(n) \end such that 
  \eq* 
    Bt Fpo(n)
  \end
  \eq* 
    Dp Fpo(n) = n & Sz Fpo(n)+1 = Exp2(n)
  \end
  \eq* 
    Postorder Fpo(n) = Interval(0,Exp2(n)-1)
  \end

fun/2 Fpo1 'Tex_f2_g'
  Fpo1(n,m) = Foo

fun Fpo 'Tex_f1_f'
  Fpo(n) = Foo

thm Fpo_bt
  Bt Fpo(n)

thm Fpo_perfect
  Dp Fpo(n) = n & Sz Fpo(n)+1 = Exp2(n)

thm Fpo_postorder
  Postorder Fpo(n) = Interval(0,Exp2(n)-1)

rem 
  \para \bf  Subsection. Tree Numberings.  \end 

rem 
  \para \bf  Problem.  \end Given a tree, create a new tree of the same shape, 
  but with the values at the nodes replaced by the numbers 0,1,2... in a fixed 
  order. 

rem 
  \para \bf  Isomorphic binary trees.  \end 
  \header* pred/2 Isomorphic 'Tex_p2_bt_isomorphic' \end Given binary trees 
  \ft t1 \end and \ft t2 \end, the predicate \ft Isomorphic(t1,t2) \end holds if 
  the trees \ft t1 \end and \ft t2 \end are isomorphic (of the same shape). 

pred/2 Isomorphic 'Tex_p2_bt_isomorphic'
  Isomorphic(E,E)
  Isomorphic(Nd(x1,l1,r1),Nd(x2,l2,r2)) <- Isomorphic(l1,l2) & Isomorphic(r1,r2)

rem 
  \para \bf  Exercise.  \end \header* fun Npr 'Tex_f1_f' \end Define the 
  function \ft Npr(t) \end such that 
  \eq* 
    Bt(t) -> Isomorphic(Npr(t),t)
  \end
  \eq* 
    Bt(t) -> Preorder Npr(t) = Interval(0,Sz(t))
  \end
  \para Verify your implementation! 
  \para \it  Remark.  \end Implement the function with the help of the size 
  function \ft Sz(t) \end. 
  \para \it  Hint.  \end \header* fun/2 Npr1 'Tex_f2_g' \end Define first an 
  auxiliary function \ft Npr1(t,m) \end such that 
  \eq* 
    Bt(t) -> Isomorphic(Npr1(t,m),t)
  \end
  \eq* 
    Bt(t) -> Preorder Npr1(t,m) = Interval(m,m+Sz(t))
  \end

rem 
  \para \it  Implementation.  \end 

fun/2 Npr1 'Tex_f2_g'
  Npr1(E,m) = E
  Npr1(Nd(x,l,r),m) = Nd(m,Npr1(l,m+1),Npr1(r,m+Sz(l)+1))

fun Npr 'Tex_f1_f'
  Npr(t) = Npr1(t,0)

rem 
  \para \it  Verification.  \end 

lemma Npr1_isomorphic
  Bt(t) -> Isomorphic(Npr1(t,m),t)

lemma Npr1_preorder
  Bt(t) -> Preorder Npr1(t,m) = Interval(m,m+Sz(t))

thm Npr_isomorphic
  Bt(t) -> Isomorphic(Npr(t),t)

thm Npr_preorder
  Bt(t) -> Preorder Npr(t) = Interval(0,Sz(t))

rem 
  \para \bf  Exercise.  \end \header* fun Nin 'Tex_f1_f' \end Define the 
  function \ft Nin(t) \end such that 
  \eq* 
    Bt(t) -> Isomorphic(Nin(t),t)
  \end
  \eq* 
    Bt(t) -> Inorder Nin(t) = Interval(0,Sz(t))
  \end
  \para Verify your implementation! 
  \para \it  Remark.  \end Implement the function with the help of the size 
  function \ft Sz(t) \end. 

rem 
  \para \it  Implementation.  \end 

fun/2 Nin1 'Tex_f2_g'
  Nin1(t,m) = Foo

fun Nin 'Tex_f1_f'
  Nin(t) = Foo

rem 
  \para \it  Verification.  \end 

thm Nin_isomorphic
  Bt(t) -> Isomorphic(Nin(t),t)

thm Nin_inorder
  Bt(t) -> Inorder Nin(t) = Interval(0,Sz(t))

rem 
  \para \bf  Exercise.  \end \header* fun Npo 'Tex_f1_f' \end Define the 
  function \ft Npo(t) \end such that 
  \eq* 
    Bt(t) -> Isomorphic(Npo(t),t)
  \end
  \eq* 
    Bt(t) -> Postorder Npo(t) = Interval(0,Sz(t))
  \end
  \para Verify your implementation! 
  \para \it  Remark.  \end Implement the function with the help of the size 
  function \ft Sz(t) \end. 

rem 
  \para \it  Implementation.  \end 

fun/2 Npo1 'Tex_f2_g'
  Npo1(t,m) = Foo

fun Npo 'Tex_f1_f'
  Npo(t) = Foo

rem 
  \para \it  Verification.  \end 

thm Npo_isomorphic
  Bt(t) -> Isomorphic(Npo(t),t)

thm Npo_postorder
  Bt(t) -> Postorder Npo(t) = Interval(0,Sz(t))

rem 
  \para \bf  Subsection. Flattened Trees.  \end 

pred Flattened 
  Flattened(E)
  Flattened Nd(x,l,E) <- Flattened(l)

rem 
  \para \bf  Exercise. \it  (bonus 2 points)  \end  \end Define the function 
  \ft Flatten(t) \end such that 
  \eq* 
    Bt(t) -> Flattened Flatten(t)
  \end
  \eq* 
    Bt(t) -> Count(x,Flatten(t)) = Count(x,t)
  \end
  \para Do not use auxiliary functions! 

fun Flatten 
  Flatten(E) = Foo
  Flatten Nd(x,l,E) = Foo
  Flatten Nd(x,l,Nd(y,lr,rr)) = Foo

rem 
  \para \bf  Remark.  \end \header* fun M1 'Tex1_appl_mu_sb' \end Prove the 
  conditions of regularity for a suitable measure \ft M1(t) \end. 

fun M1 'Tex1_appl_mu_sb'
  M1(t) = Foo

thm Condition_of_regularity_e
  M1 Nd(x,l,E) > M1(l)

thm Condition_of_regularity_nd
  M1 Nd(x,l,Nd(y,lr,rr)) > M1 Nd(y,Nd(x,l,lr),rr)

rem 
  \para \bf  Exercise.  \end Prove that the function satisfies the required 
  properties. 

thm Flatten_flattened
  Bt(t) -> Flattened Flatten(t)

thm Flatten_count
  Bt(t) -> Count(x,Flatten(t)) = Count(x,t)

loc rem 
  ******************************************************************************
  ********************************* DEBUGGING **********************************
  ******************************************************************************

loc rem 
  \para \bf  Building a tree.  \end The function \ft Ln2bt(x) \end converts a 
  list of labels into a balanced binary tree. Use the operation to test your 
  solutions. 

loc fun L 
  L(0) = 0
  L(v,w) = L(w)+1

loc fun/2 Take 
  Take(0,x) = 0
  Take(n+1,v,w) = v,Take(n,w)

loc fun/2 Drop 
  Drop(0,x) = x
  Drop(n+1,v,w) = Drop(n,w)

loc fun/2 Ln2bt1 'Tex_f2_f'
  Ln2bt1(0,x) = E
  Ln2bt1(S1(n),v,w) = Nd(v,Ln2bt1(n,Take(n,w)),Ln2bt1(n,Drop(n,w)))
  Ln2bt1(S2(n),v,w) = Nd(v,Ln2bt1(n+1,Take(n+1,w)),Ln2bt1(n,Drop(n+1,w)))

loc fun Ln2bt 
  Ln2bt(x) = Ln2bt1(L(x),x)

