mod Mauxc logic: 'cl'

incl Mtex

incl Mtexln

rem 
  \para \bf  List length.  \end 

fun L 
  L(0) = 0
  L(v,w) = L(w)+1

thm L_is_zero
  L(x) = 0 <-> x = 0
proof 
 case Ln; x @ 0; v,w
  proved
  proved..

thm L_conc
  L(x++y) = L(x)+L(y)
proof 
 ind Ln; x @ 0; v,w
  proved
  proved..

rem 
  \para \bf  List indexing.  \end 

fun/2 Sub 'Tex_f2_ln_sub'
  Sub(x,0) = v <- x = v,w
  Sub(x,i+1) = Sub(w,i) <- x = v,w

loc rem 
  \para \bf  List membership.  \end 

lemma In_expl_sub
  x in y <-> \e i(i < L(y) & Sub(y,i) = x)
proof 
 ind Ln; y @ 0; v,w
  proved
  weak x in w <-> \e i(i < L(w) & Sub(w,i) = x)
   split* x = v \/ \e i(i < L(w) & Sub(w,i) = x) <-> 
          \e i(i <= L(w) & Sub((v,w),i) = x).2,(1,(4,0,0,0),0),0
    weak x = v
     inst* \e i(i <= L(w) & Sub((v,w),i) = v); 0 proved..
    eigen \e i(i < L(w) & Sub(w,i) = x).0; i
     inst* \e i1(i1 <= L(w) & Sub((v,w),i1) = x); i+1 proved..
    eigen \e i(i <= L(w) & Sub((v,w),i) = x).0; i
     case N; i @ 0; j
      proved
      weak* x = v
       inst* \e i1(i1 < L(w) & Sub(w,i1) = x); j proved........

lemma In_expl_conc
  x in y <-> \e z1\e z2 y = z1++(x,z2)
proof 
 ind Ln; y @ 0; v,w
  proved
  weak x in w <-> \e z1\e z2 w = z1++(x,z2)
   split* x = v \/ \e z1\e z2 w = z1++(x,z2) <-> \e z1\e z2 v,w = z1++(x,z2).2,
                                                                             (1,
                                                                              (4,
                                                                               0,
                                                                               0,
                                                                               0),
                                                                              0),
                                                                             0
    weak x = v
     inst* \e z1\e z2 v,w = z1++(v,z2); 0; w proved..
    eigen \e z1\e z2 w = z1++(x,z2); z1,z2
     weak w = z1++(x,z2)
      inst* \e z3\e z4 v,z1++(x,z2) = z3++(x,z4); v,z1; z2 proved...
    eigen \e z1\e z2 v,w = z1++(x,z2); z1,z2
     case Ln; z1 @ 0; v1,w1
      proved
      weak z1 = v1,w1
       weak v = v1
        weak* x = v1
         weak w = w1++(x,z2)
          inst* \e z1\e z3 w1++(x,z2) = z1++(x,z3); w1; z2 proved...........

rem 
  \para \bf  Counting the number of occurrences in lists.  \end 

fun/2 Eqf 'Tex_f2_n_char_eqf'
  Eqf(x,y) = 1 <- x = y
  Eqf(x,y) = 0 <- x != y

fun/2 Count 'Tex_f2_ln_count'
  Count(a,0) = 0
  Count(a,v,w) = Count(a,w)+Eqf(a,v)

lemma Count_is_zero
  \a a Count(a,x) = 0 <-> x = 0
proof 
 case Ln; x @ 0; v,w
  proved
  weak x = v,w
   weak* ~\a a Count(a,w) = 0
    inst* ~\a a Eqf(a,v) = 0; v proved.....

lemma Count_in
  a in x <-> Count(a,x) != 0
proof 
 ind Ln; x @ 0; v,w
  proved
  cut a = v
   proved
   proved...

lemma Count_conc
  Count(a,x++y) = Count(a,x)+Count(a,y)
proof 
 ind Ln; x @ 0; v,w
  proved
  proved..

lemma Count_conc_elem
  Count(a,x++(a,y)) = Count(a,x++y)+1 & 
  (a != b -> Count(a,x++(b,y)) = Count(a,x++y))
proof 
 split* Count(a,x++(a,y)) = Count(a,x++y)+1 & 
        (a != b -> Count(a,x++(b,y)) = Count(a,x++y)).4,0,0,0
  use Count_conc; a; x; a,y
   use Count_conc; a; x; y proved..
  use Count_conc; a; x; b,y
   use Count_conc; a; x; y proved....

rem 
  \para \bf  Definition and basic properties of permutations.  \end 

pred/2 Perm 'Tex_p2_ln_perm'
  Perm(x,y) <-> \a a Count(a,x) = Count(a,y)

rem 
  \para \it  Permutation is an equivalence relation.  \end 

thm Perm_refl
  Perm(x,x)
proof 
 exp Perm; x,x proved..

thm Perm_sym
  Perm(x,y) -> Perm(y,x)
proof 
 exp Perm; x,y
  exp Perm; y,x proved...

thm Perm_trans
  Perm(x,y) & Perm(y,z) -> Perm(x,z)
proof 
 exp Perm; x,y
  exp Perm; y,z
   exp Perm; x,z
    eigen* \a a Count(a,x) = Count(a,z); a
     inst \a a Count(a,x) = Count(a,y); a
      inst \a a Count(a,y) = Count(a,z); a proved.......

rem 
  \para \it  Congruence properties of permutations.  \end 

thm Perm_pair
  Perm(x,y) -> Perm((a,x),a,y)
proof 
 exp Perm; (a,x),a,y
  exp Perm; x,y proved...

thm Perm_conc
  Perm(x1,y1) & Perm(x2,y2) -> Perm(x1++x2,y1++y2)
proof 
 exp Perm; x1,y1
  exp Perm; x2,y2
   exp Perm; x1++x2,y1++y2
    eigen* \a a Count(a,x1++x2) = Count(a,y1++y2); a
     use Count_conc; a; x1; x2
      use Count_conc; a; y1; y2
       inst \a a Count(a,x1) = Count(a,y1); a
        inst \a a Count(a,x2) = Count(a,y2); a proved.........

lemma Lemma_perm_in
  Perm(x,y) & a in x -> a in y
proof 
 use Count_in.0; a; y
  weak a in y <-> Count(a,y) != 0
   use Count_in.2,0,0; a; x
    use Perm.2,0,0:0,2,1,0; x; y; a proved.....

thm Perm_in
  Perm(x,y) -> a in x <-> a in y
proof 
 split* a in x <-> a in y.2,0,0
  use Lemma_perm_in; x; y; a proved.
  use Lemma_perm_in; y; x; a
   use Perm_sym; x; y proved....

lemma Lemma_perm_zero_left
  Perm(0,y) <-> y = 0
proof 
 exp Perm; 0,y
  use Count_is_zero.0; y proved...

lemma Lemma_perm_cancel_conc_elem
  Perm(x1++(a,x2),y1++(a,y2)) <-> Perm(x1++x2,y1++y2)
proof 
 split* Perm(x1++(a,x2),y1++(a,y2)) <-> Perm(x1++x2,y1++y2).2,0,0
  exp Perm; x1++x2,y1++y2
   eigen* \a a1 Count(a1,x1++x2) = Count(a1,y1++y2); b
    cut a = b
     weak a = b
      use Perm.2,0,0:0,2,1,0; x1++(b,x2); y1++(b,y2); b
       weak Perm(x1++(b,x2),y1++(b,y2))
        use Count_conc_elem.4,0,0; b; x1; x2
         use Count_conc_elem.4,0,0; b; y1; y2 proved.....
     use Perm.2,0,0:0,2,1,0; x1++(a,x2); y1++(a,y2); b
      weak Perm(x1++(a,x2),y1++(a,y2))
       use Count_conc_elem.4,1,0; b; x1; x2; a
        use Count_conc_elem.4,1,0; b; y1; y2; a proved.......
  exp Perm; x1++(a,x2),y1++(a,y2)
   eigen* \a a1 Count(a1,x1++(a,x2)) = Count(a1,y1++(a,y2)); b
    cut a = b
     weak a = b
      use Count_conc_elem.4,0,0; b; x1; x2
       weak Count(b,x1++(b,x2)) = Count(b,x1++x2)+1
        use Count_conc_elem.4,0,0; b; y1; y2
         weak Count(b,y1++(b,y2)) = Count(b,y1++y2)+1
          use Perm.2,0,0:0,2,1,0; x1++x2; y1++y2; b proved......
     use Count_conc_elem.4,1,0; b; x1; x2; a
      weak Count(b,x1++(a,x2)) = Count(b,x1++x2)
       use Count_conc_elem.4,1,0; b; y1; y2; a
        weak Count(b,y1++(a,y2)) = Count(b,y1++y2)
         use Perm.2,0,0:0,2,1,0; x1++x2; y1++y2; b proved..........

lemma Lemma_perm_pair_left_conc
  Perm((v,w),y) <-> \e z1\e z2(y = z1++(v,z2) & Perm(w,z1++z2))
proof 
 split* Perm((v,w),y) <-> \e z1\e z2(y = z1++(v,z2) & Perm(w,z1++z2)).2,0,0
  use Perm_in.1,0,2,0,0; v,w; y; v
   use In_expl_conc.2,0,0; v; y
    weak v in y
     eigen \e z1\e z2 y = z1++(v,z2); z1,z2
      weak y = z1++(v,z2)
       use Lemma_perm_cancel_conc_elem.0; 0; v; w; z1; z2
        weak Perm((v,w),z1++(v,z2))
         inst* \e z3\e z4(z1++(v,z2) = z3++(v,z4) & Perm(w,z3++z4)); z1; z2 proved........
  eigen \e z1\e z2(y = z1++(v,z2) & Perm(w,z1++z2)).0; z1,z2
   weak y = z1++(v,z2)
    use Lemma_perm_cancel_conc_elem.0; 0; v; w; z1; z2 proved.....

thm Perm_l
  Perm(x,y) -> L(x) = L(y)
proof 
 ind Ln; x; y @ 0; v,w
  use Lemma_perm_zero_left.2,0,0; y proved.
  use Lemma_perm_pair_left_conc.2,0,0; v; w; y
   weak Perm((v,w),y)
    eigen \e z1\e z2(y = z1++(v,z2) & Perm(w,z1++z2)).0; z1,z2
     weak y = z1++(v,z2)
      use L_conc; z1; v,z2
       weak L(z1++(v,z2)) = L(z1)+L(z2)+1
        inst \a y(Perm(w,y) -> L(w) = L(y)); z1++z2
         use L_conc; z1; z2 proved..........

rem 
  \para \it  Remaining properties of permutations.  \end 

thm Perm_zero_right
  Perm(x,0) <-> x = 0
proof 
 exp Perm; x,0
  use Count_is_zero.0; x proved...

thm Perm_zero_left
  Perm(0,y) <-> y = 0
proof 
 exp Perm; 0,y
  use Count_is_zero.0; y proved...

thm Perm_exchange
  Perm((a,b,x),b,a,x)
proof 
 exp Perm; (a,b,x),b,a,x proved..

thm Perm_cancel_conc_elem
  Perm(x1++(a,x2),y1++(a,y2)) <-> Perm(x1++x2,y1++y2)
proof 
 use Lemma_perm_cancel_conc_elem.0; x1; a; x2; y1; y2 proved..

rem 
  \para \bf  Definition and basic properties of list comparision predicates. 
   \end 

pred/2 Le 'Tex_p2_ln_le'
  Le(a,0)
  Le(a,v,w) <- a <= v & Le(a,w)

thm Le_mono
  a <= b & Le(b,x) -> Le(a,x)
proof 
 ind Ln; x @ 0; v,w
  proved
  proved..

rem 
  \para \bf  Definition and basic properties of ordered lists.  \end 

pred Ord 
  Ord(0)
  Ord(v,w) <- Le(v,w) & Ord(w)

