mod Mauxb logic: 'cl'

incl Mtex

incl Mtexln

rem 
  \para \bf  Characteristic function.  \end 

fun/2 Eqf 'Tex_f2_n_char_eqf'
  Eqf(x,y) = 1 <- x = y
  Eqf(x,y) = 0 <- x != y

rem 
  \para \bf  Minimum and maximum.  \end 

fun/2 Min 'Tex_f2_n_min'
  Min(x,y) = x <- x <= y
  Min(x,y) = y <- x > y

fun/2 Max 'Tex_f2_n_max'
  Max(x,y) = x <- x >= y
  Max(x,y) = y <- x < y

thm Spec_min
  Min(x,y) <= x & Min(x,y) <= y & (Min(x,y) = x \/ Min(x,y) = y)
proof 
 case Dich; x,y @ x1,y1; x1,y1
  proved
  proved..

thm Spec_max
  Max(x,y) >= x & Max(x,y) >= y & (Max(x,y) = x \/ Max(x,y) = y)
proof 
 case Dich; y,x @ x1,y1; x1,y1
  proved
  proved..

rem 
  \para \bf  Lists.  \end 

fun L 
  L(0) = 0
  L(v,w) = L(w)+1

thm L_is_zero
  L(x) = 0 <-> x = 0
proof 
 case Ln; x @ 0; v,w
  proved
  proved..

thm L_conc
  L(x++y) = L(x)+L(y)
proof 
 ind Ln; x @ 0; v,w
  proved
  proved..

fun/2 Sub 'Tex_f2_ln_sub'
  Sub(x,0) = v <- x = v,w
  Sub(x,i+1) = Sub(w,i) <- x = v,w

