mod Ex09c logic: 'cl'

incl Mtex

incl Mtexln

incl Mauxc

loc rem 
  \para \bf  9. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21.2 
  \para* \it  Dátum:  \end štvrtok 24.4.2025 
  \para* \it  WWW:  \end 
  https://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/2425ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované týmto 
  témam: 
  \items 
   \item \para zoznamy, 
   \item \para operácie na zoznamoch, 
   \item \para triedenie zoznamov. 
  \end
  \para Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Počet bodov za úlohy v tomto súbore: 0 
   \item \para Počet bodov za prémiove úlohy v tomto súbore: 2 
  \end
  \para Odovzdať do 25.4.2025 (utorok). 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end Ján Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
   \item \para \it  [3]  \end Ján Komara. Recursive Functions. Online. 
  \end

rem 
  \para \bf  Chapter. Programs Operating on Lists.  \end 

rem 
  \para \bf  Section. Sorting of Lists.  \end 

rem 
  \para \bf  [CL] Remark.  \end See the auxiliary module \it  Maux*  \end. 

rem 
  \para \bf  Subsection. Insertion Sort.  \end 

rem 
  \para \bf  Insertion function.  \end 

fun/2 Insert 
  Insert(a,0) = a,0
  Insert(a,v,w) = a,v,w <- a <= v
  Insert(a,v,w) = v,Insert(a,w) <- a > v

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Perm(Insert(a,x),a,x)
  \end
  \eq* 
    Ord(x) -> Ord Insert(a,x)
  \end

lemma Lemma_insert_perm
  Perm(i,a,w) -> Perm((v,i),a,v,w)
proof 
 use Perm_cancel_conc_elem.0; 0; v; i; a,0; w proved..

thm Insert_perm
  Perm(Insert(a,x),a,x)

lemma Insert_le
  b <= a & Le(b,x) -> Le(b,Insert(a,x))

thm Insert_ord
  Ord(x) -> Ord Insert(a,x)

rem 
  \para \bf  Insertion sort.  \end 

fun Isort 
  Isort(0) = 0
  Isort(v,w) = Insert(v,Isort(w))

rem 
  \para \bf  Exercise. \it  (bonus 2 points)  \end  \end Prove 
  \eq* 
    Perm(Isort(x),x)
  \end
  \eq* 
    Ord Isort(x)
  \end

lemma Lemma_isort_perm
  Perm(iw,w) & Perm(ivw,v,iw) -> Perm(ivw,v,w)
proof 
 use Perm_trans; ivw; v,iw; v,w
  use Perm_pair; iw; w; v proved...

thm Isort_perm
  Perm(Isort(x),x)

thm Isort_ord
  Ord Isort(x)

