mod Ex09a logic: 'cl'

incl Mtex

incl Mtexg

incl Mtexln

loc rem 
  \para \bf  9. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21.2 
  \para* \it  Dátum:  \end štvrtok 24.4.2025 
  \para* \it  WWW:  \end 
  https://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/2425ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované týmto 
  témam: 
  \items 
   \item \para zoznamy, 
   \item \para operácie na zoznamoch, 
   \item \para triedenie zoznamov. 
  \end
  \para Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Počet bodov za úlohy v tomto súbore: 0 
   \item \para Počet bodov za prémiove úlohy v tomto súbore: 0 
  \end
  \para Odovzdať do 25.4.2025 (utorok). 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end Ján Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
   \item \para \it  [3]  \end Ján Komara. Recursive Functions. Online. 
  \end

rem 
  \para \bf  [CL] CL-TeX.  \end 

appldisp/1 Tex1_paren
  Fenced(Op('(',0),Arg(0),Op(')',0))

rem 
  \para \bf  Chapter. Programs Operating on Lists.  \end 

rem 
  \para \bf  Section. Lists.  \end 

rem 
  \para \bf  [CL] Structural case analysis on lists.  \end Syntax: 
  \eq* 
    'case Ln ; <term>'
  \end
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_case Tex_f2_g_x_sc(Ln,t) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f0_g_x_nothing,
                            Tex_f2_g_x_branch(Tex_f1_g_x_assum Tex_f2_g_eq(t,0),
                                              Tex_f1_g_x_assum Tex_f2_g_eq(t,v,w)))
         \end
         \para where \ft v \end and \ft w \end are new variables \it  
         (eigen-variables)  \end. 
  \end
  \para The predicate \ft Ln \end is defined in the module \it  Standard  \end. 

rem 
  \para \bf  [CL] Structural induction on lists.  \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'ind Ln ; <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Ln,x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(R(w),
                                                                           R(v,w))))
         \end
   \item \para \ft Tex_f1_g_x_ind Tex_f2_g_x_sc(Tex_f2_g_x_sc(Ln,x),a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f2_g_x_branch(Tex_f1_g_x_goal R(0),
                                              Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(a,
                                                                                           R(w)),
                                                                           R(v,w))))
         \end
  \end
  \para The predicate \ft Ln \end is defined in the module \it  Standard  \end. 

rem 
  \para \bf  List length.  \end 

fun L 
  L(0) = 0
  L(v,w) = L(w)+1

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    L(x) = 0 <-> x = 0
  \end
  \eq* 
    \e x L(x) = n
  \end

thm L_is_zero
  L(x) = 0 <-> x = 0

thm L_surjective
  \e x L(x) = n

rem 
  \para \bf  List indexing.  \end 

fun/2 Sub 'Tex_f2_ln_sub'
  Sub(x,0) = v <- x = v,w
  Sub(x,i+1) = Sub(w,i) <- x = v,w

rem 
  \para \bf  Remark.  \end Note that by default 
  \eq* 
    Sub(0,i) = 0
  \end

thm Sub_default
  Sub(0,i) = 0

rem 
  \para \bf  List concatenation.  \end The list concatenation function 
  \ft x++y \end, written as \it  x++y  \end, is defined in the module 
  \ft Standard \end and the following properties are built in into the CL 
  theorem prover: 
  \eq* 
    0++y = y
  \end
  \eq* 
    (v,w)++y = v,w++y
  \end
  \eq* 
    x++y = 0 <-> x = 0 & y = 0
  \end
  \eq* 
    x++0 = x
  \end
  \eq* 
    x++(y++z) = x++y++z
  \end
  \eq* 
    x++y = x++z <-> y = z
  \end
  \eq* 
    x++(a,0) = y++(b,0) <-> x = y & a = b
  \end
  \eq* 
    x++z = y++z <-> x = y
  \end
  \eq* 
    x++y = a,0 -> x = a,0 & y = 0 \/ x = 0 & y = a,0
  \end
  \eq* 
    x++(a,y) = a,0 <-> x = 0 & y = 0
  \end
  \eq* 
    x++a++y = a,0 <-> a = 0 & x++y = 0,0
  \end
  \para We write \ft x++y++z \end as an abbreviation for 
  \ft Tex1_paren(x++y)++z \end. 

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    L(x++y) = L(x)+L(y)
  \end
  \eq* 
    i < L(x) -> Sub(x++y,i) = Sub(x,i)
  \end
  \eq* 
    i < L(y) -> Sub(x++y,L(x)+i) = Sub(y,i)
  \end
  \eq* 
    x != 0 <-> \e y\e a x = y++(a,0)
  \end

thm Conc_l
  L(x++y) = L(x)+L(y)

thm Conc_sub_left
  i < L(x) -> Sub(x++y,i) = Sub(x,i)

thm Conc_sub_right
  i < L(y) -> Sub(x++y,L(x)+i) = Sub(y,i)

thm Conc_nzero
  x != 0 <-> \e y\e a x = y++(a,0)

rem 
  \para \bf  List membership.  \end The list membership predicate 
  \ft x in y \end written as \it  x in y  \end, is defined in the module 
  \ft Standard \end. The following properties are built in into the CL theorem 
  prover: 
  \eq* 
    x !in 0
  \end
  \eq* 
    x in v,w <-> x = v \/ x in w
  \end
  \eq* 
    x in y++z <-> x in y \/ x in z
  \end
  \para Note that the negation \ft x !in y \end is written as \it  x !in y 
   \end. 

rem 
  \para \bf  List reversal.  \end 

fun Rev 
  Rev(0) = 0
  Rev(v,w) = Rev(w)++(v,0)

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    Rev(x) = 0 <-> x = 0
  \end
  \eq* 
    Rev(x++y) = Rev(y)++Rev(x)
  \end
  \eq* 
    Rev Rev(x) = x
  \end
  \eq* 
    Rev(x) = Rev(y) -> x = y
  \end
  \eq* 
    \e y Rev(y) = x
  \end
  \eq* 
    x in Rev(y) <-> x in y
  \end
  \eq* 
    L Rev(x) = L(x)
  \end

thm Rev_is_zero
  Rev(x) = 0 <-> x = 0

thm Rev_conc
  Rev(x++y) = Rev(y)++Rev(x)

thm Rev_rev
  Rev Rev(x) = x

thm Rev_injective
  Rev(x) = Rev(y) -> x = y

thm Rev_surjective
  \e y Rev(y) = x

thm Rev_in
  x in Rev(y) <-> x in y

thm Rev_l
  L Rev(x) = L(x)

rem 
  \para \bf  Fast list reversal.  \end 

fun/2 Reva 'Tex_f2_f'
  Reva(0,a) = a
  Reva((v,w),a) = Reva(w,v,a)

rem 
  \para Prove 
  \eq* 
    Rev(x) = Reva(x,0)
  \end

thm Rev_by_reva
  Rev(x) = Reva(x,0)

