mod Ex08b logic: 'cl'

incl Mtex

incl Mtexg

incl Maux

loc rem 
  \para \bf  8. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21.2 
  \para* \it  Dátum:  \end štvrtok 10.4.2025 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/2425ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované týmto 
  témam: 
  \items 
   \item \para primitívna rekurzia, 
   \item \para 'course-of-values' rekurzia, 
   \item \para rekurzia s mierou, 
   \item \para iteratívna rekurzia. 
  \end
  \para Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Počet bodov za úlohy v tomto súbore: 2 
   \item \para Počet bodov za prémiove úlohy v tomto súbore: 0 
  \end
  \para Odovzdať do 15.4.2025 (utorok). 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end Ján Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
   \item \para \it  [3]  \end Ján Komara. Recursive Functions. Online. 
  \end

rem 
  \para \bf  Chapter. Numeric Programs.  \end 

rem 
  \para \bf  Section. Course of Values Recursion.  \end 

rem 
  \para \bf  Complete mathematical induction. \it  (1 point)  \end  \end Show 
  that the principle of complete mathematical induction (course of values 
  induction) is admissible in Peano arithmetic. 
  \para \it  Remark.  \end Prove the claim for the special case in the following 
  theory. 

theory Complete_mathematical_induction

pred A 'Tex1_g_appl_phi_sb'

axiom Progressivity
  \a x(\a y(y < x -> A(y)) -> A(x))

lemma Lemma
  \a z(z < n -> A(z))

thm Conclusion
  A(x)

end theory Complete_mathematical_induction

rem 
  \para \bf  [CL] Complete mathematical induction.  \end 
  \header* fun R 'Tex1_g_appl_phi_sb' \end Syntax: 
  \eq* 
    'indm <variable> [; <variable(s)>]'
  \end
  \para where the induction formula is formed from the current sequent. 
  \para Example(s): 
  \items 
   \item \para \ft Tex_f1_g_x_indm(x) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(y,
                                                                         Tex_f2_g_imp(Tex_f2_g_lt(y,
                                                                                                  x),
                                                                                      R(y))),
                                                         R(x)))
         \end
   \item \para \ft Tex_f1_g_x_indm Tex_f2_g_x_sc(x,a) \end 
         \eq* 
           Tex_f2_g_x_nrule(Tex_f1_g_x_goal R(x),
                            Tex_f1_g_x_goal Tex_f2_g_imp(Tex_f2_g_forall(y,
                                                                         Tex_f2_g_imp(Tex_f2_g_lt(y,
                                                                                                  x),
                                                                                      Tex_f2_g_forall(a,
                                                                                                      R(y)))),
                                                         R(x)))
         \end
  \end

rem 
  \para \bf  Integer division.  \end 

fun/2 Div 'Tex_f2_n_div'
  Div(x,0) = 0
  Div(x,y) = 0 <- y != 0 & x < y
  Div(x,y) = Div(x-y,y)+1 <- y != 0 & x >= y

rem 
  \para \bf  Exercise.  \end Prove 
  \eq* 
    y != 0 -> \e r(x = Div(x,y)*y+r & r < y)
  \end

thm Spec_div
  y != 0 -> \e r(x = Div(x,y)*y+r & r < y)

rem 
  \para \bf  Greatest common divisor.  \end Euclid algorithm based on the 
  property 
  \eq* 
    x != 0 & Divides(z,x) -> Divides(z,y) <-> Divides(z,y mod x)
  \end
  \para \it  [CL] Remark.  \end This property in the form of the following 
  theorem 
  \eq Euclid_divides_mod
    x != 0 & Divides(z,x) -> Divides(z,y mod x) <-> Divides(z,y)
  \end
  \para is proved in the module \it  Maux*  \end. 

fun/2 Gcd 'Tex_f2_n_gcd'
  Gcd(0,y) = y
  Gcd(x,y) = Gcd(y mod x,x) <- x != 0

rem 
  \para \bf  Exercise. \it  (1 point)  \end  \end Prove 
  \eq* 
    x != 0 \/ y != 0 -> Divides(Gcd(x,y),x) & Divides(Gcd(x,y),y)
  \end
  \eq* 
    (x != 0 \/ y != 0) & Divides(z,x) & Divides(z,y) -> z <= Gcd(x,y)
  \end
  \para \it  [CL] Hint.  \end In the proof you will need the following theorem 
  \eq Mod_bounded
    x != 0 -> y mod x < x
  \end
  \para from the module \it  Maux*  \end. 

thm Spec_gcd_divides
  x != 0 \/ y != 0 -> Divides(Gcd(x,y),x) & Divides(Gcd(x,y),y)

thm Spec_gcd_greatest
  (x != 0 \/ y != 0) & Divides(z,x) & Divides(z,y) -> z <= Gcd(x,y)

