mod Maux logic: 'cl'

incl Mtex

rem 
  \para \bf  Remainder.  \end 

lemma Quotient_remainder
  x != 0 -> \e q\e r(y = q*x+r & r < x)
proof 
 indm y @ y1
  case Dich; x,y @ y1,x1; y1,x1
   inst \a y1(y1 < y -> \e r(\e q y1 = x*q+r & r < x)).0; y-x
    eigen \e r(\e q y = x+x*q+r & r < x).0:0,3,0,1,0; r,q
     inst* \e r1(\e q1 q*x+r+x = x*q1+r1 & r1 < x):0,3,0,1,0; r; q+1 proved...
   inst* \e r(\e q y = x*q+r & r < x):0,3,0,1,0; y; 0 proved....

lemma Remainder_mod
  x != 0 -> \e q y = q*x+y mod x & y mod x < x
proof 
 use Quotient_remainder.0; x; y
  eigen \e r(\e q y = x*q+r & r < x).0:0,3,0,1,0; r,q
   inst* \e q1 q = q1; q proved....

thm Mod_bounded
  x != 0 -> y mod x < x
proof 
 use Remainder_mod.1,0,4,1,0; x; y proved..

rem 
  \para \bf  Divisibility predicate.  \end 

pred/2 Divides 'Tex_p2_n_divides'
  Divides(x,y) <-> \e z y = x*z

thm Divides_reflexivity
  Divides(x,x)
proof 
 exp Divides; x,x
  inst* \e z x = x*z; 1 proved...

thm Divides_antisymmetry
  Divides(x,y) & Divides(y,x) -> x = y
proof 
 exp Divides; x,y
  eigen \e z y = x*z; z
   weak y = x*z
    exp Divides; x*z,x
     eigen \e z1 x = x*z*z1; z1
      cut x = 0
       proved
       proved.......

thm Divides_transitivity
  Divides(x,y) & Divides(y,z) -> Divides(x,z)
proof 
 exp Divides; x,z
  exp Divides; x,y
   eigen \e z1 y = x*z1; z1
    exp Divides; x*z1,z
     eigen \e z2 z = x*z1*z2; z2
      inst* \e z3 x*z1*z2 = x*z3; z1*z2 proved.......

thm Divides_left_zero
  Divides(0,x) <-> x = 0
proof 
 exp Divides; 0,x proved..

thm Divides_right_zero
  Divides(x,0)
proof 
 exp Divides; x,0
  inst* \e z z = 0; 0 proved...

thm Divides_left_one
  Divides(1,x)
proof 
 exp Divides; 1,x
  inst* \e z x = z; x proved...

thm Divides_right_one
  Divides(x,1) <-> x = 1
proof 
 exp Divides; x,1
  split* \e z z = 1 & x = 1 <-> x = 1.2,0,1,0,4,0,0,0
   proved
   inst* \e z z = 1; 1 proved.
   proved...

thm Divides_adjacent
  Divides(x,y) & Divides(x,y+1) -> x = 1
proof 
 case Trich; x,1 @ x1,y1; x1,y1; x1,y1
  use Divides_left_zero.2,0,0; y+1 proved.
  proved
  exp Divides; x,y
   eigen \e z y = x*z; z
    exp Divides; x,x*z+1 proved.....

thm Divides_plus
  Divides(x,y) & Divides(x,z) -> Divides(x,y+z)
proof 
 exp Divides; x,y+z
  exp Divides; x,y
   eigen \e z1 y = x*z1; z1
    exp Divides; x,z
     eigen \e z2 z = x*z2; z2
      inst* \e z3 x*z1+x*z2 = x*z3; z1+z2 proved.......

thm Divides_minus
  Divides(x,y) & Divides(x,z) -> Divides(x,y-z)
proof 
 case Dich; y,z @ x1,y1; x1,y1
  use Divides_right_zero; x proved.
  exp Divides; x,y-z
   exp Divides; x,y
    eigen \e z1 y = x*z1; z1
     exp Divides; x,z
      eigen \e z2 z = x*z2; z2
       cut x = 0
        proved
        inst* \e z3 z1 = z2+z3; z1-z2 proved.........

thm Divides_times
  Divides(x,y) -> Divides(x,y*z)
proof 
 exp Divides; x,y*z
  exp Divides; x,y
   eigen \e z1 y = x*z1; z1
    inst* \e z2 x*z*z1 = x*z2; z*z1 proved.....

thm Divides_times_reflexivity
  Divides(x,x*y)
proof 
 use Divides_times; x; x; y
  use Divides_reflexivity; x proved...

thm Divides_bounded
  x != 0 & Divides(y,x) -> y <= x
proof 
 exp Divides; y,x
  eigen \e z x = y*z; z proved...

rem 
  \para \it  Euclid algorithm.  \end 

thm Euclid_divides_mod
  x != 0 & Divides(z,x) -> Divides(z,y mod x) <-> Divides(z,y)
proof 
 use Remainder_mod.1,0,4,0,0; x; y
  eigen \e q y = x*q+y mod x; q
   sym y = q*x+y mod x
    use Divides_times; z; x; q
     split* Divides(z,y mod x) <-> Divides(z,y).2,0,0
      use Divides_plus; z; y mod x; q*x proved.
      use Divides_minus; z; y; q*x proved.......

thm Euclid_divides_minus
  x <= y & Divides(z,x) -> Divides(z,y-x) <-> Divides(z,y)
proof 
 split* Divides(z,y-x) <-> Divides(z,y).2,0,0
  use Divides_plus; z; x; y-x proved.
  use Divides_minus; z; y; x proved...

rem 
  \para \bf  Maximum.  \end 

fun/2 Max 'Tex_f2_n_max'
  Max(x,y) = x <- x >= y
  Max(x,y) = y <- x < y

