mod Ex08d logic: 'cl'

incl Mtex

loc rem 
  \para \bf  8. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21.2 
  \para* \it  Dátum:  \end štvrtok 10.4.2025 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/2425ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované týmto 
  témam: 
  \items 
   \item \para primitívna rekurzia, 
   \item \para 'course-of-values' rekurzia, 
   \item \para rekurzia s mierou, 
   \item \para iteratívna rekurzia. 
  \end
  \para Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbory \it  mlogic*.cl  \end obsahujú popis verifikačnej 
         časti systému CL. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Počet bodov za úlohy v tomto súbore: 2 
   \item \para Počet bodov za prémiove úlohy v tomto súbore: 0 
  \end
  \para Odovzdať do 15.4.2025 (utorok). 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end Ján Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
   \item \para \it  [3]  \end Ján Komara. Recursive Functions. Online. 
  \end

rem 
  \para \bf  Chapter. Numeric Programs.  \end 

rem 
  \para \bf  Section. Iterative Recursion.  \end 

rem 
  \para \bf  Exercise.  \end Find an efficient, tail recursive implementation of 
  the function: 

fun F1 'Tex_f1_f_sub'
  F1(0) = 0
  F1(1) = 1
  F1(n+2) = F1(n+1)+F1(n)

rem 
  \para Your solution should simulate the following while-loop by primitive 
  recursion with substitution in parameters: 
  \verbatim 
  def f(n):
      if n == 0:
          return 0
      else:
          n,a,b = n-1,1,0
          while n != 0:
              n,a,b = n-1,a+b,a
          return a
  \end
  \para Verify your implementation. 

rem 
  \para \it  While-loop by primitive recursion with substitution in parameters. 
   \end 

fun/3 While1 'Tex_f3_g'
  While1(0,a,b) = a
  While1(n+1,a,b) = While1(n,a+b,a)

rem 
  \para Prove 
  \eq* 
    F1(n+1) = While1(n,1,0)
  \end

thm F1_by_while1
  F1(n+1) = While1(n,1,0)

rem 
  \para \bf  Exercise. \it  (1 point)  \end  \end Find a similar tail recursive 
  implementation of the function: 

fun F2 'Tex_f1_f_sub'
  F2(0) = 0
  F2(1) = 1
  F2(2) = 2
  F2(n+3) = F2(n+2)+F2(n+1)+F2(n)

rem 
  \para \it  While-loop by primitive recursion with substitution in parameters. 
   \end 

rem 
  \para \bf  Exercise.  \end Find an efficient, tail recursive implementation of 
  the function: 

fun F3 'Tex_f1_f_sub'
  F3(0) = 0
  F3(1) = 1
  F3(n+2) = F3(n+1)+F3(n)+n

rem 
  \para Your solution should simulate the following for-loop by backward 
  recursion with substitution in parameters: 
  \verbatim 
  def f(n):
      if n == 0:
          return 0
      else:
          n,a,b = n-1,1,0
          for i in range(0,n):
              a,b = a+b+i,a
          return a
  \end
  \para Verify your implementation. 

rem 
  \para \it  For-loop by backward recursion with substitution in parameters. 
   \end 

fun/4 For3 'Tex_f4_g'
  For3(i,n,a,b) = a <- i >= n
  For3(i,n,a,b) = For3(i+1,n,a+b+i,a) <- i < n

rem 
  \para Prove 
  \eq* 
    F3(n+1) = For3(0,n,1,0)
  \end

thm F3_by_for3
  F3(n+1) = For3(0,n,1,0)

rem 
  \para \bf  Exercise. \it  (1 point)  \end  \end Find a similar tail recursive 
  implementation of the function: 

fun F4 'Tex_f1_f_sub'
  F4(0) = 0
  F4(1) = 1
  F4(2) = 2
  F4(n+3) = F4(n+2)+F4(n+1)+F4(n)+n

rem 
  \para \it  For-loop by backward recursion with substitution in parameters. 
   \end 

