mod Ex04a

incl Mtex

incl Mtexbt

incl Mauxa

loc rem 
  \para \bf  4. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21.2 
  \para* \it  Dátum:  \end pondelok 13.3.2025 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/2425ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované týmto 
  témam: 
  \items 
   \item \para binárne stromy 
   \item \para binárne vyhľadávacie stromy 
  \end
  \para Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Počet bodov za úlohy v tomto súbore: 3 
   \item \para Počet bodov za prémiove úlohy v tomto súbore: 1 
  \end
  \para Odovzdať do 18.3.2025 (utorok). 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
   \item \para \it  [3]  \end Ján Komara. Recursive Functions. Online. 
  \end

rem 
  \para \bf  Chapter. Programs Operating on Trees.  \end 

rem 
  \para \bf  Section. Binary Trees.  \end 

rem 
  \para \bf  Subsection. Arithmetization of Binary Trees.  \end 

rem 
  \para \bf  Constructors of binary trees.  \end 

fun/0 E 'Tex_f0_bt_e'
  E = 0,0

fun/3 Nd 'Tex_f3_bt_nd'
  Nd(x,l,r) = 1,x,l,r

rem 
  \para \bf  [CL] Discrimination on the constructors of binary trees.  \end 
  Example(s): 
  \def 
    fun F 'Tex_f1_f'
    F(E) = Foo
    F Nd(x,l,r) = Foo
  \end

rem 
  \para \bf  Binary trees.  \end 

pred Bt 
  Bt(E)
  Bt Nd(x,l,r) <- N(x) & Bt(l) & Bt(r)

rem 
  \para \bf  [CL] Formatting the output.  \end Use the format \ft Bt \end to 
  display numbers as binary trees. Try out the following simple queries 
  \verbatim 
      171386336145149 = t:Bt
  \end
  \verbatim 
      1,10,(1,11,(0,0),0,0),(1,12,(0,0),0,0) = t:Bt
  \end

rem 
  \para \bf  Subsection. Basic Operations and Predicates.  \end 

rem 
  \para \bf  Size and depth of binary trees.  \end 
  \header* fun Sz 'Tex_f1_bt_sz' \end \header* fun Dp 'Tex_f1_bt_dp' \end Define 
  the functions \ft Sz(t) \end and \ft Dp(t) \end computing respectively the 
  size and the depth of the binary tree \ft t \end. Note that we have 
  \eq* 
    Bt(t) -> Dp(t) <= Sz(t) & Sz(t) < Exp(2,Dp(t))
  \end

fun Sz 'Tex_f1_bt_sz'
  Sz(E) = 0
  Sz Nd(x,l,r) = Sz(l)+Sz(r)+1

fun Dp 'Tex_f1_bt_dp'
  Dp(E) = Foo
  Dp Nd(x,l,r) = Foo

rem 
  \para \bf  Reflection function.  \end Define the function \ft Reflect(t) \end 
  which yields the mirror's image of the binary tree \ft t \end. 

fun Reflect 
  Reflect(t) = Foo

rem 
  \para \bf  Membership in binary trees.  \end 
  \header* pred/2 Inbt 'Tex_p2_bt_in' \end Define the predicate 
  \ft Inbt(x,t) \end such that 
  \eq* 
    ~Inbt(x,E)
  \end
  \eq* 
    Inbt(x,Nd(y,l,r)) <-> x = y \/ Inbt(x,l) \/ Inbt(x,r)
  \end

pred/2 Inbt 'Tex_p2_bt_in'
  Inbt(x,Nd(y,l,r)) <- x = y
  Inbt(x,Nd(y,l,r)) <- x != y & Inbt(x,l)
  Inbt(x,Nd(y,l,r)) <- x != y & ~Inbt(x,l) & Inbt(x,r)

rem 
  \para \bf  Isomorphic binary trees.  \end 
  \header* pred/2 Isomorphic 'Tex_p2_bt_isomorphic' \end Given binary trees 
  \ft t1 \end and \ft t2 \end, the predicate \ft Isomorphic(t1,t2) \end holds if 
  the trees \ft t1 \end and \ft t2 \end are isomorphic (of the same shape). 

pred/2 Isomorphic 'Tex_p2_bt_isomorphic'
  Isomorphic(E,E)
  Isomorphic(Nd(x1,l1,r1),Nd(x2,l2,r2)) <- Isomorphic(l1,l2) & Isomorphic(r1,r2)

rem 
  \para We have 
  \eq* 
    Bt(t) -> Isomorphic(t,t)
  \end
  \eq* 
    Isomorphic(t1,t2) -> Isomorphic(t2,t1)
  \end
  \eq* 
    Isomorphic(t1,t2) & Isomorphic(t2,t3) -> Isomorphic(t1,t3)
  \end
  \eq* 
    Bt(t1) & Isomorphic(t1,t2) -> Bt(t2)
  \end
  \eq* 
    Isomorphic(t1,t2) -> Sz(t1) = Sz(t2)
  \end
  \eq* 
    Isomorphic(t1,t2) -> Dp(t1) = Dp(t2)
  \end

rem 
  \para \bf  Subsection. Traversals of Binary Trees.  \end 

rem 
  \para \bf  Basic traversals of binary trees.  \end 

fun Preorder 'Tex_f1_bt_preorder'
  Preorder(E) = 0
  Preorder Nd(x,l,r) = (x,0)++Preorder(l)++Preorder(r)

fun Inorder 'Tex_f1_bt_inorder'
  Inorder(E) = 0
  Inorder Nd(x,l,r) = Inorder(l)++(x,0)++Inorder(r)

fun Postorder 'Tex_f1_bt_postorder'
  Postorder(E) = 0
  Postorder Nd(x,l,r) = Postorder(l)++Postorder(r)++(x,0)

rem 
  \para \bf  Fast programs for tree traversals.  \end Save the concatenation in 
  the definition of each tree traversal function. 

rem 
  \para \bf  Case: preorder traversal.  \end 

fun/2 Preordera 'Tex_f2_f'
  Preordera(E,as) = as
  Preordera(Nd(x,l,r),as) = x,Preordera(l,Preordera(r,as))

rem 
  \para Invariant: 
  \eq* 
    Bt(t) -> Preordera(t,as) = Preorder(t)++as
  \end

fun Preorder_fast 'Tex_f1_bt_preorder'
  Preorder_fast(t) = Preordera(t,0)

rem 
  \para \bf  Case: inorder traversal.  \end 

fun/2 Inordera 'Tex_f2_f'
  Inordera(E,as) = Foo
  Inordera(Nd(x,l,r),as) = Foo

rem 
  \para Invariant: 
  \eq* 
    Bt(t) -> Inordera(t,as) = Inorder(t)++as
  \end

fun Inorder_fast 'Tex_f1_bt_inorder'
  Inorder_fast(t) = Foo

rem 
  \para \bf  Case: postorder traversal. \it  (1 point)  \end  \end 

fun/2 Postordera 'Tex_f2_f'
  Postordera(t,as) = Foo

rem 
  \para Invariant: 
  \eq* 
    Bt(t) -> Postordera(t,as) = Postorder(t)++as
  \end

fun Postorder_fast 'Tex_f1_bt_postorder'
  Postorder_fast(t) = Foo

rem 
  \para \bf  Subsection. Perfect Binary Trees.  \end 

rem 
  \para \bf  Perfect binary trees.  \end A binary tree \ft t \end is said to be 
  \it  perfect  \end if 
  \eq* 
    Sz(t)+1 = Exp(2,Dp(t))
  \end

rem 
  \para \bf  Exercise.  \end \header* fun/2 Fs 'Tex_f2_f' \end Define the 
  function \ft Fs(n,x) \end such that 
  \eq* 
    Bt Fs(n,x)
  \end
  \eq* 
    Dp Fs(n,x) = n & Sz Fs(n,x)+1 = Exp(2,n)
  \end
  \eq* 
    Inbt(y,Fs(n,x)) -> y = x
  \end

fun/2 Fs 'Tex_f2_f'
  Fs(0,x) = E
  Fs(n+1,x) = Nd(x,Fs(n,x),Fs(n,x))

rem 
  \para \bf  Exercise.  \end \header* fun Fpr 'Tex_f1_f' \end Define the 
  function \ft Fpr(n) \end such that 
  \eq* 
    Bt Fpr(n)
  \end
  \eq* 
    Dp Fpr(n) = n & Sz Fpr(n)+1 = Exp(2,n)
  \end
  \eq* 
    Preorder Fpr(n) = Interval(0,Exp(2,n)-1)
  \end
  \para \it  Hint.  \end \header* fun/2 Fpr1 'Tex_f2_g' \end Define first an 
  auxiliary function \ft Fpr1(n,m) \end such that 
  \eq* 
    Bt Fpr1(n,m)
  \end
  \eq* 
    Dp Fpr1(n,m) = n & Sz Fpr1(n,m)+1 = Exp(2,n)
  \end
  \eq* 
    Preorder Fpr1(n,m) = Interval(m,m+Exp(2,n)-1)
  \end

fun/2 Fpr1 'Tex_f2_g'
  Fpr1(0,m) = E
  Fpr1(n+1,m) = Nd(m,Fpr1(n,m+1),Fpr1(n,m+Exp(2,n)))

fun Fpr 'Tex_f1_f'
  Fpr(n) = Fpr1(n,0)

rem 
  \para \bf  Exercise.  \end \header* fun Fin 'Tex_f1_f' \end Define the 
  function \ft Fin(n) \end such that 
  \eq* 
    Bt Fin(n)
  \end
  \eq* 
    Dp Fin(n) = n & Sz Fin(n)+1 = Exp(2,n)
  \end
  \eq* 
    Inorder Fin(n) = Interval(0,Exp(2,n)-1)
  \end

fun/2 Fin1 'Tex_f2_g'
  Fin1(0,m) = Foo
  Fin1(n+1,m) = Foo

fun Fin 'Tex_f1_f'
  Fin(n) = Foo

rem 
  \para \bf  Exercise. \it  (1 point)  \end  \end 
  \header* fun Fpo 'Tex_f1_f' \end Define the function \ft Fpo(n) \end such that 
  \eq* 
    Bt Fpo(n)
  \end
  \eq* 
    Dp Fpo(n) = n & Sz Fpo(n)+1 = Exp(2,n)
  \end
  \eq* 
    Postorder Fpo(n) = Interval(0,Exp(2,n)-1)
  \end

fun/2 Fpo1 'Tex_f2_g'
  Fpo1(n,m) = Foo

fun Fpo 'Tex_f1_f'
  Fpo(n) = Foo

rem 
  \para \bf  Exercise. \it  (1 bonus point)  \end  \end 
  \header* fun Fbr 'Tex_f1_f' \end Define the function \ft Fbr(n) \end which 
  creates perfect binary tree \ft t \end of depth \ft n \end with values 
  \ft 0,1,2,3,Tex0_dotsc \end stored in \ft t \end in breadth-first order. We 
  have 
  \eq* 
    Bt Fbr(n)
  \end
  \eq* 
    Dp Fbr(n) = n & Sz Fbr(n)+1 = Exp(2,n)
  \end
  \eq* 
    Inbt(x,Fbr(n)) <-> x+1 < Exp(2,n)
  \end
  \para \it  Hint.  \end \header* fun/2 Fbr1 'Tex_f2_g' \end Define first an 
  auxiliary function \ft Fbr1(n,m) \end such that 
  \eq* 
    Bt Fbr1(n,m)
  \end
  \eq* 
    Dp Fbr1(n,m) = n & Sz Fbr1(n,m)+1 = Exp(2,n)
  \end
  \eq* 
    Inbt(x,Fbr1(n,m)) <-> \e y(x = Dconc(m,y) & y+1 < Exp(2,n))
  \end
  \para Here the \ft Dconc(x,y) \end is dyadic concatenation. 

fun/2 Fbr1 'Tex_f2_g'
  Fbr1(0,m) = Foo
  Fbr1(n+1,m) = Foo

fun Fbr 'Tex_f1_f'
  Fbr(n) = Foo

rem 
  \para \bf  Subsection. Tree Numberings.  \end 

rem 
  \para \bf  Problem.  \end Given a tree, create a new tree of the same shape, 
  but with the values at the nodes replaced by the numbers 0,1,2... in a fixed 
  order. 

rem 
  \para \bf  Exercise.  \end \header* fun Npr 'Tex_f1_f' \end Define the 
  function \ft Npr(t) \end such that 
  \eq* 
    Bt(t) -> Isomorphic(Npr(t),t)
  \end
  \eq* 
    Bt(t) -> Preorder Npr(t) = Interval(0,Sz(t))
  \end
  \para \it  Remark.  \end Implement the function with the help of the size 
  function \ft Sz(t) \end. 
  \para \it  Hint.  \end \header* fun/2 Npr1 'Tex_f2_g' \end Define first an 
  auxiliary function \ft Npr1(t,m) \end such that 
  \eq* 
    Bt(t) -> Isomorphic(Npr1(t,m),t)
  \end
  \eq* 
    Bt(t) -> Preorder Npr1(t,m) = Interval(m,m+Sz(t))
  \end

fun/2 Npr1 'Tex_f2_g'
  Npr1(E,m) = E
  Npr1(Nd(x,l,r),m) = Nd(m,Npr1(l,m+1),Npr1(r,m+Sz(l)+1))

fun Npr 'Tex_f1_f'
  Npr(t) = Npr1(t,0)

rem 
  \para \bf  Exercise.  \end \header* fun Nin 'Tex_f1_f' \end Define the 
  function \ft Nin(t) \end such that 
  \eq* 
    Bt(t) -> Isomorphic(Nin(t),t)
  \end
  \eq* 
    Bt(t) -> Inorder Nin(t) = Interval(0,Sz(t))
  \end
  \para \it  Remark.  \end Implement the function with the help of the size 
  function \ft Sz(t) \end. 

fun/2 Nin1 'Tex_f2_g'
  Nin1(E,m) = Foo
  Nin1(Nd(x,l,r),m) = Foo

fun Nin 'Tex_f1_f'
  Nin(t) = Foo

rem 
  \para \bf  Exercise. \it  (1 point)  \end  \end 
  \header* fun Npo 'Tex_f1_f' \end Define the function \ft Npo(t) \end such that 
  \eq* 
    Bt(t) -> Isomorphic(Npo(t),t)
  \end
  \eq* 
    Bt(t) -> Postorder Npo(t) = Interval(0,Sz(t))
  \end
  \para \it  Remark.  \end Implement the function with the help of the size 
  function \ft Sz(t) \end. 

fun/2 Npo1 'Tex_f2_g'
  Npo1(t,m) = Foo

fun Npo 'Tex_f1_f'
  Npo(t) = Foo

loc rem 
  ******************************************************************************
  ********************************* DEBUGGING **********************************
  ******************************************************************************

loc rem 
  \para \bf  Building a tree.  \end The function \ft Ln2bt(xs) \end converts a 
  list of labels into a balanced binary tree. Use the operation to test your 
  solutions. 

loc fun L 
  L(0) = 0
  L(x,xs) = L(xs)+1

loc fun/2 Take 
  Take(0,xs) = 0
  Take(n+1,x,xs) = x,Take(n,xs)

loc fun/2 Drop 
  Drop(0,xs) = xs
  Drop(n+1,x,xs) = Drop(n,xs)

loc fun/2 Ln2bt1 'Tex_f2_f'
  Ln2bt1(0,xs) = E
  Ln2bt1(S1(n),x,xs) = Nd(x,Ln2bt1(n,Take(n,xs)),Ln2bt1(n,Drop(n,xs)))
  Ln2bt1(S2(n),x,xs) = Nd(x,Ln2bt1(n+1,Take(n+1,xs)),Ln2bt1(n,Drop(n+1,xs)))

loc fun Ln2bt 
  Ln2bt(xs) = Ln2bt1(L(xs),xs)

loc rem 
  \para \bf  Some useful queries.  \end 

loc rem 
  171386336145149 = t:Bt
  1,10,(1,11,(0,0),0,0),(1,12,(0,0),0,0) = t:Bt
  Interval(1,10) = xs & Ln2bt(xs) = t:Bt
  Interval(1,10) = xs & Ln2bt(xs) = t:Bt & Sz(t) = s & Dp(t) = d
  Interval(1,10) = xs & Ln2bt(xs) = t:Bt & Reflect(t) = t1:Bt
  Interval(1,10) = xs & Ln2bt(xs) = t:Bt & Preorder(t) = ys
  Interval(1,10) = xs & Ln2bt(xs) = t:Bt & Preorder_fast(t) = ys
  Fs(3,9) = t:Bt
  Fpr(3) = t:Bt
  Fbr(3) = t:Bt
  Interval(1,10) = xs & Ln2bt(xs) = t:Bt & Npr(t) = t1:Bt

