mod Ex01b

incl Mtex

loc rem 
  \para \bf  1. CVIČENIE Z PREDMETU 1-AIN-470 ŠPECIFIKÁCIA A VERIFIKÁCIA 
  PROGRAMOV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.21.2 
  \para* \it  Dátum:  \end stvrtok 20.2.2025 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/1-AIN-470-svp/2425ls/?lang=sk 
  \para* \it  Kontakt:  \end Jan.Komara(at)fmph.uniba.sk 

loc rem 
  \para \bf  Úvodná poznámka.  \end Toto cvičenie je venované týmto 
  témam: 
  \items 
   \item \para explicitné definície, 
   \item \para rekurzívne definície. 
  \end
  \para Zadanie sa skladá z týchto súborov: 
  \items 
   \item \para Súbory \it  mtex*.cl  \end obsahujú makrá pre CL-TeX. 
   \item \para Súbory \it  maux*.cl  \end obsahujú definície a vlastnosti 
         pomocných funkcií a predikátov. 
   \item \para Súbory \it  ex*.cl  \end obsahujú úlohy, ktoré máte riešiť 
         na tomto cvičení. 
   \item \para Súbor \it  msyntax.cl  \end obsahuje základnú syntax systému 
         CL. 
  \end
  \para Tieto súbory sa musia skompilovať v správnom poradí. Presný postup 
  je uvedený v súbore \it  readme.txt  \end. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara. Specification and Verification of 
         Programs. Online. 
   \item \para \it  [2]  \end Ján Kľuka. Úvod do deklaratívneho 
         programovania. Online. 
   \item \para \it  [3]  \end Ján Komara. Recursive Functions. Online. 
  \end

appldisp/3 Tex_f3_n_min3
  Std('Min3',0)

appldisp/3 Tex_f3_n_max3
  Std('Max3',0)

rem 
  \para \bf  [CL] Syntax.  \end Identifier conventions: 
  \items 
   \item \para Variable identifier. A string of lower case letters possibly 
         followed by one or two digits as indices. Examples: \ft x \end, 
         \ft ys \end, \ft i1 \end, \ft foo99 \end. 
   \item \para Function identifier. An alpha-numeric string starting with a 
         capital letter and containing lower case letters, digits, and underline 
         symbols '_'. Examples: \ft F \end, \ft Max \end, 
         \ft Power_of_some_prime \end, \ft A1b2c3 \end. 
  \end

rem 
  \para \bf  [CL] Remark.  \end By a component we mean either remark, or 
  definition or theorem. 

rem 
  \para \bf  Chapter. Numeric Programs.  \end 

rem 
  \para \bf  Section. Explicit Definitions.  \end 

rem 
  \para \bf  Square function.  \end The following component contains the 
  explicit definition of the function \ft Square(x) \end which returns the 
  square \ft Tex_f2_n_exp(x,2) \end of the number \ft x \end. 

fun Square 
  Square(x) = x*x

rem 
  \para \bf  Exercise.  \end Evaluate the function for some arguments. 

rem 
  \para \bf  Cube function.  \end Write an explicit definition of the function 
  \ft Cube(x) \end which returns the cube \ft Tex_f2_n_exp(x,3) \end of the 
  number \ft x \end. 
  \para \it  Hint.  \end Use the \it  Ins/Del  \end button on the right to 
  insert a new component. 

fun Cube 
  Cube(x) = Foo

rem 
  \para \bf  Sum of two squares.  \end \header* fun/2 Sum_of_squares  \end Give 
  an explicit definition of the binary function \ft Sum_of_squares(x,y) \end 
  which returns the sum of the squares \ft Tex_f2_n_exp(x,2) \end and 
  \ft Tex_f2_n_exp(y,2) \end. 

fun/2 Sum_of_squares 
  Sum_of_squares(x,y) = Foo

rem 
  \para \bf  Minimum of two numbers.  \end 
  \header* fun/2 Min 'Tex_f2_n_min' \end The binary function \ft Min(x,y) \end 
  returns the smaller of its two arguments: 
  \eq* 
    Min(x,y) <= x & Min(x,y) <= y & (Min(x,y) = x \/ Min(x,y) = y)
  \end
  \para The following component contains its explicit \it  clausal  \end 
  definition. Note that the definition uses \it  dichotomy discrimination  \end. 

fun/2 Min 'Tex_f2_n_min'
  Min(x,y) = x <- x <= y
  Min(x,y) = y <- x > y

rem 
  \para \bf  Exercise.  \end Evaluate the function for some arguments. 

rem 
  \para \bf  [CL] Remark.  \end Here is an example of syntactically incorrect 
  definition of the same function: 
  \def 
    fun/2 Min 'Tex_f2_n_min'
    Min(x,y) = x <- x <= y
    Min(a,b) = b <- a > b
  \end
  \para This is because the first application \ft Min(x,y) \end of the minimum 
  function is syntactically different from the second \ft Min(a,b) \end. They 
  should be identical as it is in the previous definition. 

rem 
  \para \bf  Maximum of two numbers.  \end 
  \header* fun/2 Max 'Tex_f2_n_max' \end Define the binary function 
  \ft Max(x,y) \end which returns the larger of its two arguments: 
  \eq* 
    Max(x,y) >= x & Max(x,y) >= y & (Max(x,y) = x \/ Max(x,y) = y)
  \end

fun/2 Max 'Tex_f2_n_max'
  Max(x,y) = Foo

rem 
  \para \bf  Minimum of three numbers.  \end \header* fun/3 Min3  \end The 
  ternary function \ft Min3(x,y,z) \end returns the smallest of its three 
  arguments: 
  \eq* 
    Min3(x,y,z) <= x & Min3(x,y,z) <= y & Min3(x,y,z) <= z & 
    (Min3(x,y,z) = x \/ Min3(x,y,z) = y \/ Min3(x,y,z) = z)
  \end
  \para The following component contains its explicit clausal definition. Note 
  that the definition uses two \it  nested  \end dichotomy discriminations. 

fun/3 Min3 
  Min3(x,y,z) = x <- x <= y & x <= z
  Min3(x,y,z) = z <- x <= y & x > z
  Min3(x,y,z) = y <- x > y & y <= z
  Min3(x,y,z) = z <- x > y & y > z

rem 
  \para Alternative definition: 

fun/3 Min3_alternative_definition 'Tex_f3_n_min3'
  Min3_alternative_definition(x,y,z) = Min(x,Min(y,z))

rem 
  \para \bf  Maximum of three numbers.  \end \header* fun/3 Max3  \end Define 
  the ternary function \ft Max3(x,y,z) \end such that 
  \eq* 
    Max3(x,y,z) >= x & Max3(x,y,z) >= y & Max3(x,y,z) >= z & 
    (Max3(x,y,z) = x \/ Max3(x,y,z) = y \/ Max3(x,y,z) = z)
  \end

fun/3 Max3 
  Max3(x,y,z) = Foo

rem 
  \para Alternative definition: 

fun/3 Max3_alternative_definition 'Tex_f3_n_max3'
  Max3_alternative_definition(x,y,z) = Foo

rem 
  \para \bf  Median of three numbers.  \end \header* fun/3 Median  \end Define 
  the ternary function \ft Median(x,y,z) \end which returns the median of its 
  three arguments: 
  \eq* 
    x <= y & y <= z -> Median(x,y,z) = y
  \end
  \eq* 
    Median(x,y,z) = Median(y,x,z)
  \end
  \eq* 
    Median(x,y,z) = Median(x,z,y)
  \end

fun/3 Median 
  Median(x,y,z) = Foo

rem 
  \para \bf  [CL] Final remark.  \end Save your solutions and exit the system 
  CL. That is, click the \it  Save & Exit  \end button or type \it  Alt  \end + 
  \it  X  \end. 

