mod Mrd

incl Mtex

incl Mtexrc

incl Mtexgr

incl Maux

incl Mterm

rem 
  \para \bf  Arithmetization of reductions.  \end 

rem 
  \para \it  Codes of numerals.  \end 

fun Cnm 'Tex_f1_gr_cnm'
  Cnm(0) = Zt
  Cnm(x+1) = St Cnm(x)

fun Dc 
  Dc(Zt) = 0
  Dc St(t) = Dc(t)+1

rem 
  \para \it  Substitution function.  \end 

fun/3 Sb 'Tex_f3_gr_sb'
  Sb(Vt(i),e,rs) = Sub(rs,i-1)
  Sb(Zt,e,rs) = Zt
  Sb(St(t),e,rs) = St Sb(t,e,rs)
  Sb(Pt(t),e,rs) = Pt Sb(t,e,rs)
  Sb(Dt(t1,t2,t3),e,rs) = Dt(Sb(t1,e,rs),Sb(t2,e,rs),Sb(t3,e,rs))
  Sb(Act(t1,t2),e,rs) = Cntr(Sb(t1,e,rs),Sb(t2,e,rs))
  Sb(Apt(Fs(n),ts),e,rs) = Apt(e,ts)
  Sb(Apt(Ls(n,t),ts),e,rs) = Apt(Ls(n,t),ts)

rem 
  \para \it  Auxiliary functions.  \end 

fun Pn 
  Pn(Zt) = Zt
  Pn St(t) = t

fun/3 Dn 
  Dn(Zt,t2,t3) = t3
  Dn(St(t1),t2,t3) = t2

rem 
  \para \it  One-step reduction function.  \end 

fun Rd 
  Rd(Zt) = Zt
  Rd St(t) = St Rd(t)
  Rd Pt(t) = Pn(t) <- Nm(t)
  Rd Pt(t) = Pt Rd(t) <- ~Nm(t)
  Rd Dt(t1,t2,t3) = Dn(t1,t2,t3) <- Nm(t1)
  Rd Dt(t1,t2,t3) = Dt(Rd(t1),t2,t3) <- ~Nm(t1)
  Rd Act(t1,t2) = Cntr(t1,Rd(t2)) <- Is_apt(t1)
  Rd Act(t1,t2) = Cntr(Rd(t1),t2) <- ~Is_apt(t1)
  Rd Apt(Ls(n,t),ts) = Sb(t,Ls(n,t),ts)

rem 
  \para \it  Iteration of one-step reduction function.  \end 

fun/2 Ird 'Tex_f2_gr_ird'
  Ird(0,t) = t
  Ird(k+1,t) = Ird(k,Rd(t))

rem 
  \para \bf  Some well-formed recursive indices.  \end 

fun/0 Xplus 'Tex_f0_gr_xplus'
  Xplus = Ls(2,Dt(x,t2,y)) <- 
    Vt(1) = x & Vt(2) = y & St Act(Act(Apt(Fs(2),0),Pt(x)),y) = t2

fun/0 Xminus 'Tex_f0_gr_xminus'
  Xminus = Ls(2,Dt(y,t2,x)) <- 
    Vt(1) = x & Vt(2) = y & Pt Act(Act(Apt(Fs(2),0),x),Pt(y)) = t2

fun/0 Xtimes 'Tex_f0_gr_xtimes'
  Xtimes = Ls(2,Dt(x,t2,Zt)) <- 
    Vt(1) = x & Vt(2) = y & 
    Act(Act(Apt(Xplus,0),Act(Act(Apt(Fs(2),0),Pt(x)),y)),y) = t2

fun/0 Xexp 'Tex_f0_gr_xexp'
  Xexp = Ls(2,Dt(y,t2,Cnm(1))) <- 
    Vt(1) = x & Vt(2) = y & 
    Act(Act(Apt(Xtimes,0),x),Act(Act(Apt(Fs(2),0),x),Pt(y))) = t2

rem 
  \para \bf  Auxiliary functions and predicates.  \end 

rem 
  \para \it  Arity function.  \end 

fun Ar 
  Ar Fs(n) = n
  Ar Ls(n,t) = n

rem 
  \para \it  Iterated contraction function.  \end 

fun/3 Cntri 'Tex_f3_gr_cntri'
  Cntri(t,1,r) = Cntr(t,r)
  Cntri(t,n+2,r,rs) = Cntri(Cntr(t,r),n+1,rs)

rem 
  \para \it  Application function.  \end 

fun/2 At 'Tex_f2_gr_at'
  At(e,ts) = Cntri(Apt(e,0),Ar(e),ts)

