mod Ex03a

incl Mtex

incl Mtexrc

incl Maux

loc rem 
  \para \bf  3. CVICENIE Z PREDMETU M-INBP-004 TEORIA VYPOCITATELNOSTI PRE 
  PROGRAMATOROV  \end 

loc rem 
  \para* \it  Meno:  \end 
  \para* \it  Verzia CL:  \end 5.81.16 
  \para* \it  Datum:  \end stvrtok 5.10.2006 
  \para* \it  WWW:  \end 
  http://www.ii.fmph.uniba.sk/cl/view.php/courses/M-INBP-004-vyp/0607zs/?lang=sk 
  \para* \it  Kontakt:  \end mailto:komara@nw.fmph.uniba.sk 

rem 
  \para \bf  Uvodna poznamka.  \end Toto cvicenie je venovane primitivne 
  rekurzivnym funkciam ('course of values recursion', universalna funkcia). 
  Zadanie sa sklada z tychto suborov: 
  \items 
   \item \para Subor(y) \it  mtex*.cl  \end obsahuje makra pre CL-TeX. 
   \item \para Subor(y) \it  maux*.cl  \end obsahuje definicie niektorych 
         funkcii a predikatov. 
   \item \para Subor \it  mxpr.cl  \end obsahuje aritmetizaciu p.r. funkcnych 
         symbolov. 
   \item \para Subor(y) \it  ex*.cl  \end obsahuje ulohy, ktore mate riesit na 
         tomto cviceni. 
  \end
  \para Tieto subory sa musia skompilovat v spravnom poradi; presny postup je 
  uvedeny v subore \it  readme.txt  \end. 

rem 
  \para \bf  Hodnotenie.  \end 
  \items 
   \item \para Pocet bodov za ulohy v tomto subore: 2 = 1+1 
   \item \para Pocet bodov za premiove ulohy v tomto subore: 1 
  \end
  \para Prenos: 
  \verbatim 
  ftp://barbie.nw.fmph.uniba.sk/data/vyuka/inf/cl/M-INBP-004-vyp/prenos/ex/ex<ord>/<user>/ex*.cl 
  \end
  \para Odovzdat do 10.10.2006 (utorok) do 18:00. 

loc rem 
  ******************************************************************************
  ********************************* EXERCISES **********************************
  ******************************************************************************

rem 
  \para \bf  Literature.  \end 
  \items 
   \item \para \it  [1]  \end J. Komara and P. J. Voda. Lecture Notes in Theory 
         of Computability. 2001. 
   \item \para \it  [2]  \end P. J. Voda. Theory of Recursive Functions & 
         Computability. 2000. 
   \item \para \it  [3]  \end I. Korec. Uvod do teorie algoritmov. MFF UK. 
         Bratislava. 1983. 
  \end

rem 
  \para \bf  Chapter. Primitive Recursive Functions.  \end 

rem 
  \para \bf  Section. Course of Values Recursion.  \end 

rem 
  \para \bf  Subsection. Pairing Function.  \end 

rem 
  \para \bf  [CL] Remark.  \end Catalan pairing function - see the module 
  \ft Maux \end. 

rem 
  \para \bf  Subsection. Course of Values Recursion.  \end 

rem 
  \para \bf  [CL] Remark.  \end Do not use the `function' \ft D \end from the 
  module \it  Standard  \end; it plays the role of if-then-else construct. Use 
  rather the function \ft D1(x,y,z) \end defined in the module \it  Maux  \end 
  with prefix name \it  D1  \end. 

rem 
  \para \bf  Course of values functions.  \end In the following examples use the 
  method of course values sequences to show that the functions discussed are 
  primitive recursive. 

rem 
  \para \bf  Exercise.  \end \it  [Uloha (1 bod)]  \end 
  \header* fun Fib 'Tex_f1_n_fib' \end The Fibonacci function \ft Fib(n) \end 
  has the following course of values recursive definition: 

fun Fib 'Tex_f1_n_fib'
  Fib(0) = 0
  Fib(1) = 1
  Fib(n+2) = Fib(n+1)+Fib(n)

rem 
  \para Show that the function is primitive recursive. 

fun Cvf_fib_debug 'Tex_f1_rec_cvf_f'
  Cvf_fib_debug(0) = 0,0
  Cvf_fib_debug(n+1) = Fib(n+1),Cvf_fib_debug(n)

fun Cvf_fib 'Tex_f1_rec_cvf_f'
  Cvf_fib(n) = Foo

fun Fib_is_primrec 'Tex_f1_n_fib'
  Fib_is_primrec(n) = Foo

rem 
  \para \bf  Exercise.  \end \it  [Uloha (1 bod)]  \end 
  \header* fun Szb 'Tex_f1_nb_sz' \end The binary size function \ft Szb(x) \end 
  has the following course of values recursive definition: 

fun Szb 'Tex_f1_nb_sz'
  Szb(2*x+0) = 0 <- x = 0
  Szb(2*x+0) = Szb(x)+1 <- x != 0
  Szb(2*x+1) = Szb(x)+1

rem 
  \para Show that the function is primitive recursive. 

fun Cvf_szb_debug 'Tex_f1_rec_cvf_f'
  Cvf_szb_debug(0) = 0,0
  Cvf_szb_debug(x+1) = Szb(x+1),Cvf_szb_debug(x)

fun Cvf_szb 'Tex_f1_rec_cvf_f'
  Cvf_szb(x) = Foo

fun Szb_is_primrec 'Tex_f1_nb_sz'
  Szb_is_primrec(x) = Foo

rem 
  \para \bf  Exercise.  \end \it  [Premiova uloha (1 bod)]  \end The list 
  concatenation function \ft x++y \end has the following course of values 
  recursive definition: 

fun/2 Conc 'Tex_f2_ln_conc'
  Conc(0,y) = y
  Conc((v,w),y) = v,Conc(w,y)

rem 
  \para Show that the function is primitive recursive. 

fun/2 Cvf_conc_debug 'Tex_f2_rec_cvf_f'
  Cvf_conc_debug(0,y) = y,0
  Cvf_conc_debug(x+1,y) = x+1++y,Cvf_conc_debug(x,y)

fun/2 Cvf_conc 'Tex_f2_rec_cvf_f'
  Cvf_conc(x,y) = Foo

fun/2 Conc_is_primrec 'Tex_f2_ln_conc'
  Conc_is_primrec(x,y) = Foo

loc rem 
  ******************************************************************************
  ********************************* DEBUGGING **********************************
  ******************************************************************************

loc fun Test_fun 
  Test_fun(x) = Foo

loc fun/2 Itfa 
  Itfa(0,a) = a
  Itfa(n+1,a) = Itfa(n,(n,Test_fun(n)),a)

loc fun Itf 
  Itf(n) = Itfa(n,0)

loc pred Test_pred 
  Test_pred(x) <-> Poo

loc fun/2 Itpa 
  Itpa(0,a) = a
  Itpa(n+1,a) = Itpa(n,n,a) <- Test_pred(n)
  Itpa(n+1,a) = Itpa(n,a) <- ~Test_pred(n)

loc fun Itp 
  Itp(n) = Itpa(n,0)

rem 
  \para Formats for testing binary functions and predicates. Examples of usage: 
  \items 
   \item \para define \ft Test_fun(x) = H(x)+T(x) \end and run query \it  
         Itf(10)=x:Lf2  \end 
   \item \para define \ft Test_pred(x) <-> H(x) <= T(x) \end and run query \it  
         Itp(10)=x:Lp2  \end 
  \end

loc pred Nn 
  Nn(0)
  Nn(x1,x2) <- N(x1) & N(x2)

loc pred Nnn 
  Nnn(x,y) <- Nn(x) & N(y)

loc pred Lf2 
  Lf2(0)
  Lf2(v,w) <- Nnn(v) & Lf2(w)

loc pred Lp2 
  Lp2(0)
  Lp2(v,w) <- Nn(v) & Lp2(w)

