mod Mxmrf

incl Mtex

incl Mtexrc

incl Mtexxmr

incl Maux

rem 
  \para \bf  Partial \ft Tex0_mu \end-Recursive Functions.  \end 

rem 
  \para \bf  Arithmetization of \ft Tex0_mu \end-recursive function symbols. 
   \end 

fun/0 Zx 'Tex_f0_xmr_zx'
  Zx = 0,0

fun/0 Sx 'Tex_f0_xmr_sx'
  Sx = 1,0

fun/2 Ix 'Tex_f2_xmr_ix'
  Ix(n,i) = 2,n,i

fun/2 Px 'Tex_f2_xmr_px'
  Px(g,gs) = 3,g,gs

fun/4 Cx 'Tex_f4_xmr_cx'
  Cx(n,m,h,gs) = 4,n,m,h,gs

fun/3 Rx 'Tex_f3_xmr_rx'
  Rx(n,g,h) = 5,n,g,h

fun/2 Mx 'Tex_f2_xmr_mx'
  Mx(n,g) = 6,n,g

fun/3 Nx 'Tex_f3_xmr_nx'
  Nx(n,z,g) = 7,n,z,g

rem 
  \para \bf  Arity of \ft Tex0_mu \end-recursive function symbols.  \end 

fun Ar 
  Ar(Zx) = 1
  Ar(Sx) = 1
  Ar Ix(n,i) = n
  Ar Cx(n,m,h,gs) = n
  Ar Rx(n,g,h) = n
  Ar Mx(n,g) = n

rem 
  \para \bf  Well-formed \ft Tex0_mu \end-recursive indices.  \end 
  \header* pred/2 Mrf  \end The binary primitive recursive predicate 
  \ft Mrf(n,e) \end holds if the number \ft e \end is the code of some 
  \ft n \end-ary \ft Tex0_mu \end-recursive function symbol. We say that the 
  number \ft e \end is a \it  well-formed \ft Tex0_mu \end-recursive index 
   \end. 

pred/3 Mrf1 
  Mrf1(n,Zx,k) <- n = 1 & k = 1
  Mrf1(n,Sx,k) <- n = 1 & k = 1
  Mrf1(n,Ix(n1,i),k) <- n >= 1 & k = 1 & n1 = n & 1 <= i & i <= n
  Mrf1(n,Px(g,gs),k) <- k > 1 & Mrf1(n,g,1) & Mrf1(n,gs,k-1)
  Mrf1(n,Cx(n1,m,h,gs),k) <- 
    n >= 1 & k = 1 & n1 = n & m >= 1 & Mrf1(m,h,1) & Mrf1(n,gs,m)
  Mrf1(n,Rx(n1,g,h),k) <- 
    n >= 2 & k = 1 & n1 = n & Mrf1(n-1,g,1) & Mrf1(n+1,h,1)
  Mrf1(n,Mx(n1,g),k) <- n >= 1 & k = 1 & n1 = n & Mrf1(n+1,g,1)

pred/2 Mrf 
  Mrf(n,e) <-> Mrf1(n,e,1)

rem 
  \para \bf  [CL] Display of well-formed \ft Tex0_mu \end-recursive indices. 
   \end The unary predicate \ft Ff \end is the union format and it can be used 
  to control the display of well-formed \ft Tex0_mu \end-recursive indices. 

pred Ff 
  Ff(Zx)
  Ff(Sx)
  Ff Ix(n,i) <- N(n) & N(i)
  Ff Px(g,gs) <- Ff(g) & Ff(gs)
  Ff Cx(n,m,h,gs) <- N(n) & N(m) & Ff(h) & Ff(gs)
  Ff Rx(n,g,h) <- N(n) & Ff(g) & Ff(h)
  Ff Mx(n,g) <- N(n) & Ff(g)
  Ff Nx(n,z,g) <- N(n) & N(z) & Ff(g)

rem 
  \para \bf  \ft Tex0_mu \end-Recursive indices.  \end 

rem 
  \para \it  Indices of constant functions.  \end 

fun Xc1 'Tex_f1_xmr_xc1'
  Xc1(0) = Zx
  Xc1(m+1) = Cx(1,1,Sx,Xc1(m))

fun/2 Xc2 'Tex_f2_xmr_xc2'
  Xc2(n,m) = Cx(n,1,Xc1(m),Ix(n,1))

rem 
  \para \it  Indices of nowhere defined partial functions.  \end 

fun Xundef 'Tex_f1_xmr_xundef'
  Xundef(n) = Mx(n,Xc2(n+1,0))

rem 
  \para \it  Turning recursive indices into well-formed ones.  \end 

fun/2 Xwf 'Tex_f2_xmr_xwf'
  Xwf(n,e) = e <- Mrf(n,e)
  Xwf(n,e) = Xundef(n) <- ~Mrf(n,e)

rem 
  \para \it  Parametric function.  \end 

fun/2 Xparam 'Tex_f2_xmr_xparam'
  Xparam(e,x) = Cx(1,2,e,Px(Xc1(x),Ix(1,1)))

