mod Maux

incl Mtex

incl Mtextm

rem 
  \para \bf  Characteristic functions.  \end 

fun/2 Nef 'Tex_f2_tm_char_nef'
  Nef(x,y) = 1 <- x != y
  Nef(x,y) = 0 <- x = y

rem 
  \para \bf  Catalan pairing function.  \end 

rem 
  \para \it  Pairing function.  \end 

fun/2 Pair 'Tex_f2_pp_pair'
  Pair(x,y) = x,y

rem 
  \para \it  Projection functions.  \end 

fun Proj1 'Tex_f1_pp_proj1'
  Proj1(x) = H(x)

fun Proj2 'Tex_f1_pp_proj2'
  Proj2(x) = T(x)

rem 
  \para \it  Unary iteration of the second projection.  \end 

fun/2 Iproj2 'Tex_f2_pp_iproj2'
  Iproj2(0,x) = x
  Iproj2(n+1,x) = Iproj2(n,Proj2(x))

rem 
  \para \bf  Tuples.  \end 

pred/2 Tuple 
  Tuple(n,x) <-> n = 0 & x = 0 \/ n = 1 \/ n >= 2 & Iproj2(n-2,x) != 0

fun/2 Tuplef 'Tex_f2_tm_pp_tuplef'
  Tuplef(n,x) = 1 <- Tuple(n,x)
  Tuplef(n,x) = 0 <- ~Tuple(n,x)

rem 
  \para \bf  Binary arithmetic.  \end 

rem 
  \para Binary constructors \ft S0(x) \end and \ft S1(x) \end. See the module 
  \it  Standard  \end. 

rem 
  \para Binary format \ft Nb(x) \end. See the module \it  Standard  \end. 

rem 
  \para \it  Binary size.  \end 

fun Szb 'Tex_f1_tm_nb_sz'
  Szb S0(0) = 0
  Szb S0(x) = Szb(x)+1 <- x != 0
  Szb S1(x) = Szb(x)+1

rem 
  \para \it  Binary concatenation.  \end 

fun/2 Concb 'Tex_f2_tm_nb_conc'
  Concb(x,S0(0)) = x
  Concb(x,S0(y)) = S0 Concb(x,y) <- y != 0
  Concb(x,S1(y)) = S1 Concb(x,y)

