mod Mclsyntax

rem 
  \para \bf  Bounded Quantifiers and Minimalization.  \end 

rem 
  \para \bf  Bounded formulas.  \end 

rem 
  \para \bf  [CL] Syntax.  \end Examples: 
  \items 
   \item \para Atomic formulas: \ft x = y \end, \ft R(x) \end. 
   \item \para Propositional connectives: \ft \t \end, \ft \f \end, \ft ~R \end, 
         \ft R & Q \end, \ft R \/ Q \end, \ft R -> Q \end, \ft R <-> Q \end. 
   \item \para Bounded quantification: \ft \eb y y <= x: R \end, 
         \ft \ab y y <= x: R \end, \ft \eb y y < x: R \end, 
         \ft \ab y y < x: R \end, \ft \eb y y in x: R \end, 
         \ft \ab y y in x: R \end. 
   \item \para Notational conventions: \ft x != y \end, \ft x <= y \end, 
         \ft x < y \end, \ft x > y \end, \ft x >= y \end, \ft x in y \end, 
         \ft x !in y \end 
  \end

rem 
  \para \bf  Explicit definitions of predicates with bounded formulas.  \end 

rem 
  \para \bf  [CL] Syntax.  \end \header* pred/2 Q  \end Examples: 
  \def 
    pred R 
    R(x) <-> \eb y y <= x: Q(x,y)
  \end
  \def 
    pred R 
    R(x) <-> \eb y y < x: Q(x,y)
  \end
  \def 
    pred R 
    R(x) <-> 
      \ab y y <= x: Q(x,y)
  \end
  \def 
    pred R 
    R(x) <-> 
      \ab y y < x: Q(x,y)
  \end
  \def 
    pred R 
    R(x) <-> 
      \eb y y in x: Q(x,y)
  \end
  \def 
    pred R 
    R(x) <-> 
      \ab y y in x: Q(x,y)
  \end

rem 
  \para \bf  Definitions of functions with bounded minimalization.  \end 

rem 
  \para \bf  [CL] Syntax.  \end \header* pred/2 Q  \end Examples: 
  \def 
    fun F 
    F(x) = \m y <= x [ Q(x,y) ]
  \end
  \def 
    fun F 
    F(x) = \m y < x [ Q(x,y) ]
  \end

rem 
  \para \bf  Definitions of functions with regular minimalization.  \end 

rem 
  \para \bf  [CL] Syntax.  \end \header* pred/2 Q  \end Examples: 
  \def 
    fun F 
    F(x) = \m y [ Q(x,y) ]
  \end

