mod Mxmrf

incl Mtex

incl Mtexrc

incl Mtexxmr

incl Maux

rem 
  \para \bf  Partial \ft Tex0_mu \end-Recursive Functions.  \end 

rem 
  \para \bf  Remark.  \end The word \it  \ft Tex0_mu \end-r.  \end abbreviates 
  the word \it  \ft Tex0_mu \end-recursive  \end. 

rem 
  \para \bf  Arithmetization of \ft Tex0_mu \end-r. function symbols.  \end 

fun/0 Zx 'Tex_f0_xmr_zx'
  Zx = 0,0

fun/0 Sx 'Tex_f0_xmr_sx'
  Sx = 1,0

fun/2 Ix 'Tex_f2_xmr_ix'
  Ix(n,i) = 2,n,i

fun/2 Px 'Tex_f2_xmr_px'
  Px(g,gs) = 3,g,gs

fun/4 Cx 'Tex_f4_xmr_cx'
  Cx(n,m,h,gs) = 4,n,m,h,gs

fun/3 Rx 'Tex_f3_xmr_rx'
  Rx(n,g,h) = 5,n,g,h

fun/2 Mx 'Tex_f2_xmr_mx'
  Mx(n,g) = 6,n,g

fun/3 Nx 'Tex_f3_xmr_nx'
  Nx(n,z,g) = 7,n,z,g

rem 
  \para \bf  Arity of \ft Tex0_mu \end-r. function symbols.  \end 

fun Ar 
  Ar(Zx) = 1
  Ar(Sx) = 1
  Ar Ix(n,i) = n
  Ar Cx(n,m,h,gs) = n
  Ar Rx(n,g,h) = n
  Ar Mx(n,g) = n

rem 
  \para \bf  Well-formed \ft Tex0_mu \end-r. indices.  \end 
  \header* pred/2 Mrf  \end The binary primitive recursive predicate 
  \ft Mrf(n,e) \end holds if the number \ft e \end is the code of some 
  \ft n \end-ary \ft Tex0_mu \end-r. function symbol. 

pred/3 Mrf1 
  Mrf1(k,Zx,1) <- k = 1
  Mrf1(k,Sx,1) <- k = 1
  Mrf1(k,Ix(n1,i),n) <- k = 1 & n1 = n & 1 <= i & i <= n
  Mrf1(k,Px(g,gs),n) <- k > 1 & Mrf1(1,g,n) & Mrf1(k-1,gs,n)
  Mrf1(k,Cx(n1,m,h,gs),n) <- 
    k = 1 & n1 = n & m >= 1 & Mrf1(1,h,m) & Mrf1(m,gs,n)
  Mrf1(k,Rx(n1,g,h),n) <- k = 1 & n1 = n & Mrf1(1,g,n-1) & Mrf1(1,h,n+1)
  Mrf1(k,Mx(n1,g,h),n) <- k = 1 & n1 = n & Mrf1(1,g,n+1)

pred/2 Mrf 
  Mrf(n,e) <-> n >= 1 & n = Ar(e) & Mrf1(1,e,n)

rem 
  \para \bf  [CL] Display of well-formed \ft Tex0_mu \end-r. indices.  \end The 
  unary predicate \ft Ff \end is the union format and it can be used to control 
  the display of well-formed \ft Tex0_mu \end-r. indices. 

pred Ff 
  Ff(Zx)
  Ff(Sx)
  Ff Ix(n,i) <- N(n) & N(i)
  Ff Px(g,gs) <- Ff(g) & Ff(gs)
  Ff Cx(n,m,h,gs) <- N(n) & N(m) & Ff(h) & Ff(gs)
  Ff Rx(n,g,h) <- N(n) & Ff(g) & Ff(h)
  Ff Mx(n,g) <- N(n) & Ff(g)
  Ff Nx(n,z,g) <- N(n) & N(z) & Ff(g)

rem 
  \para \bf  [CL] Interpreter of \ft Tex0_mu \end-r. function symbols.  \end 
  Only for debugging. 

fun/2 Interpreter 'Tex_f2_xmr_interpreter'
  Interpreter(Zx,x) = 0
  Interpreter(Sx,x) = x+1
  Interpreter(Ix(n,i),x) = Proj(n,x,i)
  Interpreter(Px(g,gs),x) = Interpreter(g,x),Interpreter(gs,x)
  Interpreter(Cx(n,m,h,gs),x) = Interpreter(h,Interpreter(gs,x))
  Interpreter(Rx(n,g,h),0,y) = Interpreter(g,y)
  Interpreter(Rx(n,g,h),x+1,y) = Interpreter(h,x,Interpreter(Rx(n,g,h),x,y),y)
  Interpreter(Mx(n,g),x) = Interpreter(Nx(n,0,g),x)
  Interpreter(Nx(n,z,g),x) = z <- Interpreter(g,z,x) = 1
  Interpreter(Nx(n,z,g),x) = Interpreter(Nx(n,z+1,g),x) <- 
    Interpreter(g,z,x) != 1

