mod Mtm

incl Mtex

incl Mtextm

incl Maux

rem 
  \para \bf  Turing Machines.  \end 

rem 
  \para \bf  Internal states.  \end 

fun/0 Qb 'Tex_f0_tm_qb'
  Qb = 1

fun/0 Qe 'Tex_f0_tm_qe'
  Qe = 0

rem 
  \para \bf  Tape symbols.  \end \header* fun/0 Sb 'Tex_f0_tm_sb' \end 
  \header* fun/0 So 'Tex_f0_tm_so' \end The tape alphabet consists of two 
  symbols: the blank symbol \ft Sb \end and the symbol \ft So \end. 

fun/0 Sb 'Tex_f0_tm_sb'
  Sb = 0

fun/0 So 'Tex_f0_tm_so'
  So = 1

rem 
  \para \header* pred Ts 'Tex_f0_tm_ts' \end The predicate \ft Ts(s) \end 
  holding of tape symbols is defined explicitly as a primitive recursive 
  predicate (union format): 

pred Ts 'Tex_f0_tm_ts'
  Ts(Sb)
  Ts(So)

rem 
  \para Auxiliary function. 

fun Mkones 'Tex_f1_tm_mkones'
  Mkones(0) = 0
  Mkones(x+1) = S1 Mkones(x)

rem 
  \para \bf  Movement.  \end \header* fun/0 Dh 'Tex_f0_tm_dh' \end 
  \header* fun/0 Dl 'Tex_f0_tm_dl' \end \header* fun/0 Dr 'Tex_f0_tm_dr' \end 
  Only the following movement may be performed by the heads of Turing machines: 
  \items 
   \item \para the head stays at the same square - this is represented by the 
         number \ft Dh \end, 
   \item \para the head moves one square left - this is represented by the 
         number \ft Dl \end, 
   \item \para the head moves one square right - this is represented by the 
         number \ft Dr \end. 
  \end

fun/0 Dh 'Tex_f0_tm_dh'
  Dh = 0

fun/0 Dl 'Tex_f0_tm_dl'
  Dl = 1

fun/0 Dr 'Tex_f0_tm_dr'
  Dr = 2

rem 
  \para The predicate \ft Fd(d) \end which holds if \ft d \end is one of the 
  above possible movements is defined explicitly as a primitive recursive 
  predicate (union format): 

pred Fd 
  Fd(Dh)
  Fd(Dl)
  Fd(Dr)

rem 
  \para \bf  Displays of configurations.  \end The primitive recursive predicate 
  \ft Fc \end is the cartesian format and it can be used to control the display 
  of the configurations of Turing machines. The configurations are numbers of 
  the form \ft q,l,r \end, where \ft q \end is a state, \ft l \end is a left 
  word, and \ft r \end is a right word. 

pred Fc 
  Fc(q,l,r) <- N(q) & Nb(l) & Nb(r)

