mod Mtm

incl Mtex

incl Mtextm

incl Maux

rem 
  \para \bf  Turing Machines.  \end 

rem 
  \para \bf  Tape symbols.  \end \header* fun/0 Sb 'Tex_f0_tm_sb' \end 
  \header* fun/0 So 'Tex_f0_tm_so' \end The tape alphabet consists of two 
  symbols: the blank symbol \ft Sb \end and the symbol \ft So \end. 

fun/0 Sb 'Tex_f0_tm_sb'
  Sb = 0

fun/0 So 'Tex_f0_tm_so'
  So = 1

rem 
  \para \header* pred Ts 'Tex_f0_tm_ts' \end The predicate \ft Ts(s) \end 
  holding of tape symbols is defined explicitly as a primitive recursive 
  predicate (union format): 

pred Ts 'Tex_f0_tm_ts'
  Ts(Sb)
  Ts(So)

rem 
  \para \bf  Movement.  \end \header* fun/0 Dh 'Tex_f0_tm_dh' \end 
  \header* fun/0 Dl 'Tex_f0_tm_dl' \end \header* fun/0 Dr 'Tex_f0_tm_dr' \end 
  Only the following movement may be performed by the heads of Turing machines: 
  \items 
   \item \para the head stays at the same square - this is represented by the 
         number \ft Dh \end, 
   \item \para the head moves one square left - this is represented by the 
         number \ft Dl \end, 
   \item \para the head moves one square right - this is represented by the 
         number \ft Dr \end. 
  \end

fun/0 Dh 'Tex_f0_tm_dh'
  Dh = 0

fun/0 Dl 'Tex_f0_tm_dl'
  Dl = 1

fun/0 Dr 'Tex_f0_tm_dr'
  Dr = 2

rem 
  \para The predicate \ft Fd(d) \end which holds if \ft d \end is one of the 
  above possible movements is defined explicitly as a primitive recursive 
  predicate (union format): 

pred Fd 
  Fd(Dh)
  Fd(Dl)
  Fd(Dr)

rem 
  \para \bf  Auxiliary functions and predicates.  \end 

fun Mkones 'Tex_f1_tm_mkones'
  Mkones(0) = 0
  Mkones(x+1) = S1 Mkones(x)

pred Ones 
  Ones(0)
  Ones S1(w) <- Ones(w)

rem 
  \para \bf  Arithmetization of Turing Machines.  \end 

theory Tm

rem 
  \para \it  Goal.  \end Find a Turing machine \ft Tex_f0_tm_a \end computing 
  the partial function \ft f \end. 

rem 
  \para \header* fun/0 Qb 'Tex_f0_tm_qb' \end 
  \header* fun/0 Qe 'Tex_f0_tm_qe' \end \header* pred Q 'Tex_f1_tm_q' \end 
  \header* fun/2 Tf 'Tex_f2_tm_tf' \end \it  Solution.  \end The Turing machine 
  \ft Tex_f0_tm_a \end computing \ft f \end will be defined if we determine the 
  following objects: 
  \items 
   \item \para a set of symbols represented here by the predicate 
         \ft Ts(s) \end, 
   \item \para a set of states represented here by the predicate \ft Q(q) \end, 
         and 
   \item \para a set of movements represented here by the predicate 
         \ft Fd(d) \end, 
   \item \para a binary transition function denoted here by \ft Tf(q,s) \end. 
  \end
  \para Note that the tape alphabet \ft Ts(s) \end and the set of movements 
  \ft Fd(d) \end is already fixed. The predicates and the transition function 
  must satisfy: 
  \items 
   \item \para finiteness of the set of states: 
         \eq* 
           \e n\a q(Q(q) -> q <= n)
         \end
   \item \para finiteness of the transition function: 
         \eq* 
           \e n\a q\a s(Tf(q,s) != 0 -> q <= n & s <= n)
         \end
   \item \para existence of two distinguished states \ft Qb \end and \ft Qe \end 
         called respectively the initial state and the final state: 
         \eq* 
           Q(Qb) & Q(Qe) & Qb != Qe
         \end
   \item \para property of being a transition function: 
         \eq* 
           Tf(q,s) != 0 -> 
           q != Qe & Q(q) & Ts(s) & 
           \e q1\e s1\e d(Tf(q,s) = q1,s1,d & Q(q1) & Ts(s1) & Fd(d))
         \end
  \end

rem 
  \para \it  Step I.  \end Determine the arity of \ft f \end. 

fun/0 Ar 'Tex_f0_tm_ar'

rem 
  \para \it  Step II.  \end Determine the initial state of the Turing machine 
  \ft Tex_f0_tm_a \end. 

fun/0 Qb 'Tex_f0_tm_qb'

rem 
  \para \it  Step III.  \end Determine the final state of the Turing machine 
  \ft Tex_f0_tm_a \end. 

fun/0 Qe 'Tex_f0_tm_qe'

rem 
  \para \it  Step IV.  \end Determine the set of states of the Turing machine 
  \ft Tex_f0_tm_a \end. 

pred Q 'Tex_f1_tm_q'

rem 
  \para \it  Step V.  \end Determine the transition function of the Turing 
  machine \ft Tex_f0_tm_a \end. 

fun/2 Tf 'Tex_f2_tm_tf'

rem 
  \para Arithmetization of one computation step. 

fun Run 'Tex_f1_tm_run'
  Run(q,l,2*r+s) = q1,l,s1+2*r <- 0 <= s & s <= 1 & Tf(q,s) = q1,s1,Dh
  Run(q,l,2*r+s) = q1,l1,s2+2*(s1+2*r) <- 
    0 <= s & s <= 1 & Tf(q,s) = q1,s1,Dl & l = 2*l1+s2 & 0 <= s2 & s2 <= 1
  Run(q,l,2*r+s) = q1,2*l+s1,r <- 0 <= s & s <= 1 & Tf(q,s) = q1,s1,Dr

rem 
  \para Arithmetization of computation. 

fun Urun 'Tex_f1_tm_urun'
  Urun(c) = D(Nef(Proj1(c),Qe),Urun Run(c),c)

rem 
  \para Encoding input. 

fun/2 Enc1 'Tex_f2_tm_enc1'
  Enc1(1,x1) = Mkones(x1)
  Enc1(n+2,x1,x) = Concb(S0 Enc1(n+1,x),Mkones(x1))

fun/2 Enc 'Tex_f2_tm_enc'
  Enc(n,x) = Qb,0,S0 Enc1(n,x)

rem 
  \para Decoding output. 

fun Dc1 'Tex_f1_tm_dc1'
  Dc1(c) = \m r [ c = Qe,0,S0(r) & Ones(r) ]

fun Dc 'Tex_f1_tm_dc'
  Dc(c) = Szb Dc1(c)

rem 
  \para The Turing machine \ft Tex_f0_tm_a \end computes the partial function 
  \ft f \end. Its contraction is explicitly defined as a partial recursive 
  function: 

fun Cf 'Tex_f1_tm_cf'
  Cf(x) = D(Tuplef(Ar,x),Dc Urun Enc(Ar,x),0)

rem 
  \para Only for debugging. 

fun/2 Brun 'Tex_f2_tm_brun'
  Brun(0,c) = c
  Brun(k+1,c) = c <- Proj1(c) = Qe
  Brun(k+1,c) = Brun(k,Run(c)) <- Proj1(c) != Qe

fun/2 Debug 'Tex_f2_tm_debug'
  Debug(k,x) = Brun(k,Enc(Ar,x)) <- Tuple(Ar,x)

rem 
  \para \it  Final step.  \end Define \ft f \end with the help of its 
  contraction. 

end theory Tm

rem 
  \para \bf  Displays of configurations.  \end The primitive recursive predicate 
  \ft Fc \end is the cartesian format and it can be used to control the display 
  of the configurations of Turing machines. The configurations are numbers of 
  the form \ft q,l,r \end, where \ft q \end is a state, \ft l \end is a left 
  word, and \ft r \end is a right word. 

pred Fc 
  Fc(q,l,r) <- N(q) & Nb(l) & Nb(r)

