mod Mxprf

incl Mtex

incl Mtexrc

incl Mtexxpr

rem 
  \para \bf  Arithmetization of primitive recursive function symbols.  \end 

fun/0 Zx 'Tex_f0_xpr_zx'
  Zx = 0,0

fun/0 Sx 'Tex_f0_xpr_sx'
  Sx = 1,0

fun/2 Ix 'Tex_f2_xpr_ix'
  Ix(n,i) = 2,n,i

fun/2 Px 'Tex_f2_xpr_px'
  Px(g,gs) = 3,g,gs

fun/4 Cx 'Tex_f4_xpr_cx'
  Cx(n,m,h,gs) = 4,n,m,h,gs

fun/3 Rx 'Tex_f3_xpr_rx'
  Rx(n,g,h) = 5,n,g,h

rem 
  \para \bf  Arity of primitive recursive function symbols.  \end 

fun Ar 
  Ar(Zx) = 1
  Ar(Sx) = 1
  Ar Ix(n,i) = n
  Ar Cx(n,m,h,gs) = n
  Ar Rx(n,g,h) = n

rem 
  \para \bf  Well-formed primitive recursive indices.  \end The predicate 
  \ft Prf(e) \end holds if the number \ft e \end is the code of some primitive 
  recursive function symbol. 

pred/3 Prf1 
  Prf1(k,Zx,1) <- k = 1
  Prf1(k,Sx,1) <- k = 1
  Prf1(k,Ix(n1,i),n) <- k = 1 & n1 = n & 1 <= i & i <= n
  Prf1(k,Px(g,gs),n) <- k > 1 & Prf1(1,g,n) & Prf1(k-1,gs,n)
  Prf1(k,Cx(n1,m,h,gs),n) <- 
    k = 1 & n1 = n & m >= 1 & Prf1(1,h,m) & Prf1(m,gs,n)
  Prf1(k,Rx(n1,g,h),n) <- k = 1 & n1 = n & Prf1(1,g,n-1) & Prf1(1,h,n+1)

pred Prf 
  Prf(e) <-> Prf1(1,e,Ar(e))

rem 
  \para \bf  [CL] Display of well-formed primitive recursive indices.  \end The 
  unary predicate \ft Ff \end is the union format and it can be used to control 
  the display of well-formed primitive recursive indices. 

pred Ff 
  Ff(Zx)
  Ff(Sx)
  Ff Ix(n,i) <- N(n) & N(i)
  Ff Px(g,gs) <- Ff(g) & Ff(gs)
  Ff Cx(n,m,h,gs) <- N(n) & N(m) & Ff(h) & Ff(gs)
  Ff Rx(n,g,h) <- N(n) & Ff(g) & Ff(h)

